package cloudphoto

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetThumbnail invokes the cloudphoto.GetThumbnail API synchronously
// api document: https://help.aliyun.com/api/cloudphoto/getthumbnail.html
func (client *Client) GetThumbnail(request *GetThumbnailRequest) (response *GetThumbnailResponse, err error) {
	response = CreateGetThumbnailResponse()
	err = client.DoAction(request, response)
	return
}

// GetThumbnailWithChan invokes the cloudphoto.GetThumbnail API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getthumbnail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetThumbnailWithChan(request *GetThumbnailRequest) (<-chan *GetThumbnailResponse, <-chan error) {
	responseChan := make(chan *GetThumbnailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetThumbnail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetThumbnailWithCallback invokes the cloudphoto.GetThumbnail API asynchronously
// api document: https://help.aliyun.com/api/cloudphoto/getthumbnail.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) GetThumbnailWithCallback(request *GetThumbnailRequest, callback func(response *GetThumbnailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetThumbnailResponse
		var err error
		defer close(result)
		response, err = client.GetThumbnail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetThumbnailRequest is the request struct for api GetThumbnail
type GetThumbnailRequest struct {
	*requests.RpcRequest
	LibraryId string           `position:"Query" name:"LibraryId"`
	PhotoId   requests.Integer `position:"Query" name:"PhotoId"`
	StoreName string           `position:"Query" name:"StoreName"`
	ZoomType  string           `position:"Query" name:"ZoomType"`
}

// GetThumbnailResponse is the response struct for api GetThumbnail
type GetThumbnailResponse struct {
	*responses.BaseResponse
	Code         string `json:"Code" xml:"Code"`
	Message      string `json:"Message" xml:"Message"`
	ThumbnailUrl string `json:"ThumbnailUrl" xml:"ThumbnailUrl"`
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Action       string `json:"Action" xml:"Action"`
}

// CreateGetThumbnailRequest creates a request to invoke GetThumbnail API
func CreateGetThumbnailRequest() (request *GetThumbnailRequest) {
	request = &GetThumbnailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudPhoto", "2017-07-11", "GetThumbnail", "cloudphoto", "openAPI")
	return
}

// CreateGetThumbnailResponse creates a response to parse from GetThumbnail response
func CreateGetThumbnailResponse() (response *GetThumbnailResponse) {
	response = &GetThumbnailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
