package cloudesl

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeClientPackage invokes the cloudesl.DescribeClientPackage API synchronously
func (client *Client) DescribeClientPackage(request *DescribeClientPackageRequest) (response *DescribeClientPackageResponse, err error) {
	response = CreateDescribeClientPackageResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeClientPackageWithChan invokes the cloudesl.DescribeClientPackage API asynchronously
func (client *Client) DescribeClientPackageWithChan(request *DescribeClientPackageRequest) (<-chan *DescribeClientPackageResponse, <-chan error) {
	responseChan := make(chan *DescribeClientPackageResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeClientPackage(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeClientPackageWithCallback invokes the cloudesl.DescribeClientPackage API asynchronously
func (client *Client) DescribeClientPackageWithCallback(request *DescribeClientPackageRequest, callback func(response *DescribeClientPackageResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeClientPackageResponse
		var err error
		defer close(result)
		response, err = client.DescribeClientPackage(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeClientPackageRequest is the request struct for api DescribeClientPackage
type DescribeClientPackageRequest struct {
	*requests.RpcRequest
	ClientType  string `position:"Body" name:"ClientType"`
	ExtraParams string `position:"Body" name:"ExtraParams"`
}

// DescribeClientPackageResponse is the response struct for api DescribeClientPackage
type DescribeClientPackageResponse struct {
	*responses.BaseResponse
	ErrorMessage   string `json:"ErrorMessage" xml:"ErrorMessage"`
	ErrorCode      string `json:"ErrorCode" xml:"ErrorCode"`
	Description    string `json:"Description" xml:"Description"`
	Message        string `json:"Message" xml:"Message"`
	UpdateType     string `json:"UpdateType" xml:"UpdateType"`
	Url            string `json:"Url" xml:"Url"`
	Version        string `json:"Version" xml:"Version"`
	DynamicCode    string `json:"DynamicCode" xml:"DynamicCode"`
	Code           string `json:"Code" xml:"Code"`
	DynamicMessage string `json:"DynamicMessage" xml:"DynamicMessage"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
}

// CreateDescribeClientPackageRequest creates a request to invoke DescribeClientPackage API
func CreateDescribeClientPackageRequest() (request *DescribeClientPackageRequest) {
	request = &DescribeClientPackageRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("cloudesl", "2020-02-01", "DescribeClientPackage", "cloudesl", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeClientPackageResponse creates a response to parse from DescribeClientPackage response
func CreateDescribeClientPackageResponse() (response *DescribeClientPackageResponse) {
	response = &DescribeClientPackageResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
