package cdrs

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVehicleResults invokes the cdrs.ListVehicleResults API synchronously
func (client *Client) ListVehicleResults(request *ListVehicleResultsRequest) (response *ListVehicleResultsResponse, err error) {
	response = CreateListVehicleResultsResponse()
	err = client.DoAction(request, response)
	return
}

// ListVehicleResultsWithChan invokes the cdrs.ListVehicleResults API asynchronously
func (client *Client) ListVehicleResultsWithChan(request *ListVehicleResultsRequest) (<-chan *ListVehicleResultsResponse, <-chan error) {
	responseChan := make(chan *ListVehicleResultsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVehicleResults(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVehicleResultsWithCallback invokes the cdrs.ListVehicleResults API asynchronously
func (client *Client) ListVehicleResultsWithCallback(request *ListVehicleResultsRequest, callback func(response *ListVehicleResultsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVehicleResultsResponse
		var err error
		defer close(result)
		response, err = client.ListVehicleResults(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVehicleResultsRequest is the request struct for api ListVehicleResults
type ListVehicleResultsRequest struct {
	*requests.RpcRequest
	CorpId             string           `position:"Body" name:"CorpId"`
	EndTime            string           `position:"Body" name:"EndTime"`
	StartTime          string           `position:"Body" name:"StartTime"`
	VehicleColor       string           `position:"Body" name:"VehicleColor"`
	VehicleApplication string           `position:"Body" name:"VehicleApplication"`
	PageNumber         requests.Integer `position:"Body" name:"PageNumber"`
	VehicleClass       string           `position:"Body" name:"VehicleClass"`
	PageSize           requests.Integer `position:"Body" name:"PageSize"`
}

// ListVehicleResultsResponse is the response struct for api ListVehicleResults
type ListVehicleResultsResponse struct {
	*responses.BaseResponse
	Code       string  `json:"Code" xml:"Code"`
	Message    string  `json:"Message" xml:"Message"`
	RequestId  string  `json:"RequestId" xml:"RequestId"`
	PageNumber int64   `json:"PageNumber" xml:"PageNumber"`
	PageSize   int64   `json:"PageSize" xml:"PageSize"`
	TotalCount int64   `json:"TotalCount" xml:"TotalCount"`
	Data       []Datas `json:"Data" xml:"Data"`
}

// CreateListVehicleResultsRequest creates a request to invoke ListVehicleResults API
func CreateListVehicleResultsRequest() (request *ListVehicleResultsRequest) {
	request = &ListVehicleResultsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CDRS", "2020-11-01", "ListVehicleResults", "", "")
	request.Method = requests.POST
	return
}

// CreateListVehicleResultsResponse creates a response to parse from ListVehicleResults response
func CreateListVehicleResultsResponse() (response *ListVehicleResultsResponse) {
	response = &ListVehicleResultsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
