package cbn

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteTransitRouterRouteEntry invokes the cbn.DeleteTransitRouterRouteEntry API synchronously
func (client *Client) DeleteTransitRouterRouteEntry(request *DeleteTransitRouterRouteEntryRequest) (response *DeleteTransitRouterRouteEntryResponse, err error) {
	response = CreateDeleteTransitRouterRouteEntryResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteTransitRouterRouteEntryWithChan invokes the cbn.DeleteTransitRouterRouteEntry API asynchronously
func (client *Client) DeleteTransitRouterRouteEntryWithChan(request *DeleteTransitRouterRouteEntryRequest) (<-chan *DeleteTransitRouterRouteEntryResponse, <-chan error) {
	responseChan := make(chan *DeleteTransitRouterRouteEntryResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteTransitRouterRouteEntry(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteTransitRouterRouteEntryWithCallback invokes the cbn.DeleteTransitRouterRouteEntry API asynchronously
func (client *Client) DeleteTransitRouterRouteEntryWithCallback(request *DeleteTransitRouterRouteEntryRequest, callback func(response *DeleteTransitRouterRouteEntryResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteTransitRouterRouteEntryResponse
		var err error
		defer close(result)
		response, err = client.DeleteTransitRouterRouteEntry(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteTransitRouterRouteEntryRequest is the request struct for api DeleteTransitRouterRouteEntry
type DeleteTransitRouterRouteEntryRequest struct {
	*requests.RpcRequest
	TransitRouterRouteEntryId                   string           `position:"Query" name:"TransitRouterRouteEntryId"`
	ResourceOwnerId                             requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClientToken                                 string           `position:"Query" name:"ClientToken"`
	TransitRouterRouteEntryNextHopType          string           `position:"Query" name:"TransitRouterRouteEntryNextHopType"`
	TransitRouterRouteEntryDestinationCidrBlock string           `position:"Query" name:"TransitRouterRouteEntryDestinationCidrBlock"`
	TransitRouterRouteTableId                   string           `position:"Query" name:"TransitRouterRouteTableId"`
	TransitRouterRouteEntryNextHopId            string           `position:"Query" name:"TransitRouterRouteEntryNextHopId"`
	DryRun                                      requests.Boolean `position:"Query" name:"DryRun"`
	ResourceOwnerAccount                        string           `position:"Query" name:"ResourceOwnerAccount"`
	OwnerAccount                                string           `position:"Query" name:"OwnerAccount"`
	OwnerId                                     requests.Integer `position:"Query" name:"OwnerId"`
}

// DeleteTransitRouterRouteEntryResponse is the response struct for api DeleteTransitRouterRouteEntry
type DeleteTransitRouterRouteEntryResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateDeleteTransitRouterRouteEntryRequest creates a request to invoke DeleteTransitRouterRouteEntry API
func CreateDeleteTransitRouterRouteEntryRequest() (request *DeleteTransitRouterRouteEntryRequest) {
	request = &DeleteTransitRouterRouteEntryRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Cbn", "2017-09-12", "DeleteTransitRouterRouteEntry", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteTransitRouterRouteEntryResponse creates a response to parse from DeleteTransitRouterRouteEntry response
func CreateDeleteTransitRouterRouteEntryResponse() (response *DeleteTransitRouterRouteEntryResponse) {
	response = &DeleteTransitRouterRouteEntryResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
