package policy

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// VariableValuesClient is the client for the VariableValues methods of the Policy service.
type VariableValuesClient struct {
	BaseClient
}

// NewVariableValuesClient creates an instance of the VariableValuesClient client.
func NewVariableValuesClient(subscriptionID string) VariableValuesClient {
	return NewVariableValuesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewVariableValuesClientWithBaseURI creates an instance of the VariableValuesClient client using a custom endpoint.
// Use this when interacting with an Azure cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewVariableValuesClientWithBaseURI(baseURI string, subscriptionID string) VariableValuesClient {
	return VariableValuesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CreateOrUpdate this operation creates or updates a variable value with the given subscription and name for a given
// variable. Variable values are scoped to the variable for which they are created for.
// Parameters:
// variableName - the name of the variable to operate on.
// variableValueName - the name of the variable value to operate on.
// parameters - parameters for the variable value.
func (client VariableValuesClient) CreateOrUpdate(ctx context.Context, variableName string, variableValueName string, parameters VariableValue) (result VariableValue, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.CreateOrUpdate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.VariableValueProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.VariableValueProperties.Values", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policy.VariableValuesClient", "CreateOrUpdate", err.Error())
	}

	req, err := client.CreateOrUpdatePreparer(ctx, variableName, variableValueName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "CreateOrUpdate", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "CreateOrUpdate", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "CreateOrUpdate", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client VariableValuesClient) CreateOrUpdatePreparer(ctx context.Context, variableName string, variableValueName string, parameters VariableValue) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"variableName":      autorest.Encode("path", variableName),
		"variableValueName": autorest.Encode("path", variableValueName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) CreateOrUpdateResponder(resp *http.Response) (result VariableValue, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdateAtManagementGroup this operation creates or updates a variable value with the given management group
// and name for a given variable. Variable values are scoped to the variable for which they are created for.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
// variableValueName - the name of the variable value to operate on.
// parameters - parameters for the variable value.
func (client VariableValuesClient) CreateOrUpdateAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, variableValueName string, parameters VariableValue) (result VariableValue, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.CreateOrUpdateAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.VariableValueProperties", Name: validation.Null, Rule: true,
				Chain: []validation.Constraint{{Target: "parameters.VariableValueProperties.Values", Name: validation.Null, Rule: true, Chain: nil}}}}}}); err != nil {
		return result, validation.NewError("policy.VariableValuesClient", "CreateOrUpdateAtManagementGroup", err.Error())
	}

	req, err := client.CreateOrUpdateAtManagementGroupPreparer(ctx, managementGroupID, variableName, variableValueName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "CreateOrUpdateAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateOrUpdateAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "CreateOrUpdateAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.CreateOrUpdateAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "CreateOrUpdateAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// CreateOrUpdateAtManagementGroupPreparer prepares the CreateOrUpdateAtManagementGroup request.
func (client VariableValuesClient) CreateOrUpdateAtManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string, variableValueName string, parameters VariableValue) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
		"variableValueName": autorest.Encode("path", variableValueName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.SystemData = nil
	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateOrUpdateAtManagementGroupSender sends the CreateOrUpdateAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) CreateOrUpdateAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateOrUpdateAtManagementGroupResponder handles the response to the CreateOrUpdateAtManagementGroup request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) CreateOrUpdateAtManagementGroupResponder(resp *http.Response) (result VariableValue, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Delete this operation deletes a variable value, given its name, the subscription it was created in, and the variable
// it belongs to. The scope of a variable value is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// Parameters:
// variableName - the name of the variable to operate on.
// variableValueName - the name of the variable value to operate on.
func (client VariableValuesClient) Delete(ctx context.Context, variableName string, variableValueName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.Delete")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeletePreparer(ctx, variableName, variableValueName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "Delete", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "Delete", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "Delete", resp, "Failure responding to request")
		return
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client VariableValuesClient) DeletePreparer(ctx context.Context, variableName string, variableValueName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"variableName":      autorest.Encode("path", variableName),
		"variableValueName": autorest.Encode("path", variableValueName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteAtManagementGroup this operation deletes a variable value, given its name, the management group it was created
// in, and the variable it belongs to. The scope of a variable value is the part of its ID preceding
// '/providers/Microsoft.Authorization/variables/{variableName}'.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
// variableValueName - the name of the variable value to operate on.
func (client VariableValuesClient) DeleteAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, variableValueName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.DeleteAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.DeleteAtManagementGroupPreparer(ctx, managementGroupID, variableName, variableValueName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "DeleteAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.DeleteAtManagementGroupSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "DeleteAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.DeleteAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "DeleteAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// DeleteAtManagementGroupPreparer prepares the DeleteAtManagementGroup request.
func (client VariableValuesClient) DeleteAtManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string, variableValueName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
		"variableValueName": autorest.Encode("path", variableValueName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// DeleteAtManagementGroupSender sends the DeleteAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) DeleteAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// DeleteAtManagementGroupResponder handles the response to the DeleteAtManagementGroup request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) DeleteAtManagementGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusNoContent),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Get this operation retrieves a single variable value; given its name, subscription it was created at and the
// variable it's created for.
// Parameters:
// variableName - the name of the variable to operate on.
// variableValueName - the name of the variable value to operate on.
func (client VariableValuesClient) Get(ctx context.Context, variableName string, variableValueName string) (result VariableValue, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, variableName, variableValueName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client VariableValuesClient) GetPreparer(ctx context.Context, variableName string, variableValueName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
		"variableName":      autorest.Encode("path", variableName),
		"variableValueName": autorest.Encode("path", variableValueName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) GetResponder(resp *http.Response) (result VariableValue, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetAtManagementGroup this operation retrieves a single variable value; given its name,  management group it was
// created at and the variable it's created for.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
// variableValueName - the name of the variable value to operate on.
func (client VariableValuesClient) GetAtManagementGroup(ctx context.Context, managementGroupID string, variableName string, variableValueName string) (result VariableValue, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.GetAtManagementGroup")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetAtManagementGroupPreparer(ctx, managementGroupID, variableName, variableValueName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "GetAtManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetAtManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "GetAtManagementGroup", resp, "Failure sending request")
		return
	}

	result, err = client.GetAtManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "GetAtManagementGroup", resp, "Failure responding to request")
		return
	}

	return
}

// GetAtManagementGroupPreparer prepares the GetAtManagementGroup request.
func (client VariableValuesClient) GetAtManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string, variableValueName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
		"variableValueName": autorest.Encode("path", variableValueName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values/{variableValueName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetAtManagementGroupSender sends the GetAtManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) GetAtManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetAtManagementGroupResponder handles the response to the GetAtManagementGroup request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) GetAtManagementGroupResponder(resp *http.Response) (result VariableValue, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// List this operation retrieves the list of all variable values associated with the given variable that is at a
// subscription level.
// Parameters:
// variableName - the name of the variable to operate on.
func (client VariableValuesClient) List(ctx context.Context, variableName string) (result VariableValueListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.List")
		defer func() {
			sc := -1
			if result.vvlr.Response.Response != nil {
				sc = result.vvlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listNextResults
	req, err := client.ListPreparer(ctx, variableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "List", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListSender(req)
	if err != nil {
		result.vvlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "List", resp, "Failure sending request")
		return
	}

	result.vvlr, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "List", resp, "Failure responding to request")
		return
	}
	if result.vvlr.hasNextLink() && result.vvlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListPreparer prepares the List request.
func (client VariableValuesClient) ListPreparer(ctx context.Context, variableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
		"variableName":   autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Authorization/variables/{variableName}/values", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListSender sends the List request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) ListSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, azure.DoRetryWithRegistration(client.Client))
}

// ListResponder handles the response to the List request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) ListResponder(resp *http.Response) (result VariableValueListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listNextResults retrieves the next set of results, if any.
func (client VariableValuesClient) listNextResults(ctx context.Context, lastResults VariableValueListResult) (result VariableValueListResult, err error) {
	req, err := lastResults.variableValueListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policy.VariableValuesClient", "listNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policy.VariableValuesClient", "listNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "listNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListComplete enumerates all values, automatically crossing page boundaries as required.
func (client VariableValuesClient) ListComplete(ctx context.Context, variableName string) (result VariableValueListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.List")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.List(ctx, variableName)
	return
}

// ListForManagementGroup this operation retrieves the list of all variable values applicable the variable indicated at
// the management group scope.
// Parameters:
// managementGroupID - the ID of the management group.
// variableName - the name of the variable to operate on.
func (client VariableValuesClient) ListForManagementGroup(ctx context.Context, managementGroupID string, variableName string) (result VariableValueListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.ListForManagementGroup")
		defer func() {
			sc := -1
			if result.vvlr.Response.Response != nil {
				sc = result.vvlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForManagementGroupNextResults
	req, err := client.ListForManagementGroupPreparer(ctx, managementGroupID, variableName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "ListForManagementGroup", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForManagementGroupSender(req)
	if err != nil {
		result.vvlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "ListForManagementGroup", resp, "Failure sending request")
		return
	}

	result.vvlr, err = client.ListForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "ListForManagementGroup", resp, "Failure responding to request")
		return
	}
	if result.vvlr.hasNextLink() && result.vvlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForManagementGroupPreparer prepares the ListForManagementGroup request.
func (client VariableValuesClient) ListForManagementGroupPreparer(ctx context.Context, managementGroupID string, variableName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"managementGroupId": autorest.Encode("path", managementGroupID),
		"variableName":      autorest.Encode("path", variableName),
	}

	const APIVersion = "2022-08-01-preview"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/providers/Microsoft.Management/managementGroups/{managementGroupId}/providers/Microsoft.Authorization/variables/{variableName}/values", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForManagementGroupSender sends the ListForManagementGroup request. The method will close the
// http.Response Body if it receives an error.
func (client VariableValuesClient) ListForManagementGroupSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForManagementGroupResponder handles the response to the ListForManagementGroup request. The method always
// closes the http.Response Body.
func (client VariableValuesClient) ListForManagementGroupResponder(resp *http.Response) (result VariableValueListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForManagementGroupNextResults retrieves the next set of results, if any.
func (client VariableValuesClient) listForManagementGroupNextResults(ctx context.Context, lastResults VariableValueListResult) (result VariableValueListResult, err error) {
	req, err := lastResults.variableValueListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "policy.VariableValuesClient", "listForManagementGroupNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForManagementGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "policy.VariableValuesClient", "listForManagementGroupNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForManagementGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "policy.VariableValuesClient", "listForManagementGroupNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForManagementGroupComplete enumerates all values, automatically crossing page boundaries as required.
func (client VariableValuesClient) ListForManagementGroupComplete(ctx context.Context, managementGroupID string, variableName string) (result VariableValueListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/VariableValuesClient.ListForManagementGroup")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForManagementGroup(ctx, managementGroupID, variableName)
	return
}
