--TEST--
BcMath\Number pow int by operator
--EXTENSIONS--
bcmath
--FILE--
<?php

$values = [
    100,
    '-20',
    3,
];

$exponents = [
    2,
    '3',
    0,
    -1,
    -2,
];

foreach ($values as $value) {
    $num1 = new BcMath\Number($value);

    foreach ($exponents as $exponent) {
        echo "{$value} ** {$exponent}\n";
        $ret = $num1 ** ((int) $exponent);
        $ret2 = ((int) $value) ** (new BcMath\Number($exponent));
        if ($ret->compare($ret2) !== 0) {
            echo "Result is incorrect.\n";
        }
        var_dump($ret);
        echo "\n";
    }
}
?>
--EXPECT--
100 ** 2
object(BcMath\Number)#2 (2) {
  ["value"]=>
  string(5) "10000"
  ["scale"]=>
  int(0)
}

100 ** 3
object(BcMath\Number)#3 (2) {
  ["value"]=>
  string(7) "1000000"
  ["scale"]=>
  int(0)
}

100 ** 0
object(BcMath\Number)#4 (2) {
  ["value"]=>
  string(1) "1"
  ["scale"]=>
  int(0)
}

100 ** -1
object(BcMath\Number)#5 (2) {
  ["value"]=>
  string(4) "0.01"
  ["scale"]=>
  int(2)
}

100 ** -2
object(BcMath\Number)#2 (2) {
  ["value"]=>
  string(6) "0.0001"
  ["scale"]=>
  int(4)
}

-20 ** 2
object(BcMath\Number)#1 (2) {
  ["value"]=>
  string(3) "400"
  ["scale"]=>
  int(0)
}

-20 ** 3
object(BcMath\Number)#4 (2) {
  ["value"]=>
  string(5) "-8000"
  ["scale"]=>
  int(0)
}

-20 ** 0
object(BcMath\Number)#5 (2) {
  ["value"]=>
  string(1) "1"
  ["scale"]=>
  int(0)
}

-20 ** -1
object(BcMath\Number)#2 (2) {
  ["value"]=>
  string(5) "-0.05"
  ["scale"]=>
  int(2)
}

-20 ** -2
object(BcMath\Number)#1 (2) {
  ["value"]=>
  string(6) "0.0025"
  ["scale"]=>
  int(4)
}

3 ** 2
object(BcMath\Number)#3 (2) {
  ["value"]=>
  string(1) "9"
  ["scale"]=>
  int(0)
}

3 ** 3
object(BcMath\Number)#5 (2) {
  ["value"]=>
  string(2) "27"
  ["scale"]=>
  int(0)
}

3 ** 0
object(BcMath\Number)#2 (2) {
  ["value"]=>
  string(1) "1"
  ["scale"]=>
  int(0)
}

3 ** -1
object(BcMath\Number)#1 (2) {
  ["value"]=>
  string(12) "0.3333333333"
  ["scale"]=>
  int(10)
}

3 ** -2
object(BcMath\Number)#3 (2) {
  ["value"]=>
  string(12) "0.1111111111"
  ["scale"]=>
  int(10)
}
