; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 2
; Test vector intrinsics.
;
; RUN: llc < %s -mtriple=s390x-linux-gnu -mcpu=z13 | FileCheck %s

declare i32 @llvm.s390.lcbb(ptr, i32)
declare <16 x i8> @llvm.s390.vlbb(ptr, i32)
declare <16 x i8> @llvm.s390.vll(i32, ptr)
declare <2 x i64> @llvm.s390.vpdi(<2 x i64>, <2 x i64>, i32)
declare <16 x i8> @llvm.s390.vperm(<16 x i8>, <16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vpksh(<8 x i16>, <8 x i16>)
declare <8 x i16> @llvm.s390.vpksf(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.s390.vpksg(<2 x i64>, <2 x i64>)
declare {<16 x i8>, i32} @llvm.s390.vpkshs(<8 x i16>, <8 x i16>)
declare {<8 x i16>, i32} @llvm.s390.vpksfs(<4 x i32>, <4 x i32>)
declare {<4 x i32>, i32} @llvm.s390.vpksgs(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.s390.vpklsh(<8 x i16>, <8 x i16>)
declare <8 x i16> @llvm.s390.vpklsf(<4 x i32>, <4 x i32>)
declare <4 x i32> @llvm.s390.vpklsg(<2 x i64>, <2 x i64>)
declare {<16 x i8>, i32} @llvm.s390.vpklshs(<8 x i16>, <8 x i16>)
declare {<8 x i16>, i32} @llvm.s390.vpklsfs(<4 x i32>, <4 x i32>)
declare {<4 x i32>, i32} @llvm.s390.vpklsgs(<2 x i64>, <2 x i64>)
declare void @llvm.s390.vstl(<16 x i8>, i32, ptr)
declare <8 x i16> @llvm.s390.vuphb(<16 x i8>)
declare <4 x i32> @llvm.s390.vuphh(<8 x i16>)
declare <2 x i64> @llvm.s390.vuphf(<4 x i32>)
declare <8 x i16> @llvm.s390.vuplhb(<16 x i8>)
declare <4 x i32> @llvm.s390.vuplhh(<8 x i16>)
declare <2 x i64> @llvm.s390.vuplhf(<4 x i32>)
declare <8 x i16> @llvm.s390.vuplb(<16 x i8>)
declare <4 x i32> @llvm.s390.vuplhw(<8 x i16>)
declare <2 x i64> @llvm.s390.vuplf(<4 x i32>)
declare <8 x i16> @llvm.s390.vupllb(<16 x i8>)
declare <4 x i32> @llvm.s390.vupllh(<8 x i16>)
declare <2 x i64> @llvm.s390.vupllf(<4 x i32>)
declare <16 x i8> @llvm.s390.vaccb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vacch(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vaccf(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.s390.vaccg(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vaq(i128, i128)
declare i128 @llvm.s390.vacq(i128, i128, i128)
declare i128 @llvm.s390.vaccq(i128, i128)
declare i128 @llvm.s390.vacccq(i128, i128, i128)
declare <16 x i8> @llvm.s390.vavgb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vavgh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vavgf(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.s390.vavgg(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.s390.vavglb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vavglh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vavglf(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.s390.vavglg(<2 x i64>, <2 x i64>)
declare <4 x i32> @llvm.s390.vcksm(<4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.s390.vgfmb(<16 x i8>, <16 x i8>)
declare <4 x i32> @llvm.s390.vgfmh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vgfmf(<4 x i32>, <4 x i32>)
declare i128 @llvm.s390.vgfmg(<2 x i64>, <2 x i64>)
declare <8 x i16> @llvm.s390.vgfmab(<16 x i8>, <16 x i8>, <8 x i16>)
declare <4 x i32> @llvm.s390.vgfmah(<8 x i16>, <8 x i16>, <4 x i32>)
declare <2 x i64> @llvm.s390.vgfmaf(<4 x i32>, <4 x i32>, <2 x i64>)
declare i128 @llvm.s390.vgfmag(<2 x i64>, <2 x i64>, i128)
declare <16 x i8> @llvm.s390.vmahb(<16 x i8>, <16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vmahh(<8 x i16>, <8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmahf(<4 x i32>, <4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.vmalhb(<16 x i8>, <16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vmalhh(<8 x i16>, <8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmalhf(<4 x i32>, <4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.s390.vmaeb(<16 x i8>, <16 x i8>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmaeh(<8 x i16>, <8 x i16>, <4 x i32>)
declare <2 x i64> @llvm.s390.vmaef(<4 x i32>, <4 x i32>, <2 x i64>)
declare <8 x i16> @llvm.s390.vmaleb(<16 x i8>, <16 x i8>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmaleh(<8 x i16>, <8 x i16>, <4 x i32>)
declare <2 x i64> @llvm.s390.vmalef(<4 x i32>, <4 x i32>, <2 x i64>)
declare <8 x i16> @llvm.s390.vmaob(<16 x i8>, <16 x i8>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmaoh(<8 x i16>, <8 x i16>, <4 x i32>)
declare <2 x i64> @llvm.s390.vmaof(<4 x i32>, <4 x i32>, <2 x i64>)
declare <8 x i16> @llvm.s390.vmalob(<16 x i8>, <16 x i8>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmaloh(<8 x i16>, <8 x i16>, <4 x i32>)
declare <2 x i64> @llvm.s390.vmalof(<4 x i32>, <4 x i32>, <2 x i64>)
declare <16 x i8> @llvm.s390.vmhb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vmhh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmhf(<4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.vmlhb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vmlhh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vmlhf(<4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.s390.vmeb(<16 x i8>, <16 x i8>)
declare <4 x i32> @llvm.s390.vmeh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vmef(<4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.s390.vmleb(<16 x i8>, <16 x i8>)
declare <4 x i32> @llvm.s390.vmleh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vmlef(<4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.s390.vmob(<16 x i8>, <16 x i8>)
declare <4 x i32> @llvm.s390.vmoh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vmof(<4 x i32>, <4 x i32>)
declare <8 x i16> @llvm.s390.vmlob(<16 x i8>, <16 x i8>)
declare <4 x i32> @llvm.s390.vmloh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vmlof(<4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.verimb(<16 x i8>, <16 x i8>, <16 x i8>, i32)
declare <8 x i16> @llvm.s390.verimh(<8 x i16>, <8 x i16>, <8 x i16>, i32)
declare <4 x i32> @llvm.s390.verimf(<4 x i32>, <4 x i32>, <4 x i32>, i32)
declare <2 x i64> @llvm.s390.verimg(<2 x i64>, <2 x i64>, <2 x i64>, i32)
declare <16 x i8> @llvm.s390.vsl(<16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vslb(<16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vsra(<16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vsrab(<16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vsrl(<16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vsrlb(<16 x i8>, <16 x i8>)
declare <16 x i8> @llvm.s390.vsldb(<16 x i8>, <16 x i8>, i32)
declare <16 x i8> @llvm.s390.vscbib(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vscbih(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vscbif(<4 x i32>, <4 x i32>)
declare <2 x i64> @llvm.s390.vscbig(<2 x i64>, <2 x i64>)
declare i128 @llvm.s390.vsq(i128, i128)
declare i128 @llvm.s390.vsbiq(i128, i128, i128)
declare i128 @llvm.s390.vscbiq(i128, i128)
declare i128 @llvm.s390.vsbcbiq(i128, i128, i128)
declare <4 x i32> @llvm.s390.vsumb(<16 x i8>, <16 x i8>)
declare <4 x i32> @llvm.s390.vsumh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vsumgh(<8 x i16>, <8 x i16>)
declare <2 x i64> @llvm.s390.vsumgf(<4 x i32>, <4 x i32>)
declare i128 @llvm.s390.vsumqf(<4 x i32>, <4 x i32>)
declare i128 @llvm.s390.vsumqg(<2 x i64>, <2 x i64>)
declare i32 @llvm.s390.vtm(<16 x i8>, <16 x i8>)
declare {<16 x i8>, i32} @llvm.s390.vceqbs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vceqhs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vceqfs(<4 x i32>, <4 x i32>)
declare {<2 x i64>, i32} @llvm.s390.vceqgs(<2 x i64>, <2 x i64>)
declare {<16 x i8>, i32} @llvm.s390.vchbs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vchhs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vchfs(<4 x i32>, <4 x i32>)
declare {<2 x i64>, i32} @llvm.s390.vchgs(<2 x i64>, <2 x i64>)
declare {<16 x i8>, i32} @llvm.s390.vchlbs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vchlhs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vchlfs(<4 x i32>, <4 x i32>)
declare {<2 x i64>, i32} @llvm.s390.vchlgs(<2 x i64>, <2 x i64>)
declare <16 x i8> @llvm.s390.vfaeb(<16 x i8>, <16 x i8>, i32)
declare <8 x i16> @llvm.s390.vfaeh(<8 x i16>, <8 x i16>, i32)
declare <4 x i32> @llvm.s390.vfaef(<4 x i32>, <4 x i32>, i32)
declare {<16 x i8>, i32} @llvm.s390.vfaebs(<16 x i8>, <16 x i8>, i32)
declare {<8 x i16>, i32} @llvm.s390.vfaehs(<8 x i16>, <8 x i16>, i32)
declare {<4 x i32>, i32} @llvm.s390.vfaefs(<4 x i32>, <4 x i32>, i32)
declare <16 x i8> @llvm.s390.vfaezb(<16 x i8>, <16 x i8>, i32)
declare <8 x i16> @llvm.s390.vfaezh(<8 x i16>, <8 x i16>, i32)
declare <4 x i32> @llvm.s390.vfaezf(<4 x i32>, <4 x i32>, i32)
declare {<16 x i8>, i32} @llvm.s390.vfaezbs(<16 x i8>, <16 x i8>, i32)
declare {<8 x i16>, i32} @llvm.s390.vfaezhs(<8 x i16>, <8 x i16>, i32)
declare {<4 x i32>, i32} @llvm.s390.vfaezfs(<4 x i32>, <4 x i32>, i32)
declare <16 x i8> @llvm.s390.vfeeb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vfeeh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vfeef(<4 x i32>, <4 x i32>)
declare {<16 x i8>, i32} @llvm.s390.vfeebs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vfeehs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vfeefs(<4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.vfeezb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vfeezh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vfeezf(<4 x i32>, <4 x i32>)
declare {<16 x i8>, i32} @llvm.s390.vfeezbs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vfeezhs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vfeezfs(<4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.vfeneb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vfeneh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vfenef(<4 x i32>, <4 x i32>)
declare {<16 x i8>, i32} @llvm.s390.vfenebs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vfenehs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vfenefs(<4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.vfenezb(<16 x i8>, <16 x i8>)
declare <8 x i16> @llvm.s390.vfenezh(<8 x i16>, <8 x i16>)
declare <4 x i32> @llvm.s390.vfenezf(<4 x i32>, <4 x i32>)
declare {<16 x i8>, i32} @llvm.s390.vfenezbs(<16 x i8>, <16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vfenezhs(<8 x i16>, <8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vfenezfs(<4 x i32>, <4 x i32>)
declare <16 x i8> @llvm.s390.vistrb(<16 x i8>)
declare <8 x i16> @llvm.s390.vistrh(<8 x i16>)
declare <4 x i32> @llvm.s390.vistrf(<4 x i32>)
declare {<16 x i8>, i32} @llvm.s390.vistrbs(<16 x i8>)
declare {<8 x i16>, i32} @llvm.s390.vistrhs(<8 x i16>)
declare {<4 x i32>, i32} @llvm.s390.vistrfs(<4 x i32>)
declare <16 x i8> @llvm.s390.vstrcb(<16 x i8>, <16 x i8>, <16 x i8>, i32)
declare <8 x i16> @llvm.s390.vstrch(<8 x i16>, <8 x i16>, <8 x i16>, i32)
declare <4 x i32> @llvm.s390.vstrcf(<4 x i32>, <4 x i32>, <4 x i32>, i32)
declare {<16 x i8>, i32} @llvm.s390.vstrcbs(<16 x i8>, <16 x i8>, <16 x i8>,
                                            i32)
declare {<8 x i16>, i32} @llvm.s390.vstrchs(<8 x i16>, <8 x i16>, <8 x i16>,
                                            i32)
declare {<4 x i32>, i32} @llvm.s390.vstrcfs(<4 x i32>, <4 x i32>, <4 x i32>,
                                            i32)
declare <16 x i8> @llvm.s390.vstrczb(<16 x i8>, <16 x i8>, <16 x i8>, i32)
declare <8 x i16> @llvm.s390.vstrczh(<8 x i16>, <8 x i16>, <8 x i16>, i32)
declare <4 x i32> @llvm.s390.vstrczf(<4 x i32>, <4 x i32>, <4 x i32>, i32)
declare {<16 x i8>, i32} @llvm.s390.vstrczbs(<16 x i8>, <16 x i8>, <16 x i8>,
                                             i32)
declare {<8 x i16>, i32} @llvm.s390.vstrczhs(<8 x i16>, <8 x i16>, <8 x i16>,
                                             i32)
declare {<4 x i32>, i32} @llvm.s390.vstrczfs(<4 x i32>, <4 x i32>, <4 x i32>,
                                             i32)
declare {<2 x i64>, i32} @llvm.s390.vfcedbs(<2 x double>, <2 x double>)
declare {<2 x i64>, i32} @llvm.s390.vfchdbs(<2 x double>, <2 x double>)
declare {<2 x i64>, i32} @llvm.s390.vfchedbs(<2 x double>, <2 x double>)
declare {<2 x i64>, i32} @llvm.s390.vftcidb(<2 x double>, i32)
declare <2 x double> @llvm.s390.vfidb(<2 x double>, i32, i32)

; LCBB with the lowest M3 operand.
define i32 @test_lcbb1(ptr %ptr) {
; CHECK-LABEL: test_lcbb1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcbb %r2, 0(%r2), 0
; CHECK-NEXT:    br %r14
  %res = call i32 @llvm.s390.lcbb(ptr %ptr, i32 0)
  ret i32 %res
}

; LCBB with the highest M3 operand.
define i32 @test_lcbb2(ptr %ptr) {
; CHECK-LABEL: test_lcbb2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcbb %r2, 0(%r2), 15
; CHECK-NEXT:    br %r14
  %res = call i32 @llvm.s390.lcbb(ptr %ptr, i32 15)
  ret i32 %res
}

; LCBB with a displacement and index.
define i32 @test_lcbb3(ptr %base, i64 %index) {
; CHECK-LABEL: test_lcbb3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    lcbb %r2, 4095(%r2,%r3), 4
; CHECK-NEXT:    br %r14
  %add = add i64 %index, 4095
  %ptr = getelementptr i8, ptr %base, i64 %add
  %res = call i32 @llvm.s390.lcbb(ptr %ptr, i32 4)
  ret i32 %res
}

; LCBB with an out-of-range displacement.
define i32 @test_lcbb4(ptr %base) {
; CHECK-LABEL: test_lcbb4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    aghi %r2, 4096
; CHECK-NEXT:    lcbb %r2, 0(%r2), 5
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 4096
  %res = call i32 @llvm.s390.lcbb(ptr %ptr, i32 5)
  ret i32 %res
}

; VLBB with the lowest M3 operand.
define <16 x i8> @test_vlbb1(ptr %ptr) {
; CHECK-LABEL: test_vlbb1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlbb %v24, 0(%r2), 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vlbb(ptr %ptr, i32 0)
  ret <16 x i8> %res
}

; VLBB with the highest M3 operand.
define <16 x i8> @test_vlbb2(ptr %ptr) {
; CHECK-LABEL: test_vlbb2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlbb %v24, 0(%r2), 15
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vlbb(ptr %ptr, i32 15)
  ret <16 x i8> %res
}

; VLBB with a displacement and index.
define <16 x i8> @test_vlbb3(ptr %base, i64 %index) {
; CHECK-LABEL: test_vlbb3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vlbb %v24, 4095(%r2,%r3), 4
; CHECK-NEXT:    br %r14
  %add = add i64 %index, 4095
  %ptr = getelementptr i8, ptr %base, i64 %add
  %res = call <16 x i8> @llvm.s390.vlbb(ptr %ptr, i32 4)
  ret <16 x i8> %res
}

; VLBB with an out-of-range displacement.
define <16 x i8> @test_vlbb4(ptr %base) {
; CHECK-LABEL: test_vlbb4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    aghi %r2, 4096
; CHECK-NEXT:    vlbb %v24, 0(%r2), 5
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 4096
  %res = call <16 x i8> @llvm.s390.vlbb(ptr %ptr, i32 5)
  ret <16 x i8> %res
}

; VLL with the lowest in-range displacement.
define <16 x i8> @test_vll1(ptr %ptr, i32 %length) {
; CHECK-LABEL: test_vll1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vll %v24, %r3, 0(%r2)
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vll(i32 %length, ptr %ptr)
  ret <16 x i8> %res
}

; VLL with the highest in-range displacement.
define <16 x i8> @test_vll2(ptr %base, i32 %length) {
; CHECK-LABEL: test_vll2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vll %v24, %r3, 4095(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 4095
  %res = call <16 x i8> @llvm.s390.vll(i32 %length, ptr %ptr)
  ret <16 x i8> %res
}

; VLL with an out-of-range displacementa.
define <16 x i8> @test_vll3(ptr %base, i32 %length) {
; CHECK-LABEL: test_vll3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    aghi %r2, 4096
; CHECK-NEXT:    vll %v24, %r3, 0(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 4096
  %res = call <16 x i8> @llvm.s390.vll(i32 %length, ptr %ptr)
  ret <16 x i8> %res
}

; Check that VLL doesn't allow an index.
define <16 x i8> @test_vll4(ptr %base, i64 %index, i32 %length) {
; CHECK-LABEL: test_vll4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    agr %r2, %r3
; CHECK-NEXT:    vll %v24, %r4, 0(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 %index
  %res = call <16 x i8> @llvm.s390.vll(i32 %length, ptr %ptr)
  ret <16 x i8> %res
}

; VLL with length >= 15 should become VL.
define <16 x i8> @test_vll5(ptr %ptr) {
; CHECK-LABEL: test_vll5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v24, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vll(i32 15, ptr %ptr)
  ret <16 x i8> %res
}

; VPDI taking element 0 from each half.
define <2 x i64> @test_vpdi1(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vpdi1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdi %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vpdi(<2 x i64> %a, <2 x i64> %b, i32 0)
  ret <2 x i64> %res
}

; VPDI taking element 1 from each half.
define <2 x i64> @test_vpdi2(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vpdi2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpdi %v24, %v24, %v26, 5
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vpdi(<2 x i64> %a, <2 x i64> %b, i32 5)
  ret <2 x i64> %res
}

; VPERM.
define <16 x i8> @test_vperm(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vperm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vperm %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vperm(<16 x i8> %a, <16 x i8> %b,
                                         <16 x i8> %c)
  ret <16 x i8> %res
}

; VPKSH.
define <16 x i8> @test_vpksh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vpksh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vpksh(<8 x i16> %a, <8 x i16> %b)
  ret <16 x i8> %res
}

; VPKSF.
define <8 x i16> @test_vpksf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vpksf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vpksf(<4 x i32> %a, <4 x i32> %b)
  ret <8 x i16> %res
}

; VPKSG.
define <4 x i32> @test_vpksg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vpksg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vpksg(<2 x i64> %a, <2 x i64> %b)
  ret <4 x i32> %res
}

; VPKSHS with no processing of the result.
define <16 x i8> @test_vpkshs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vpkshs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpkshs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vpkshs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VPKSHS, storing to %ptr if all values were saturated.
define <16 x i8> @test_vpkshs_all_store(<8 x i16> %a, <8 x i16> %b, ptr %ptr) {
; CHECK-LABEL: test_vpkshs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpkshs %v24, %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB20_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vpkshs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp uge i32 %cc, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <16 x i8> %res
}

; VPKSFS with no processing of the result.
define <8 x i16> @test_vpksfs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vpksfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksfs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vpksfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VPKSFS, storing to %ptr if any values were saturated.
define <8 x i16> @test_vpksfs_any_store(<4 x i32> %a, <4 x i32> %b, ptr %ptr) {
; CHECK-LABEL: test_vpksfs_any_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksfs %v24, %v24, %v26
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB22_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vpksfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp ugt i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <8 x i16> %res
}

; VPKSGS with no processing of the result.
define <4 x i32> @test_vpksgs(<2 x i64> %a, <2 x i64> %b, ptr %ccptr) {
; CHECK-LABEL: test_vpksgs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksgs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vpksgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VPKSGS, storing to %ptr if no elements were saturated
define <4 x i32> @test_vpksgs_none_store(<2 x i64> %a, <2 x i64> %b,
; CHECK-LABEL: test_vpksgs_none_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpksgs %v24, %v24, %v26
; CHECK-NEXT:    bnher %r14
; CHECK-NEXT:  .LBB24_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                         ptr %ptr) {
  %call = call {<4 x i32>, i32} @llvm.s390.vpksgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp sle i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <4 x i32> %res
}

; VPKLSH.
define <16 x i8> @test_vpklsh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vpklsh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vpklsh(<8 x i16> %a, <8 x i16> %b)
  ret <16 x i8> %res
}

; VPKLSF.
define <8 x i16> @test_vpklsf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vpklsf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vpklsf(<4 x i32> %a, <4 x i32> %b)
  ret <8 x i16> %res
}

; VPKLSG.
define <4 x i32> @test_vpklsg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vpklsg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vpklsg(<2 x i64> %a, <2 x i64> %b)
  ret <4 x i32> %res
}

; VPKLSHS with no processing of the result.
define <16 x i8> @test_vpklshs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vpklshs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklshs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vpklshs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VPKLSHS, storing to %ptr if all values were saturated.
define <16 x i8> @test_vpklshs_all_store(<8 x i16> %a, <8 x i16> %b,
; CHECK-LABEL: test_vpklshs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklshs %v24, %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB29_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                         ptr %ptr) {
  %call = call {<16 x i8>, i32} @llvm.s390.vpklshs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp eq i32 %cc, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <16 x i8> %res
}

; VPKLSFS with no processing of the result.
define <8 x i16> @test_vpklsfs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vpklsfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsfs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vpklsfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VPKLSFS, storing to %ptr if any values were saturated.
define <8 x i16> @test_vpklsfs_any_store(<4 x i32> %a, <4 x i32> %b,
; CHECK-LABEL: test_vpklsfs_any_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsfs %v24, %v24, %v26
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB31_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                         ptr %ptr) {
  %call = call {<8 x i16>, i32} @llvm.s390.vpklsfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp ne i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <8 x i16> %res
}

; VPKLSGS with no processing of the result.
define <4 x i32> @test_vpklsgs(<2 x i64> %a, <2 x i64> %b, ptr %ccptr) {
; CHECK-LABEL: test_vpklsgs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsgs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vpklsgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VPKLSGS, storing to %ptr if no elements were saturated
define <4 x i32> @test_vpklsgs_none_store(<2 x i64> %a, <2 x i64> %b,
; CHECK-LABEL: test_vpklsgs_none_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vpklsgs %v24, %v24, %v26
; CHECK-NEXT:    bnher %r14
; CHECK-NEXT:  .LBB33_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                          ptr %ptr) {
  %call = call {<4 x i32>, i32} @llvm.s390.vpklsgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp eq i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <4 x i32> %res
}

; VSTL with the lowest in-range displacement.
define void @test_vstl1(<16 x i8> %vec, ptr %ptr, i32 %length) {
; CHECK-LABEL: test_vstl1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstl %v24, %r3, 0(%r2)
; CHECK-NEXT:    br %r14
  call void @llvm.s390.vstl(<16 x i8> %vec, i32 %length, ptr %ptr)
  ret void
}

; VSTL with the highest in-range displacement.
define void @test_vstl2(<16 x i8> %vec, ptr %base, i32 %length) {
; CHECK-LABEL: test_vstl2:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstl %v24, %r3, 4095(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 4095
  call void @llvm.s390.vstl(<16 x i8> %vec, i32 %length, ptr %ptr)
  ret void
}

; VSTL with an out-of-range displacement.
define void @test_vstl3(<16 x i8> %vec, ptr %base, i32 %length) {
; CHECK-LABEL: test_vstl3:
; CHECK:       # %bb.0:
; CHECK-NEXT:    aghi %r2, 4096
; CHECK-NEXT:    vstl %v24, %r3, 0(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 4096
  call void @llvm.s390.vstl(<16 x i8> %vec, i32 %length, ptr %ptr)
  ret void
}

; Check that VSTL doesn't allow an index.
define void @test_vstl4(<16 x i8> %vec, ptr %base, i64 %index, i32 %length) {
; CHECK-LABEL: test_vstl4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    agr %r2, %r3
; CHECK-NEXT:    vstl %v24, %r4, 0(%r2)
; CHECK-NEXT:    br %r14
  %ptr = getelementptr i8, ptr %base, i64 %index
  call void @llvm.s390.vstl(<16 x i8> %vec, i32 %length, ptr %ptr)
  ret void
}

; VSTL with length >= 15 should become VST.
define void @test_vstl5(<16 x i8> %vec, ptr %ptr) {
; CHECK-LABEL: test_vstl5:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vst %v24, 0(%r2), 3
; CHECK-NEXT:    br %r14
  call void @llvm.s390.vstl(<16 x i8> %vec, i32 15, ptr %ptr)
  ret void
}

; VUPHB.
define <8 x i16> @test_vuphb(<16 x i8> %a) {
; CHECK-LABEL: test_vuphb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuphb %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vuphb(<16 x i8> %a)
  ret <8 x i16> %res
}

; VUPHH.
define <4 x i32> @test_vuphh(<8 x i16> %a) {
; CHECK-LABEL: test_vuphh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuphh %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vuphh(<8 x i16> %a)
  ret <4 x i32> %res
}

; VUPHF.
define <2 x i64> @test_vuphf(<4 x i32> %a) {
; CHECK-LABEL: test_vuphf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuphf %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vuphf(<4 x i32> %a)
  ret <2 x i64> %res
}

; VUPLHB.
define <8 x i16> @test_vuplhb(<16 x i8> %a) {
; CHECK-LABEL: test_vuplhb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplhb %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vuplhb(<16 x i8> %a)
  ret <8 x i16> %res
}

; VUPLHH.
define <4 x i32> @test_vuplhh(<8 x i16> %a) {
; CHECK-LABEL: test_vuplhh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplhh %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vuplhh(<8 x i16> %a)
  ret <4 x i32> %res
}

; VUPLHF.
define <2 x i64> @test_vuplhf(<4 x i32> %a) {
; CHECK-LABEL: test_vuplhf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplhf %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vuplhf(<4 x i32> %a)
  ret <2 x i64> %res
}

; VUPLB.
define <8 x i16> @test_vuplb(<16 x i8> %a) {
; CHECK-LABEL: test_vuplb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplb %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vuplb(<16 x i8> %a)
  ret <8 x i16> %res
}

; VUPLHW.
define <4 x i32> @test_vuplhw(<8 x i16> %a) {
; CHECK-LABEL: test_vuplhw:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplhw %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vuplhw(<8 x i16> %a)
  ret <4 x i32> %res
}

; VUPLF.
define <2 x i64> @test_vuplf(<4 x i32> %a) {
; CHECK-LABEL: test_vuplf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vuplf %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vuplf(<4 x i32> %a)
  ret <2 x i64> %res
}

; VUPLLB.
define <8 x i16> @test_vupllb(<16 x i8> %a) {
; CHECK-LABEL: test_vupllb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vupllb %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vupllb(<16 x i8> %a)
  ret <8 x i16> %res
}

; VUPLLH.
define <4 x i32> @test_vupllh(<8 x i16> %a) {
; CHECK-LABEL: test_vupllh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vupllh %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vupllh(<8 x i16> %a)
  ret <4 x i32> %res
}

; VUPLLF.
define <2 x i64> @test_vupllf(<4 x i32> %a) {
; CHECK-LABEL: test_vupllf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vupllf %v24, %v24
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vupllf(<4 x i32> %a)
  ret <2 x i64> %res
}

; VACCB.
define <16 x i8> @test_vaccb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vaccb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vaccb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VACCH.
define <8 x i16> @test_vacch(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vacch:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vacch %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vacch(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VACCF.
define <4 x i32> @test_vaccf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vaccf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vaccf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VACCG.
define <2 x i64> @test_vaccg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vaccg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vaccg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vaccg(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %res
}

; VAQ.
define i128 @test_vaq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vaq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vaq(i128 %a, i128 %b)
  ret i128 %res
}

; VACQ.
define i128 @test_vacq(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: test_vacq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vacq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vacq(i128 %a, i128 %b, i128 %c)
  ret i128 %res
}

; VACCQ.
define i128 @test_vaccq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vaccq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vaccq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vaccq(i128 %a, i128 %b)
  ret i128 %res
}

; VACCCQ.
define i128 @test_vacccq(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: test_vacccq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vacccq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vacccq(i128 %a, i128 %b, i128 %c)
  ret i128 %res
}

; VAVGB.
define <16 x i8> @test_vavgb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vavgb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavgb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vavgb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VAVGH.
define <8 x i16> @test_vavgh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vavgh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavgh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vavgh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VAVGF.
define <4 x i32> @test_vavgf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vavgf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavgf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vavgf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VAVGG.
define <2 x i64> @test_vavgg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vavgg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavgg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vavgg(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %res
}

; VAVGLB.
define <16 x i8> @test_vavglb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vavglb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavglb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vavglb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VAVGLH.
define <8 x i16> @test_vavglh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vavglh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavglh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vavglh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VAVGLF.
define <4 x i32> @test_vavglf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vavglf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavglf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vavglf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VAVGLG.
define <2 x i64> @test_vavglg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vavglg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vavglg %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vavglg(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %res
}

; VCKSM.
define <4 x i32> @test_vcksm(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vcksm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vcksm %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vcksm(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VGFMB.
define <8 x i16> @test_vgfmb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vgfmb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vgfmb(<16 x i8> %a, <16 x i8> %b)
  ret <8 x i16> %res
}

; VGFMH.
define <4 x i32> @test_vgfmh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vgfmh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vgfmh(<8 x i16> %a, <8 x i16> %b)
  ret <4 x i32> %res
}

; VGFMF.
define <2 x i64> @test_vgfmf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vgfmf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vgfmf(<4 x i32> %a, <4 x i32> %b)
  ret <2 x i64> %res
}

; VGFMG.
define i128 @test_vgfmg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vgfmg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmg %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vgfmg(<2 x i64> %a, <2 x i64> %b)
  ret i128 %res
}

; VGFMAB.
define <8 x i16> @test_vgfmab(<16 x i8> %a, <16 x i8> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vgfmab:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmab %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vgfmab(<16 x i8> %a, <16 x i8> %b,
                                          <8 x i16> %c)
  ret <8 x i16> %res
}

; VGFMAH.
define <4 x i32> @test_vgfmah(<8 x i16> %a, <8 x i16> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vgfmah:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmah %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vgfmah(<8 x i16> %a, <8 x i16> %b,
                                          <4 x i32> %c)
  ret <4 x i32> %res
}

; VGFMAF.
define <2 x i64> @test_vgfmaf(<4 x i32> %a, <4 x i32> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vgfmaf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vgfmaf %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vgfmaf(<4 x i32> %a, <4 x i32> %b,
                                          <2 x i64> %c)
  ret <2 x i64> %res
}

; VGFMAG.
define i128 @test_vgfmag(<2 x i64> %a, <2 x i64> %b, i128 %c) {
; CHECK-LABEL: test_vgfmag:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r3), 3
; CHECK-NEXT:    vgfmag %v0, %v24, %v26, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vgfmag(<2 x i64> %a, <2 x i64> %b, i128 %c)
  ret i128 %res
}

; VMAHB.
define <16 x i8> @test_vmahb(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vmahb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vmahb(<16 x i8> %a, <16 x i8> %b,
                                         <16 x i8> %c)
  ret <16 x i8> %res
}

; VMAHH.
define <8 x i16> @test_vmahh(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmahh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmahh(<8 x i16> %a, <8 x i16> %b,
                                         <8 x i16> %c)
  ret <8 x i16> %res
}

; VMAHF.
define <4 x i32> @test_vmahf(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmahf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmahf %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmahf(<4 x i32> %a, <4 x i32> %b,
                                         <4 x i32> %c)
  ret <4 x i32> %res
}

; VMALHB.
define <16 x i8> @test_vmalhb(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vmalhb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vmalhb(<16 x i8> %a, <16 x i8> %b,
                                          <16 x i8> %c)
  ret <16 x i8> %res
}

; VMALHH.
define <8 x i16> @test_vmalhh(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmalhh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmalhh(<8 x i16> %a, <8 x i16> %b,
                                          <8 x i16> %c)
  ret <8 x i16> %res
}

; VMALHF.
define <4 x i32> @test_vmalhf(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmalhf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalhf %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmalhf(<4 x i32> %a, <4 x i32> %b,
                                          <4 x i32> %c)
  ret <4 x i32> %res
}

; VMAEB.
define <8 x i16> @test_vmaeb(<16 x i8> %a, <16 x i8> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmaeb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaeb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmaeb(<16 x i8> %a, <16 x i8> %b,
                                         <8 x i16> %c)
  ret <8 x i16> %res
}

; VMAEH.
define <4 x i32> @test_vmaeh(<8 x i16> %a, <8 x i16> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmaeh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaeh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmaeh(<8 x i16> %a, <8 x i16> %b,
                                         <4 x i32> %c)
  ret <4 x i32> %res
}

; VMAEF.
define <2 x i64> @test_vmaef(<4 x i32> %a, <4 x i32> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vmaef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaef %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmaef(<4 x i32> %a, <4 x i32> %b,
                                         <2 x i64> %c)
  ret <2 x i64> %res
}

; VMALEB.
define <8 x i16> @test_vmaleb(<16 x i8> %a, <16 x i8> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmaleb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaleb %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmaleb(<16 x i8> %a, <16 x i8> %b,
                                          <8 x i16> %c)
  ret <8 x i16> %res
}

; VMALEH.
define <4 x i32> @test_vmaleh(<8 x i16> %a, <8 x i16> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmaleh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaleh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmaleh(<8 x i16> %a, <8 x i16> %b,
                                          <4 x i32> %c)
  ret <4 x i32> %res
}

; VMALEF.
define <2 x i64> @test_vmalef(<4 x i32> %a, <4 x i32> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vmalef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalef %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmalef(<4 x i32> %a, <4 x i32> %b,
                                          <2 x i64> %c)
  ret <2 x i64> %res
}

; VMAOB.
define <8 x i16> @test_vmaob(<16 x i8> %a, <16 x i8> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmaob:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaob %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmaob(<16 x i8> %a, <16 x i8> %b,
                                         <8 x i16> %c)
  ret <8 x i16> %res
}

; VMAOH.
define <4 x i32> @test_vmaoh(<8 x i16> %a, <8 x i16> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmaoh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaoh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmaoh(<8 x i16> %a, <8 x i16> %b,
                                         <4 x i32> %c)
  ret <4 x i32> %res
}

; VMAOF.
define <2 x i64> @test_vmaof(<4 x i32> %a, <4 x i32> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vmaof:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaof %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmaof(<4 x i32> %a, <4 x i32> %b,
                                         <2 x i64> %c)
  ret <2 x i64> %res
}

; VMALOB.
define <8 x i16> @test_vmalob(<16 x i8> %a, <16 x i8> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vmalob:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalob %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmalob(<16 x i8> %a, <16 x i8> %b,
                                          <8 x i16> %c)
  ret <8 x i16> %res
}

; VMALOH.
define <4 x i32> @test_vmaloh(<8 x i16> %a, <8 x i16> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vmaloh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmaloh %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmaloh(<8 x i16> %a, <8 x i16> %b,
                                          <4 x i32> %c)
  ret <4 x i32> %res
}

; VMALOF.
define <2 x i64> @test_vmalof(<4 x i32> %a, <4 x i32> %b, <2 x i64> %c) {
; CHECK-LABEL: test_vmalof:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmalof %v24, %v24, %v26, %v28
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmalof(<4 x i32> %a, <4 x i32> %b,
                                          <2 x i64> %c)
  ret <2 x i64> %res
}

; VMHB.
define <16 x i8> @test_vmhb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vmhb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vmhb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VMHH.
define <8 x i16> @test_vmhh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmhh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmhh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VMHF.
define <4 x i32> @test_vmhf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmhf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmhf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmhf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VMLHB.
define <16 x i8> @test_vmlhb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vmlhb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vmlhb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VMLHH.
define <8 x i16> @test_vmlhh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmlhh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmlhh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VMLHF.
define <4 x i32> @test_vmlhf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlhf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlhf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmlhf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VMEB.
define <8 x i16> @test_vmeb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vmeb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmeb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmeb(<16 x i8> %a, <16 x i8> %b)
  ret <8 x i16> %res
}

; VMEH.
define <4 x i32> @test_vmeh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmeh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmeh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmeh(<8 x i16> %a, <8 x i16> %b)
  ret <4 x i32> %res
}

; VMEF.
define <2 x i64> @test_vmef(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmef %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmef(<4 x i32> %a, <4 x i32> %b)
  ret <2 x i64> %res
}

; VMLEB.
define <8 x i16> @test_vmleb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vmleb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmleb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmleb(<16 x i8> %a, <16 x i8> %b)
  ret <8 x i16> %res
}

; VMLEH.
define <4 x i32> @test_vmleh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmleh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmleh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmleh(<8 x i16> %a, <8 x i16> %b)
  ret <4 x i32> %res
}

; VMLEF.
define <2 x i64> @test_vmlef(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlef %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmlef(<4 x i32> %a, <4 x i32> %b)
  ret <2 x i64> %res
}

; VMOB.
define <8 x i16> @test_vmob(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vmob:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmob %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmob(<16 x i8> %a, <16 x i8> %b)
  ret <8 x i16> %res
}

; VMOH.
define <4 x i32> @test_vmoh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmoh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmoh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmoh(<8 x i16> %a, <8 x i16> %b)
  ret <4 x i32> %res
}

; VMOF.
define <2 x i64> @test_vmof(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmof:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmof %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmof(<4 x i32> %a, <4 x i32> %b)
  ret <2 x i64> %res
}

; VMLOB.
define <8 x i16> @test_vmlob(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vmlob:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlob %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vmlob(<16 x i8> %a, <16 x i8> %b)
  ret <8 x i16> %res
}

; VMLOH.
define <4 x i32> @test_vmloh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vmloh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmloh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vmloh(<8 x i16> %a, <8 x i16> %b)
  ret <4 x i32> %res
}

; VMLOF.
define <2 x i64> @test_vmlof(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vmlof:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vmlof %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vmlof(<4 x i32> %a, <4 x i32> %b)
  ret <2 x i64> %res
}

; VERIMB.
define <16 x i8> @test_verimb(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_verimb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verimb %v24, %v26, %v28, 1
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.verimb(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, i32 1)
  ret <16 x i8> %res
}

; VERIMH.
define <8 x i16> @test_verimh(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_verimh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verimh %v24, %v26, %v28, 1
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.verimh(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c, i32 1)
  ret <8 x i16> %res
}

; VERIMF.
define <4 x i32> @test_verimf(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_verimf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verimf %v24, %v26, %v28, 1
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.verimf(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c, i32 1)
  ret <4 x i32> %res
}

; VERIMG.
define <2 x i64> @test_verimg(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c) {
; CHECK-LABEL: test_verimg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verimg %v24, %v26, %v28, 1
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.verimg(<2 x i64> %a, <2 x i64> %b, <2 x i64> %c, i32 1)
  ret <2 x i64> %res
}

; VERIMB with a different mask.
define <16 x i8> @test_verimb_254(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_verimb_254:
; CHECK:       # %bb.0:
; CHECK-NEXT:    verimb %v24, %v26, %v28, 254
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.verimb(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c, i32 254)
  ret <16 x i8> %res
}

; VSL.
define <16 x i8> @test_vsl(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsl %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsl(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSLB.
define <16 x i8> @test_vslb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vslb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vslb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vslb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSRA.
define <16 x i8> @test_vsra(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsra:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsra %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsra(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSRAB.
define <16 x i8> @test_vsrab(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsrab:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrab %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsrab(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSRL.
define <16 x i8> @test_vsrl(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsrl:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrl %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsrl(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSRLB.
define <16 x i8> @test_vsrlb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsrlb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsrlb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsrlb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSLDB with the minimum useful value.
define <16 x i8> @test_vsldb_1(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsldb_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsldb %v24, %v24, %v26, 1
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsldb(<16 x i8> %a, <16 x i8> %b, i32 1)
  ret <16 x i8> %res
}

; VSLDB with the maximum value.
define <16 x i8> @test_vsldb_15(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsldb_15:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsldb %v24, %v24, %v26, 15
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vsldb(<16 x i8> %a, <16 x i8> %b, i32 15)
  ret <16 x i8> %res
}

; VSCBIB.
define <16 x i8> @test_vscbib(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vscbib:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbib %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vscbib(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VSCBIH.
define <8 x i16> @test_vscbih(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vscbih:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbih %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vscbih(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VSCBIF.
define <4 x i32> @test_vscbif(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vscbif:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbif %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vscbif(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VSCBIG.
define <2 x i64> @test_vscbig(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vscbig:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vscbig %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vscbig(<2 x i64> %a, <2 x i64> %b)
  ret <2 x i64> %res
}

; VSQ.
define i128 @test_vsq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vsq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vsq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vsq(i128 %a, i128 %b)
  ret i128 %res
}

; VSBIQ.
define i128 @test_vsbiq(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: test_vsbiq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vsbiq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vsbiq(i128 %a, i128 %b, i128 %c)
  ret i128 %res
}

; VSCBIQ.
define i128 @test_vscbiq(i128 %a, i128 %b) {
; CHECK-LABEL: test_vscbiq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r4), 3
; CHECK-NEXT:    vl %v1, 0(%r3), 3
; CHECK-NEXT:    vscbiq %v0, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vscbiq(i128 %a, i128 %b)
  ret i128 %res
}

; VSBCBIQ.
define i128 @test_vsbcbiq(i128 %a, i128 %b, i128 %c) {
; CHECK-LABEL: test_vsbcbiq:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl %v0, 0(%r5), 3
; CHECK-NEXT:    vl %v1, 0(%r4), 3
; CHECK-NEXT:    vl %v2, 0(%r3), 3
; CHECK-NEXT:    vsbcbiq %v0, %v2, %v1, %v0
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vsbcbiq(i128 %a, i128 %b, i128 %c)
  ret i128 %res
}

; VSUMB.
define <4 x i32> @test_vsumb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vsumb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsumb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vsumb(<16 x i8> %a, <16 x i8> %b)
  ret <4 x i32> %res
}

; VSUMH.
define <4 x i32> @test_vsumh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vsumh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsumh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vsumh(<8 x i16> %a, <8 x i16> %b)
  ret <4 x i32> %res
}

; VSUMGH.
define <2 x i64> @test_vsumgh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vsumgh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsumgh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vsumgh(<8 x i16> %a, <8 x i16> %b)
  ret <2 x i64> %res
}

; VSUMGF.
define <2 x i64> @test_vsumgf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vsumgf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsumgf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <2 x i64> @llvm.s390.vsumgf(<4 x i32> %a, <4 x i32> %b)
  ret <2 x i64> %res
}

; VSUMQF.
define i128 @test_vsumqf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vsumqf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsumqf %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vsumqf(<4 x i32> %a, <4 x i32> %b)
  ret i128 %res
}

; VSUMQG.
define i128 @test_vsumqg(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vsumqg:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsumqg %v0, %v24, %v26
; CHECK-NEXT:    vst %v0, 0(%r2), 3
; CHECK-NEXT:    br %r14
  %res = call i128 @llvm.s390.vsumqg(<2 x i64> %a, <2 x i64> %b)
  ret i128 %res
}

; VTM with no processing of the result.
define i32 @test_vtm(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vtm:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vtm %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %res = call i32 @llvm.s390.vtm(<16 x i8> %a, <16 x i8> %b)
  ret i32 %res
}

; VTM, storing to %ptr if all bits are set.
define void @test_vtm_all_store(<16 x i8> %a, <16 x i8> %b, ptr %ptr) {
; CHECK-LABEL: test_vtm_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vtm %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB140_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %res = call i32 @llvm.s390.vtm(<16 x i8> %a, <16 x i8> %b)
  %cmp = icmp sge i32 %res, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret void
}

; VCEQBS with no processing of the result.
define i32 @test_vceqbs(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vceqbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vceqbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 1
  ret i32 %res
}

; VCEQBS, returning 1 if any elements are equal (CC != 3).
define i32 @test_vceqbs_any_bool(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vceqbs_any_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqbs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochile %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vceqbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp ne i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCEQBS, storing to %ptr if any elements are equal.
define <16 x i8> @test_vceqbs_any_store(<16 x i8> %a, <16 x i8> %b, ptr %ptr) {
; CHECK-LABEL: test_vceqbs_any_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqbs %v24, %v24, %v26
; CHECK-NEXT:    bor %r14
; CHECK-NEXT:  .LBB143_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vceqbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp ule i32 %cc, 2
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <16 x i8> %res
}

; VCEQHS with no processing of the result.
define i32 @test_vceqhs(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vceqhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vceqhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 1
  ret i32 %res
}

; VCEQHS, returning 1 if not all elements are equal.
define i32 @test_vceqhs_notall_bool(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vceqhs_notall_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqhs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochinhe %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vceqhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp sge i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCEQHS, storing to %ptr if not all elements are equal.
define <8 x i16> @test_vceqhs_notall_store(<8 x i16> %a, <8 x i16> %b,
; CHECK-LABEL: test_vceqhs_notall_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqhs %v24, %v24, %v26
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB146_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                           ptr %ptr) {
  %call = call {<8 x i16>, i32} @llvm.s390.vceqhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp ugt i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <8 x i16> %res
}

; VCEQFS with no processing of the result.
define i32 @test_vceqfs(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vceqfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vceqfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 1
  ret i32 %res
}

; VCEQFS, returning 1 if no elements are equal.
define i32 @test_vceqfs_none_bool(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vceqfs_none_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqfs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochio %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vceqfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp eq i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCEQFS, storing to %ptr if no elements are equal.
define <4 x i32> @test_vceqfs_none_store(<4 x i32> %a, <4 x i32> %b,
; CHECK-LABEL: test_vceqfs_none_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqfs %v24, %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB149_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                         ptr %ptr) {
  %call = call {<4 x i32>, i32} @llvm.s390.vceqfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp uge i32 %cc, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <4 x i32> %res
}

; VCEQGS with no processing of the result.
define i32 @test_vceqgs(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vceqgs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vceqgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VCEQGS returning 1 if all elements are equal (CC == 0).
define i32 @test_vceqgs_all_bool(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vceqgs_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqgs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vceqgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp ult i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCEQGS, storing to %ptr if all elements are equal.
define <2 x i64> @test_vceqgs_all_store(<2 x i64> %a, <2 x i64> %b, ptr %ptr) {
; CHECK-LABEL: test_vceqgs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vceqgs %v24, %v24, %v26
; CHECK-NEXT:    bnher %r14
; CHECK-NEXT:  .LBB152_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vceqgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 0
  %cc = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp sle i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <2 x i64> %res
}

; VCHBS with no processing of the result.
define i32 @test_vchbs(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vchbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vchbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 1
  ret i32 %res
}

; VCHBS, returning 1 if any elements are higher (CC != 3).
define i32 @test_vchbs_any_bool(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vchbs_any_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchbs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochile %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vchbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp ne i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHBS, storing to %ptr if any elements are higher.
define <16 x i8> @test_vchbs_any_store(<16 x i8> %a, <16 x i8> %b, ptr %ptr) {
; CHECK-LABEL: test_vchbs_any_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchbs %v24, %v24, %v26
; CHECK-NEXT:    bor %r14
; CHECK-NEXT:  .LBB155_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vchbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp ule i32 %cc, 2
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <16 x i8> %res
}

; VCHHS with no processing of the result.
define i32 @test_vchhs(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vchhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vchhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 1
  ret i32 %res
}

; VCHHS, returning 1 if not all elements are higher.
define i32 @test_vchhs_notall_bool(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vchhs_notall_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchhs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochinhe %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vchhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp sge i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHHS, storing to %ptr if not all elements are higher.
define <8 x i16> @test_vchhs_notall_store(<8 x i16> %a, <8 x i16> %b,
; CHECK-LABEL: test_vchhs_notall_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchhs %v24, %v24, %v26
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB158_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                          ptr %ptr) {
  %call = call {<8 x i16>, i32} @llvm.s390.vchhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp ugt i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <8 x i16> %res
}

; VCHFS with no processing of the result.
define i32 @test_vchfs(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vchfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vchfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 1
  ret i32 %res
}

; VCHFS, returning 1 if no elements are higher.
define i32 @test_vchfs_none_bool(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vchfs_none_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchfs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochio %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vchfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp eq i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHFS, storing to %ptr if no elements are higher.
define <4 x i32> @test_vchfs_none_store(<4 x i32> %a, <4 x i32> %b, ptr %ptr) {
; CHECK-LABEL: test_vchfs_none_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchfs %v24, %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB161_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vchfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp uge i32 %cc, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <4 x i32> %res
}

; VCHGS with no processing of the result.
define i32 @test_vchgs(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vchgs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vchgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VCHGS returning 1 if all elements are higher (CC == 0).
define i32 @test_vchgs_all_bool(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vchgs_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchgs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vchgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp ult i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHGS, storing to %ptr if all elements are higher.
define <2 x i64> @test_vchgs_all_store(<2 x i64> %a, <2 x i64> %b, ptr %ptr) {
; CHECK-LABEL: test_vchgs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchgs %v24, %v24, %v26
; CHECK-NEXT:    bnher %r14
; CHECK-NEXT:  .LBB164_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vchgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 0
  %cc = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp sle i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <2 x i64> %res
}

; VCHLBS with no processing of the result.
define i32 @test_vchlbs(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vchlbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vchlbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 1
  ret i32 %res
}

; VCHLBS, returning 1 if any elements are higher (CC != 3).
define i32 @test_vchlbs_any_bool(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vchlbs_any_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlbs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochile %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vchlbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp ne i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHLBS, storing to %ptr if any elements are higher.
define <16 x i8> @test_vchlbs_any_store(<16 x i8> %a, <16 x i8> %b, ptr %ptr) {
; CHECK-LABEL: test_vchlbs_any_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlbs %v24, %v24, %v26
; CHECK-NEXT:    bor %r14
; CHECK-NEXT:  .LBB167_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vchlbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  %cmp = icmp sle i32 %cc, 2
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <16 x i8> %res
}

; VCHLHS with no processing of the result.
define i32 @test_vchlhs(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vchlhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vchlhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 1
  ret i32 %res
}

; VCHLHS, returning 1 if not all elements are higher.
define i32 @test_vchlhs_notall_bool(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vchlhs_notall_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlhs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochinhe %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vchlhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp uge i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHLHS, storing to %ptr if not all elements are higher.
define <8 x i16> @test_vchlhs_notall_store(<8 x i16> %a, <8 x i16> %b,
; CHECK-LABEL: test_vchlhs_notall_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlhs %v24, %v24, %v26
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB170_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                           ptr %ptr) {
  %call = call {<8 x i16>, i32} @llvm.s390.vchlhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  %cmp = icmp sgt i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <8 x i16> %res
}

; VCHLFS with no processing of the result.
define i32 @test_vchlfs(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vchlfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vchlfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 1
  ret i32 %res
}

; VCHLFS, returning 1 if no elements are higher.
define i32 @test_vchlfs_none_bool(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vchlfs_none_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlfs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochio %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vchlfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp eq i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHLFS, storing to %ptr if no elements are higher.
define <4 x i32> @test_vchlfs_none_store(<4 x i32> %a, <4 x i32> %b,
; CHECK-LABEL: test_vchlfs_none_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlfs %v24, %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB173_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                         ptr %ptr) {
  %call = call {<4 x i32>, i32} @llvm.s390.vchlfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  %cmp = icmp sge i32 %cc, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <4 x i32> %res
}

; VCHLGS with no processing of the result.
define i32 @test_vchlgs(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vchlgs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vchlgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VCHLGS returning 1 if all elements are higher (CC == 0).
define i32 @test_vchlgs_all_bool(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: test_vchlgs_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlgs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vchlgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp slt i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VCHLGS, storing to %ptr if all elements are higher.
define <2 x i64> @test_vchlgs_all_store(<2 x i64> %a, <2 x i64> %b, ptr %ptr) {
; CHECK-LABEL: test_vchlgs_all_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vchlgs %v24, %v24, %v26
; CHECK-NEXT:    bnher %r14
; CHECK-NEXT:  .LBB176_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vchlgs(<2 x i64> %a, <2 x i64> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 0
  %cc = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp ule i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <2 x i64> %res
}

; VFAEB with !IN !RT.
define <16 x i8> @test_vfaeb_0(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaeb_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaeb %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaeb(<16 x i8> %a, <16 x i8> %b, i32 0)
  ret <16 x i8> %res
}

; VFAEB with !IN RT.
define <16 x i8> @test_vfaeb_4(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaeb_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaeb %v24, %v24, %v26, 4
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaeb(<16 x i8> %a, <16 x i8> %b, i32 4)
  ret <16 x i8> %res
}

; VFAEB with IN !RT.
define <16 x i8> @test_vfaeb_8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaeb_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaeb %v24, %v24, %v26, 8
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaeb(<16 x i8> %a, <16 x i8> %b, i32 8)
  ret <16 x i8> %res
}

; VFAEB with IN RT.
define <16 x i8> @test_vfaeb_12(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaeb_12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaeb %v24, %v24, %v26, 12
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaeb(<16 x i8> %a, <16 x i8> %b, i32 12)
  ret <16 x i8> %res
}

; VFAEB with CS -- should be ignored.
define <16 x i8> @test_vfaeb_1(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaeb_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaeb %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaeb(<16 x i8> %a, <16 x i8> %b, i32 1)
  ret <16 x i8> %res
}

; VFAEH.
define <8 x i16> @test_vfaeh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vfaeh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaeh %v24, %v24, %v26, 4
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vfaeh(<8 x i16> %a, <8 x i16> %b, i32 4)
  ret <8 x i16> %res
}

; VFAEF.
define <4 x i32> @test_vfaef(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vfaef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaef %v24, %v24, %v26, 8
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vfaef(<4 x i32> %a, <4 x i32> %b, i32 8)
  ret <4 x i32> %res
}

; VFAEBS.
define <16 x i8> @test_vfaebs(<16 x i8> %a, <16 x i8> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfaebs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaebs %v24, %v24, %v26, 0
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vfaebs(<16 x i8> %a, <16 x i8> %b,
                                                  i32 0)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VFAEHS.
define <8 x i16> @test_vfaehs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfaehs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaehs %v24, %v24, %v26, 4
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vfaehs(<8 x i16> %a, <8 x i16> %b,
                                                  i32 4)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VFAEFS.
define <4 x i32> @test_vfaefs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfaefs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaefs %v24, %v24, %v26, 8
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vfaefs(<4 x i32> %a, <4 x i32> %b,
                                                  i32 8)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VFAEZB with !IN !RT.
define <16 x i8> @test_vfaezb_0(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaezb_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezb %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaezb(<16 x i8> %a, <16 x i8> %b, i32 0)
  ret <16 x i8> %res
}

; VFAEZB with !IN RT.
define <16 x i8> @test_vfaezb_4(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaezb_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezb %v24, %v24, %v26, 4
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaezb(<16 x i8> %a, <16 x i8> %b, i32 4)
  ret <16 x i8> %res
}

; VFAEZB with IN !RT.
define <16 x i8> @test_vfaezb_8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaezb_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezb %v24, %v24, %v26, 8
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaezb(<16 x i8> %a, <16 x i8> %b, i32 8)
  ret <16 x i8> %res
}

; VFAEZB with IN RT.
define <16 x i8> @test_vfaezb_12(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaezb_12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezb %v24, %v24, %v26, 12
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaezb(<16 x i8> %a, <16 x i8> %b, i32 12)
  ret <16 x i8> %res
}

; VFAEZB with CS -- should be ignored.
define <16 x i8> @test_vfaezb_1(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfaezb_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezb %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfaezb(<16 x i8> %a, <16 x i8> %b, i32 1)
  ret <16 x i8> %res
}

; VFAEZH.
define <8 x i16> @test_vfaezh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vfaezh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezh %v24, %v24, %v26, 4
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vfaezh(<8 x i16> %a, <8 x i16> %b, i32 4)
  ret <8 x i16> %res
}

; VFAEZF.
define <4 x i32> @test_vfaezf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vfaezf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezf %v24, %v24, %v26, 8
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vfaezf(<4 x i32> %a, <4 x i32> %b, i32 8)
  ret <4 x i32> %res
}

; VFAEZBS.
define <16 x i8> @test_vfaezbs(<16 x i8> %a, <16 x i8> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfaezbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezbs %v24, %v24, %v26, 0
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vfaezbs(<16 x i8> %a, <16 x i8> %b,
                                                   i32 0)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VFAEZHS.
define <8 x i16> @test_vfaezhs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfaezhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezhs %v24, %v24, %v26, 4
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vfaezhs(<8 x i16> %a, <8 x i16> %b,
                                                   i32 4)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VFAEZFS.
define <4 x i32> @test_vfaezfs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfaezfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfaezfs %v24, %v24, %v26, 8
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vfaezfs(<4 x i32> %a, <4 x i32> %b,
                                                   i32 8)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VFEEB.
define <16 x i8> @test_vfeeb_0(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfeeb_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeeb %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfeeb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VFEEH.
define <8 x i16> @test_vfeeh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vfeeh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeeh %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vfeeh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VFEEF.
define <4 x i32> @test_vfeef(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vfeef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeef %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vfeef(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VFEEBS.
define <16 x i8> @test_vfeebs(<16 x i8> %a, <16 x i8> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfeebs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeebs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vfeebs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VFEEHS.
define <8 x i16> @test_vfeehs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfeehs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeehs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vfeehs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VFEEFS.
define <4 x i32> @test_vfeefs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfeefs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeefs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vfeefs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VFEEZB.
define <16 x i8> @test_vfeezb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfeezb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeezb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfeezb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VFEEZH.
define <8 x i16> @test_vfeezh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vfeezh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeezh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vfeezh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VFEEZF.
define <4 x i32> @test_vfeezf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vfeezf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeezf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vfeezf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VFEEZBS.
define <16 x i8> @test_vfeezbs(<16 x i8> %a, <16 x i8> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfeezbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeezbs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vfeezbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VFEEZHS.
define <8 x i16> @test_vfeezhs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfeezhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeezhs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vfeezhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VFEEZFS.
define <4 x i32> @test_vfeezfs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfeezfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeezfs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vfeezfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VFENEB.
define <16 x i8> @test_vfeneb_0(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfeneb_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeneb %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfeneb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VFENEH.
define <8 x i16> @test_vfeneh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vfeneh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfeneh %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vfeneh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VFENEF.
define <4 x i32> @test_vfenef(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vfenef:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenef %v24, %v24, %v26, 0
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vfenef(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VFENEBS.
define <16 x i8> @test_vfenebs(<16 x i8> %a, <16 x i8> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfenebs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenebs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vfenebs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VFENEHS.
define <8 x i16> @test_vfenehs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfenehs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenehs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vfenehs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VFENEFS.
define <4 x i32> @test_vfenefs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfenefs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenefs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vfenefs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VFENEZB.
define <16 x i8> @test_vfenezb(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: test_vfenezb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenezb %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vfenezb(<16 x i8> %a, <16 x i8> %b)
  ret <16 x i8> %res
}

; VFENEZH.
define <8 x i16> @test_vfenezh(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: test_vfenezh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenezh %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vfenezh(<8 x i16> %a, <8 x i16> %b)
  ret <8 x i16> %res
}

; VFENEZF.
define <4 x i32> @test_vfenezf(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: test_vfenezf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenezf %v24, %v24, %v26
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vfenezf(<4 x i32> %a, <4 x i32> %b)
  ret <4 x i32> %res
}

; VFENEZBS.
define <16 x i8> @test_vfenezbs(<16 x i8> %a, <16 x i8> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfenezbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenezbs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vfenezbs(<16 x i8> %a, <16 x i8> %b)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VFENEZHS.
define <8 x i16> @test_vfenezhs(<8 x i16> %a, <8 x i16> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfenezhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenezhs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vfenezhs(<8 x i16> %a, <8 x i16> %b)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VFENEZFS.
define <4 x i32> @test_vfenezfs(<4 x i32> %a, <4 x i32> %b, ptr %ccptr) {
; CHECK-LABEL: test_vfenezfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfenezfs %v24, %v24, %v26
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vfenezfs(<4 x i32> %a, <4 x i32> %b)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VISTRB.
define <16 x i8> @test_vistrb(<16 x i8> %a) {
; CHECK-LABEL: test_vistrb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vistrb %v24, %v24, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vistrb(<16 x i8> %a)
  ret <16 x i8> %res
}

; VISTRH.
define <8 x i16> @test_vistrh(<8 x i16> %a) {
; CHECK-LABEL: test_vistrh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vistrh %v24, %v24, 0
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vistrh(<8 x i16> %a)
  ret <8 x i16> %res
}

; VISTRF.
define <4 x i32> @test_vistrf(<4 x i32> %a) {
; CHECK-LABEL: test_vistrf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vistrf %v24, %v24, 0
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vistrf(<4 x i32> %a)
  ret <4 x i32> %res
}

; VISTRBS.
define <16 x i8> @test_vistrbs(<16 x i8> %a, ptr %ccptr) {
; CHECK-LABEL: test_vistrbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vistrbs %v24, %v24
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<16 x i8>, i32} @llvm.s390.vistrbs(<16 x i8> %a)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VISTRHS.
define <8 x i16> @test_vistrhs(<8 x i16> %a, ptr %ccptr) {
; CHECK-LABEL: test_vistrhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vistrhs %v24, %v24
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<8 x i16>, i32} @llvm.s390.vistrhs(<8 x i16> %a)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VISTRFS.
define <4 x i32> @test_vistrfs(<4 x i32> %a, ptr %ccptr) {
; CHECK-LABEL: test_vistrfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vistrfs %v24, %v24
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
  %call = call {<4 x i32>, i32} @llvm.s390.vistrfs(<4 x i32> %a)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VSTRCB with !IN !RT.
define <16 x i8> @test_vstrcb_0(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrcb_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcb %v24, %v24, %v26, %v28, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrcb(<16 x i8> %a, <16 x i8> %b,
                                          <16 x i8> %c, i32 0)
  ret <16 x i8> %res
}

; VSTRCB with !IN RT.
define <16 x i8> @test_vstrcb_4(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrcb_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcb %v24, %v24, %v26, %v28, 4
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrcb(<16 x i8> %a, <16 x i8> %b,
                                          <16 x i8> %c, i32 4)
  ret <16 x i8> %res
}

; VSTRCB with IN !RT.
define <16 x i8> @test_vstrcb_8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrcb_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcb %v24, %v24, %v26, %v28, 8
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrcb(<16 x i8> %a, <16 x i8> %b,
                                          <16 x i8> %c, i32 8)
  ret <16 x i8> %res
}

; VSTRCB with IN RT.
define <16 x i8> @test_vstrcb_12(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrcb_12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcb %v24, %v24, %v26, %v28, 12
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrcb(<16 x i8> %a, <16 x i8> %b,
                                          <16 x i8> %c, i32 12)
  ret <16 x i8> %res
}

; VSTRCB with CS -- should be ignored.
define <16 x i8> @test_vstrcb_1(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrcb_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcb %v24, %v24, %v26, %v28, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrcb(<16 x i8> %a, <16 x i8> %b,
                                          <16 x i8> %c, i32 1)
  ret <16 x i8> %res
}

; VSTRCH.
define <8 x i16> @test_vstrch(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vstrch:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrch %v24, %v24, %v26, %v28, 4
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vstrch(<8 x i16> %a, <8 x i16> %b,
                                          <8 x i16> %c, i32 4)
  ret <8 x i16> %res
}

; VSTRCF.
define <4 x i32> @test_vstrcf(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vstrcf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcf %v24, %v24, %v26, %v28, 8
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vstrcf(<4 x i32> %a, <4 x i32> %b,
                                          <4 x i32> %c, i32 8)
  ret <4 x i32> %res
}

; VSTRCBS.
define <16 x i8> @test_vstrcbs(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c,
; CHECK-LABEL: test_vstrcbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcbs %v24, %v24, %v26, %v28, 0
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
                               ptr %ccptr) {
  %call = call {<16 x i8>, i32} @llvm.s390.vstrcbs(<16 x i8> %a, <16 x i8> %b,
                                                   <16 x i8> %c, i32 0)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VSTRCHS.
define <8 x i16> @test_vstrchs(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c,
; CHECK-LABEL: test_vstrchs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrchs %v24, %v24, %v26, %v28, 4
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
                               ptr %ccptr) {
  %call = call {<8 x i16>, i32} @llvm.s390.vstrchs(<8 x i16> %a, <8 x i16> %b,
                                                   <8 x i16> %c, i32 4)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VSTRCFS.
define <4 x i32> @test_vstrcfs(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c,
; CHECK-LABEL: test_vstrcfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrcfs %v24, %v24, %v26, %v28, 8
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
                               ptr %ccptr) {
  %call = call {<4 x i32>, i32} @llvm.s390.vstrcfs(<4 x i32> %a, <4 x i32> %b,
                                                   <4 x i32> %c, i32 8)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VSTRCZB with !IN !RT.
define <16 x i8> @test_vstrczb_0(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrczb_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczb %v24, %v24, %v26, %v28, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrczb(<16 x i8> %a, <16 x i8> %b,
                                           <16 x i8> %c, i32 0)
  ret <16 x i8> %res
}

; VSTRCZB with !IN RT.
define <16 x i8> @test_vstrczb_4(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrczb_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczb %v24, %v24, %v26, %v28, 4
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrczb(<16 x i8> %a, <16 x i8> %b,
                                           <16 x i8> %c, i32 4)
  ret <16 x i8> %res
}

; VSTRCZB with IN !RT.
define <16 x i8> @test_vstrczb_8(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrczb_8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczb %v24, %v24, %v26, %v28, 8
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrczb(<16 x i8> %a, <16 x i8> %b,
                                           <16 x i8> %c, i32 8)
  ret <16 x i8> %res
}

; VSTRCZB with IN RT.
define <16 x i8> @test_vstrczb_12(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrczb_12:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczb %v24, %v24, %v26, %v28, 12
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrczb(<16 x i8> %a, <16 x i8> %b,
                                           <16 x i8> %c, i32 12)
  ret <16 x i8> %res
}

; VSTRCZB with CS -- should be ignored.
define <16 x i8> @test_vstrczb_1(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c) {
; CHECK-LABEL: test_vstrczb_1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczb %v24, %v24, %v26, %v28, 0
; CHECK-NEXT:    br %r14
  %res = call <16 x i8> @llvm.s390.vstrczb(<16 x i8> %a, <16 x i8> %b,
                                           <16 x i8> %c, i32 1)
  ret <16 x i8> %res
}

; VSTRCZH.
define <8 x i16> @test_vstrczh(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c) {
; CHECK-LABEL: test_vstrczh:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczh %v24, %v24, %v26, %v28, 4
; CHECK-NEXT:    br %r14
  %res = call <8 x i16> @llvm.s390.vstrczh(<8 x i16> %a, <8 x i16> %b,
                                           <8 x i16> %c,  i32 4)
  ret <8 x i16> %res
}

; VSTRCZF.
define <4 x i32> @test_vstrczf(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c) {
; CHECK-LABEL: test_vstrczf:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczf %v24, %v24, %v26, %v28, 8
; CHECK-NEXT:    br %r14
  %res = call <4 x i32> @llvm.s390.vstrczf(<4 x i32> %a, <4 x i32> %b,
                                           <4 x i32> %c, i32 8)
  ret <4 x i32> %res
}

; VSTRCZBS.
define <16 x i8> @test_vstrczbs(<16 x i8> %a, <16 x i8> %b, <16 x i8> %c,
; CHECK-LABEL: test_vstrczbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczbs %v24, %v24, %v26, %v28, 0
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
                                ptr %ccptr) {
  %call = call {<16 x i8>, i32} @llvm.s390.vstrczbs(<16 x i8> %a, <16 x i8> %b,
                                                    <16 x i8> %c, i32 0)
  %res = extractvalue {<16 x i8>, i32} %call, 0
  %cc = extractvalue {<16 x i8>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <16 x i8> %res
}

; VSTRCZHS.
define <8 x i16> @test_vstrczhs(<8 x i16> %a, <8 x i16> %b, <8 x i16> %c,
; CHECK-LABEL: test_vstrczhs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczhs %v24, %v24, %v26, %v28, 4
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
                                ptr %ccptr) {
  %call = call {<8 x i16>, i32} @llvm.s390.vstrczhs(<8 x i16> %a, <8 x i16> %b,
                                                    <8 x i16> %c, i32 4)
  %res = extractvalue {<8 x i16>, i32} %call, 0
  %cc = extractvalue {<8 x i16>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <8 x i16> %res
}

; VSTRCZFS.
define <4 x i32> @test_vstrczfs(<4 x i32> %a, <4 x i32> %b, <4 x i32> %c,
; CHECK-LABEL: test_vstrczfs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vstrczfs %v24, %v24, %v26, %v28, 8
; CHECK-NEXT:    ipm %r0
; CHECK-NEXT:    srl %r0, 28
; CHECK-NEXT:    st %r0, 0(%r2)
; CHECK-NEXT:    br %r14
                                ptr %ccptr) {
  %call = call {<4 x i32>, i32} @llvm.s390.vstrczfs(<4 x i32> %a, <4 x i32> %b,
                                                    <4 x i32> %c, i32 8)
  %res = extractvalue {<4 x i32>, i32} %call, 0
  %cc = extractvalue {<4 x i32>, i32} %call, 1
  store i32 %cc, ptr %ccptr
  ret <4 x i32> %res
}

; VFCEDBS with no processing of the result.
define i32 @test_vfcedbs(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_vfcedbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vfcedbs(<2 x double> %a,
                                                   <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VFCEDBS, returning 1 if any elements are equal (CC != 3).
define i32 @test_vfcedbs_any_bool(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_vfcedbs_any_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcedbs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochile %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vfcedbs(<2 x double> %a,
                                                   <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp ne i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VFCEDBS, storing to %ptr if any elements are equal.
define <2 x i64> @test_vfcedbs_any_store(<2 x double> %a, <2 x double> %b,
; CHECK-LABEL: test_vfcedbs_any_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfcedbs %v24, %v24, %v26
; CHECK-NEXT:    bor %r14
; CHECK-NEXT:  .LBB249_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                         ptr %ptr) {
  %call = call {<2 x i64>, i32} @llvm.s390.vfcedbs(<2 x double> %a,
                                                   <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 0
  %cc = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp ule i32 %cc, 2
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <2 x i64> %res
}

; VFCHDBS with no processing of the result.
define i32 @test_vfchdbs(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_vfchdbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vfchdbs(<2 x double> %a,
                                                   <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VFCHDBS, returning 1 if not all elements are higher.
define i32 @test_vfchdbs_notall_bool(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_vfchdbs_notall_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfchdbs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochinhe %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vfchdbs(<2 x double> %a,
                                                   <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp sge i32 %res, 1
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VFCHDBS, storing to %ptr if not all elements are higher.
define <2 x i64> @test_vfchdbs_notall_store(<2 x double> %a, <2 x double> %b,
; CHECK-LABEL: test_vfchdbs_notall_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfchdbs %v24, %v24, %v26
; CHECK-NEXT:    ber %r14
; CHECK-NEXT:  .LBB252_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                            ptr %ptr) {
  %call = call {<2 x i64>, i32} @llvm.s390.vfchdbs(<2 x double> %a,
                                                   <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 0
  %cc = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp ugt i32 %cc, 0
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <2 x i64> %res
}

; VFCHEDBS with no processing of the result.
define i32 @test_vfchedbs(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_vfchedbs:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vfchedbs(<2 x double> %a,
						    <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VFCHEDBS, returning 1 if neither element is higher or equal.
define i32 @test_vfchedbs_none_bool(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: test_vfchedbs_none_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfchedbs %v0, %v24, %v26
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochio %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vfchedbs(<2 x double> %a,
						    <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp eq i32 %res, 3
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VFCHEDBS, storing to %ptr if neither element is higher or equal.
define <2 x i64> @test_vfchedbs_none_store(<2 x double> %a, <2 x double> %b,
; CHECK-LABEL: test_vfchedbs_none_store:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfchedbs %v24, %v24, %v26
; CHECK-NEXT:    bler %r14
; CHECK-NEXT:  .LBB255_1: # %store
; CHECK-NEXT:    mvhi 0(%r2), 0
; CHECK-NEXT:    br %r14
                                           ptr %ptr) {
  %call = call {<2 x i64>, i32} @llvm.s390.vfchedbs(<2 x double> %a,
						    <2 x double> %b)
  %res = extractvalue {<2 x i64>, i32} %call, 0
  %cc = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp uge i32 %cc, 3
  br i1 %cmp, label %store, label %exit

store:
  store i32 0, ptr %ptr
  br label %exit

exit:
  ret <2 x i64> %res
}

; VFTCIDB with the lowest useful class selector and no processing of the result.
define i32 @test_vftcidb(<2 x double> %a) {
; CHECK-LABEL: test_vftcidb:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vftcidb %v0, %v24, 1
; CHECK-NEXT:    ipm %r2
; CHECK-NEXT:    srl %r2, 28
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vftcidb(<2 x double> %a, i32 1)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  ret i32 %res
}

; VFTCIDB with the highest useful class selector, returning 1 if all elements
; have the right class (CC == 0).
define i32 @test_vftcidb_all_bool(<2 x double> %a) {
; CHECK-LABEL: test_vftcidb_all_bool:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vftcidb %v0, %v24, 4094
; CHECK-NEXT:    lhi %r2, 0
; CHECK-NEXT:    lochie %r2, 1
; CHECK-NEXT:    br %r14
  %call = call {<2 x i64>, i32} @llvm.s390.vftcidb(<2 x double> %a, i32 4094)
  %res = extractvalue {<2 x i64>, i32} %call, 1
  %cmp = icmp eq i32 %res, 0
  %ext = zext i1 %cmp to i32
  ret i32 %ext
}

; VFIDB with a rounding mode not usable via standard intrinsics.
define <2 x double> @test_vfidb_0_4(<2 x double> %a) {
; CHECK-LABEL: test_vfidb_0_4:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfidb %v24, %v24, 0, 4
; CHECK-NEXT:    br %r14
  %res = call <2 x double> @llvm.s390.vfidb(<2 x double> %a, i32 0, i32 4)
  ret <2 x double> %res
}

; VFIDB with IEEE-inexact exception suppressed.
define <2 x double> @test_vfidb_4_0(<2 x double> %a) {
; CHECK-LABEL: test_vfidb_4_0:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vfidb %v24, %v24, 4, 0
; CHECK-NEXT:    br %r14
  %res = call <2 x double> @llvm.s390.vfidb(<2 x double> %a, i32 4, i32 0)
  ret <2 x double> %res
}

