; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-globals none --filter-out-after "scalar.ph\:" --version 5
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=VF2 %s
; RUN: opt -p loop-vectorize -force-vector-width=2 -force-vector-interleave=2 -S %s | FileCheck --check-prefixes=VF2IC2 %s
; RUN: opt -p loop-vectorize -force-vector-width=4 -force-vector-interleave=1 -S %s | FileCheck --check-prefixes=VF4 %s

target datalayout = "e-m:o-p270:32:32-p271:32:32-p272:64:64-i64:64-i128:128-n32:64-S128-Fn32"
target triple = "arm64-apple-macosx15.0.0"

define void @derived_int_ivs(ptr noalias %a, ptr noalias %b, i64 %end) {
; VF2-LABEL: define void @derived_int_ivs(
; VF2-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], i64 [[END:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*:]]
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[END]], -32
; VF2-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 4
; VF2-NEXT:    [[TMP2:%.*]] = add nuw nsw i64 [[TMP1]], 1
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP2]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP2]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP2]], [[N_MOD_VF]]
; VF2-NEXT:    [[TMP3:%.*]] = mul i64 [[N_VEC]], 16
; VF2-NEXT:    [[TMP4:%.*]] = add i64 16, [[TMP3]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[TMP5:%.*]] = mul i64 [[INDEX]], 16
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 16, [[TMP5]]
; VF2-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[OFFSET_IDX]]
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x double>, ptr [[TMP6]], align 8
; VF2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i8, ptr [[B]], i64 [[OFFSET_IDX]]
; VF2-NEXT:    store <2 x double> [[WIDE_LOAD]], ptr [[TMP7]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP9:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP9]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP2]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
;
; VF2IC2-LABEL: define void @derived_int_ivs(
; VF2IC2-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], i64 [[END:%.*]]) {
; VF2IC2-NEXT:  [[ENTRY:.*:]]
; VF2IC2-NEXT:    [[TMP0:%.*]] = add i64 [[END]], -32
; VF2IC2-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 4
; VF2IC2-NEXT:    [[TMP2:%.*]] = add nuw nsw i64 [[TMP1]], 1
; VF2IC2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP2]], 4
; VF2IC2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2IC2:       [[VECTOR_PH]]:
; VF2IC2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP2]], 4
; VF2IC2-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP2]], [[N_MOD_VF]]
; VF2IC2-NEXT:    [[TMP3:%.*]] = mul i64 [[N_VEC]], 16
; VF2IC2-NEXT:    [[TMP4:%.*]] = add i64 16, [[TMP3]]
; VF2IC2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2IC2:       [[VECTOR_BODY]]:
; VF2IC2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2IC2-NEXT:    [[TMP5:%.*]] = mul i64 [[INDEX]], 16
; VF2IC2-NEXT:    [[OFFSET_IDX:%.*]] = add i64 16, [[TMP5]]
; VF2IC2-NEXT:    [[TMP6:%.*]] = add i64 [[OFFSET_IDX]], 16
; VF2IC2-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[OFFSET_IDX]]
; VF2IC2-NEXT:    [[TMP8:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[TMP6]]
; VF2IC2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x double>, ptr [[TMP7]], align 8
; VF2IC2-NEXT:    [[WIDE_LOAD1:%.*]] = load <2 x double>, ptr [[TMP8]], align 8
; VF2IC2-NEXT:    [[TMP9:%.*]] = getelementptr inbounds i8, ptr [[B]], i64 [[OFFSET_IDX]]
; VF2IC2-NEXT:    [[TMP10:%.*]] = getelementptr inbounds i8, ptr [[B]], i64 [[TMP6]]
; VF2IC2-NEXT:    store <2 x double> [[WIDE_LOAD]], ptr [[TMP9]], align 8
; VF2IC2-NEXT:    store <2 x double> [[WIDE_LOAD1]], ptr [[TMP10]], align 8
; VF2IC2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2IC2-NEXT:    [[TMP11:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2IC2-NEXT:    br i1 [[TMP11]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF2IC2:       [[MIDDLE_BLOCK]]:
; VF2IC2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP2]], [[N_VEC]]
; VF2IC2-NEXT:    br i1 [[CMP_N]], [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2IC2:       [[SCALAR_PH]]:
;
; VF4-LABEL: define void @derived_int_ivs(
; VF4-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], i64 [[END:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*:]]
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[END]], -32
; VF4-NEXT:    [[TMP1:%.*]] = lshr i64 [[TMP0]], 4
; VF4-NEXT:    [[TMP2:%.*]] = add nuw nsw i64 [[TMP1]], 1
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP2]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP2]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP2]], [[N_MOD_VF]]
; VF4-NEXT:    [[TMP3:%.*]] = mul i64 [[N_VEC]], 16
; VF4-NEXT:    [[TMP4:%.*]] = add i64 16, [[TMP3]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[TMP5:%.*]] = mul i64 [[INDEX]], 16
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = add i64 16, [[TMP5]]
; VF4-NEXT:    [[TMP6:%.*]] = getelementptr inbounds i8, ptr [[A]], i64 [[OFFSET_IDX]]
; VF4-NEXT:    [[WIDE_VEC:%.*]] = load <8 x double>, ptr [[TMP6]], align 8
; VF4-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <8 x double> [[WIDE_VEC]], <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; VF4-NEXT:    [[STRIDED_VEC1:%.*]] = shufflevector <8 x double> [[WIDE_VEC]], <8 x double> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; VF4-NEXT:    [[TMP7:%.*]] = getelementptr inbounds i8, ptr [[B]], i64 [[OFFSET_IDX]]
; VF4-NEXT:    [[TMP8:%.*]] = shufflevector <4 x double> [[STRIDED_VEC]], <4 x double> [[STRIDED_VEC1]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; VF4-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <8 x double> [[TMP8]], <8 x double> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; VF4-NEXT:    store <8 x double> [[INTERLEAVED_VEC]], ptr [[TMP7]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP9:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP9]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP0:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP2]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [ 16, %entry ], [ %iv.next, %loop ]
  %gep.a.0 = getelementptr inbounds i8, ptr %a, i64 %iv
  %l.0 = load double, ptr %gep.a.0, align 8
  %gep.b.0 = getelementptr inbounds i8, ptr %b, i64 %iv
  store double %l.0, ptr %gep.b.0, align 8
  %gep.a.1 = getelementptr inbounds i8, ptr %gep.a.0, i64 8
  %l.1 = load double, ptr %gep.a.1, align 8
  %gep.b.1 = getelementptr inbounds i8, ptr %gep.b.0, i64 8
  store double %l.1, ptr %gep.b.1, align 8
  %iv.next = add nuw nsw i64 %iv, 16
  %ec = icmp eq i64 %iv.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @derived_pointer_ivs(ptr noalias %a, ptr noalias %b, ptr %end) {
; VF2-LABEL: define void @derived_pointer_ivs(
; VF2-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], ptr [[END:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*:]]
; VF2-NEXT:    [[A5:%.*]] = ptrtoint ptr [[A]] to i64
; VF2-NEXT:    [[END4:%.*]] = ptrtoint ptr [[END]] to i64
; VF2-NEXT:    [[A2:%.*]] = ptrtoint ptr [[A]] to i64
; VF2-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; VF2-NEXT:    [[TMP0:%.*]] = add i64 [[END4]], -16
; VF2-NEXT:    [[TMP1:%.*]] = sub i64 [[TMP0]], [[A5]]
; VF2-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 4
; VF2-NEXT:    [[TMP3:%.*]] = add nuw nsw i64 [[TMP2]], 1
; VF2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP3]], 2
; VF2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_MEMCHECK:.*]]
; VF2:       [[VECTOR_MEMCHECK]]:
; VF2-NEXT:    [[TMP4:%.*]] = add i64 [[END1]], -16
; VF2-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP4]], [[A2]]
; VF2-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 4
; VF2-NEXT:    [[TMP7:%.*]] = shl nuw i64 [[TMP6]], 4
; VF2-NEXT:    [[TMP8:%.*]] = add i64 [[TMP7]], 16
; VF2-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP8]]
; VF2-NEXT:    [[SCEVGEP3:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP8]]
; VF2-NEXT:    [[BOUND0:%.*]] = icmp ult ptr [[B]], [[SCEVGEP3]]
; VF2-NEXT:    [[BOUND1:%.*]] = icmp ult ptr [[A]], [[SCEVGEP]]
; VF2-NEXT:    [[FOUND_CONFLICT:%.*]] = and i1 [[BOUND0]], [[BOUND1]]
; VF2-NEXT:    br i1 [[FOUND_CONFLICT]], label %[[SCALAR_PH]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP3]], 2
; VF2-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP3]], [[N_MOD_VF]]
; VF2-NEXT:    [[TMP9:%.*]] = mul i64 [[N_VEC]], 16
; VF2-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP9]]
; VF2-NEXT:    [[TMP11:%.*]] = mul i64 [[N_VEC]], 16
; VF2-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP11]]
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 16
; VF2-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[A]], i64 [[OFFSET_IDX]]
; VF2-NEXT:    [[OFFSET_IDX6:%.*]] = mul i64 [[INDEX]], 16
; VF2-NEXT:    [[NEXT_GEP7:%.*]] = getelementptr i8, ptr [[B]], i64 [[OFFSET_IDX6]]
; VF2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x double>, ptr [[NEXT_GEP]], align 8
; VF2-NEXT:    store <2 x double> [[WIDE_LOAD]], ptr [[NEXT_GEP7]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2-NEXT:    br i1 [[TMP14]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP3]], [[N_VEC]]
; VF2-NEXT:    br i1 [[CMP_N]], [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
;
; VF2IC2-LABEL: define void @derived_pointer_ivs(
; VF2IC2-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], ptr [[END:%.*]]) {
; VF2IC2-NEXT:  [[ENTRY:.*:]]
; VF2IC2-NEXT:    [[A5:%.*]] = ptrtoint ptr [[A]] to i64
; VF2IC2-NEXT:    [[END4:%.*]] = ptrtoint ptr [[END]] to i64
; VF2IC2-NEXT:    [[A2:%.*]] = ptrtoint ptr [[A]] to i64
; VF2IC2-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; VF2IC2-NEXT:    [[TMP0:%.*]] = add i64 [[END4]], -16
; VF2IC2-NEXT:    [[TMP1:%.*]] = sub i64 [[TMP0]], [[A5]]
; VF2IC2-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 4
; VF2IC2-NEXT:    [[TMP3:%.*]] = add nuw nsw i64 [[TMP2]], 1
; VF2IC2-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP3]], 4
; VF2IC2-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_MEMCHECK:.*]]
; VF2IC2:       [[VECTOR_MEMCHECK]]:
; VF2IC2-NEXT:    [[TMP4:%.*]] = add i64 [[END1]], -16
; VF2IC2-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP4]], [[A2]]
; VF2IC2-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 4
; VF2IC2-NEXT:    [[TMP7:%.*]] = shl nuw i64 [[TMP6]], 4
; VF2IC2-NEXT:    [[TMP8:%.*]] = add i64 [[TMP7]], 16
; VF2IC2-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP8]]
; VF2IC2-NEXT:    [[SCEVGEP3:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP8]]
; VF2IC2-NEXT:    [[BOUND0:%.*]] = icmp ult ptr [[B]], [[SCEVGEP3]]
; VF2IC2-NEXT:    [[BOUND1:%.*]] = icmp ult ptr [[A]], [[SCEVGEP]]
; VF2IC2-NEXT:    [[FOUND_CONFLICT:%.*]] = and i1 [[BOUND0]], [[BOUND1]]
; VF2IC2-NEXT:    br i1 [[FOUND_CONFLICT]], label %[[SCALAR_PH]], label %[[VECTOR_PH:.*]]
; VF2IC2:       [[VECTOR_PH]]:
; VF2IC2-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP3]], 4
; VF2IC2-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP3]], [[N_MOD_VF]]
; VF2IC2-NEXT:    [[TMP9:%.*]] = mul i64 [[N_VEC]], 16
; VF2IC2-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP9]]
; VF2IC2-NEXT:    [[TMP11:%.*]] = mul i64 [[N_VEC]], 16
; VF2IC2-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP11]]
; VF2IC2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2IC2:       [[VECTOR_BODY]]:
; VF2IC2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2IC2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 16
; VF2IC2-NEXT:    [[TMP13:%.*]] = add i64 [[OFFSET_IDX]], 16
; VF2IC2-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[A]], i64 [[OFFSET_IDX]]
; VF2IC2-NEXT:    [[NEXT_GEP6:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP13]]
; VF2IC2-NEXT:    [[OFFSET_IDX7:%.*]] = mul i64 [[INDEX]], 16
; VF2IC2-NEXT:    [[TMP14:%.*]] = add i64 [[OFFSET_IDX7]], 16
; VF2IC2-NEXT:    [[NEXT_GEP8:%.*]] = getelementptr i8, ptr [[B]], i64 [[OFFSET_IDX7]]
; VF2IC2-NEXT:    [[NEXT_GEP9:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP14]]
; VF2IC2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x double>, ptr [[NEXT_GEP]], align 8
; VF2IC2-NEXT:    [[WIDE_LOAD10:%.*]] = load <2 x double>, ptr [[NEXT_GEP6]], align 8
; VF2IC2-NEXT:    store <2 x double> [[WIDE_LOAD]], ptr [[NEXT_GEP8]], align 8
; VF2IC2-NEXT:    store <2 x double> [[WIDE_LOAD10]], ptr [[NEXT_GEP9]], align 8
; VF2IC2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2IC2-NEXT:    [[TMP15:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF2IC2-NEXT:    br i1 [[TMP15]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF2IC2:       [[MIDDLE_BLOCK]]:
; VF2IC2-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP3]], [[N_VEC]]
; VF2IC2-NEXT:    br i1 [[CMP_N]], [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2IC2:       [[SCALAR_PH]]:
;
; VF4-LABEL: define void @derived_pointer_ivs(
; VF4-SAME: ptr noalias [[A:%.*]], ptr noalias [[B:%.*]], ptr [[END:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*:]]
; VF4-NEXT:    [[A5:%.*]] = ptrtoint ptr [[A]] to i64
; VF4-NEXT:    [[END4:%.*]] = ptrtoint ptr [[END]] to i64
; VF4-NEXT:    [[A2:%.*]] = ptrtoint ptr [[A]] to i64
; VF4-NEXT:    [[END1:%.*]] = ptrtoint ptr [[END]] to i64
; VF4-NEXT:    [[TMP0:%.*]] = add i64 [[END4]], -16
; VF4-NEXT:    [[TMP1:%.*]] = sub i64 [[TMP0]], [[A5]]
; VF4-NEXT:    [[TMP2:%.*]] = lshr i64 [[TMP1]], 4
; VF4-NEXT:    [[TMP3:%.*]] = add nuw nsw i64 [[TMP2]], 1
; VF4-NEXT:    [[MIN_ITERS_CHECK:%.*]] = icmp ult i64 [[TMP3]], 4
; VF4-NEXT:    br i1 [[MIN_ITERS_CHECK]], label %[[SCALAR_PH:.*]], label %[[VECTOR_MEMCHECK:.*]]
; VF4:       [[VECTOR_MEMCHECK]]:
; VF4-NEXT:    [[TMP4:%.*]] = add i64 [[END1]], -16
; VF4-NEXT:    [[TMP5:%.*]] = sub i64 [[TMP4]], [[A2]]
; VF4-NEXT:    [[TMP6:%.*]] = lshr i64 [[TMP5]], 4
; VF4-NEXT:    [[TMP7:%.*]] = shl nuw i64 [[TMP6]], 4
; VF4-NEXT:    [[TMP8:%.*]] = add i64 [[TMP7]], 16
; VF4-NEXT:    [[SCEVGEP:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP8]]
; VF4-NEXT:    [[SCEVGEP3:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP8]]
; VF4-NEXT:    [[BOUND0:%.*]] = icmp ult ptr [[B]], [[SCEVGEP3]]
; VF4-NEXT:    [[BOUND1:%.*]] = icmp ult ptr [[A]], [[SCEVGEP]]
; VF4-NEXT:    [[FOUND_CONFLICT:%.*]] = and i1 [[BOUND0]], [[BOUND1]]
; VF4-NEXT:    br i1 [[FOUND_CONFLICT]], label %[[SCALAR_PH]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    [[N_MOD_VF:%.*]] = urem i64 [[TMP3]], 4
; VF4-NEXT:    [[N_VEC:%.*]] = sub i64 [[TMP3]], [[N_MOD_VF]]
; VF4-NEXT:    [[TMP9:%.*]] = mul i64 [[N_VEC]], 16
; VF4-NEXT:    [[TMP10:%.*]] = getelementptr i8, ptr [[A]], i64 [[TMP9]]
; VF4-NEXT:    [[TMP11:%.*]] = mul i64 [[N_VEC]], 16
; VF4-NEXT:    [[TMP12:%.*]] = getelementptr i8, ptr [[B]], i64 [[TMP11]]
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 16
; VF4-NEXT:    [[NEXT_GEP:%.*]] = getelementptr i8, ptr [[A]], i64 [[OFFSET_IDX]]
; VF4-NEXT:    [[OFFSET_IDX6:%.*]] = mul i64 [[INDEX]], 16
; VF4-NEXT:    [[NEXT_GEP7:%.*]] = getelementptr i8, ptr [[B]], i64 [[OFFSET_IDX6]]
; VF4-NEXT:    [[WIDE_VEC:%.*]] = load <8 x double>, ptr [[NEXT_GEP]], align 8
; VF4-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <8 x double> [[WIDE_VEC]], <8 x double> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; VF4-NEXT:    [[STRIDED_VEC8:%.*]] = shufflevector <8 x double> [[WIDE_VEC]], <8 x double> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; VF4-NEXT:    [[TMP13:%.*]] = shufflevector <4 x double> [[STRIDED_VEC]], <4 x double> [[STRIDED_VEC8]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; VF4-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <8 x double> [[TMP13]], <8 x double> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; VF4-NEXT:    store <8 x double> [[INTERLEAVED_VEC]], ptr [[NEXT_GEP7]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP14:%.*]] = icmp eq i64 [[INDEX_NEXT]], [[N_VEC]]
; VF4-NEXT:    br i1 [[TMP14]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP4:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    [[CMP_N:%.*]] = icmp eq i64 [[TMP3]], [[N_VEC]]
; VF4-NEXT:    br i1 [[CMP_N]], [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
;
entry:
  br label %loop

loop:
  %ptr.iv.1 = phi ptr [ %a, %entry ], [ %ptr.iv.1.next, %loop ]
  %ptr.iv.2 = phi ptr [ %b, %entry ], [ %ptr.iv.2.next, %loop ]
  %l.0 = load double, ptr %ptr.iv.1, align 8
  store double %l.0, ptr %ptr.iv.2, align 8
  %gep.a.1 = getelementptr inbounds i8, ptr %ptr.iv.1, i64 8
  %l.1 = load double, ptr %gep.a.1, align 8
  %gep.b.1 = getelementptr inbounds i8, ptr %ptr.iv.2, i64 8
  store double %l.1, ptr %gep.b.1, align 8
  %ptr.iv.1.next = getelementptr inbounds i8, ptr %ptr.iv.1, i64 16
  %ptr.iv.2.next = getelementptr inbounds i8, ptr %ptr.iv.2, i64 16
  %ec = icmp eq ptr %ptr.iv.1.next, %end
  br i1 %ec, label %exit, label %loop

exit:
  ret void
}

define void @narrow_with_uniform_add_and_gep(ptr noalias %p) {
; VF2-LABEL: define void @narrow_with_uniform_add_and_gep(
; VF2-SAME: ptr noalias [[P:%.*]]) {
; VF2-NEXT:  [[ENTRY:.*:]]
; VF2-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2:       [[VECTOR_PH]]:
; VF2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2:       [[VECTOR_BODY]]:
; VF2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2-NEXT:    [[TMP0:%.*]] = add nuw nsw i64 [[OFFSET_IDX]], 0
; VF2-NEXT:    [[TMP1:%.*]] = getelementptr i64, ptr [[P]], i64 [[TMP0]]
; VF2-NEXT:    [[STRIDED_VEC1:%.*]] = load <2 x i64>, ptr [[TMP1]], align 8
; VF2-NEXT:    [[TMP3:%.*]] = add <2 x i64> [[STRIDED_VEC1]], splat (i64 1)
; VF2-NEXT:    store <2 x i64> [[TMP3]], ptr [[TMP1]], align 8
; VF2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 1
; VF2-NEXT:    [[TMP5:%.*]] = icmp eq i64 [[INDEX_NEXT]], 512
; VF2-NEXT:    br i1 [[TMP5]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF2:       [[MIDDLE_BLOCK]]:
; VF2-NEXT:    br i1 true, [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2:       [[SCALAR_PH]]:
;
; VF2IC2-LABEL: define void @narrow_with_uniform_add_and_gep(
; VF2IC2-SAME: ptr noalias [[P:%.*]]) {
; VF2IC2-NEXT:  [[ENTRY:.*:]]
; VF2IC2-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF2IC2:       [[VECTOR_PH]]:
; VF2IC2-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF2IC2:       [[VECTOR_BODY]]:
; VF2IC2-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF2IC2-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF2IC2-NEXT:    [[TMP0:%.*]] = add i64 [[OFFSET_IDX]], 2
; VF2IC2-NEXT:    [[TMP1:%.*]] = add nuw nsw i64 [[OFFSET_IDX]], 0
; VF2IC2-NEXT:    [[TMP2:%.*]] = add nuw nsw i64 [[TMP0]], 0
; VF2IC2-NEXT:    [[TMP3:%.*]] = getelementptr i64, ptr [[P]], i64 [[TMP1]]
; VF2IC2-NEXT:    [[TMP4:%.*]] = getelementptr i64, ptr [[P]], i64 [[TMP2]]
; VF2IC2-NEXT:    [[WIDE_LOAD:%.*]] = load <2 x i64>, ptr [[TMP3]], align 8
; VF2IC2-NEXT:    [[WIDE_LOAD1:%.*]] = load <2 x i64>, ptr [[TMP4]], align 8
; VF2IC2-NEXT:    [[TMP5:%.*]] = add <2 x i64> [[WIDE_LOAD]], splat (i64 1)
; VF2IC2-NEXT:    [[TMP6:%.*]] = add <2 x i64> [[WIDE_LOAD1]], splat (i64 1)
; VF2IC2-NEXT:    store <2 x i64> [[TMP5]], ptr [[TMP3]], align 8
; VF2IC2-NEXT:    store <2 x i64> [[TMP6]], ptr [[TMP4]], align 8
; VF2IC2-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 2
; VF2IC2-NEXT:    [[TMP7:%.*]] = icmp eq i64 [[INDEX_NEXT]], 512
; VF2IC2-NEXT:    br i1 [[TMP7]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF2IC2:       [[MIDDLE_BLOCK]]:
; VF2IC2-NEXT:    br i1 true, [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF2IC2:       [[SCALAR_PH]]:
;
; VF4-LABEL: define void @narrow_with_uniform_add_and_gep(
; VF4-SAME: ptr noalias [[P:%.*]]) {
; VF4-NEXT:  [[ENTRY:.*:]]
; VF4-NEXT:    br i1 false, label %[[SCALAR_PH:.*]], label %[[VECTOR_PH:.*]]
; VF4:       [[VECTOR_PH]]:
; VF4-NEXT:    br label %[[VECTOR_BODY:.*]]
; VF4:       [[VECTOR_BODY]]:
; VF4-NEXT:    [[INDEX:%.*]] = phi i64 [ 0, %[[VECTOR_PH]] ], [ [[INDEX_NEXT:%.*]], %[[VECTOR_BODY]] ]
; VF4-NEXT:    [[OFFSET_IDX:%.*]] = mul i64 [[INDEX]], 2
; VF4-NEXT:    [[TMP0:%.*]] = add nuw nsw i64 [[OFFSET_IDX]], 0
; VF4-NEXT:    [[TMP1:%.*]] = getelementptr i64, ptr [[P]], i64 [[TMP0]]
; VF4-NEXT:    [[WIDE_VEC:%.*]] = load <8 x i64>, ptr [[TMP1]], align 8
; VF4-NEXT:    [[STRIDED_VEC:%.*]] = shufflevector <8 x i64> [[WIDE_VEC]], <8 x i64> poison, <4 x i32> <i32 0, i32 2, i32 4, i32 6>
; VF4-NEXT:    [[STRIDED_VEC1:%.*]] = shufflevector <8 x i64> [[WIDE_VEC]], <8 x i64> poison, <4 x i32> <i32 1, i32 3, i32 5, i32 7>
; VF4-NEXT:    [[TMP2:%.*]] = add <4 x i64> [[STRIDED_VEC]], splat (i64 1)
; VF4-NEXT:    [[TMP3:%.*]] = add <4 x i64> [[STRIDED_VEC1]], splat (i64 1)
; VF4-NEXT:    [[TMP4:%.*]] = shufflevector <4 x i64> [[TMP2]], <4 x i64> [[TMP3]], <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
; VF4-NEXT:    [[INTERLEAVED_VEC:%.*]] = shufflevector <8 x i64> [[TMP4]], <8 x i64> poison, <8 x i32> <i32 0, i32 4, i32 1, i32 5, i32 2, i32 6, i32 3, i32 7>
; VF4-NEXT:    store <8 x i64> [[INTERLEAVED_VEC]], ptr [[TMP1]], align 8
; VF4-NEXT:    [[INDEX_NEXT]] = add nuw i64 [[INDEX]], 4
; VF4-NEXT:    [[TMP5:%.*]] = icmp eq i64 [[INDEX_NEXT]], 512
; VF4-NEXT:    br i1 [[TMP5]], label %[[MIDDLE_BLOCK:.*]], label %[[VECTOR_BODY]], !llvm.loop [[LOOP6:![0-9]+]]
; VF4:       [[MIDDLE_BLOCK]]:
; VF4-NEXT:    br i1 true, [[EXIT:label %.*]], label %[[SCALAR_PH]]
; VF4:       [[SCALAR_PH]]:
;
entry:
  br label %loop

loop:
  %iv = phi i64 [0, %entry], [%iv.next, %loop]

  %iv0 = add nuw nsw i64 %iv, 0
  %gep0 = getelementptr i64, ptr %p, i64 %iv0
  %load0 = load i64, ptr %gep0
  %add0 = add i64 %load0, 1
  store i64 %add0, ptr %gep0

  %iv1 = add nuw nsw i64 %iv, 1
  %gep1 = getelementptr i64, ptr %p, i64 %iv1
  %load1 = load i64, ptr %gep1
  %add1 = add i64 %load1, 1
  store i64 %add1, ptr %gep1

  %iv.next = add nuw nsw i64 %iv, 2
  %done = icmp eq i64 %iv.next, 1024
  br i1 %done, label %exit, label %loop

exit:
  ret void
}
