; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --check-attributes --check-globals all --version 5
; RUN: opt -S -passes=function-attrs < %s | FileCheck --check-prefixes=COMMON,FNATTRS %s
; RUN: opt -S -passes=attributor-light < %s | FileCheck --check-prefixes=COMMON,ATTRIBUTOR %s

; Make sure norecurse is inferred on the calling functions

define internal void @sendmsg_is_norecurse() {
; FNATTRS: Function Attrs: mustprogress norecurse nounwind willreturn
; FNATTRS-LABEL: define internal void @sendmsg_is_norecurse(
; FNATTRS-SAME: ) #[[ATTR0:[0-9]+]] {
; FNATTRS-NEXT:    call void @llvm.amdgcn.s.sendmsg(i32 1, i32 0)
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR: Function Attrs: mustprogress norecurse nounwind willreturn
; ATTRIBUTOR-LABEL: define internal void @sendmsg_is_norecurse(
; ATTRIBUTOR-SAME: ) #[[ATTR0:[0-9]+]] {
; ATTRIBUTOR-NEXT:    call void @llvm.amdgcn.s.sendmsg(i32 1, i32 0) #[[ATTR4:[0-9]+]]
; ATTRIBUTOR-NEXT:    ret void
;
  call void @llvm.amdgcn.s.sendmsg(i32 1, i32 0)
  ret void
}

define internal void @sendmsghalt_is_norecurse() {
; COMMON: Function Attrs: norecurse nounwind
; COMMON-LABEL: define internal void @sendmsghalt_is_norecurse(
; COMMON-SAME: ) #[[ATTR1:[0-9]+]] {
; COMMON-NEXT:    call void @llvm.amdgcn.s.sendmsghalt(i32 1, i32 0)
; COMMON-NEXT:    ret void
;
  call void @llvm.amdgcn.s.sendmsghalt(i32 1, i32 0)
  ret void
}

define internal i32 @sendmsg_rtn_is_norecurse() {
; FNATTRS: Function Attrs: mustprogress norecurse nounwind willreturn
; FNATTRS-LABEL: define internal i32 @sendmsg_rtn_is_norecurse(
; FNATTRS-SAME: ) #[[ATTR0]] {
; FNATTRS-NEXT:    [[RES:%.*]] = call i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32 1)
; FNATTRS-NEXT:    ret i32 [[RES]]
;
; ATTRIBUTOR: Function Attrs: mustprogress norecurse nounwind willreturn
; ATTRIBUTOR-LABEL: define internal i32 @sendmsg_rtn_is_norecurse(
; ATTRIBUTOR-SAME: ) #[[ATTR0]] {
; ATTRIBUTOR-NEXT:    [[RES:%.*]] = call i32 @llvm.amdgcn.s.sendmsg.rtn.i32(i32 1) #[[ATTR4]]
; ATTRIBUTOR-NEXT:    ret i32 [[RES]]
;
  %res = call i32 @llvm.amdgcn.s.sendmsg.rtn(i32 1)
  ret i32 %res
}

define void @user() {
; FNATTRS-LABEL: define void @user() {
; FNATTRS-NEXT:    call void @sendmsg_is_norecurse()
; FNATTRS-NEXT:    call void @sendmsghalt_is_norecurse()
; FNATTRS-NEXT:    call void @sendmsg_rtn_is_norecurse()
; FNATTRS-NEXT:    ret void
;
; ATTRIBUTOR: Function Attrs: norecurse nounwind
; ATTRIBUTOR-LABEL: define void @user(
; ATTRIBUTOR-SAME: ) #[[ATTR1]] {
; ATTRIBUTOR-NEXT:    call void @sendmsg_is_norecurse() #[[ATTR5:[0-9]+]]
; ATTRIBUTOR-NEXT:    call void @sendmsghalt_is_norecurse() #[[ATTR6:[0-9]+]]
; ATTRIBUTOR-NEXT:    call void @sendmsg_rtn_is_norecurse() #[[ATTR6]]
; ATTRIBUTOR-NEXT:    ret void
;
  call void @sendmsg_is_norecurse()
  call void @sendmsghalt_is_norecurse()
  call void @sendmsg_rtn_is_norecurse()
  ret void
}
;.
; FNATTRS: attributes #[[ATTR0]] = { mustprogress norecurse nounwind willreturn }
; FNATTRS: attributes #[[ATTR1]] = { norecurse nounwind }
; FNATTRS: attributes #[[ATTR2:[0-9]+]] = { nocallback nounwind willreturn }
; FNATTRS: attributes #[[ATTR3:[0-9]+]] = { nocallback nounwind }
;.
; ATTRIBUTOR: attributes #[[ATTR0]] = { mustprogress norecurse nounwind willreturn }
; ATTRIBUTOR: attributes #[[ATTR1]] = { norecurse nounwind }
; ATTRIBUTOR: attributes #[[ATTR2:[0-9]+]] = { nocallback nounwind willreturn }
; ATTRIBUTOR: attributes #[[ATTR3:[0-9]+]] = { nocallback nounwind }
; ATTRIBUTOR: attributes #[[ATTR4]] = { willreturn }
; ATTRIBUTOR: attributes #[[ATTR5]] = { nounwind willreturn }
; ATTRIBUTOR: attributes #[[ATTR6]] = { nounwind }
;.
