; NOTE: Assertions have been autogenerated by utils/update_test_checks.py
; RUN: opt -passes=aggressive-instcombine -S < %s | FileCheck %s

;; These cases test lowering of various implementations of table-based ctz
;; algorithms to the llvm.cttz instruction.

;; C reproducers:
;; int ctz1 (unsigned x)
;; {
;; static const char table[32] =
;;    {
;;     0, 1, 28, 2, 29, 14, 24, 3, 30, 22, 20, 15, 25, 17, 4, 8,
;;      31, 27, 13, 23, 21, 19, 16, 7, 26, 12, 18, 6, 11, 5, 10, 9
;;    };
;;   return table[((unsigned)((x & -x) * 0x077CB531U)) >> 27];
;; }

;; int ctz2(unsigned x)
;; {
;; #define u 0
;;  static short table[64] =
;;   {
;;     32, 0, 1, 12, 2, 6, u, 13, 3, u, 7, u, u, u, u, 14,
;;     10, 4, u, u, 8, u, u, 25, u, u, u, u, u, 21, 27, 15,
;;     31, 11, 5, u, u, u, u, u, 9, u, u, 24, u, u, 20, 26,
;;     30, u, u, u, u, 23, u, 19, 29, u, 22, 18, 28, 17, 16, u
;;   };
;; x = (x & -x) * 0x0450FBAF;
;; return table[x >> 26];
;; }

;; int ctz3(unsigned x)
;;{
;; static int table[32] =
;;   {
;;     0, 1, 2, 24, 3, 19, 6, 25, 22, 4, 20, 10, 16, 7, 12, 26,
;;      31, 23, 18, 5, 21, 9, 15, 11, 30, 17, 8, 14, 29, 13, 28, 27
;;    };
;;  if (x == 0) return 32;
;;  x = (x & -x) * 0x04D7651F;
;;  return table[x >> 27];
;; }

;; static const unsigned long long magic = 0x03f08c5392f756cdULL;
;;
;; static const int table[64] = {
;;     0,  1, 12,  2, 13, 22, 17,  3, 14, 33, 23, 36, 18, 58, 28, 4,
;;    62, 15, 34, 26, 24, 48, 50, 37, 19, 55, 59, 52, 29, 44, 39,  5,
;;    63, 11, 21, 16, 32, 35, 57, 27, 61, 25, 47, 49, 54, 51, 43, 38,
;;    10, 20, 31, 56, 60, 46, 53, 42, 9, 30, 45, 41,  8, 40,  7,  6,
;; };
;;
;; int ctz4 (unsigned long long b)
;; {
;;    unsigned long long lsb = b & -b;
;;    return table[(lsb * magic) >> 58];
;; }
;;
;; int ctz5(unsigned x)
;; {
;;  static char table[32] =
;;    {
;;      0, 1, 2, 24, 3, 19, 6, 25, 22, 4, 20, 10, 16, 7, 12, 26,
;;      31, 23, 18, 5, 21, 9, 15, 11, 30, 17, 8, 14, 29, 13, 28, 27
;;    };
;;  x = (x & -x)*0x04D7651F;
;;  return table[x >> 27];
;; }

;; const int indexes[] = {
;;     63, 0, 58, 1, 59, 47, 53, 2,60, 39, 48, 27, 54, 33, 42, 3,
;;     61, 51, 37, 40, 49, 18, 28, 20, 55, 30, 34, 11, 43, 14, 22, 4,
;;     62, 57, 46, 52, 38, 26, 32, 41, 50, 36, 17, 19, 29, 10, 13, 21,
;;     56, 45, 25, 31, 35, 16, 9, 12, 44, 24, 15, 8, 23, 7, 6, 5
;; };
;;
;; int ctz6(unsigned long n)
;; {
;;       return indexes[((n & (~n + 1)) * 0x07EDD5E59A4E28C2ull) >> 58];
;; }
;;
;; int ctz8(unsigned v)
;; {
;; static const int table[] =
;; {
;;  31 ,0 ,1 ,23 ,2 ,18 ,5 ,24 ,21 ,3 ,19 ,9 ,15 ,6 ,11 ,25 ,30 ,22 ,17 ,4 ,20 ;,8 ,14 ,10 ,29 ,16 ,7 ,13 ,28 ,12 ,27 ,26
;; };
;; unsigned x =(-v & v);
;; return table[(unsigned)(x * 0x9AECA3EU) >> 27];
;; }

@ctz7.table = internal unnamed_addr constant [32 x i8] c"\00\01\1C\02\1D\0E\18\03\1E\16\14\0F\19\11\04\08\1F\1B\0D\17\15\13\10\07\1A\0C\12\06\0B\05\0A\09", align 1

define i32 @ctz1(i32 %x) {
; CHECK-LABEL: @ctz1(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 0, i32 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[TMP2]] to i8
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP3]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
entry:
  %sub = sub i32 0, %x
  %and = and i32 %sub, %x
  %mul = mul i32 %and, 125613361
  %shr = lshr i32 %mul, 27
  %idxprom = zext i32 %shr to i64
  %arrayidx = getelementptr inbounds [32 x i8], ptr @ctz7.table, i64 0, i64 %idxprom
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

define i32 @ctz1_nusw(i32 %x) {
; CHECK-LABEL: @ctz1_nusw(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 0, i32 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[TMP2]] to i8
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP3]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
entry:
  %sub = sub i32 0, %x
  %and = and i32 %sub, %x
  %mul = mul i32 %and, 125613361
  %shr = lshr i32 %mul, 27
  %idxprom = zext i32 %shr to i64
  %arrayidx = getelementptr nusw [32 x i8], ptr @ctz7.table, i64 0, i64 %idxprom
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

@ctz2.table = internal unnamed_addr constant [64 x i16] [i16 32, i16 0, i16 1, i16 12, i16 2, i16 6, i16 0, i16 13, i16 3, i16 0, i16 7, i16 0, i16 0, i16 0, i16 0, i16 14, i16 10, i16 4, i16 0, i16 0, i16 8, i16 0, i16 0, i16 25, i16 0, i16 0, i16 0, i16 0, i16 0, i16 21, i16 27, i16 15, i16 31, i16 11, i16 5, i16 0, i16 0, i16 0, i16 0, i16 0, i16 9, i16 0, i16 0, i16 24, i16 0, i16 0, i16 20, i16 26, i16 30, i16 0, i16 0, i16 0, i16 0, i16 23, i16 0, i16 19, i16 29, i16 0, i16 22, i16 18, i16 28, i16 17, i16 16, i16 0], align 2

define i32 @ctz2(i32 %x) {
; CHECK-LABEL: @ctz2(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 false)
; CHECK-NEXT:    [[TMP1:%.*]] = trunc i32 [[TMP0]] to i16
; CHECK-NEXT:    [[CONV:%.*]] = sext i16 [[TMP1]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
entry:
  %sub = sub i32 0, %x
  %and = and i32 %sub, %x
  %mul = mul i32 %and, 72416175
  %shr = lshr i32 %mul, 26
  %idxprom = zext i32 %shr to i64
  %arrayidx = getelementptr inbounds [64 x i16], ptr @ctz2.table, i64 0, i64 %idxprom
  %0 = load i16, ptr %arrayidx, align 2
  %conv = sext i16 %0 to i32
  ret i32 %conv
}

@ctz3.table = internal unnamed_addr constant [32 x i32] [i32 0, i32 1, i32 2, i32 24, i32 3, i32 19, i32 6, i32 25, i32 22, i32 4, i32 20, i32 10, i32 16, i32 7, i32 12, i32 26, i32 31, i32 23, i32 18, i32 5, i32 21, i32 9, i32 15, i32 11, i32 30, i32 17, i32 8, i32 14, i32 29, i32 13, i32 28, i32 27], align 4

define i32 @ctz3(i32 %x) {
; CHECK-LABEL: @ctz3(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[CMP:%.*]] = icmp eq i32 [[X:%.*]], 0
; CHECK-NEXT:    br i1 [[CMP]], label [[RETURN:%.*]], label [[IF_END:%.*]]
; CHECK:       if.end:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[X]], i1 true)
; CHECK-NEXT:    br label [[RETURN]]
; CHECK:       return:
; CHECK-NEXT:    [[RETVAL_0:%.*]] = phi i32 [ [[TMP0]], [[IF_END]] ], [ 32, [[ENTRY:%.*]] ]
; CHECK-NEXT:    ret i32 [[RETVAL_0]]
;
entry:
  %cmp = icmp eq i32 %x, 0
  br i1 %cmp, label %return, label %if.end

if.end:                                           ; preds = %entry
  %sub = sub i32 0, %x
  %and = and i32 %sub, %x
  %mul = mul i32 %and, 81224991
  %shr = lshr i32 %mul, 27
  %idxprom = zext i32 %shr to i64
  %arrayidx = getelementptr inbounds [32 x i32], ptr @ctz3.table, i64 0, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  br label %return

return:                                           ; preds = %entry, %if.end
  %retval.0 = phi i32 [ %0, %if.end ], [ 32, %entry ]
  ret i32 %retval.0
}

@table = internal unnamed_addr constant [64 x i32] [i32 0, i32 1, i32 12, i32 2, i32 13, i32 22, i32 17, i32 3, i32 14, i32 33, i32 23, i32 36, i32 18, i32 58, i32 28, i32 4, i32 62, i32 15, i32 34, i32 26, i32 24, i32 48, i32 50, i32 37, i32 19, i32 55, i32 59, i32 52, i32 29, i32 44, i32 39, i32 5, i32 63, i32 11, i32 21, i32 16, i32 32, i32 35, i32 57, i32 27, i32 61, i32 25, i32 47, i32 49, i32 54, i32 51, i32 43, i32 38, i32 10, i32 20, i32 31, i32 56, i32 60, i32 46, i32 53, i32 42, i32 9, i32 30, i32 45, i32 41, i32 8, i32 40, i32 7, i32 6], align 4

define i32 @ctz4(i64 %b) {
; CHECK-LABEL: @ctz4(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.cttz.i64(i64 [[B:%.*]], i1 true)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[B]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i64 0, i64 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 [[TMP2]] to i32
; CHECK-NEXT:    ret i32 [[TMP3]]
;
entry:
  %sub = sub i64 0, %b
  %and = and i64 %sub, %b
  %mul = mul i64 %and, 283881067100198605
  %shr = lshr i64 %mul, 58
  %arrayidx = getelementptr inbounds [64 x i32], ptr @table, i64 0, i64 %shr
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

@ctz5.table = internal unnamed_addr constant [32 x i8] c"\00\01\02\18\03\13\06\19\16\04\14\0A\10\07\0C\1A\1F\17\12\05\15\09\0F\0B\1E\11\08\0E\1D\0D\1C\1B", align 1

define i32 @ctz5(i32 %x) {
; CHECK-LABEL: @ctz5(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[X:%.*]], i1 true)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[X]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 0, i32 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i32 [[TMP2]] to i8
; CHECK-NEXT:    [[CONV:%.*]] = zext i8 [[TMP3]] to i32
; CHECK-NEXT:    ret i32 [[CONV]]
;
entry:
  %sub = sub i32 0, %x
  %and = and i32 %sub, %x
  %mul = mul i32 %and, 81224991
  %shr = lshr i32 %mul, 27
  %idxprom = zext i32 %shr to i64
  %arrayidx = getelementptr inbounds [32 x i8], ptr @ctz5.table, i64 0, i64 %idxprom
  %0 = load i8, ptr %arrayidx, align 1
  %conv = zext i8 %0 to i32
  ret i32 %conv
}

@ctz6.table = constant [64 x i32] [i32 63, i32 0, i32 58, i32 1, i32 59, i32 47, i32 53, i32 2, i32 60, i32 39, i32 48, i32 27, i32 54, i32 33, i32 42, i32 3, i32 61, i32 51, i32 37, i32 40, i32 49, i32 18, i32 28, i32 20, i32 55, i32 30, i32 34, i32 11, i32 43, i32 14, i32 22, i32 4, i32 62, i32 57, i32 46, i32 52, i32 38, i32 26, i32 32, i32 41, i32 50, i32 36, i32 17, i32 19, i32 29, i32 10, i32 13, i32 21, i32 56, i32 45, i32 25, i32 31, i32 35, i32 16, i32 9, i32 12, i32 44, i32 24, i32 15, i32 8, i32 23, i32 7, i32 6, i32 5], align 4

define i32 @ctz6(i64 %n) {
; CHECK-LABEL: @ctz6(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i64 @llvm.cttz.i64(i64 [[N:%.*]], i1 true)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i64 [[N]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i64 63, i64 [[TMP0]]
; CHECK-NEXT:    [[TMP3:%.*]] = trunc i64 [[TMP2]] to i32
; CHECK-NEXT:    ret i32 [[TMP3]]
;
entry:
  %add = sub i64 0, %n
  %and = and i64 %add, %n
  %mul = mul i64 %and, 571347909858961602
  %shr = lshr i64 %mul, 58
  %arrayidx = getelementptr inbounds [64 x i32], ptr @ctz6.table, i64 0, i64 %shr
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}

@ctz8.table = internal unnamed_addr constant [32 x i32] [i32 31, i32 0, i32 1, i32 23, i32 2, i32 18, i32 5, i32 24, i32 21, i32 3, i32 19, i32 9, i32 15, i32 6, i32 11, i32 25, i32 30, i32 22, i32 17, i32 4, i32 20, i32 8, i32 14, i32 10, i32 29, i32 16, i32 7, i32 13, i32 28, i32 12, i32 27, i32 26], align 4

define i32 @ctz8(i32 %v) {
; CHECK-LABEL: @ctz8(
; CHECK-NEXT:  entry:
; CHECK-NEXT:    [[TMP0:%.*]] = call i32 @llvm.cttz.i32(i32 [[V:%.*]], i1 true)
; CHECK-NEXT:    [[TMP1:%.*]] = icmp eq i32 [[V]], 0
; CHECK-NEXT:    [[TMP2:%.*]] = select i1 [[TMP1]], i32 31, i32 [[TMP0]]
; CHECK-NEXT:    ret i32 [[TMP2]]
;
entry:
  %sub = sub i32 0, %v
  %and = and i32 %sub, %v
  %mul = mul i32 %and, 162449982
  %shr = lshr i32 %mul, 27
  %idxprom = zext i32 %shr to i64
  %arrayidx = getelementptr inbounds [32 x i32], ptr @ctz8.table, i64 0, i64 %idxprom
  %0 = load i32, ptr %arrayidx, align 4
  ret i32 %0
}
