; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; Test that we are able to generate the Xqcilia instructions
; RUN: llc < %s -mtriple=riscv32 | FileCheck %s -check-prefix=RV32I
; RUN: llc < %s -mtriple=riscv32 -mattr=+experimental-xqcilia | FileCheck %s -check-prefix=RV32XQCILIA

define i32 @add(i32 %a, i32 %b) {
; RV32I-LABEL: add:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 65536
; RV32I-NEXT:    add a0, a0, a2
; RV32I-NEXT:    lui a2, 573
; RV32I-NEXT:    addi a2, a2, -1330
; RV32I-NEXT:    add a1, a1, a2
; RV32I-NEXT:    and a0, a1, a0
; RV32I-NEXT:    addi a0, a0, 13
; RV32I-NEXT:    ret
;
; RV32XQCILIA-LABEL: add:
; RV32XQCILIA:       # %bb.0:
; RV32XQCILIA-NEXT:    qc.e.addi a1, a1, 2345678
; RV32XQCILIA-NEXT:    qc.e.addai a0, 268435456
; RV32XQCILIA-NEXT:    and a0, a0, a1
; RV32XQCILIA-NEXT:    addi a0, a0, 13
; RV32XQCILIA-NEXT:    ret
 %addai = add i32 %a, 268435456
 %add = add i32 %b, 2345678
 %and = and i32 %add, %addai
 %res = add i32 %and, 13
 ret i32 %res
}

define i32 @and(i32 %a, i32 %b) {
; RV32I-LABEL: and:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 65536
; RV32I-NEXT:    and a0, a0, a2
; RV32I-NEXT:    lui a2, 573
; RV32I-NEXT:    addi a2, a2, -1330
; RV32I-NEXT:    and a1, a1, a2
; RV32I-NEXT:    srl a0, a1, a0
; RV32I-NEXT:    andi a0, a0, 10
; RV32I-NEXT:    ret
;
; RV32XQCILIA-LABEL: and:
; RV32XQCILIA:       # %bb.0:
; RV32XQCILIA-NEXT:    qc.e.andi a1, a1, 2345678
; RV32XQCILIA-NEXT:    qc.e.andai a0, 268435456
; RV32XQCILIA-NEXT:    srl a0, a1, a0
; RV32XQCILIA-NEXT:    andi a0, a0, 10
; RV32XQCILIA-NEXT:    ret
 %andai = and i32 %a, 268435456
 %and = and i32 %b, 2345678
 %srl = lshr i32 %and, %andai
 %res = and i32 %srl, 10
 ret i32 %res
}

define i32 @or(i32 %a, i32 %b) {
; RV32I-LABEL: or:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 65536
; RV32I-NEXT:    or a0, a0, a2
; RV32I-NEXT:    lui a2, 573
; RV32I-NEXT:    addi a2, a2, -1330
; RV32I-NEXT:    or a1, a1, a2
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    ori a0, a0, 13
; RV32I-NEXT:    ret
;
; RV32XQCILIA-LABEL: or:
; RV32XQCILIA:       # %bb.0:
; RV32XQCILIA-NEXT:    qc.e.ori a1, a1, 2345678
; RV32XQCILIA-NEXT:    qc.e.orai a0, 268435456
; RV32XQCILIA-NEXT:    add a0, a0, a1
; RV32XQCILIA-NEXT:    ori a0, a0, 13
; RV32XQCILIA-NEXT:    ret
 %orai = or i32 %a, 268435456
 %or = or i32 %b, 2345678
 %add = add i32 %or, %orai
 %res = or i32 %add, 13
 ret i32 %res
}

define i32 @xor(i32 %a, i32 %b) {
; RV32I-LABEL: xor:
; RV32I:       # %bb.0:
; RV32I-NEXT:    lui a2, 65536
; RV32I-NEXT:    xor a0, a0, a2
; RV32I-NEXT:    lui a2, 573
; RV32I-NEXT:    addi a2, a2, -1330
; RV32I-NEXT:    xor a1, a1, a2
; RV32I-NEXT:    add a0, a1, a0
; RV32I-NEXT:    xori a0, a0, 13
; RV32I-NEXT:    ret
;
; RV32XQCILIA-LABEL: xor:
; RV32XQCILIA:       # %bb.0:
; RV32XQCILIA-NEXT:    qc.e.xori a1, a1, 2345678
; RV32XQCILIA-NEXT:    qc.e.xorai a0, 268435456
; RV32XQCILIA-NEXT:    add a0, a0, a1
; RV32XQCILIA-NEXT:    xori a0, a0, 13
; RV32XQCILIA-NEXT:    ret
 %xorai = xor i32 %a, 268435456
 %xor = xor i32 %b, 2345678
 %add = add i32 %xor, %xorai
 %res = xor i32 %add, 13
 ret i32 %res
}
