# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mattr=+rva23u64,+zabha -mcpu=generic-ooo -iterations=1 < %s | FileCheck %s

# Zalrsc
lr.w t0, (t1)
lr.w.aq t1, (t2)
lr.w.rl t2, (t3)
lr.w.aqrl t3, (t4)
sc.w t6, t5, (t4)
sc.w.aq t5, t4, (t3)
sc.w.rl t4, t3, (t2)
sc.w.aqrl t3, t2, (t1)

lr.d t0, (t1)
lr.d.aq t1, (t2)
lr.d.rl t2, (t3)
lr.d.aqrl t3, (t4)
sc.d t6, t5, (t4)
sc.d.aq t5, t4, (t3)
sc.d.rl t4, t3, (t2)
sc.d.aqrl t3, t2, (t1)

# Zaamo
amoswap.w a4, ra, (s0)
amoadd.w a1, a2, (a3)
amoxor.w a2, a3, (a4)
amoand.w a3, a4, (a5)
amoor.w a4, a5, (a6)
amomin.w a5, a6, (a7)
amomax.w s7, s6, (s5)
amominu.w s6, s5, (s4)
amomaxu.w s5, s4, (s3)

amoswap.w.aq a4, ra, (s0)
amoadd.w.aq a1, a2, (a3)
amoxor.w.aq a2, a3, (a4)
amoand.w.aq a3, a4, (a5)
amoor.w.aq a4, a5, (a6)
amomin.w.aq a5, a6, (a7)
amomax.w.aq s7, s6, (s5)
amominu.w.aq s6, s5, (s4)
amomaxu.w.aq s5, s4, (s3)

amoswap.w.rl a4, ra, (s0)
amoadd.w.rl a1, a2, (a3)
amoxor.w.rl a2, a3, (a4)
amoand.w.rl a3, a4, (a5)
amoor.w.rl a4, a5, (a6)
amomin.w.rl a5, a6, (a7)
amomax.w.rl s7, s6, (s5)
amominu.w.rl s6, s5, (s4)
amomaxu.w.rl s5, s4, (s3)

amoswap.w.aqrl a4, ra, (s0)
amoadd.w.aqrl a1, a2, (a3)
amoxor.w.aqrl a2, a3, (a4)
amoand.w.aqrl a3, a4, (a5)
amoor.w.aqrl a4, a5, (a6)
amomin.w.aqrl a5, a6, (a7)
amomax.w.aqrl s7, s6, (s5)
amominu.w.aqrl s6, s5, (s4)
amomaxu.w.aqrl s5, s4, (s3)

amoswap.d a4, ra, (s0)
amoadd.d a1, a2, (a3)
amoxor.d a2, a3, (a4)
amoand.d a3, a4, (a5)
amoor.d a4, a5, (a6)
amomin.d a5, a6, (a7)
amomax.d s7, s6, (s5)
amominu.d s6, s5, (s4)
amomaxu.d s5, s4, (s3)

amoswap.d.aq a4, ra, (s0)
amoadd.d.aq a1, a2, (a3)
amoxor.d.aq a2, a3, (a4)
amoand.d.aq a3, a4, (a5)
amoor.d.aq a4, a5, (a6)
amomin.d.aq a5, a6, (a7)
amomax.d.aq s7, s6, (s5)
amominu.d.aq s6, s5, (s4)
amomaxu.d.aq s5, s4, (s3)

amoswap.d.rl a4, ra, (s0)
amoadd.d.rl a1, a2, (a3)
amoxor.d.rl a2, a3, (a4)
amoand.d.rl a3, a4, (a5)
amoor.d.rl a4, a5, (a6)
amomin.d.rl a5, a6, (a7)
amomax.d.rl s7, s6, (s5)
amominu.d.rl s6, s5, (s4)
amomaxu.d.rl s5, s4, (s3)

amoswap.d.aqrl a4, ra, (s0)
amoadd.d.aqrl a1, a2, (a3)
amoxor.d.aqrl a2, a3, (a4)
amoand.d.aqrl a3, a4, (a5)
amoor.d.aqrl a4, a5, (a6)
amomin.d.aqrl a5, a6, (a7)
amomax.d.aqrl s7, s6, (s5)
amominu.d.aqrl s6, s5, (s4)
amomaxu.d.aqrl s5, s4, (s3)

# Zabha
amoswap.b a4, ra, (s0)
amoadd.b a1, a2, (a3)
amoxor.b a2, a3, (a4)
amoand.b a3, a4, (a5)
amoor.b a4, a5, (a6)
amomin.b a5, a6, (a7)
amomax.b s7, s6, (s5)
amominu.b s6, s5, (s4)
amomaxu.b s5, s4, (s3)

amoswap.b.aq a4, ra, (s0)
amoadd.b.aq a1, a2, (a3)
amoxor.b.aq a2, a3, (a4)
amoand.b.aq a3, a4, (a5)
amoor.b.aq a4, a5, (a6)
amomin.b.aq a5, a6, (a7)
amomax.b.aq s7, s6, (s5)
amominu.b.aq s6, s5, (s4)
amomaxu.b.aq s5, s4, (s3)

amoswap.b.rl a4, ra, (s0)
amoadd.b.rl a1, a2, (a3)
amoxor.b.rl a2, a3, (a4)
amoand.b.rl a3, a4, (a5)
amoor.b.rl a4, a5, (a6)
amomin.b.rl a5, a6, (a7)
amomax.b.rl s7, s6, (s5)
amominu.b.rl s6, s5, (s4)
amomaxu.b.rl s5, s4, (s3)

amoswap.b.aqrl a4, ra, (s0)
amoadd.b.aqrl a1, a2, (a3)
amoxor.b.aqrl a2, a3, (a4)
amoand.b.aqrl a3, a4, (a5)
amoor.b.aqrl a4, a5, (a6)
amomin.b.aqrl a5, a6, (a7)
amomax.b.aqrl s7, s6, (s5)
amominu.b.aqrl s6, s5, (s4)
amomaxu.b.aqrl s5, s4, (s3)

amoswap.h a4, ra, (s0)
amoadd.h a1, a2, (a3)
amoxor.h a2, a3, (a4)
amoand.h a3, a4, (a5)
amoor.h a4, a5, (a6)
amomin.h a5, a6, (a7)
amomax.h s7, s6, (s5)
amominu.h s6, s5, (s4)
amomaxu.h s5, s4, (s3)

amoswap.h.aq a4, ra, (s0)
amoadd.h.aq a1, a2, (a3)
amoxor.h.aq a2, a3, (a4)
amoand.h.aq a3, a4, (a5)
amoor.h.aq a4, a5, (a6)
amomin.h.aq a5, a6, (a7)
amomax.h.aq s7, s6, (s5)
amominu.h.aq s6, s5, (s4)
amomaxu.h.aq s5, s4, (s3)

amoswap.h.rl a4, ra, (s0)
amoadd.h.rl a1, a2, (a3)
amoxor.h.rl a2, a3, (a4)
amoand.h.rl a3, a4, (a5)
amoor.h.rl a4, a5, (a6)
amomin.h.rl a5, a6, (a7)
amomax.h.rl s7, s6, (s5)
amominu.h.rl s6, s5, (s4)
amomaxu.h.rl s5, s4, (s3)

amoswap.h.aqrl a4, ra, (s0)
amoadd.h.aqrl a1, a2, (a3)
amoxor.h.aqrl a2, a3, (a4)
amoand.h.aqrl a3, a4, (a5)
amoor.h.aqrl a4, a5, (a6)
amomin.h.aqrl a5, a6, (a7)
amomax.h.aqrl s7, s6, (s5)
amominu.h.aqrl s6, s5, (s4)
amomaxu.h.aqrl s5, s4, (s3)

# Zacas
# amocas.w a1, a3, (a5)
# amocas.w a1, a3, 0(a5)
# amocas.w zero, zero, (a5)
# amocas.w.aq zero, zero, (a5)
# amocas.w.rl zero, zero, (a5)
# amocas.w.aqrl zero, zero, (a5)

# amocas.d a0, a2, (a1)
# amocas.d a0, a2, 0(a1)
# amocas.d zero, zero, (a1)
# amocas.d.aq zero, zero, (a1)
# amocas.d.rl zero, zero, (a1)
# amocas.d.aqrl zero, zero, (a1)

# amocas.q a0, a2, (a1)
# amocas.q a0, a2, 0(a1)
# amocas.q zero, zero, (a1)
# amocas.q.aq zero, zero, (a1)
# amocas.q.rl zero, zero, (a1)
# amocas.q.aqrl zero, zero, (a1)

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      160
# CHECK-NEXT: Total Cycles:      148
# CHECK-NEXT: Total uOps:        160

# CHECK:      Dispatch Width:    6
# CHECK-NEXT: uOps Per Cycle:    1.08
# CHECK-NEXT: IPC:               1.08
# CHECK-NEXT: Block RThroughput: 80.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      4     0.50    *                   lr.w	t0, (t1)
# CHECK-NEXT:  1      4     0.50    *                   lr.w.aq	t1, (t2)
# CHECK-NEXT:  1      4     0.50    *                   lr.w.rl	t2, (t3)
# CHECK-NEXT:  1      4     0.50    *                   lr.w.aqrl	t3, (t4)
# CHECK-NEXT:  1      1     0.50           *            sc.w	t6, t5, (t4)
# CHECK-NEXT:  1      1     0.50           *            sc.w.aq	t5, t4, (t3)
# CHECK-NEXT:  1      1     0.50           *            sc.w.rl	t4, t3, (t2)
# CHECK-NEXT:  1      1     0.50           *            sc.w.aqrl	t3, t2, (t1)
# CHECK-NEXT:  1      4     0.50    *                   lr.d	t0, (t1)
# CHECK-NEXT:  1      4     0.50    *                   lr.d.aq	t1, (t2)
# CHECK-NEXT:  1      4     0.50    *                   lr.d.rl	t2, (t3)
# CHECK-NEXT:  1      4     0.50    *                   lr.d.aqrl	t3, (t4)
# CHECK-NEXT:  1      1     0.50           *            sc.d	t6, t5, (t4)
# CHECK-NEXT:  1      1     0.50           *            sc.d.aq	t5, t4, (t3)
# CHECK-NEXT:  1      1     0.50           *            sc.d.rl	t4, t3, (t2)
# CHECK-NEXT:  1      1     0.50           *            sc.d.aqrl	t3, t2, (t1)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.w	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.w	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.w	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.w	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.w	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.w	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.w	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.w	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.w	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.w.aq	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.w.aq	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.w.aq	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.w.aq	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.w.aq	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.w.aq	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.w.aq	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.w.aq	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.w.aq	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.w.rl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.w.rl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.w.rl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.w.rl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.w.rl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.w.rl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.w.rl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.w.rl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.w.rl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.w.aqrl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.w.aqrl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.w.aqrl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.w.aqrl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.w.aqrl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.w.aqrl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.w.aqrl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.w.aqrl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.w.aqrl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.d	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.d	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.d	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.d	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.d	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.d	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.d	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.d	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.d	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.d.aq	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.d.aq	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.d.aq	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.d.aq	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.d.aq	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.d.aq	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.d.aq	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.d.aq	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.d.aq	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.d.rl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.d.rl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.d.rl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.d.rl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.d.rl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.d.rl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.d.rl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.d.rl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.d.rl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.d.aqrl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.d.aqrl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.d.aqrl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.d.aqrl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.d.aqrl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.d.aqrl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.d.aqrl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.d.aqrl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.d.aqrl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.b	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.b	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.b	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.b	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.b	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.b	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.b	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.b	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.b	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.b.aq	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.b.aq	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.b.aq	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.b.aq	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.b.aq	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.b.aq	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.b.aq	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.b.aq	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.b.aq	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.b.rl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.b.rl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.b.rl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.b.rl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.b.rl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.b.rl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.b.rl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.b.rl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.b.rl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.b.aqrl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.b.aqrl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.b.aqrl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.b.aqrl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.b.aqrl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.b.aqrl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.b.aqrl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.b.aqrl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.b.aqrl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.h	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.h	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.h	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.h	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.h	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.h	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.h	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.h	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.h	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.h.aq	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.h.aq	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.h.aq	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.h.aq	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.h.aq	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.h.aq	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.h.aq	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.h.aq	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.h.aq	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.h.rl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.h.rl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.h.rl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.h.rl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.h.rl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.h.rl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.h.rl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.h.rl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.h.rl	s5, s4, (s3)
# CHECK-NEXT:  1      5     0.50    *      *            amoswap.h.aqrl	a4, ra, (s0)
# CHECK-NEXT:  1      5     0.50    *      *            amoadd.h.aqrl	a1, a2, (a3)
# CHECK-NEXT:  1      5     0.50    *      *            amoxor.h.aqrl	a2, a3, (a4)
# CHECK-NEXT:  1      5     0.50    *      *            amoand.h.aqrl	a3, a4, (a5)
# CHECK-NEXT:  1      5     0.50    *      *            amoor.h.aqrl	a4, a5, (a6)
# CHECK-NEXT:  1      5     0.50    *      *            amomin.h.aqrl	a5, a6, (a7)
# CHECK-NEXT:  1      5     0.50    *      *            amomax.h.aqrl	s7, s6, (s5)
# CHECK-NEXT:  1      5     0.50    *      *            amominu.h.aqrl	s6, s5, (s4)
# CHECK-NEXT:  1      5     0.50    *      *            amomaxu.h.aqrl	s5, s4, (s3)

# CHECK:      Resources:
# CHECK-NEXT: [0]   - GenericOOOBranch
# CHECK-NEXT: [1]   - GenericOOOFMulDiv
# CHECK-NEXT: [2]   - GenericOOOFloat
# CHECK-NEXT: [3.0] - GenericOOOInt
# CHECK-NEXT: [3.1] - GenericOOOInt
# CHECK-NEXT: [4.0] - GenericOOOLSU
# CHECK-NEXT: [4.1] - GenericOOOLSU
# CHECK-NEXT: [5]   - GenericOOOMulDiv

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]
# CHECK-NEXT:  -      -      -      -      -     80.00  80.00   -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3.0]  [3.1]  [4.0]  [4.1]  [5]    Instructions:
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lr.w	t0, (t1)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lr.w.aq	t1, (t2)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lr.w.rl	t2, (t3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lr.w.aqrl	t3, (t4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sc.w	t6, t5, (t4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sc.w.aq	t5, t4, (t3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     sc.w.rl	t4, t3, (t2)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sc.w.aqrl	t3, t2, (t1)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lr.d	t0, (t1)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lr.d.aq	t1, (t2)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     lr.d.rl	t2, (t3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     lr.d.aqrl	t3, (t4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sc.d	t6, t5, (t4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     sc.d.aq	t5, t4, (t3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     sc.d.rl	t4, t3, (t2)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     sc.d.aqrl	t3, t2, (t1)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.w	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.w	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.w	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.w	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.w	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.w	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.w	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.w	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.w	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.w.aq	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.w.aq	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.w.aq	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.w.aq	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.w.aq	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.w.aq	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.w.aq	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.w.aq	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.w.aq	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.w.rl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.w.rl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.w.rl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.w.rl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.w.rl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.w.rl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.w.rl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.w.rl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.w.rl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.w.aqrl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.w.aqrl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.w.aqrl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.w.aqrl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.w.aqrl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.w.aqrl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.w.aqrl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.w.aqrl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.w.aqrl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.d	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.d	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.d	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.d	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.d	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.d	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.d	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.d	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.d	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.d.aq	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.d.aq	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.d.aq	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.d.aq	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.d.aq	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.d.aq	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.d.aq	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.d.aq	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.d.aq	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.d.rl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.d.rl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.d.rl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.d.rl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.d.rl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.d.rl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.d.rl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.d.rl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.d.rl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.d.aqrl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.d.aqrl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.d.aqrl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.d.aqrl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.d.aqrl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.d.aqrl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.d.aqrl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.d.aqrl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.d.aqrl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.b	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.b	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.b	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.b	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.b	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.b	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.b	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.b	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.b	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.b.aq	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.b.aq	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.b.aq	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.b.aq	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.b.aq	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.b.aq	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.b.aq	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.b.aq	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.b.aq	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.b.rl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.b.rl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.b.rl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.b.rl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.b.rl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.b.rl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.b.rl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.b.rl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.b.rl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.b.aqrl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.b.aqrl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.b.aqrl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.b.aqrl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.b.aqrl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.b.aqrl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.b.aqrl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.b.aqrl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.b.aqrl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.h	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.h	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.h	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.h	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.h	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.h	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.h	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.h	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.h	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.h.aq	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.h.aq	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.h.aq	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.h.aq	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.h.aq	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.h.aq	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.h.aq	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.h.aq	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.h.aq	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoswap.h.rl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoadd.h.rl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoxor.h.rl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoand.h.rl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoor.h.rl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomin.h.rl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomax.h.rl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amominu.h.rl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomaxu.h.rl	s5, s4, (s3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoswap.h.aqrl	a4, ra, (s0)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoadd.h.aqrl	a1, a2, (a3)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoxor.h.aqrl	a2, a3, (a4)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amoand.h.aqrl	a3, a4, (a5)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amoor.h.aqrl	a4, a5, (a6)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amomin.h.aqrl	a5, a6, (a7)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomax.h.aqrl	s7, s6, (s5)
# CHECK-NEXT:  -      -      -      -      -      -     1.00    -     amominu.h.aqrl	s6, s5, (s4)
# CHECK-NEXT:  -      -      -      -      -     1.00    -      -     amomaxu.h.aqrl	s5, s4, (s3)
