; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py UTC_ARGS: --version 5
; RUN: llc --mtriple=loongarch64 --mattr=+lasx < %s | FileCheck %s

define <32 x i8> @concat_poison_v32i8_1(<16 x i8> %a) {
; CHECK-LABEL: concat_poison_v32i8_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <16 x i8> %a, <16 x i8> poison,
                     <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,
                                 i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15,
                                 i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23,
                                 i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i8> %1
}

define <32 x i8> @concat_poison_v32i8_2(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: concat_poison_v32i8_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <16 x i8> %b, <16 x i8> poison,
                     <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,
                                 i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15,
                                 i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23,
                                 i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i8> %1
}

define <32 x i8> @concat_vectors_v32i8(<16 x i8> %a, <16 x i8> %b) {
; CHECK-LABEL: concat_vectors_v32i8:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr1 killed $vr1 def $xr1
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    xvpermi.q $xr0, $xr1, 2
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <16 x i8> %a, <16 x i8> %b,
                     <32 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,
                                 i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15,
                                 i32 16, i32 17, i32 18, i32 19, i32 20, i32 21, i32 22, i32 23,
                                 i32 24, i32 25, i32 26, i32 27, i32 28, i32 29, i32 30, i32 31>
  ret <32 x i8> %1
}

define <16 x i16> @concat_poison_v16i16_1(<8 x i16> %a) {
; CHECK-LABEL: concat_poison_v16i16_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <8 x i16> %a, <8 x i16> poison,
                     <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,
                                 i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i16> %1
}

define <16 x i16> @concat_poison_v16i16_2(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: concat_poison_v16i16_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <8 x i16> %b, <8 x i16> poison,
                     <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,
                                 i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i16> %1
}

define <16 x i16> @concat_vectors_v16i16(<8 x i16> %a, <8 x i16> %b) {
; CHECK-LABEL: concat_vectors_v16i16:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr1 killed $vr1 def $xr1
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    xvpermi.q $xr0, $xr1, 2
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <8 x i16> %a, <8 x i16> %b,
                     <16 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7,
                                 i32 8, i32 9, i32 10, i32 11, i32 12, i32 13, i32 14, i32 15>
  ret <16 x i16> %1
}

define <8 x i32> @concat_poison_v8i32_1(<4 x i32> %a) {
; CHECK-LABEL: concat_poison_v8i32_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <4 x i32> %a, <4 x i32> poison,
                     <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %1
}

define <8 x i32> @concat_poison_v8i32_2(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: concat_poison_v8i32_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <4 x i32> %b, <4 x i32> poison,
                     <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %1
}

define <8 x i32> @concat_vectors_v8i32(<4 x i32> %a, <4 x i32> %b) {
; CHECK-LABEL: concat_vectors_v8i32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr1 killed $vr1 def $xr1
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    xvpermi.q $xr0, $xr1, 2
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <4 x i32> %a, <4 x i32> %b,
                     <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x i32> %1
}

define <8 x float> @concat_poison_v8f32_1(<4 x float> %a) {
; CHECK-LABEL: concat_poison_v8f32_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <4 x float> %a, <4 x float> poison,
                     <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %1
}

define <8 x float> @concat_poison_v8f32_2(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: concat_poison_v8f32_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <4 x float> %b, <4 x float> poison,
                     <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %1
}

define <8 x float> @concat_vectors_v8f32(<4 x float> %a, <4 x float> %b) {
; CHECK-LABEL: concat_vectors_v8f32:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr1 killed $vr1 def $xr1
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    xvpermi.q $xr0, $xr1, 2
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <4 x float> %a, <4 x float> %b,
                     <8 x i32> <i32 0, i32 1, i32 2, i32 3, i32 4, i32 5, i32 6, i32 7>
  ret <8 x float> %1
}

define <4 x i64> @concat_poison_v8i64_1(<2 x i64> %a) {
; CHECK-LABEL: concat_poison_v8i64_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <2 x i64> %a, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %1
}

define <4 x i64> @concat_poison_v8i64_2(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: concat_poison_v8i64_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <2 x i64> %b, <2 x i64> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %1
}

define <4 x i64> @concat_vectors_v8i64(<2 x i64> %a, <2 x i64> %b) {
; CHECK-LABEL: concat_vectors_v8i64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr1 killed $vr1 def $xr1
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    xvpermi.q $xr0, $xr1, 2
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <2 x i64> %a, <2 x i64> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x i64> %1
}

define <4 x double> @concat_poison_v8f64_1(<2 x double> %a) {
; CHECK-LABEL: concat_poison_v8f64_1:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <2 x double> %a, <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %1
}

define <4 x double> @concat_poison_v8f64_2(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: concat_poison_v8f64_2:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    vori.b $vr0, $vr1, 0
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <2 x double> %b, <2 x double> poison, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %1
}

define <4 x double> @concat_vectors_v8f64(<2 x double> %a, <2 x double> %b) {
; CHECK-LABEL: concat_vectors_v8f64:
; CHECK:       # %bb.0: # %entry
; CHECK-NEXT:    # kill: def $vr1 killed $vr1 def $xr1
; CHECK-NEXT:    # kill: def $vr0 killed $vr0 def $xr0
; CHECK-NEXT:    xvpermi.q $xr0, $xr1, 2
; CHECK-NEXT:    ret
entry:
  %1 = shufflevector <2 x double> %a, <2 x double> %b, <4 x i32> <i32 0, i32 1, i32 2, i32 3>
  ret <4 x double> %1
}
