; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -global-isel -mattr=-promote-alloca -mattr=+enable-flat-scratch -verify-machineinstrs < %s | FileCheck -check-prefix=GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 -global-isel -mattr=-promote-alloca -mattr=+enable-flat-scratch -verify-machineinstrs < %s | FileCheck -check-prefix=GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 -global-isel -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefix=GFX942 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -global-isel -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefix=GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -global-isel -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefix=GFX12 %s

; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx900 -global-isel -mattr=-unaligned-access-mode -mattr=-promote-alloca -mattr=+enable-flat-scratch -verify-machineinstrs < %s | FileCheck -check-prefixes=UNALIGNED_GFX9 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1030 -global-isel -mattr=-unaligned-access-mode -mattr=-promote-alloca -mattr=+enable-flat-scratch -verify-machineinstrs < %s | FileCheck -check-prefixes=UNALIGNED_GFX10 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx942 -global-isel -mattr=-unaligned-access-mode -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefixes=UNALIGNED_GFX942 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1100 -global-isel -mattr=-unaligned-access-mode -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefixes=UNALIGNED_GFX11 %s
; RUN: llc -mtriple=amdgcn-amd-amdhsa -mcpu=gfx1200 -global-isel -mattr=-unaligned-access-mode -mattr=-promote-alloca -verify-machineinstrs < %s | FileCheck -check-prefixes=UNALIGNED_GFX12 %s

define amdgpu_kernel void @store_load_sindex_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_sindex_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; UNALIGNED_GFX9-NEXT:    s_and_b32 s0, s0, 15
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s1
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_sindex_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v0, s0
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_sindex_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; UNALIGNED_GFX942-NEXT:    s_and_b32 s0, s0, 15
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_sindex_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_sindex_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_kernel(i32 %n) {
; GFX9-LABEL: store_load_vindex_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_add_u32_e32 v2, s0, v2
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v2, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vindex_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; GFX942-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; GFX942-NEXT:    v_add_u32_e32 v2, s0, v2
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_store_dword v2, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    v_mov_b32_e32 v2, 15
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX12-NEXT:    scratch_store_b32 v0, v2, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_vindex_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; UNALIGNED_GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; UNALIGNED_GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v2, s0, v2
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v2, v1, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_vindex_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_vindex_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v2, 2, v0
; UNALIGNED_GFX942-NEXT:    v_sub_u32_e32 v0, 0, v0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v2, s0, v2
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v2, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_vindex_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; UNALIGNED_GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_vindex_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; UNALIGNED_GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; UNALIGNED_GFX12-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v2, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %i.alloca = alloca [2 x [32 x float]], align 4, addrspace(5)
  %i = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 %n
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 0, %i2
  %i9.1 = getelementptr [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i9.1, i32 0, i32 31
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_vindex_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX942-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, s32 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_vindex_foo:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v1, v2, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_vindex_foo:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_vindex_foo:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, s32, v1
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, s32 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_vindex_foo:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; UNALIGNED_GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(NEXT) | instid1(VALU_DEP_2)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v0, s32 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_vindex_foo:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v2, s32 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v1, s32 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = alloca [32 x float], align 4, addrspace(5)
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @private_ptr_foo(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: private_ptr_foo:
; GFX9:       ; %bb.0:
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX9-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: private_ptr_foo:
; GFX10:       ; %bb.0:
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: private_ptr_foo:
; GFX942:       ; %bb.0:
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX942-NEXT:    scratch_store_dword v0, v1, off offset:4
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: private_ptr_foo:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: private_ptr_foo:
; GFX12:       ; %bb.0:
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 0x41200000
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:4
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: private_ptr_foo:
; UNALIGNED_GFX9:       ; %bb.0:
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 0x41200000
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v0, v1, off offset:4
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: private_ptr_foo:
; UNALIGNED_GFX10:       ; %bb.0:
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 0x41200000
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v1, off offset:4
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: private_ptr_foo:
; UNALIGNED_GFX942:       ; %bb.0:
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 0x41200000
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v0, v1, off offset:4
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: private_ptr_foo:
; UNALIGNED_GFX11:       ; %bb.0:
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v1, 0x41200000
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:4
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: private_ptr_foo:
; UNALIGNED_GFX12:       ; %bb.0:
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v1, 0x41200000
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:4
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
  %gep = getelementptr inbounds float, ptr addrspace(5) %arg, i32 1
  store float 1.000000e+01, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_kernel void @store_load_sindex_small_offset_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_small_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s1 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_addk_i32 s1, 0x100
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_addk_i32 s0, 0x100
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_small_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_addk_i32 s0, 0x100
; GFX10-NEXT:    s_addk_i32 s1, 0x100
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_small_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    scratch_load_dword v0, off, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_addk_i32 s1, 0x100
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_addk_i32 s0, 0x100
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_small_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_addk_i32 s0, 0x100
; GFX11-NEXT:    s_addk_i32 s1, 0x100
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_small_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    s_addk_co_i32 s0, 0x100
; GFX12-NEXT:    s_addk_co_i32 s1, 0x100
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_sindex_small_offset_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    s_mov_b32 s1, 0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s1 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; UNALIGNED_GFX9-NEXT:    s_and_b32 s0, s0, 15
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX9-NEXT:    s_addk_i32 s1, 0x100
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s1
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_addk_i32 s0, 0x100
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_sindex_small_offset_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX10-NEXT:    s_addk_i32 s0, 0x100
; UNALIGNED_GFX10-NEXT:    s_addk_i32 s1, 0x100
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v0, s0
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_sindex_small_offset_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; UNALIGNED_GFX942-NEXT:    s_and_b32 s0, s0, 15
; UNALIGNED_GFX942-NEXT:    s_addk_i32 s1, 0x100
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_addk_i32 s0, 0x100
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_sindex_small_offset_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX11-NEXT:    s_addk_i32 s0, 0x100
; UNALIGNED_GFX11-NEXT:    s_addk_i32 s1, 0x100
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_sindex_small_offset_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX12-NEXT:    s_addk_co_i32 s0, 0x100
; UNALIGNED_GFX12-NEXT:    s_addk_co_i32 s1, 0x100
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_small_offset_kernel(i32 %n) {
; GFX9-LABEL: store_load_vindex_small_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v1, off, s1 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x100, v1
; GFX9-NEXT:    s_add_u32 s0, 0x100, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_small_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x100, v0
; GFX10-NEXT:    scratch_store_dword v0, v2, off offset:128
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-NEXT:    s_add_u32 s0, 0x100, s0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vindex_small_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    scratch_load_dword v1, off, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX942-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; GFX942-NEXT:    s_add_u32 s0, 0x100, s0
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off offset:384 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_small_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    scratch_load_b32 v3, off, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    scratch_store_b32 v0, v2, off offset:384 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-NEXT:    s_add_u32 s0, 0x100, s0
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_small_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 15
; GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, off offset:384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-NEXT:    s_add_co_u32 s0, 0x100, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_vindex_small_offset_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    s_mov_b32 s1, 0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v1, off, s1 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 0x100, v1
; UNALIGNED_GFX9-NEXT:    s_add_u32 s0, 0x100, s0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v1, v2, off offset:128
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_vindex_small_offset_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v3, off, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x100, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v2, off offset:128
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, 0x100, s0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_vindex_small_offset_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v1, off, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX942-NEXT:    v_sub_u32_e32 v0, 0, v0
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX942-NEXT:    s_add_u32 s0, 0x100, s0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v1, v2, off offset:384 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_vindex_small_offset_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v3, off, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v2, off offset:384 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX11-NEXT:    s_add_u32 s0, 0x100, s0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_vindex_small_offset_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v2, off offset:384 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX12-NEXT:    s_add_co_u32 s0, 0x100, s0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; UNALIGNED_GFX12-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i.alloca = alloca [2 x [32 x float]], align 4, addrspace(5)
  %i = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 %n
  %i.1 = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 1
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i.1, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 0, %i2
  %i9.1 = getelementptr [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i9.1, i32 0, i32 31
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_small_offset_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_small_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v1, off, s32 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x100, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0x100, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_small_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, s32 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x100, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x100, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_vindex_small_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    scratch_load_dword v1, off, s32 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX942-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX942-NEXT:    v_add_u32_e32 v1, 0x100, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, s32 offset:256 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_small_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-NEXT:    scratch_load_b32 v3, off, s32 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x100, v1
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, s32 offset:256 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_small_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_vindex_small_offset_foo:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v1, off, s32 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 0x100, v1
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v1, v2, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, 0x100, v0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_vindex_small_offset_foo:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v3, off, s32 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x100, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x100, v1
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_vindex_small_offset_foo:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v1, off, s32 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, s32, v1
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, 0x100, v1
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, s32 offset:256 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_vindex_small_offset_foo:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; UNALIGNED_GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v3, off, s32 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x100, v1
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v0, s32 offset:256 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_vindex_small_offset_foo:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:256 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:256 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %padding = alloca [64 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [64 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_sindex_large_offset_kernel(i32 %idx) {
; GFX9-LABEL: store_load_sindex_large_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; GFX9-NEXT:    s_and_b32 s0, s0, 15
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_addk_i32 s1, 0x4004
; GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; GFX9-NEXT:    scratch_store_dword off, v0, s1
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_addk_i32 s0, 0x4004
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_sindex_large_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_and_b32 s1, s0, 15
; GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; GFX10-NEXT:    s_addk_i32 s0, 0x4004
; GFX10-NEXT:    s_addk_i32 s1, 0x4004
; GFX10-NEXT:    scratch_store_dword off, v0, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_sindex_large_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    scratch_load_dword v0, off, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; GFX942-NEXT:    s_and_b32 s0, s0, 15
; GFX942-NEXT:    s_addk_i32 s1, 0x4004
; GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_addk_i32 s0, 0x4004
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_sindex_large_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 15
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_and_b32 s1, s0, 15
; GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; GFX11-NEXT:    s_addk_i32 s0, 0x4004
; GFX11-NEXT:    s_addk_i32 s1, 0x4004
; GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_sindex_large_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v0, 15
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_and_b32 s1, s0, 15
; GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; GFX12-NEXT:    s_addk_co_i32 s0, 0x4000
; GFX12-NEXT:    s_addk_co_i32 s1, 0x4000
; GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_sindex_large_offset_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    s_mov_b32 s1, 0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s1 offset:4 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s1, s0, 2
; UNALIGNED_GFX9-NEXT:    s_and_b32 s0, s0, 15
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX9-NEXT:    s_addk_i32 s1, 0x4004
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s1
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_addk_i32 s0, 0x4004
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_sindex_large_offset_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, off offset:4 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX10-NEXT:    s_addk_i32 s0, 0x4004
; UNALIGNED_GFX10-NEXT:    s_addk_i32 s1, 0x4004
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v0, s0
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, s1 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_sindex_large_offset_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, off offset:4 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s1, s0, 2
; UNALIGNED_GFX942-NEXT:    s_and_b32 s0, s0, 15
; UNALIGNED_GFX942-NEXT:    s_addk_i32 s1, 0x4004
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, s1 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_addk_i32 s0, 0x4004
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_sindex_large_offset_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, off offset:4 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX11-NEXT:    s_addk_i32 s0, 0x4004
; UNALIGNED_GFX11-NEXT:    s_addk_i32 s1, 0x4004
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v0, s0 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, s1 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_sindex_large_offset_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_and_b32 s1, s0, 15
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s0, s0, 2
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s1, s1, 2
; UNALIGNED_GFX12-NEXT:    s_addk_co_i32 s0, 0x4000
; UNALIGNED_GFX12-NEXT:    s_addk_co_i32 s1, 0x4000
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v0, s0 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, s1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vindex_large_offset_kernel(i32 %n) {
; GFX9-LABEL: store_load_vindex_large_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    s_mov_b32 s1, 0
; GFX9-NEXT:    scratch_load_dword v1, off, s1 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; GFX9-NEXT:    s_add_u32 s0, 0x4004, s0
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off offset:128
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vindex_large_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, off offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x4004, v0
; GFX10-NEXT:    scratch_store_dword v0, v2, off offset:128
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; GFX10-NEXT:    s_add_u32 s0, 0x4004, s0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vindex_large_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    scratch_load_dword v1, off, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX942-NEXT:    v_sub_u32_e32 v0, 0, v0
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; GFX942-NEXT:    s_add_u32 s0, 0x4004, s0
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    s_movk_i32 s1, 0x4004
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, s1 offset:128 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vindex_large_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX11-NEXT:    scratch_load_b32 v3, off, off offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v2, 15
; GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; GFX11-NEXT:    s_add_u32 s0, 0x4004, s0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX11-NEXT:    s_movk_i32 s0, 0x4004
; GFX11-NEXT:    scratch_store_b32 v0, v2, s0 offset:128 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vindex_large_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v2, 15
; GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, off offset:16512 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; GFX12-NEXT:    s_add_co_u32 s0, 0x4000, s0
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_vindex_large_offset_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    s_mov_b32 s1, 0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v1, off, s1 offset:4 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX9-NEXT:    v_sub_u32_e32 v0, 0, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; UNALIGNED_GFX9-NEXT:    s_add_u32 s0, 0x4004, s0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v1, v2, off offset:128
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s0, v0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off offset:124 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_vindex_large_offset_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v3, off, off offset:4 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x4004, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v2, off offset:128
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, 0x4004, s0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v1, off offset:124 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_vindex_large_offset_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v1, off, off offset:4 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX942-NEXT:    v_sub_u32_e32 v0, 0, v0
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX942-NEXT:    s_add_u32 s0, 0x4004, s0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX942-NEXT:    s_movk_i32 s1, 0x4004
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v1, v2, s1 offset:128 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v0, s0, v0
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, off offset:124 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_vindex_large_offset_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v3, off, off offset:4 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX11-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX11-NEXT:    s_add_u32 s0, 0x4004, s0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX11-NEXT:    s_movk_i32 s0, 0x4004
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v2, s0 offset:128 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v1, off offset:124 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_vindex_large_offset_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v3, off, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX12-NEXT:    v_sub_nc_u32_e32 v1, 0, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_4) | instid1(SALU_CYCLE_1)
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v2, off offset:16512 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_lshl_b32 s0, s0, 7
; UNALIGNED_GFX12-NEXT:    s_add_co_u32 s0, 0x4000, s0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; UNALIGNED_GFX12-NEXT:    v_add_nc_u32_e32 v1, s0, v1
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v1, off offset:124 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i.alloca = alloca [2 x [32 x float]], align 4, addrspace(5)
  %i = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 %n
  %i.1 = getelementptr inbounds [2 x [32 x float]], ptr addrspace (5) %i.alloca, i32 0, i32 1
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i2 = tail call i32 @llvm.amdgcn.workitem.id.x()
  %i3 = zext i32 %i2 to i64
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i.1, i32 0, i32 %i2
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = sub nsw i32 0, %i2
  %i9.1 = getelementptr [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i9.1, i32 0, i32 31
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_vindex_large_offset_foo(i32 %idx) {
; GFX9-LABEL: store_load_vindex_large_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    scratch_load_dword v1, off, s32 offset:4 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX9-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; GFX9-NEXT:    v_mov_b32_e32 v2, 15
; GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; GFX9-NEXT:    scratch_store_dword v1, v2, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_add_u32_e32 v0, 0x4004, v0
; GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_vindex_large_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX10-NEXT:    v_mov_b32_e32 v2, 15
; GFX10-NEXT:    scratch_load_dword v3, off, s32 offset:4 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x4004, v0
; GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v1
; GFX10-NEXT:    scratch_store_dword v0, v2, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_vindex_large_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    scratch_load_dword v1, off, s32 offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; GFX942-NEXT:    v_add_u32_e32 v1, s32, v1
; GFX942-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; GFX942-NEXT:    v_mov_b32_e32 v2, 15
; GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX942-NEXT:    scratch_load_dword v0, v0, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_vindex_large_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; GFX11-NEXT:    scratch_load_b32 v3, off, s32 offset:4 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v1
; GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_vindex_large_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:16384 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_vindex_large_offset_foo:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v1, off, s32 offset:4 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX9-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, s32, v1
; UNALIGNED_GFX9-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s32, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v1, v2, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, 0x4004, v0
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_vindex_large_offset_foo:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_and_b32_e32 v1, 15, v0
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v3, off, s32 offset:4 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s32, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, 0x4004, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v1
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v1, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_vindex_large_offset_foo:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v1, off, s32 offset:4 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v1, 2, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, s32, v1
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, 0x4004, v1
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v2, 15
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v1, v2, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX942-NEXT:    s_add_i32 s0, s32, 0x4004
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_vindex_large_offset_foo:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_lshlrev_b32 v1, 2, v0
; UNALIGNED_GFX11-NEXT:    v_and_b32_e32 v0, 15, v0
; UNALIGNED_GFX11-NEXT:    s_add_i32 s0, s32, 0x4004
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v3, off, s32 offset:4 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, s32, v1
; UNALIGNED_GFX11-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, 0x4004, v1
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v1, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v0, s0 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_vindex_large_offset_foo:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v2, 15 :: v_dual_and_b32 v1, 15, v0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v0, 2, v0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v3, off, s32 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_lshlrev_b32_e32 v1, 2, v1
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v2, s32 offset:16384 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v1, s32 offset:16384 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %padding = alloca [4096 x i32], align 4, addrspace(5)
  %i = alloca [32 x float], align 4, addrspace(5)
  %pad_gep = getelementptr inbounds [4096 x i32], ptr addrspace(5) %padding, i32 0, i32 0
  %pad_load = load volatile i32, ptr addrspace(5) %pad_gep, align 4
  %i7 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %idx
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i9 = and i32 %idx, 15
  %i10 = getelementptr inbounds [32 x float], ptr addrspace(5) %i, i32 0, i32 %i9
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_large_imm_offset_kernel() {
; GFX9-LABEL: store_load_large_imm_offset_kernel:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-NEXT:    s_mov_b32 s0, 0
; GFX9-NEXT:    scratch_store_dword off, v0, s0 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_movk_i32 s0, 0x3e84
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_large_imm_offset_kernel:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_movk_i32 s0, 0x3e84
; GFX10-NEXT:    scratch_store_dword off, v0, off offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_store_dword off, v1, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_large_imm_offset_kernel:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    v_mov_b32_e32 v0, 13
; GFX942-NEXT:    scratch_store_dword off, v0, off offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_movk_i32 s0, 0x3e84
; GFX942-NEXT:    scratch_store_dword off, v0, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_large_imm_offset_kernel:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX11-NEXT:    s_movk_i32 s0, 0x3e84
; GFX11-NEXT:    scratch_store_b32 off, v0, off offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_store_b32 off, v1, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_large_imm_offset_kernel:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-NEXT:    scratch_store_b32 off, v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v1, off offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, off offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_large_imm_offset_kernel:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 13
; UNALIGNED_GFX9-NEXT:    s_mov_b32 s0, 0
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s0 offset:4
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX9-NEXT:    s_movk_i32 s0, 0x3e84
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s0
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_large_imm_offset_kernel:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v0, 13
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    s_movk_i32 s0, 0x3e84
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v0, off offset:4
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v1, s0
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_large_imm_offset_kernel:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 13
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, off offset:4 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX942-NEXT:    s_movk_i32 s0, 0x3e84
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_large_imm_offset_kernel:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; UNALIGNED_GFX11-NEXT:    s_movk_i32 s0, 0x3e84
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v0, off offset:4 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v1, s0 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, s0 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_large_imm_offset_kernel:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v0, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v1, off offset:16000 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, off offset:16000 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %i = alloca [4096 x i32], align 4, addrspace(5)
  %i1 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 0
  store volatile i32 13, ptr addrspace(5) %i1, align 4
  %i7 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i10 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define void @store_load_large_imm_offset_foo() {
; GFX9-LABEL: store_load_large_imm_offset_foo:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 13
; GFX9-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v0, 15
; GFX9-NEXT:    s_add_i32 s0, s32, 0x3e84
; GFX9-NEXT:    scratch_store_dword off, v0, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_large_imm_offset_foo:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v0, 13
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_add_i32 s0, s32, 0x3e84
; GFX10-NEXT:    scratch_store_dword off, v0, s32 offset:4
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_store_dword off, v1, s0
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_large_imm_offset_foo:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 13
; GFX942-NEXT:    scratch_store_dword off, v0, s32 offset:4 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    v_mov_b32_e32 v0, 15
; GFX942-NEXT:    s_add_i32 s0, s32, 0x3e84
; GFX942-NEXT:    scratch_store_dword off, v0, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_large_imm_offset_foo:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX11-NEXT:    s_add_i32 s0, s32, 0x3e84
; GFX11-NEXT:    scratch_store_b32 off, v0, s32 offset:4 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_store_b32 off, v1, s0 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, off, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_large_imm_offset_foo:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v0, s32 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b32 off, v1, s32 offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, off, s32 offset:16000 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_large_imm_offset_foo:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 13
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s32 offset:4
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX9-NEXT:    s_add_i32 s0, s32, 0x3e84
; UNALIGNED_GFX9-NEXT:    scratch_store_dword off, v0, s0
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, off, s0 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_large_imm_offset_foo:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v0, 13
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    s_add_i32 s0, s32, 0x3e84
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v0, s32 offset:4
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_dword off, v1, s0
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, off, s0 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_large_imm_offset_foo:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 13
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, s32 offset:4 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v0, 15
; UNALIGNED_GFX942-NEXT:    s_add_i32 s0, s32, 0x3e84
; UNALIGNED_GFX942-NEXT:    scratch_store_dword off, v0, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, off, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_large_imm_offset_foo:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; UNALIGNED_GFX11-NEXT:    s_add_i32 s0, s32, 0x3e84
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v0, s32 offset:4 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 off, v1, s0 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, off, s0 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_large_imm_offset_foo:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v0, 13 :: v_dual_mov_b32 v1, 15
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v0, s32 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 off, v1, s32 offset:16000 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, off, s32 offset:16000 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  %i = alloca [4096 x i32], align 4, addrspace(5)
  %i1 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 0
  store volatile i32 13, ptr addrspace(5) %i1, align 4
  %i7 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  store volatile i32 15, ptr addrspace(5) %i7, align 4
  %i10 = getelementptr inbounds [4096 x i32], ptr addrspace(5) %i, i32 0, i32 4000
  %i12 = load volatile i32, ptr addrspace(5) %i10, align 4
  ret void
}

define amdgpu_kernel void @store_load_vidx_sidx_offset(i32 %sidx) {
; GFX9-LABEL: store_load_vidx_sidx_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; GFX9-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX9-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: store_load_vidx_sidx_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s8, s8, s13
; GFX10-NEXT:    s_addc_u32 s9, s9, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; GFX10-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:1024
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: store_load_vidx_sidx_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; GFX942-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX942-NEXT:    scratch_store_dword v0, v1, off offset:1024 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dword v0, v0, off offset:1024 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: store_load_vidx_sidx_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:1024 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b32 v0, v0, off offset:1024 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: store_load_vidx_sidx_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:1024 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b32 v0, v0, off offset:1024 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: store_load_vidx_sidx_offset:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s8, s13
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s9, 0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX9-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v0, v1, off offset:1024
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: store_load_vidx_sidx_offset:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s8, s8, s13
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s9, s9, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s8
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s9
; UNALIGNED_GFX10-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v1, off offset:1024
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v0, v0, off offset:1024 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: store_load_vidx_sidx_offset:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_load_dword s0, s[4:5], 0x0
; UNALIGNED_GFX942-NEXT:    v_and_b32_e32 v0, 0x3ff, v0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX942-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v0, v1, off offset:1024 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v0, v0, off offset:1024 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: store_load_vidx_sidx_offset:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; UNALIGNED_GFX11-NEXT:    s_waitcnt lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; UNALIGNED_GFX11-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:1024 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v0, v0, off offset:1024 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: store_load_vidx_sidx_offset:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_load_b32 s0, s[4:5], 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_and_b32 v0, 0x3ff, v0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; UNALIGNED_GFX12-NEXT:    v_add_lshl_u32 v0, s0, v0, 2
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:1024 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v0, v0, off offset:1024 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %alloca = alloca [32 x i32], align 4, addrspace(5)
  %vidx = tail call i32 @llvm.amdgcn.workitem.id.x()
  %add1 = add nsw i32 %sidx, %vidx
  %gep1 = getelementptr [32 x float], ptr addrspace(5) %alloca, i32 0, i32 %add1
  %gep = getelementptr inbounds [32 x float], ptr addrspace(5) %gep1, i32 0, i32 256
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  %load = load volatile i32, ptr addrspace(5) %gep, align 4
  ret void
}

define void @store_load_i64_aligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i64_aligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i64_aligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_i64_aligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], 15
; GFX942-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_i64_aligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_i64_aligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_i64_aligned:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v2, 0
; UNALIGNED_GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_i64_aligned:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 0
; UNALIGNED_GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_i64_aligned:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b64_e32 v[2:3], 15
; UNALIGNED_GFX942-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_i64_aligned:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX11-NEXT:    v_mov_b32_e32 v2, 0
; UNALIGNED_GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_i64_aligned:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v2, 0
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile i64 15, ptr addrspace(5) %arg, align 8
  %load = load volatile i64, ptr addrspace(5) %arg, align 8
  ret void
}

define void @store_load_i64_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_i64_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    v_mov_b32_e32 v2, 0
; GFX9-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_i64_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_mov_b32_e32 v2, 0
; GFX10-NEXT:    scratch_store_dwordx2 v0, v[1:2], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx2 v[0:1], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_i64_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], 15
; GFX942-NEXT:    scratch_store_dwordx2 v0, v[2:3], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx2 v[0:1], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_i64_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v1, 15
; GFX11-NEXT:    v_mov_b32_e32 v2, 0
; GFX11-NEXT:    scratch_store_b64 v0, v[1:2], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b64 v[0:1], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_i64_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    v_mov_b32_e32 v1, 15
; GFX12-NEXT:    v_mov_b32_e32 v2, 0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b64 v0, v[1:2], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b64 v[0:1], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_i64_unaligned:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v4, 15
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 4, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v2, 2, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v3, 1, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v0, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v4, 0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v6, 6, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v3, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v5, 3, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v2, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v5, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v7, 5, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v1, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v7, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v8, 7, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v6, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v8, v4, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr7
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr2
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr6
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr1
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr3
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr5
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr8
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr0
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v3, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v2, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v5, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v1, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v7, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v6, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v4, v8, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_i64_unaligned:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v3, 4, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v0, v1, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, 3, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v6, 5, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v7, 6, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v8, 7, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v4, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v5, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v1, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v3, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v6, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v7, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v8, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v0, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v4, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v5, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v1, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v3, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v6, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v7, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v8, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_i64_unaligned:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v4, 15
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, 4, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v2, 2, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v3, 1, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v0, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v4, 0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v6, 6, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v3, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v5, 3, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v2, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v5, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v7, 5, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v1, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v7, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v8, 7, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v6, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v8, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v0, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr7
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr2
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr6
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr1
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr3
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr5
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr8
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr0
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v2, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v5, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v7, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v6, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v4, v8, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_i64_unaligned:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v3, 4, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v0, v1, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v6, 5, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v7, 6, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v8, 7, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v4, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v5, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v1, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v3, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v6, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v7, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v8, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v0, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v4, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v5, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v1, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v3, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v6, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v7, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v8, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_i64_unaligned:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_mov_b32 v2, 0
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v1, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:3 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:4 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:5 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:6 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:7 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:2 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:3 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:4 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:5 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:6 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v0, v0, off offset:7 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile i64 15, ptr addrspace(5) %arg, align 1
  %load = load volatile i64, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_v3i32_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_v3i32_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s2, 3
; GFX9-NEXT:    s_mov_b32 s1, 2
; GFX9-NEXT:    s_mov_b32 s0, 1
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_v3i32_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s2, 3
; GFX10-NEXT:    s_mov_b32 s1, 2
; GFX10-NEXT:    s_mov_b32 s0, 1
; GFX10-NEXT:    v_mov_b32_e32 v3, s2
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    scratch_store_dwordx3 v0, v[1:3], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx3 v[0:2], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_v3i32_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s2, 3
; GFX942-NEXT:    s_mov_b32 s1, 2
; GFX942-NEXT:    s_mov_b32 s0, 1
; GFX942-NEXT:    v_mov_b32_e32 v4, s2
; GFX942-NEXT:    v_mov_b32_e32 v3, s1
; GFX942-NEXT:    v_mov_b32_e32 v2, s0
; GFX942-NEXT:    scratch_store_dwordx3 v0, v[2:4], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx3 v[0:2], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_v3i32_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s2, 3
; GFX11-NEXT:    s_mov_b32 s1, 2
; GFX11-NEXT:    s_mov_b32 s0, 1
; GFX11-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v2, s1
; GFX11-NEXT:    v_mov_b32_e32 v1, s0
; GFX11-NEXT:    scratch_store_b96 v0, v[1:3], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b96 v[0:2], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_v3i32_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s2, 3
; GFX12-NEXT:    s_mov_b32 s1, 2
; GFX12-NEXT:    s_mov_b32 s0, 1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_dual_mov_b32 v3, s2 :: v_dual_mov_b32 v2, s1
; GFX12-NEXT:    v_mov_b32_e32 v1, s0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b96 v0, v[1:3], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b96 v[0:2], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_v3i32_unaligned:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v3, 1
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 2
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v2, 2, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v4, 1, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v0, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v3, 0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v6, 4, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v7, 6, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v9, 8, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v10, 10, v0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v12, 3
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v4, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v5, 3, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v2, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v5, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v8, 5, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v6, v1, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v8, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 7, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v7, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v1, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v11, 9, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v9, v12, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v11, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v12, 11, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v10, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v12, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr12
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr4
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr11
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr7
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr6
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr10
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr5
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr9
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr1
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr8
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr2
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr0
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v4, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v2, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v5, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v6, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v8, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v7, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v1, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v9, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v11, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v10, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v12, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_v3i32_unaligned:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 1
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v3, 0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v5, 1, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 2
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v4, 2, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v0, v1, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, 3, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v6, 4, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v7, 5, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v5, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v4, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v8, 6, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v1, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v6, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v7, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v2, 7, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v9, 8, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v10, 3
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v11, 9, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v12, 10, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v13, 11, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v8, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v2, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v9, v10, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v11, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v12, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v13, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v0, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v5, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v4, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v1, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v6, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v7, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v8, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v2, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v9, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v11, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v12, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v13, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_v3i32_unaligned:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v3, 1
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 2
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v2, 2, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v4, 1, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v0, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v3, 0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v6, 4, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v7, 6, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v9, 8, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v10, 10, v0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v12, 3
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v4, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v5, 3, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v2, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v5, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v8, 5, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v6, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v8, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, 7, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v7, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v1, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v11, 9, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v9, v12, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v11, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v12, 11, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v10, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v12, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v0, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr12
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr4
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr11
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr7
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr6
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr10
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr5
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr9
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr1
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr8
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr2
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr0
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v2, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v5, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v6, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v8, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v7, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v9, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v11, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v10, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v12, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_v3i32_unaligned:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_add_nc_u32 v4, 2, v0
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v10, 3 :: v_dual_add_nc_u32 v5, 1, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v0, v1, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v6, 4, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v7, 5, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v5, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v4, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v8, 6, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v1, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v6, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v7, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v2, 7, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v9, 8, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v11, 9, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v12, 10, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v13, 11, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v8, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v2, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v9, v10, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v11, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v12, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v13, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v0, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v5, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v4, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v1, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v6, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v7, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v8, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v2, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v9, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v11, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v12, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v13, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_v3i32_unaligned:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v3, 2
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v1, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:3 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v1, 3
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:5 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:6 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:7 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v1, off offset:8 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:9 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:10 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:11 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:2 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:3 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:4 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:5 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:6 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:7 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:8 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:9 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:10 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v0, v0, off offset:11 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile <3 x i32> <i32 1, i32 2, i32 3>, ptr addrspace(5) %arg, align 1
  %load = load volatile <3 x i32>, ptr addrspace(5) %arg, align 1
  ret void
}

define void @store_load_v4i32_unaligned(ptr addrspace(5) nocapture %arg) {
; GFX9-LABEL: store_load_v4i32_unaligned:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX9-NEXT:    s_mov_b32 s3, 4
; GFX9-NEXT:    s_mov_b32 s2, 3
; GFX9-NEXT:    s_mov_b32 s1, 2
; GFX9-NEXT:    s_mov_b32 s0, 1
; GFX9-NEXT:    v_mov_b32_e32 v4, s3
; GFX9-NEXT:    v_mov_b32_e32 v3, s2
; GFX9-NEXT:    v_mov_b32_e32 v2, s1
; GFX9-NEXT:    v_mov_b32_e32 v1, s0
; GFX9-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; GFX10-LABEL: store_load_v4i32_unaligned:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX10-NEXT:    s_mov_b32 s3, 4
; GFX10-NEXT:    s_mov_b32 s2, 3
; GFX10-NEXT:    s_mov_b32 s1, 2
; GFX10-NEXT:    s_mov_b32 s0, 1
; GFX10-NEXT:    v_mov_b32_e32 v4, s3
; GFX10-NEXT:    v_mov_b32_e32 v3, s2
; GFX10-NEXT:    v_mov_b32_e32 v2, s1
; GFX10-NEXT:    v_mov_b32_e32 v1, s0
; GFX10-NEXT:    scratch_store_dwordx4 v0, v[1:4], off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    scratch_load_dwordx4 v[0:3], v0, off glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; GFX942-LABEL: store_load_v4i32_unaligned:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX942-NEXT:    s_mov_b32 s3, 4
; GFX942-NEXT:    s_mov_b32 s2, 3
; GFX942-NEXT:    s_mov_b32 s1, 2
; GFX942-NEXT:    s_mov_b32 s0, 1
; GFX942-NEXT:    v_mov_b64_e32 v[4:5], s[2:3]
; GFX942-NEXT:    v_mov_b64_e32 v[2:3], s[0:1]
; GFX942-NEXT:    scratch_store_dwordx4 v0, v[2:5], off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    scratch_load_dwordx4 v[0:3], v0, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: store_load_v4i32_unaligned:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_mov_b32 s3, 4
; GFX11-NEXT:    s_mov_b32 s2, 3
; GFX11-NEXT:    s_mov_b32 s1, 2
; GFX11-NEXT:    s_mov_b32 s0, 1
; GFX11-NEXT:    v_dual_mov_b32 v4, s3 :: v_dual_mov_b32 v3, s2
; GFX11-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX11-NEXT:    scratch_store_b128 v0, v[1:4], off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    scratch_load_b128 v[0:3], v0, off glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; GFX12-LABEL: store_load_v4i32_unaligned:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; GFX12-NEXT:    s_wait_expcnt 0x0
; GFX12-NEXT:    s_wait_samplecnt 0x0
; GFX12-NEXT:    s_wait_bvhcnt 0x0
; GFX12-NEXT:    s_wait_kmcnt 0x0
; GFX12-NEXT:    s_mov_b32 s3, 4
; GFX12-NEXT:    s_mov_b32 s2, 3
; GFX12-NEXT:    s_mov_b32 s1, 2
; GFX12-NEXT:    s_mov_b32 s0, 1
; GFX12-NEXT:    s_wait_alu 0xfffe
; GFX12-NEXT:    v_dual_mov_b32 v4, s3 :: v_dual_mov_b32 v3, s2
; GFX12-NEXT:    v_dual_mov_b32 v2, s1 :: v_dual_mov_b32 v1, s0
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_store_b128 v0, v[1:4], off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    scratch_load_b128 v[0:3], v0, off scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX9-LABEL: store_load_v4i32_unaligned:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v3, 1
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 2
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v2, 2, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v4, 1, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v0, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v3, 0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v6, 4
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v7, 4, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v8, 6, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v10, 8, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v11, 10, v0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v13, 3
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v14, 12, v0
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v15, 14, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v4, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v5, 3, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v2, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v5, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v9, 5, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v7, v1, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v9, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v1, 7, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v8, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v1, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v12, 9, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v10, v13, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v12, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v13, 11, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v11, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v13, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v16, 13, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v14, v6, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v16, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v6, 15, v0
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v15, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_store_byte v6, v3, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v0, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v4, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v2, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v5, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v7, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v9, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v8, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v1, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v10, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v12, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v11, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v13, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v14, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v16, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v3, v15, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr2
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr1
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr9
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr16
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr11
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr4
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr15
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr10
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr7
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr13
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr5
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr14
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr12
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr8
; UNALIGNED_GFX9-NEXT:    ; kill: killed $vgpr0
; UNALIGNED_GFX9-NEXT:    scratch_load_ubyte v0, v6, off glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX10-LABEL: store_load_v4i32_unaligned:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 1
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v2, 2
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v3, 0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v4, 1, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v6, 4, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v0, v1, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v1, 3, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v5, 2, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v7, 5, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v4, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v5, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v1, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v9, 6, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v6, v2, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v7, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v2, 7, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v10, 8, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v11, 3
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v12, 9, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v9, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v13, 10, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v2, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v10, v11, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v12, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v11, 11, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v8, 4
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v14, 12, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v15, 13, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v16, 14, v0
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v17, 15, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v13, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v11, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v14, v8, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v15, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v16, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_store_byte v17, v3, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v0, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v4, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v5, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v1, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v6, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v7, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v9, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v2, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v10, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v12, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v13, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v11, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v14, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v15, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v16, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    scratch_load_ubyte v0, v17, off glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX942-LABEL: store_load_v4i32_unaligned:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v3, 1
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 2
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v2, 2, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v4, 1, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v0, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v3, 0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v6, 4
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v7, 4, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v8, 6, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v10, 8, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v11, 10, v0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v13, 3
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v14, 12, v0
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v15, 14, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v4, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v5, 3, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v2, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v5, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v9, 5, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v7, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v9, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v1, 7, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v8, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v1, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v12, 9, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v10, v13, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v12, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v13, 11, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v11, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v13, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v16, 13, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v14, v6, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v16, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v6, 15, v0
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v15, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_store_byte v6, v3, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v0, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v4, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v2, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v5, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v7, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v9, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v8, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v10, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v12, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v11, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v13, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v14, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v16, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v3, v15, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr2
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr1
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr9
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr16
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr11
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr4
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr15
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr10
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr7
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr13
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr5
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr14
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr12
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr8
; UNALIGNED_GFX942-NEXT:    ; kill: killed $vgpr0
; UNALIGNED_GFX942-NEXT:    scratch_load_ubyte v0, v6, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX11-LABEL: store_load_v4i32_unaligned:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 2
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v3, 0 :: v_dual_add_nc_u32 v4, 1, v0
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v11, 3 :: v_dual_add_nc_u32 v6, 4, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v0, v1, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v1, 3, v0
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v8, 4 :: v_dual_add_nc_u32 v5, 2, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v7, 5, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v4, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v5, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v1, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v9, 6, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v6, v2, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v7, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v2, 7, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v10, 8, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v12, 9, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v9, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v13, 10, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v2, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v10, v11, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v12, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v11, 11, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v14, 12, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v15, 13, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v16, 14, v0
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v17, 15, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v13, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v11, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v14, v8, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v15, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v16, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_store_b8 v17, v3, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v0, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v4, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v5, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v1, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v6, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v7, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v9, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v2, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v10, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v12, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v13, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v11, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v14, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v15, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v16, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    scratch_load_u8 v0, v17, off glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    s_setpc_b64 s[30:31]
;
; UNALIGNED_GFX12-LABEL: store_load_v4i32_unaligned:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt_dscnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_expcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_samplecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_bvhcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_wait_kmcnt 0x0
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v1, 1 :: v_dual_mov_b32 v2, 0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v3, 2
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v1, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:2 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:3 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v3, off offset:4 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v1, 3
; UNALIGNED_GFX12-NEXT:    v_mov_b32_e32 v3, 4
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:5 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:6 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:7 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v1, off offset:8 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:9 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:10 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:11 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v3, off offset:12 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:13 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:14 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_store_b8 v0, v2, off offset:15 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:1 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:2 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:3 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:4 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:5 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:6 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:7 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:8 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:9 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:10 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:11 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:12 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:13 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v1, v0, off offset:14 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    scratch_load_u8 v0, v0, off offset:15 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    s_setpc_b64 s[30:31]
bb:
  store volatile <4 x i32> <i32 1, i32 2, i32 3, i32 4>, ptr addrspace(5) %arg, align 1
  %load = load volatile <4 x i32>, ptr addrspace(5) %arg, align 1
  ret void
}

define amdgpu_gs void @sgpr_base_large_offset(ptr addrspace(1) %out, ptr addrspace(5) inreg %sgpr_base) {
; GFX9-LABEL: sgpr_base_large_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_add_u32 s0, s2, 0xffe8
; GFX9-NEXT:    scratch_load_dword v2, off, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_large_offset:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    s_add_u32 s0, s2, 0xffe8
; GFX10-NEXT:    scratch_load_dword v2, off, s0
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_large_offset:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_add_u32 s0, s0, 0xffe8
; GFX942-NEXT:    scratch_load_dword v2, off, s0
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    global_store_dword v[0:1], v2, off
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_large_offset:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_add_u32 s0, s0, 0xffe8
; GFX11-NEXT:    scratch_load_b32 v2, off, s0
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_large_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    scratch_load_b32 v2, off, s0 offset:65512
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: sgpr_base_large_offset:
; UNALIGNED_GFX9:       ; %bb.0: ; %entry
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; UNALIGNED_GFX9-NEXT:    s_add_u32 s0, s2, 0xffe8
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v2, off, s0
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: sgpr_base_large_offset:
; UNALIGNED_GFX10:       ; %bb.0: ; %entry
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s0, s5
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s1, s1, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s2, 0xffe8
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v2, off, s0
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: sgpr_base_large_offset:
; UNALIGNED_GFX942:       ; %bb.0: ; %entry
; UNALIGNED_GFX942-NEXT:    s_add_u32 s0, s0, 0xffe8
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v2, off, s0
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: sgpr_base_large_offset:
; UNALIGNED_GFX11:       ; %bb.0: ; %entry
; UNALIGNED_GFX11-NEXT:    s_add_u32 s0, s0, 0xffe8
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v2, off, s0
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: sgpr_base_large_offset:
; UNALIGNED_GFX12:       ; %bb.0: ; %entry
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v2, off, s0 offset:65512
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; UNALIGNED_GFX12-NEXT:    s_endpgm
entry:
  %large_offset = getelementptr i8, ptr addrspace(5) %sgpr_base, i32 65512
  %load = load i32, ptr addrspace(5) %large_offset, align 4
  store i32 %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_gs void @sgpr_base_large_offset_split(ptr addrspace(1) %out, ptr addrspace(5) inreg %sgpr_base) {
; GFX9-LABEL: sgpr_base_large_offset_split:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_and_b32 s0, s2, -4
; GFX9-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; GFX9-NEXT:    scratch_load_dword v2, off, s0 glc
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_large_offset_split:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    s_and_b32 s0, s2, -4
; GFX10-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; GFX10-NEXT:    scratch_load_dword v2, off, s0 glc dlc
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_large_offset_split:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_and_b32 s0, s0, -4
; GFX942-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; GFX942-NEXT:    scratch_load_dword v2, off, s0 sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    global_store_dword v[0:1], v2, off
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_large_offset_split:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    s_and_b32 s0, s0, -4
; GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX11-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; GFX11-NEXT:    scratch_load_b32 v2, off, s0 glc dlc
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_large_offset_split:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    s_and_b32 s0, s0, -4
; GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; GFX12-NEXT:    s_add_co_u32 s0, s0, 0x100ffe8
; GFX12-NEXT:    scratch_load_b32 v2, off, s0 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: sgpr_base_large_offset_split:
; UNALIGNED_GFX9:       ; %bb.0: ; %entry
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; UNALIGNED_GFX9-NEXT:    s_and_b32 s0, s2, -4
; UNALIGNED_GFX9-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v2, off, s0 glc
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: sgpr_base_large_offset_split:
; UNALIGNED_GFX10:       ; %bb.0: ; %entry
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s0, s5
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s1, s1, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; UNALIGNED_GFX10-NEXT:    s_and_b32 s0, s2, -4
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v2, off, s0 glc dlc
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: sgpr_base_large_offset_split:
; UNALIGNED_GFX942:       ; %bb.0: ; %entry
; UNALIGNED_GFX942-NEXT:    s_and_b32 s0, s0, -4
; UNALIGNED_GFX942-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v2, off, s0 sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: sgpr_base_large_offset_split:
; UNALIGNED_GFX11:       ; %bb.0: ; %entry
; UNALIGNED_GFX11-NEXT:    s_and_b32 s0, s0, -4
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; UNALIGNED_GFX11-NEXT:    s_add_u32 s0, s0, 0x100ffe8
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v2, off, s0 glc dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: sgpr_base_large_offset_split:
; UNALIGNED_GFX12:       ; %bb.0: ; %entry
; UNALIGNED_GFX12-NEXT:    s_and_b32 s0, s0, -4
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(SALU_CYCLE_1)
; UNALIGNED_GFX12-NEXT:    s_add_co_u32 s0, s0, 0x100ffe8
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v2, off, s0 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; UNALIGNED_GFX12-NEXT:    s_endpgm
entry:
  ;%allignedBase = alloca [33554432 x i8], align 4, addrspace(5)
  %sgpr_base_i32 = ptrtoint ptr addrspace(5) %sgpr_base to i32
  %sgpr_base_i32_align4 = and i32 %sgpr_base_i32, 4294967292
  %sgpr_base_align4 = inttoptr i32 %sgpr_base_i32_align4 to ptr addrspace(5)
  %split_offset = getelementptr inbounds [33554432 x i8], ptr addrspace(5) %sgpr_base_align4, i32 0, i32 16842728
  %load = load volatile i32, ptr addrspace(5) %split_offset, align 4
  store i32 %load, ptr addrspace(1) %out
  ret void
}

define amdgpu_gs void @sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset(ptr addrspace(5) inreg %sgpr_base, i32 inreg %sidx, i32 %vidx) {
; GFX9-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    v_add_u32_e32 v0, s3, v0
; GFX9-NEXT:    v_mov_b32_e32 v1, 0xffe8
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    v_add3_u32 v0, s2, v0, v1
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    scratch_store_dword v0, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_add3_u32 v0, s2, v0, 0xffe8
; GFX10-NEXT:    scratch_store_dword v0, v1, off
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    v_add_u32_e32 v0, s1, v0
; GFX942-NEXT:    v_mov_b32_e32 v1, 0xffe8
; GFX942-NEXT:    v_add3_u32 v0, s0, v0, v1
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add3_u32 v0, s0, v0, 0xffe8
; GFX11-NEXT:    scratch_store_b32 v0, v1, off dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:65512 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s3, v0
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 0xffe8
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; UNALIGNED_GFX9-NEXT:    v_add3_u32 v0, s2, v0, v1
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v0, v1, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s0, s5
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s1, s1, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    v_add3_u32 v0, s2, v0, 0xffe8
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v1, off
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v0, s1, v0
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 0xffe8
; UNALIGNED_GFX942-NEXT:    v_add3_u32 v0, s0, v0, v1
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v0, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; UNALIGNED_GFX11-NEXT:    v_add3_u32 v0, s0, v0, 0xffe8
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v1, off dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_large_imm_offset:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; UNALIGNED_GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:65512 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %add1 = add nsw i32 %sidx, %vidx
  %add2 = add nsw i32 %add1, 65512
  %gep = getelementptr inbounds [33554432 x i8], ptr addrspace(5) %sgpr_base, i32 0, i32 %add2
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_gs void @sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset(ptr addrspace(5) inreg %sgpr_base, i32 inreg %sidx, i32 %vidx) {
; GFX9-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX9:       ; %bb.0: ; %bb
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    v_add_u32_e32 v0, s3, v0
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    v_add3_u32 v0, s2, v0, -16
; GFX9-NEXT:    v_mov_b32_e32 v1, 15
; GFX9-NEXT:    scratch_store_dword v0, v1, off
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX10:       ; %bb.0: ; %bb
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; GFX10-NEXT:    v_mov_b32_e32 v1, 15
; GFX10-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; GFX10-NEXT:    scratch_store_dword v0, v1, off offset:-16
; GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX942:       ; %bb.0: ; %bb
; GFX942-NEXT:    v_add_u32_e32 v0, s1, v0
; GFX942-NEXT:    v_add3_u32 v0, s0, v0, -16
; GFX942-NEXT:    v_mov_b32_e32 v1, 15
; GFX942-NEXT:    scratch_store_dword v0, v1, off sc0 sc1
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX11:       ; %bb.0: ; %bb
; GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:-16 dlc
; GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; GFX12:       ; %bb.0: ; %bb
; GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:-16 scope:SCOPE_SYS
; GFX12-NEXT:    s_wait_storecnt 0x0
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; UNALIGNED_GFX9:       ; %bb.0: ; %bb
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; UNALIGNED_GFX9-NEXT:    v_add_u32_e32 v0, s3, v0
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; UNALIGNED_GFX9-NEXT:    v_add3_u32 v0, s2, v0, -16
; UNALIGNED_GFX9-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX9-NEXT:    scratch_store_dword v0, v1, off
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; UNALIGNED_GFX10:       ; %bb.0: ; %bb
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s0, s5
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s1, s1, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s3, v0
; UNALIGNED_GFX10-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX10-NEXT:    v_add_nc_u32_e32 v0, s2, v0
; UNALIGNED_GFX10-NEXT:    scratch_store_dword v0, v1, off offset:-16
; UNALIGNED_GFX10-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; UNALIGNED_GFX942:       ; %bb.0: ; %bb
; UNALIGNED_GFX942-NEXT:    v_add_u32_e32 v0, s1, v0
; UNALIGNED_GFX942-NEXT:    v_add3_u32 v0, s0, v0, -16
; UNALIGNED_GFX942-NEXT:    v_mov_b32_e32 v1, 15
; UNALIGNED_GFX942-NEXT:    scratch_store_dword v0, v1, off sc0 sc1
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; UNALIGNED_GFX11:       ; %bb.0: ; %bb
; UNALIGNED_GFX11-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; UNALIGNED_GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; UNALIGNED_GFX11-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; UNALIGNED_GFX11-NEXT:    scratch_store_b32 v0, v1, off offset:-16 dlc
; UNALIGNED_GFX11-NEXT:    s_waitcnt_vscnt null, 0x0
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: sgpr_base_plus_sgpr_plus_vgpr_plus_negative_imm_offset:
; UNALIGNED_GFX12:       ; %bb.0: ; %bb
; UNALIGNED_GFX12-NEXT:    v_dual_mov_b32 v1, 15 :: v_dual_add_nc_u32 v0, s1, v0
; UNALIGNED_GFX12-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; UNALIGNED_GFX12-NEXT:    v_add_nc_u32_e32 v0, s0, v0
; UNALIGNED_GFX12-NEXT:    scratch_store_b32 v0, v1, off offset:-16 scope:SCOPE_SYS
; UNALIGNED_GFX12-NEXT:    s_wait_storecnt 0x0
; UNALIGNED_GFX12-NEXT:    s_endpgm
bb:
  %add1 = add nsw i32 %sidx, %vidx
  %add2 = add nsw i32 %add1, -16
  %gep = getelementptr inbounds [16 x i8], ptr addrspace(5) %sgpr_base, i32 0, i32 %add2
  store volatile i32 15, ptr addrspace(5) %gep, align 4
  ret void
}

define amdgpu_gs void @sgpr_base_negative_offset(ptr addrspace(1) %out, ptr addrspace(5) inreg %scevgep) {
; GFX9-LABEL: sgpr_base_negative_offset:
; GFX9:       ; %bb.0: ; %entry
; GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; GFX9-NEXT:    s_add_u32 s0, s2, 0xffffffe8
; GFX9-NEXT:    scratch_load_dword v2, off, s0
; GFX9-NEXT:    s_waitcnt vmcnt(0)
; GFX9-NEXT:    global_store_dword v[0:1], v2, off
; GFX9-NEXT:    s_endpgm
;
; GFX10-LABEL: sgpr_base_negative_offset:
; GFX10:       ; %bb.0: ; %entry
; GFX10-NEXT:    s_add_u32 s0, s0, s5
; GFX10-NEXT:    s_addc_u32 s1, s1, 0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; GFX10-NEXT:    scratch_load_dword v2, off, s2 offset:-24
; GFX10-NEXT:    s_waitcnt vmcnt(0)
; GFX10-NEXT:    global_store_dword v[0:1], v2, off
; GFX10-NEXT:    s_endpgm
;
; GFX942-LABEL: sgpr_base_negative_offset:
; GFX942:       ; %bb.0: ; %entry
; GFX942-NEXT:    s_add_u32 s0, s0, 0xffffffe8
; GFX942-NEXT:    scratch_load_dword v2, off, s0
; GFX942-NEXT:    s_waitcnt vmcnt(0)
; GFX942-NEXT:    global_store_dword v[0:1], v2, off
; GFX942-NEXT:    s_endpgm
;
; GFX11-LABEL: sgpr_base_negative_offset:
; GFX11:       ; %bb.0: ; %entry
; GFX11-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; GFX11-NEXT:    s_waitcnt vmcnt(0)
; GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; GFX11-NEXT:    s_endpgm
;
; GFX12-LABEL: sgpr_base_negative_offset:
; GFX12:       ; %bb.0: ; %entry
; GFX12-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; GFX12-NEXT:    s_wait_loadcnt 0x0
; GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; GFX12-NEXT:    s_endpgm
;
; UNALIGNED_GFX9-LABEL: sgpr_base_negative_offset:
; UNALIGNED_GFX9:       ; %bb.0: ; %entry
; UNALIGNED_GFX9-NEXT:    s_add_u32 flat_scratch_lo, s0, s5
; UNALIGNED_GFX9-NEXT:    s_addc_u32 flat_scratch_hi, s1, 0
; UNALIGNED_GFX9-NEXT:    s_add_u32 s0, s2, 0xffffffe8
; UNALIGNED_GFX9-NEXT:    scratch_load_dword v2, off, s0
; UNALIGNED_GFX9-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX9-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX9-NEXT:    s_endpgm
;
; UNALIGNED_GFX10-LABEL: sgpr_base_negative_offset:
; UNALIGNED_GFX10:       ; %bb.0: ; %entry
; UNALIGNED_GFX10-NEXT:    s_add_u32 s0, s0, s5
; UNALIGNED_GFX10-NEXT:    s_addc_u32 s1, s1, 0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_LO), s0
; UNALIGNED_GFX10-NEXT:    s_setreg_b32 hwreg(HW_REG_FLAT_SCR_HI), s1
; UNALIGNED_GFX10-NEXT:    scratch_load_dword v2, off, s2 offset:-24
; UNALIGNED_GFX10-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX10-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX10-NEXT:    s_endpgm
;
; UNALIGNED_GFX942-LABEL: sgpr_base_negative_offset:
; UNALIGNED_GFX942:       ; %bb.0: ; %entry
; UNALIGNED_GFX942-NEXT:    s_add_u32 s0, s0, 0xffffffe8
; UNALIGNED_GFX942-NEXT:    scratch_load_dword v2, off, s0
; UNALIGNED_GFX942-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX942-NEXT:    global_store_dword v[0:1], v2, off
; UNALIGNED_GFX942-NEXT:    s_endpgm
;
; UNALIGNED_GFX11-LABEL: sgpr_base_negative_offset:
; UNALIGNED_GFX11:       ; %bb.0: ; %entry
; UNALIGNED_GFX11-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; UNALIGNED_GFX11-NEXT:    s_waitcnt vmcnt(0)
; UNALIGNED_GFX11-NEXT:    global_store_b32 v[0:1], v2, off
; UNALIGNED_GFX11-NEXT:    s_endpgm
;
; UNALIGNED_GFX12-LABEL: sgpr_base_negative_offset:
; UNALIGNED_GFX12:       ; %bb.0: ; %entry
; UNALIGNED_GFX12-NEXT:    scratch_load_b32 v2, off, s0 offset:-24
; UNALIGNED_GFX12-NEXT:    s_wait_loadcnt 0x0
; UNALIGNED_GFX12-NEXT:    global_store_b32 v[0:1], v2, off
; UNALIGNED_GFX12-NEXT:    s_endpgm
entry:
  %scevgep28 = getelementptr i8, ptr addrspace(5) %scevgep, i32 -24
  %0 = load i32, ptr addrspace(5) %scevgep28, align 4
  store i32 %0, ptr addrspace(1) %out
  ret void
}

declare i32 @llvm.amdgcn.workitem.id.x()
