
# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -mtriple=riscv64 -mcpu=sifive-p470 -iterations=1 < %s | FileCheck %s

# SEW is only e32 or e64

vsetvli zero, zero, e32, m1, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e32, m2, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e32, m4, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e32, m8, tu, mu
vsha2ms.vv v8, v16, v24
vsha2ch.vv v8, v16, v24
vsha2cl.vv v8, v16, v24

vsetvli zero, zero, e64, m1, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e64, m2, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e64, m4, tu, mu
vsha2ms.vv v4, v8, v12
vsha2ch.vv v4, v8, v12
vsha2cl.vv v4, v8, v12

vsetvli zero, zero, e64, m8, tu, mu
vsha2ms.vv v8, v16, v24
vsha2ch.vv v8, v16, v24
vsha2cl.vv v8, v16, v24

# CHECK:      Iterations:        1
# CHECK-NEXT: Instructions:      32
# CHECK-NEXT: Total Cycles:      102
# CHECK-NEXT: Total uOps:        32

# CHECK:      Dispatch Width:    3
# CHECK-NEXT: uOps Per Cycle:    0.31
# CHECK-NEXT: IPC:               0.31
# CHECK-NEXT: Block RThroughput: 90.0

# CHECK:      Instruction Info:
# CHECK-NEXT: [1]: #uOps
# CHECK-NEXT: [2]: Latency
# CHECK-NEXT: [3]: RThroughput
# CHECK-NEXT: [4]: MayLoad
# CHECK-NEXT: [5]: MayStore
# CHECK-NEXT: [6]: HasSideEffects (U)

# CHECK:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  1      3     1.00                        vsha2ms.vv  v4, v8, v12
# CHECK-NEXT:  1      3     1.00                        vsha2ch.vv  v4, v8, v12
# CHECK-NEXT:  1      3     1.00                        vsha2cl.vv  v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  1      3     2.00                        vsha2ms.vv  v4, v8, v12
# CHECK-NEXT:  1      3     2.00                        vsha2ch.vv  v4, v8, v12
# CHECK-NEXT:  1      3     2.00                        vsha2cl.vv  v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  1      3     4.00                        vsha2ms.vv  v4, v8, v12
# CHECK-NEXT:  1      3     4.00                        vsha2ch.vv  v4, v8, v12
# CHECK-NEXT:  1      3     4.00                        vsha2cl.vv  v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  1      3     8.00                        vsha2ms.vv  v8, v16, v24
# CHECK-NEXT:  1      3     8.00                        vsha2ch.vv  v8, v16, v24
# CHECK-NEXT:  1      3     8.00                        vsha2cl.vv  v8, v16, v24
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  1      3     1.00                        vsha2ms.vv  v4, v8, v12
# CHECK-NEXT:  1      3     1.00                        vsha2ch.vv  v4, v8, v12
# CHECK-NEXT:  1      3     1.00                        vsha2cl.vv  v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  1      3     2.00                        vsha2ms.vv  v4, v8, v12
# CHECK-NEXT:  1      3     2.00                        vsha2ch.vv  v4, v8, v12
# CHECK-NEXT:  1      3     2.00                        vsha2cl.vv  v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  1      3     4.00                        vsha2ms.vv  v4, v8, v12
# CHECK-NEXT:  1      3     4.00                        vsha2ch.vv  v4, v8, v12
# CHECK-NEXT:  1      3     4.00                        vsha2cl.vv  v4, v8, v12
# CHECK-NEXT:  1      1     1.00                  U     vsetvli zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  1      3     8.00                        vsha2ms.vv  v8, v16, v24
# CHECK-NEXT:  1      3     8.00                        vsha2ch.vv  v8, v16, v24
# CHECK-NEXT:  1      3     8.00                        vsha2cl.vv  v8, v16, v24

# CHECK:      Resources:
# CHECK-NEXT: [0]   - SiFiveP400Div
# CHECK-NEXT: [1]   - SiFiveP400FEXQ0
# CHECK-NEXT: [2]   - SiFiveP400FloatDiv
# CHECK-NEXT: [3]   - SiFiveP400IEXQ0
# CHECK-NEXT: [4]   - SiFiveP400IEXQ1
# CHECK-NEXT: [5]   - SiFiveP400IEXQ2
# CHECK-NEXT: [6]   - SiFiveP400Load
# CHECK-NEXT: [7]   - SiFiveP400Store
# CHECK-NEXT: [8]   - SiFiveP400VDiv
# CHECK-NEXT: [9]   - SiFiveP400VEXQ0
# CHECK-NEXT: [10]  - SiFiveP400VFloatDiv
# CHECK-NEXT: [11]  - SiFiveP400VLD
# CHECK-NEXT: [12]  - SiFiveP400VST

# CHECK:      Resource pressure per iteration:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]
# CHECK-NEXT:  -      -      -      -     8.00    -      -      -      -     90.00   -      -      -

# CHECK:      Resource pressure by instruction:
# CHECK-NEXT: [0]    [1]    [2]    [3]    [4]    [5]    [6]    [7]    [8]    [9]    [10]   [11]   [12]   Instructions:
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vsha2ms.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vsha2ch.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vsha2cl.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vsha2ms.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vsha2ch.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vsha2cl.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vsha2ms.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vsha2ch.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vsha2cl.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e32, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vsha2ms.vv v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vsha2ch.vv v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vsha2cl.vv v8, v16, v24
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m1, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vsha2ms.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vsha2ch.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     1.00    -      -      -     vsha2cl.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m2, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vsha2ms.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vsha2ch.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     2.00    -      -      -     vsha2cl.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m4, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vsha2ms.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vsha2ch.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     4.00    -      -      -     vsha2cl.vv v4, v8, v12
# CHECK-NEXT:  -      -      -      -     1.00    -      -      -      -      -      -      -      -     vsetvli  zero, zero, e64, m8, tu, mu
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vsha2ms.vv v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vsha2ch.vv v8, v16, v24
# CHECK-NEXT:  -      -      -      -      -      -      -      -      -     8.00    -      -      -     vsha2cl.vv v8, v16, v24

