; NOTE: Assertions have been autogenerated by utils/update_test_checks.py UTC_ARGS: --version 5
; RUN: opt -passes=instcombine -S %s | FileCheck %s

define i8 @select_icmp_eq_pow2(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_eq_pow2(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = and i8 [[X]], -5
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %and = and i8 %x, 4
  %icmp = icmp eq i8 %and, 0
  %xor = xor i8 %x, 4
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_eq_pow2_flipped(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_eq_pow2_flipped(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = or i8 [[X]], 4
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %and = and i8 %x, 4
  %icmp = icmp eq i8 %and, 0
  %xor = xor i8 %x, 4
  %sel = select i1 %icmp, i8 %xor, i8 %x
  ret i8 %sel
}

define i8 @select_icmp_eq_not_pow2(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_eq_not_pow2(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], 5
; CHECK-NEXT:    [[ICMP:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[X]], 5
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[ICMP]], i8 [[X]], i8 [[XOR]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %and = and i8 %x, 5
  %icmp = icmp eq i8 %and, 0
  %xor = xor i8 %x, 5
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_ne_pow2(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_ne_pow2(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = and i8 [[X]], -5
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %and = and i8 %x, 4
  %icmp = icmp ne i8 %and, 0
  %xor = xor i8 %x, 4
  %sel = select i1 %icmp, i8 %xor, i8 %x
  ret i8 %sel
}

define i8 @select_icmp_ne_pow2_flipped(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_ne_pow2_flipped(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = or i8 [[X]], 4
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %and = and i8 %x, 4
  %icmp = icmp ne i8 %and, 0
  %xor = xor i8 %x, 4
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_ne_not_pow2(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_ne_not_pow2(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[AND:%.*]] = and i8 [[X]], 5
; CHECK-NEXT:    [[ICMP_NOT:%.*]] = icmp eq i8 [[AND]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[X]], 5
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[ICMP_NOT]], i8 [[X]], i8 [[XOR]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %and = and i8 %x, 5
  %icmp = icmp ne i8 %and, 0
  %xor = xor i8 %x, 5
  %sel = select i1 %icmp, i8 %xor, i8 %x
  ret i8 %sel
}

define i8 @select_icmp_slt_zero_smin(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_slt_zero_smin(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = or i8 [[X]], -128
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp slt i8 %x, 0
  %xor = xor i8 %x, -128
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_slt_zero_smin_flipped(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_slt_zero_smin_flipped(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = and i8 [[X]], 127
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp slt i8 %x, 0
  %xor = xor i8 %x, -128
  %sel = select i1 %icmp, i8 %xor, i8 %x
  ret i8 %sel
}

define i8 @select_icmp_slt_not_zero(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_slt_not_zero(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[ICMP:%.*]] = icmp slt i8 [[X]], 1
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[X]], -128
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[ICMP]], i8 [[X]], i8 [[XOR]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp slt i8 %x, 1
  %xor = xor i8 %x, -128
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_slt_not_smin(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_slt_not_smin(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[ICMP:%.*]] = icmp slt i8 [[X]], 0
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[X]], -127
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[ICMP]], i8 [[X]], i8 [[XOR]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp slt i8 %x, 0
  %xor = xor i8 %x, -127
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_sgt_allones_smin(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_sgt_allones_smin(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = and i8 [[X]], 127
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp sgt i8 %x, 255
  %xor = xor i8 %x, -128
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_sgt_allones_smin_flipped(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_sgt_allones_smin_flipped(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[SEL:%.*]] = or i8 [[X]], -128
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp sgt i8 %x, 255
  %xor = xor i8 %x, -128
  %sel = select i1 %icmp, i8 %xor, i8 %x
  ret i8 %sel
}

define i8 @select_icmp_sgt_not_allones(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_sgt_not_allones(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[ICMP:%.*]] = icmp sgt i8 [[X]], -2
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[X]], -128
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[ICMP]], i8 [[X]], i8 [[XOR]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp sgt i8 %x, 254
  %xor = xor i8 %x, -128
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}

define i8 @select_icmp_sgt_not_smin(i8 %x) {
; CHECK-LABEL: define i8 @select_icmp_sgt_not_smin(
; CHECK-SAME: i8 [[X:%.*]]) {
; CHECK-NEXT:    [[XOR:%.*]] = xor i8 [[X]], -127
; CHECK-NEXT:    [[ICMP1:%.*]] = icmp slt i8 [[X]], 0
; CHECK-NEXT:    [[SEL:%.*]] = select i1 [[ICMP1]], i8 [[XOR]], i8 [[X]]
; CHECK-NEXT:    ret i8 [[SEL]]
;
  %icmp = icmp sgt i8 %x, 255
  %xor = xor i8 %x, -127
  %sel = select i1 %icmp, i8 %x, i8 %xor
  ret i8 %sel
}
