#define VK_ENABLE_BETA_EXTENSIONS
#include "vulkan/utils.h"

const char *vk_driver_id_name(VkDriverId driver)
{
    switch (driver) {
    case VK_DRIVER_ID_AMD_PROPRIETARY: return "VK_DRIVER_ID_AMD_PROPRIETARY";
    case VK_DRIVER_ID_AMD_OPEN_SOURCE: return "VK_DRIVER_ID_AMD_OPEN_SOURCE";
    case VK_DRIVER_ID_MESA_RADV: return "VK_DRIVER_ID_MESA_RADV";
    case VK_DRIVER_ID_NVIDIA_PROPRIETARY: return "VK_DRIVER_ID_NVIDIA_PROPRIETARY";
    case VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS: return "VK_DRIVER_ID_INTEL_PROPRIETARY_WINDOWS";
    case VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA: return "VK_DRIVER_ID_INTEL_OPEN_SOURCE_MESA";
    case VK_DRIVER_ID_IMAGINATION_PROPRIETARY: return "VK_DRIVER_ID_IMAGINATION_PROPRIETARY";
    case VK_DRIVER_ID_QUALCOMM_PROPRIETARY: return "VK_DRIVER_ID_QUALCOMM_PROPRIETARY";
    case VK_DRIVER_ID_ARM_PROPRIETARY: return "VK_DRIVER_ID_ARM_PROPRIETARY";
    case VK_DRIVER_ID_GOOGLE_SWIFTSHADER: return "VK_DRIVER_ID_GOOGLE_SWIFTSHADER";
    case VK_DRIVER_ID_GGP_PROPRIETARY: return "VK_DRIVER_ID_GGP_PROPRIETARY";
    case VK_DRIVER_ID_BROADCOM_PROPRIETARY: return "VK_DRIVER_ID_BROADCOM_PROPRIETARY";
    case VK_DRIVER_ID_MESA_LLVMPIPE: return "VK_DRIVER_ID_MESA_LLVMPIPE";
    case VK_DRIVER_ID_MOLTENVK: return "VK_DRIVER_ID_MOLTENVK";
    case VK_DRIVER_ID_COREAVI_PROPRIETARY: return "VK_DRIVER_ID_COREAVI_PROPRIETARY";
    case VK_DRIVER_ID_JUICE_PROPRIETARY: return "VK_DRIVER_ID_JUICE_PROPRIETARY";
    case VK_DRIVER_ID_VERISILICON_PROPRIETARY: return "VK_DRIVER_ID_VERISILICON_PROPRIETARY";
    case VK_DRIVER_ID_MESA_TURNIP: return "VK_DRIVER_ID_MESA_TURNIP";
    case VK_DRIVER_ID_MESA_V3DV: return "VK_DRIVER_ID_MESA_V3DV";
    case VK_DRIVER_ID_MESA_PANVK: return "VK_DRIVER_ID_MESA_PANVK";
    case VK_DRIVER_ID_SAMSUNG_PROPRIETARY: return "VK_DRIVER_ID_SAMSUNG_PROPRIETARY";
    case VK_DRIVER_ID_MESA_VENUS: return "VK_DRIVER_ID_MESA_VENUS";
    case VK_DRIVER_ID_MESA_DOZEN: return "VK_DRIVER_ID_MESA_DOZEN";
    case VK_DRIVER_ID_MESA_NVK: return "VK_DRIVER_ID_MESA_NVK";
    case VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA: return "VK_DRIVER_ID_IMAGINATION_OPEN_SOURCE_MESA";
    case VK_DRIVER_ID_MESA_HONEYKRISP: return "VK_DRIVER_ID_MESA_HONEYKRISP";
    case VK_DRIVER_ID_VULKAN_SC_EMULATION_ON_VULKAN: return "VK_DRIVER_ID_VULKAN_SC_EMULATION_ON_VULKAN";

    default: return "unknown driver";
    }
}

const char *vk_res_str(VkResult res)
{
    switch (res) {
    case VK_SUCCESS: return "VK_SUCCESS";
    case VK_NOT_READY: return "VK_NOT_READY";
    case VK_TIMEOUT: return "VK_TIMEOUT";
    case VK_EVENT_SET: return "VK_EVENT_SET";
    case VK_EVENT_RESET: return "VK_EVENT_RESET";
    case VK_INCOMPLETE: return "VK_INCOMPLETE";
    case VK_ERROR_OUT_OF_HOST_MEMORY: return "VK_ERROR_OUT_OF_HOST_MEMORY";
    case VK_ERROR_OUT_OF_DEVICE_MEMORY: return "VK_ERROR_OUT_OF_DEVICE_MEMORY";
    case VK_ERROR_INITIALIZATION_FAILED: return "VK_ERROR_INITIALIZATION_FAILED";
    case VK_ERROR_DEVICE_LOST: return "VK_ERROR_DEVICE_LOST";
    case VK_ERROR_MEMORY_MAP_FAILED: return "VK_ERROR_MEMORY_MAP_FAILED";
    case VK_ERROR_LAYER_NOT_PRESENT: return "VK_ERROR_LAYER_NOT_PRESENT";
    case VK_ERROR_EXTENSION_NOT_PRESENT: return "VK_ERROR_EXTENSION_NOT_PRESENT";
    case VK_ERROR_FEATURE_NOT_PRESENT: return "VK_ERROR_FEATURE_NOT_PRESENT";
    case VK_ERROR_INCOMPATIBLE_DRIVER: return "VK_ERROR_INCOMPATIBLE_DRIVER";
    case VK_ERROR_TOO_MANY_OBJECTS: return "VK_ERROR_TOO_MANY_OBJECTS";
    case VK_ERROR_FORMAT_NOT_SUPPORTED: return "VK_ERROR_FORMAT_NOT_SUPPORTED";
    case VK_ERROR_FRAGMENTED_POOL: return "VK_ERROR_FRAGMENTED_POOL";
    case VK_ERROR_UNKNOWN: return "VK_ERROR_UNKNOWN";
    case VK_ERROR_OUT_OF_POOL_MEMORY: return "VK_ERROR_OUT_OF_POOL_MEMORY";
    case VK_ERROR_INVALID_EXTERNAL_HANDLE: return "VK_ERROR_INVALID_EXTERNAL_HANDLE";
    case VK_ERROR_FRAGMENTATION: return "VK_ERROR_FRAGMENTATION";
    case VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS: return "VK_ERROR_INVALID_OPAQUE_CAPTURE_ADDRESS";
    case VK_PIPELINE_COMPILE_REQUIRED: return "VK_PIPELINE_COMPILE_REQUIRED";
    case VK_ERROR_NOT_PERMITTED: return "VK_ERROR_NOT_PERMITTED";
    case VK_ERROR_SURFACE_LOST_KHR: return "VK_ERROR_SURFACE_LOST_KHR";
    case VK_ERROR_NATIVE_WINDOW_IN_USE_KHR: return "VK_ERROR_NATIVE_WINDOW_IN_USE_KHR";
    case VK_SUBOPTIMAL_KHR: return "VK_SUBOPTIMAL_KHR";
    case VK_ERROR_OUT_OF_DATE_KHR: return "VK_ERROR_OUT_OF_DATE_KHR";
    case VK_ERROR_INCOMPATIBLE_DISPLAY_KHR: return "VK_ERROR_INCOMPATIBLE_DISPLAY_KHR";
    case VK_ERROR_VALIDATION_FAILED_EXT: return "VK_ERROR_VALIDATION_FAILED_EXT";
    case VK_ERROR_INVALID_SHADER_NV: return "VK_ERROR_INVALID_SHADER_NV";
    case VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR: return "VK_ERROR_IMAGE_USAGE_NOT_SUPPORTED_KHR";
    case VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR: return "VK_ERROR_VIDEO_PICTURE_LAYOUT_NOT_SUPPORTED_KHR";
    case VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR: return "VK_ERROR_VIDEO_PROFILE_OPERATION_NOT_SUPPORTED_KHR";
    case VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR: return "VK_ERROR_VIDEO_PROFILE_FORMAT_NOT_SUPPORTED_KHR";
    case VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR: return "VK_ERROR_VIDEO_PROFILE_CODEC_NOT_SUPPORTED_KHR";
    case VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR: return "VK_ERROR_VIDEO_STD_VERSION_NOT_SUPPORTED_KHR";
    case VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT: return "VK_ERROR_INVALID_DRM_FORMAT_MODIFIER_PLANE_LAYOUT_EXT";
    case VK_THREAD_IDLE_KHR: return "VK_THREAD_IDLE_KHR";
    case VK_THREAD_DONE_KHR: return "VK_THREAD_DONE_KHR";
    case VK_OPERATION_DEFERRED_KHR: return "VK_OPERATION_DEFERRED_KHR";
    case VK_OPERATION_NOT_DEFERRED_KHR: return "VK_OPERATION_NOT_DEFERRED_KHR";
    case VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR: return "VK_ERROR_INVALID_VIDEO_STD_PARAMETERS_KHR";
    case VK_ERROR_COMPRESSION_EXHAUSTED_EXT: return "VK_ERROR_COMPRESSION_EXHAUSTED_EXT";
    case VK_INCOMPATIBLE_SHADER_BINARY_EXT: return "VK_INCOMPATIBLE_SHADER_BINARY_EXT";
    case VK_PIPELINE_BINARY_MISSING_KHR: return "VK_PIPELINE_BINARY_MISSING_KHR";
    case VK_ERROR_NOT_ENOUGH_SPACE_KHR: return "VK_ERROR_NOT_ENOUGH_SPACE_KHR";

    default: return "unknown error";
    }
}

const char *vk_fmt_name(VkFormat fmt)
{
    switch (fmt) {
    case VK_FORMAT_UNDEFINED: return "VK_FORMAT_UNDEFINED";
    case VK_FORMAT_R4G4_UNORM_PACK8: return "VK_FORMAT_R4G4_UNORM_PACK8";
    case VK_FORMAT_R4G4B4A4_UNORM_PACK16: return "VK_FORMAT_R4G4B4A4_UNORM_PACK16";
    case VK_FORMAT_B4G4R4A4_UNORM_PACK16: return "VK_FORMAT_B4G4R4A4_UNORM_PACK16";
    case VK_FORMAT_R5G6B5_UNORM_PACK16: return "VK_FORMAT_R5G6B5_UNORM_PACK16";
    case VK_FORMAT_B5G6R5_UNORM_PACK16: return "VK_FORMAT_B5G6R5_UNORM_PACK16";
    case VK_FORMAT_R5G5B5A1_UNORM_PACK16: return "VK_FORMAT_R5G5B5A1_UNORM_PACK16";
    case VK_FORMAT_B5G5R5A1_UNORM_PACK16: return "VK_FORMAT_B5G5R5A1_UNORM_PACK16";
    case VK_FORMAT_A1R5G5B5_UNORM_PACK16: return "VK_FORMAT_A1R5G5B5_UNORM_PACK16";
    case VK_FORMAT_R8_UNORM: return "VK_FORMAT_R8_UNORM";
    case VK_FORMAT_R8_SNORM: return "VK_FORMAT_R8_SNORM";
    case VK_FORMAT_R8_USCALED: return "VK_FORMAT_R8_USCALED";
    case VK_FORMAT_R8_SSCALED: return "VK_FORMAT_R8_SSCALED";
    case VK_FORMAT_R8_UINT: return "VK_FORMAT_R8_UINT";
    case VK_FORMAT_R8_SINT: return "VK_FORMAT_R8_SINT";
    case VK_FORMAT_R8_SRGB: return "VK_FORMAT_R8_SRGB";
    case VK_FORMAT_R8G8_UNORM: return "VK_FORMAT_R8G8_UNORM";
    case VK_FORMAT_R8G8_SNORM: return "VK_FORMAT_R8G8_SNORM";
    case VK_FORMAT_R8G8_USCALED: return "VK_FORMAT_R8G8_USCALED";
    case VK_FORMAT_R8G8_SSCALED: return "VK_FORMAT_R8G8_SSCALED";
    case VK_FORMAT_R8G8_UINT: return "VK_FORMAT_R8G8_UINT";
    case VK_FORMAT_R8G8_SINT: return "VK_FORMAT_R8G8_SINT";
    case VK_FORMAT_R8G8_SRGB: return "VK_FORMAT_R8G8_SRGB";
    case VK_FORMAT_R8G8B8_UNORM: return "VK_FORMAT_R8G8B8_UNORM";
    case VK_FORMAT_R8G8B8_SNORM: return "VK_FORMAT_R8G8B8_SNORM";
    case VK_FORMAT_R8G8B8_USCALED: return "VK_FORMAT_R8G8B8_USCALED";
    case VK_FORMAT_R8G8B8_SSCALED: return "VK_FORMAT_R8G8B8_SSCALED";
    case VK_FORMAT_R8G8B8_UINT: return "VK_FORMAT_R8G8B8_UINT";
    case VK_FORMAT_R8G8B8_SINT: return "VK_FORMAT_R8G8B8_SINT";
    case VK_FORMAT_R8G8B8_SRGB: return "VK_FORMAT_R8G8B8_SRGB";
    case VK_FORMAT_B8G8R8_UNORM: return "VK_FORMAT_B8G8R8_UNORM";
    case VK_FORMAT_B8G8R8_SNORM: return "VK_FORMAT_B8G8R8_SNORM";
    case VK_FORMAT_B8G8R8_USCALED: return "VK_FORMAT_B8G8R8_USCALED";
    case VK_FORMAT_B8G8R8_SSCALED: return "VK_FORMAT_B8G8R8_SSCALED";
    case VK_FORMAT_B8G8R8_UINT: return "VK_FORMAT_B8G8R8_UINT";
    case VK_FORMAT_B8G8R8_SINT: return "VK_FORMAT_B8G8R8_SINT";
    case VK_FORMAT_B8G8R8_SRGB: return "VK_FORMAT_B8G8R8_SRGB";
    case VK_FORMAT_R8G8B8A8_UNORM: return "VK_FORMAT_R8G8B8A8_UNORM";
    case VK_FORMAT_R8G8B8A8_SNORM: return "VK_FORMAT_R8G8B8A8_SNORM";
    case VK_FORMAT_R8G8B8A8_USCALED: return "VK_FORMAT_R8G8B8A8_USCALED";
    case VK_FORMAT_R8G8B8A8_SSCALED: return "VK_FORMAT_R8G8B8A8_SSCALED";
    case VK_FORMAT_R8G8B8A8_UINT: return "VK_FORMAT_R8G8B8A8_UINT";
    case VK_FORMAT_R8G8B8A8_SINT: return "VK_FORMAT_R8G8B8A8_SINT";
    case VK_FORMAT_R8G8B8A8_SRGB: return "VK_FORMAT_R8G8B8A8_SRGB";
    case VK_FORMAT_B8G8R8A8_UNORM: return "VK_FORMAT_B8G8R8A8_UNORM";
    case VK_FORMAT_B8G8R8A8_SNORM: return "VK_FORMAT_B8G8R8A8_SNORM";
    case VK_FORMAT_B8G8R8A8_USCALED: return "VK_FORMAT_B8G8R8A8_USCALED";
    case VK_FORMAT_B8G8R8A8_SSCALED: return "VK_FORMAT_B8G8R8A8_SSCALED";
    case VK_FORMAT_B8G8R8A8_UINT: return "VK_FORMAT_B8G8R8A8_UINT";
    case VK_FORMAT_B8G8R8A8_SINT: return "VK_FORMAT_B8G8R8A8_SINT";
    case VK_FORMAT_B8G8R8A8_SRGB: return "VK_FORMAT_B8G8R8A8_SRGB";
    case VK_FORMAT_A8B8G8R8_UNORM_PACK32: return "VK_FORMAT_A8B8G8R8_UNORM_PACK32";
    case VK_FORMAT_A8B8G8R8_SNORM_PACK32: return "VK_FORMAT_A8B8G8R8_SNORM_PACK32";
    case VK_FORMAT_A8B8G8R8_USCALED_PACK32: return "VK_FORMAT_A8B8G8R8_USCALED_PACK32";
    case VK_FORMAT_A8B8G8R8_SSCALED_PACK32: return "VK_FORMAT_A8B8G8R8_SSCALED_PACK32";
    case VK_FORMAT_A8B8G8R8_UINT_PACK32: return "VK_FORMAT_A8B8G8R8_UINT_PACK32";
    case VK_FORMAT_A8B8G8R8_SINT_PACK32: return "VK_FORMAT_A8B8G8R8_SINT_PACK32";
    case VK_FORMAT_A8B8G8R8_SRGB_PACK32: return "VK_FORMAT_A8B8G8R8_SRGB_PACK32";
    case VK_FORMAT_A2R10G10B10_UNORM_PACK32: return "VK_FORMAT_A2R10G10B10_UNORM_PACK32";
    case VK_FORMAT_A2R10G10B10_SNORM_PACK32: return "VK_FORMAT_A2R10G10B10_SNORM_PACK32";
    case VK_FORMAT_A2R10G10B10_USCALED_PACK32: return "VK_FORMAT_A2R10G10B10_USCALED_PACK32";
    case VK_FORMAT_A2R10G10B10_SSCALED_PACK32: return "VK_FORMAT_A2R10G10B10_SSCALED_PACK32";
    case VK_FORMAT_A2R10G10B10_UINT_PACK32: return "VK_FORMAT_A2R10G10B10_UINT_PACK32";
    case VK_FORMAT_A2R10G10B10_SINT_PACK32: return "VK_FORMAT_A2R10G10B10_SINT_PACK32";
    case VK_FORMAT_A2B10G10R10_UNORM_PACK32: return "VK_FORMAT_A2B10G10R10_UNORM_PACK32";
    case VK_FORMAT_A2B10G10R10_SNORM_PACK32: return "VK_FORMAT_A2B10G10R10_SNORM_PACK32";
    case VK_FORMAT_A2B10G10R10_USCALED_PACK32: return "VK_FORMAT_A2B10G10R10_USCALED_PACK32";
    case VK_FORMAT_A2B10G10R10_SSCALED_PACK32: return "VK_FORMAT_A2B10G10R10_SSCALED_PACK32";
    case VK_FORMAT_A2B10G10R10_UINT_PACK32: return "VK_FORMAT_A2B10G10R10_UINT_PACK32";
    case VK_FORMAT_A2B10G10R10_SINT_PACK32: return "VK_FORMAT_A2B10G10R10_SINT_PACK32";
    case VK_FORMAT_R16_UNORM: return "VK_FORMAT_R16_UNORM";
    case VK_FORMAT_R16_SNORM: return "VK_FORMAT_R16_SNORM";
    case VK_FORMAT_R16_USCALED: return "VK_FORMAT_R16_USCALED";
    case VK_FORMAT_R16_SSCALED: return "VK_FORMAT_R16_SSCALED";
    case VK_FORMAT_R16_UINT: return "VK_FORMAT_R16_UINT";
    case VK_FORMAT_R16_SINT: return "VK_FORMAT_R16_SINT";
    case VK_FORMAT_R16_SFLOAT: return "VK_FORMAT_R16_SFLOAT";
    case VK_FORMAT_R16G16_UNORM: return "VK_FORMAT_R16G16_UNORM";
    case VK_FORMAT_R16G16_SNORM: return "VK_FORMAT_R16G16_SNORM";
    case VK_FORMAT_R16G16_USCALED: return "VK_FORMAT_R16G16_USCALED";
    case VK_FORMAT_R16G16_SSCALED: return "VK_FORMAT_R16G16_SSCALED";
    case VK_FORMAT_R16G16_UINT: return "VK_FORMAT_R16G16_UINT";
    case VK_FORMAT_R16G16_SINT: return "VK_FORMAT_R16G16_SINT";
    case VK_FORMAT_R16G16_SFLOAT: return "VK_FORMAT_R16G16_SFLOAT";
    case VK_FORMAT_R16G16B16_UNORM: return "VK_FORMAT_R16G16B16_UNORM";
    case VK_FORMAT_R16G16B16_SNORM: return "VK_FORMAT_R16G16B16_SNORM";
    case VK_FORMAT_R16G16B16_USCALED: return "VK_FORMAT_R16G16B16_USCALED";
    case VK_FORMAT_R16G16B16_SSCALED: return "VK_FORMAT_R16G16B16_SSCALED";
    case VK_FORMAT_R16G16B16_UINT: return "VK_FORMAT_R16G16B16_UINT";
    case VK_FORMAT_R16G16B16_SINT: return "VK_FORMAT_R16G16B16_SINT";
    case VK_FORMAT_R16G16B16_SFLOAT: return "VK_FORMAT_R16G16B16_SFLOAT";
    case VK_FORMAT_R16G16B16A16_UNORM: return "VK_FORMAT_R16G16B16A16_UNORM";
    case VK_FORMAT_R16G16B16A16_SNORM: return "VK_FORMAT_R16G16B16A16_SNORM";
    case VK_FORMAT_R16G16B16A16_USCALED: return "VK_FORMAT_R16G16B16A16_USCALED";
    case VK_FORMAT_R16G16B16A16_SSCALED: return "VK_FORMAT_R16G16B16A16_SSCALED";
    case VK_FORMAT_R16G16B16A16_UINT: return "VK_FORMAT_R16G16B16A16_UINT";
    case VK_FORMAT_R16G16B16A16_SINT: return "VK_FORMAT_R16G16B16A16_SINT";
    case VK_FORMAT_R16G16B16A16_SFLOAT: return "VK_FORMAT_R16G16B16A16_SFLOAT";
    case VK_FORMAT_R32_UINT: return "VK_FORMAT_R32_UINT";
    case VK_FORMAT_R32_SINT: return "VK_FORMAT_R32_SINT";
    case VK_FORMAT_R32_SFLOAT: return "VK_FORMAT_R32_SFLOAT";
    case VK_FORMAT_R32G32_UINT: return "VK_FORMAT_R32G32_UINT";
    case VK_FORMAT_R32G32_SINT: return "VK_FORMAT_R32G32_SINT";
    case VK_FORMAT_R32G32_SFLOAT: return "VK_FORMAT_R32G32_SFLOAT";
    case VK_FORMAT_R32G32B32_UINT: return "VK_FORMAT_R32G32B32_UINT";
    case VK_FORMAT_R32G32B32_SINT: return "VK_FORMAT_R32G32B32_SINT";
    case VK_FORMAT_R32G32B32_SFLOAT: return "VK_FORMAT_R32G32B32_SFLOAT";
    case VK_FORMAT_R32G32B32A32_UINT: return "VK_FORMAT_R32G32B32A32_UINT";
    case VK_FORMAT_R32G32B32A32_SINT: return "VK_FORMAT_R32G32B32A32_SINT";
    case VK_FORMAT_R32G32B32A32_SFLOAT: return "VK_FORMAT_R32G32B32A32_SFLOAT";
    case VK_FORMAT_R64_UINT: return "VK_FORMAT_R64_UINT";
    case VK_FORMAT_R64_SINT: return "VK_FORMAT_R64_SINT";
    case VK_FORMAT_R64_SFLOAT: return "VK_FORMAT_R64_SFLOAT";
    case VK_FORMAT_R64G64_UINT: return "VK_FORMAT_R64G64_UINT";
    case VK_FORMAT_R64G64_SINT: return "VK_FORMAT_R64G64_SINT";
    case VK_FORMAT_R64G64_SFLOAT: return "VK_FORMAT_R64G64_SFLOAT";
    case VK_FORMAT_R64G64B64_UINT: return "VK_FORMAT_R64G64B64_UINT";
    case VK_FORMAT_R64G64B64_SINT: return "VK_FORMAT_R64G64B64_SINT";
    case VK_FORMAT_R64G64B64_SFLOAT: return "VK_FORMAT_R64G64B64_SFLOAT";
    case VK_FORMAT_R64G64B64A64_UINT: return "VK_FORMAT_R64G64B64A64_UINT";
    case VK_FORMAT_R64G64B64A64_SINT: return "VK_FORMAT_R64G64B64A64_SINT";
    case VK_FORMAT_R64G64B64A64_SFLOAT: return "VK_FORMAT_R64G64B64A64_SFLOAT";
    case VK_FORMAT_B10G11R11_UFLOAT_PACK32: return "VK_FORMAT_B10G11R11_UFLOAT_PACK32";
    case VK_FORMAT_E5B9G9R9_UFLOAT_PACK32: return "VK_FORMAT_E5B9G9R9_UFLOAT_PACK32";
    case VK_FORMAT_D16_UNORM: return "VK_FORMAT_D16_UNORM";
    case VK_FORMAT_X8_D24_UNORM_PACK32: return "VK_FORMAT_X8_D24_UNORM_PACK32";
    case VK_FORMAT_D32_SFLOAT: return "VK_FORMAT_D32_SFLOAT";
    case VK_FORMAT_S8_UINT: return "VK_FORMAT_S8_UINT";
    case VK_FORMAT_D16_UNORM_S8_UINT: return "VK_FORMAT_D16_UNORM_S8_UINT";
    case VK_FORMAT_D24_UNORM_S8_UINT: return "VK_FORMAT_D24_UNORM_S8_UINT";
    case VK_FORMAT_D32_SFLOAT_S8_UINT: return "VK_FORMAT_D32_SFLOAT_S8_UINT";
    case VK_FORMAT_BC1_RGB_UNORM_BLOCK: return "VK_FORMAT_BC1_RGB_UNORM_BLOCK";
    case VK_FORMAT_BC1_RGB_SRGB_BLOCK: return "VK_FORMAT_BC1_RGB_SRGB_BLOCK";
    case VK_FORMAT_BC1_RGBA_UNORM_BLOCK: return "VK_FORMAT_BC1_RGBA_UNORM_BLOCK";
    case VK_FORMAT_BC1_RGBA_SRGB_BLOCK: return "VK_FORMAT_BC1_RGBA_SRGB_BLOCK";
    case VK_FORMAT_BC2_UNORM_BLOCK: return "VK_FORMAT_BC2_UNORM_BLOCK";
    case VK_FORMAT_BC2_SRGB_BLOCK: return "VK_FORMAT_BC2_SRGB_BLOCK";
    case VK_FORMAT_BC3_UNORM_BLOCK: return "VK_FORMAT_BC3_UNORM_BLOCK";
    case VK_FORMAT_BC3_SRGB_BLOCK: return "VK_FORMAT_BC3_SRGB_BLOCK";
    case VK_FORMAT_BC4_UNORM_BLOCK: return "VK_FORMAT_BC4_UNORM_BLOCK";
    case VK_FORMAT_BC4_SNORM_BLOCK: return "VK_FORMAT_BC4_SNORM_BLOCK";
    case VK_FORMAT_BC5_UNORM_BLOCK: return "VK_FORMAT_BC5_UNORM_BLOCK";
    case VK_FORMAT_BC5_SNORM_BLOCK: return "VK_FORMAT_BC5_SNORM_BLOCK";
    case VK_FORMAT_BC6H_UFLOAT_BLOCK: return "VK_FORMAT_BC6H_UFLOAT_BLOCK";
    case VK_FORMAT_BC6H_SFLOAT_BLOCK: return "VK_FORMAT_BC6H_SFLOAT_BLOCK";
    case VK_FORMAT_BC7_UNORM_BLOCK: return "VK_FORMAT_BC7_UNORM_BLOCK";
    case VK_FORMAT_BC7_SRGB_BLOCK: return "VK_FORMAT_BC7_SRGB_BLOCK";
    case VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK: return "VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK";
    case VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK: return "VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK";
    case VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK: return "VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK";
    case VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK: return "VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK";
    case VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK: return "VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK";
    case VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK: return "VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK";
    case VK_FORMAT_EAC_R11_UNORM_BLOCK: return "VK_FORMAT_EAC_R11_UNORM_BLOCK";
    case VK_FORMAT_EAC_R11_SNORM_BLOCK: return "VK_FORMAT_EAC_R11_SNORM_BLOCK";
    case VK_FORMAT_EAC_R11G11_UNORM_BLOCK: return "VK_FORMAT_EAC_R11G11_UNORM_BLOCK";
    case VK_FORMAT_EAC_R11G11_SNORM_BLOCK: return "VK_FORMAT_EAC_R11G11_SNORM_BLOCK";
    case VK_FORMAT_ASTC_4x4_UNORM_BLOCK: return "VK_FORMAT_ASTC_4x4_UNORM_BLOCK";
    case VK_FORMAT_ASTC_4x4_SRGB_BLOCK: return "VK_FORMAT_ASTC_4x4_SRGB_BLOCK";
    case VK_FORMAT_ASTC_5x4_UNORM_BLOCK: return "VK_FORMAT_ASTC_5x4_UNORM_BLOCK";
    case VK_FORMAT_ASTC_5x4_SRGB_BLOCK: return "VK_FORMAT_ASTC_5x4_SRGB_BLOCK";
    case VK_FORMAT_ASTC_5x5_UNORM_BLOCK: return "VK_FORMAT_ASTC_5x5_UNORM_BLOCK";
    case VK_FORMAT_ASTC_5x5_SRGB_BLOCK: return "VK_FORMAT_ASTC_5x5_SRGB_BLOCK";
    case VK_FORMAT_ASTC_6x5_UNORM_BLOCK: return "VK_FORMAT_ASTC_6x5_UNORM_BLOCK";
    case VK_FORMAT_ASTC_6x5_SRGB_BLOCK: return "VK_FORMAT_ASTC_6x5_SRGB_BLOCK";
    case VK_FORMAT_ASTC_6x6_UNORM_BLOCK: return "VK_FORMAT_ASTC_6x6_UNORM_BLOCK";
    case VK_FORMAT_ASTC_6x6_SRGB_BLOCK: return "VK_FORMAT_ASTC_6x6_SRGB_BLOCK";
    case VK_FORMAT_ASTC_8x5_UNORM_BLOCK: return "VK_FORMAT_ASTC_8x5_UNORM_BLOCK";
    case VK_FORMAT_ASTC_8x5_SRGB_BLOCK: return "VK_FORMAT_ASTC_8x5_SRGB_BLOCK";
    case VK_FORMAT_ASTC_8x6_UNORM_BLOCK: return "VK_FORMAT_ASTC_8x6_UNORM_BLOCK";
    case VK_FORMAT_ASTC_8x6_SRGB_BLOCK: return "VK_FORMAT_ASTC_8x6_SRGB_BLOCK";
    case VK_FORMAT_ASTC_8x8_UNORM_BLOCK: return "VK_FORMAT_ASTC_8x8_UNORM_BLOCK";
    case VK_FORMAT_ASTC_8x8_SRGB_BLOCK: return "VK_FORMAT_ASTC_8x8_SRGB_BLOCK";
    case VK_FORMAT_ASTC_10x5_UNORM_BLOCK: return "VK_FORMAT_ASTC_10x5_UNORM_BLOCK";
    case VK_FORMAT_ASTC_10x5_SRGB_BLOCK: return "VK_FORMAT_ASTC_10x5_SRGB_BLOCK";
    case VK_FORMAT_ASTC_10x6_UNORM_BLOCK: return "VK_FORMAT_ASTC_10x6_UNORM_BLOCK";
    case VK_FORMAT_ASTC_10x6_SRGB_BLOCK: return "VK_FORMAT_ASTC_10x6_SRGB_BLOCK";
    case VK_FORMAT_ASTC_10x8_UNORM_BLOCK: return "VK_FORMAT_ASTC_10x8_UNORM_BLOCK";
    case VK_FORMAT_ASTC_10x8_SRGB_BLOCK: return "VK_FORMAT_ASTC_10x8_SRGB_BLOCK";
    case VK_FORMAT_ASTC_10x10_UNORM_BLOCK: return "VK_FORMAT_ASTC_10x10_UNORM_BLOCK";
    case VK_FORMAT_ASTC_10x10_SRGB_BLOCK: return "VK_FORMAT_ASTC_10x10_SRGB_BLOCK";
    case VK_FORMAT_ASTC_12x10_UNORM_BLOCK: return "VK_FORMAT_ASTC_12x10_UNORM_BLOCK";
    case VK_FORMAT_ASTC_12x10_SRGB_BLOCK: return "VK_FORMAT_ASTC_12x10_SRGB_BLOCK";
    case VK_FORMAT_ASTC_12x12_UNORM_BLOCK: return "VK_FORMAT_ASTC_12x12_UNORM_BLOCK";
    case VK_FORMAT_ASTC_12x12_SRGB_BLOCK: return "VK_FORMAT_ASTC_12x12_SRGB_BLOCK";
    case VK_FORMAT_G8B8G8R8_422_UNORM: return "VK_FORMAT_G8B8G8R8_422_UNORM";
    case VK_FORMAT_B8G8R8G8_422_UNORM: return "VK_FORMAT_B8G8R8G8_422_UNORM";
    case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM: return "VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM";
    case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM: return "VK_FORMAT_G8_B8R8_2PLANE_420_UNORM";
    case VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM: return "VK_FORMAT_G8_B8_R8_3PLANE_422_UNORM";
    case VK_FORMAT_G8_B8R8_2PLANE_422_UNORM: return "VK_FORMAT_G8_B8R8_2PLANE_422_UNORM";
    case VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM: return "VK_FORMAT_G8_B8_R8_3PLANE_444_UNORM";
    case VK_FORMAT_R10X6_UNORM_PACK16: return "VK_FORMAT_R10X6_UNORM_PACK16";
    case VK_FORMAT_R10X6G10X6_UNORM_2PACK16: return "VK_FORMAT_R10X6G10X6_UNORM_2PACK16";
    case VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16: return "VK_FORMAT_R10X6G10X6B10X6A10X6_UNORM_4PACK16";
    case VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16: return "VK_FORMAT_G10X6B10X6G10X6R10X6_422_UNORM_4PACK16";
    case VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16: return "VK_FORMAT_B10X6G10X6R10X6G10X6_422_UNORM_4PACK16";
    case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16: return "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_420_UNORM_3PACK16";
    case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16: return "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_420_UNORM_3PACK16";
    case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16: return "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_422_UNORM_3PACK16";
    case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16: return "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_422_UNORM_3PACK16";
    case VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16: return "VK_FORMAT_G10X6_B10X6_R10X6_3PLANE_444_UNORM_3PACK16";
    case VK_FORMAT_R12X4_UNORM_PACK16: return "VK_FORMAT_R12X4_UNORM_PACK16";
    case VK_FORMAT_R12X4G12X4_UNORM_2PACK16: return "VK_FORMAT_R12X4G12X4_UNORM_2PACK16";
    case VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16: return "VK_FORMAT_R12X4G12X4B12X4A12X4_UNORM_4PACK16";
    case VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16: return "VK_FORMAT_G12X4B12X4G12X4R12X4_422_UNORM_4PACK16";
    case VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16: return "VK_FORMAT_B12X4G12X4R12X4G12X4_422_UNORM_4PACK16";
    case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16: return "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_420_UNORM_3PACK16";
    case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16: return "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_420_UNORM_3PACK16";
    case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16: return "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_422_UNORM_3PACK16";
    case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16: return "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_422_UNORM_3PACK16";
    case VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16: return "VK_FORMAT_G12X4_B12X4_R12X4_3PLANE_444_UNORM_3PACK16";
    case VK_FORMAT_G16B16G16R16_422_UNORM: return "VK_FORMAT_G16B16G16R16_422_UNORM";
    case VK_FORMAT_B16G16R16G16_422_UNORM: return "VK_FORMAT_B16G16R16G16_422_UNORM";
    case VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM: return "VK_FORMAT_G16_B16_R16_3PLANE_420_UNORM";
    case VK_FORMAT_G16_B16R16_2PLANE_420_UNORM: return "VK_FORMAT_G16_B16R16_2PLANE_420_UNORM";
    case VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM: return "VK_FORMAT_G16_B16_R16_3PLANE_422_UNORM";
    case VK_FORMAT_G16_B16R16_2PLANE_422_UNORM: return "VK_FORMAT_G16_B16R16_2PLANE_422_UNORM";
    case VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM: return "VK_FORMAT_G16_B16_R16_3PLANE_444_UNORM";
    case VK_FORMAT_G8_B8R8_2PLANE_444_UNORM: return "VK_FORMAT_G8_B8R8_2PLANE_444_UNORM";
    case VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16: return "VK_FORMAT_G10X6_B10X6R10X6_2PLANE_444_UNORM_3PACK16";
    case VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16: return "VK_FORMAT_G12X4_B12X4R12X4_2PLANE_444_UNORM_3PACK16";
    case VK_FORMAT_G16_B16R16_2PLANE_444_UNORM: return "VK_FORMAT_G16_B16R16_2PLANE_444_UNORM";
    case VK_FORMAT_A4R4G4B4_UNORM_PACK16: return "VK_FORMAT_A4R4G4B4_UNORM_PACK16";
    case VK_FORMAT_A4B4G4R4_UNORM_PACK16: return "VK_FORMAT_A4B4G4R4_UNORM_PACK16";
    case VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_4x4_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_5x4_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_5x5_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_6x5_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_6x6_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_8x5_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_8x6_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_8x8_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_10x5_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_10x6_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_10x8_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_10x10_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_12x10_SFLOAT_BLOCK";
    case VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK: return "VK_FORMAT_ASTC_12x12_SFLOAT_BLOCK";
    case VK_FORMAT_A1B5G5R5_UNORM_PACK16: return "VK_FORMAT_A1B5G5R5_UNORM_PACK16";
    case VK_FORMAT_A8_UNORM: return "VK_FORMAT_A8_UNORM";
    case VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG: return "VK_FORMAT_PVRTC1_2BPP_UNORM_BLOCK_IMG";
    case VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG: return "VK_FORMAT_PVRTC1_4BPP_UNORM_BLOCK_IMG";
    case VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG: return "VK_FORMAT_PVRTC2_2BPP_UNORM_BLOCK_IMG";
    case VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG: return "VK_FORMAT_PVRTC2_4BPP_UNORM_BLOCK_IMG";
    case VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG: return "VK_FORMAT_PVRTC1_2BPP_SRGB_BLOCK_IMG";
    case VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG: return "VK_FORMAT_PVRTC1_4BPP_SRGB_BLOCK_IMG";
    case VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG: return "VK_FORMAT_PVRTC2_2BPP_SRGB_BLOCK_IMG";
    case VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG: return "VK_FORMAT_PVRTC2_4BPP_SRGB_BLOCK_IMG";
    case VK_FORMAT_R16G16_SFIXED5_NV: return "VK_FORMAT_R16G16_SFIXED5_NV";

    default: return "unknown format";
    }
}

const char *vk_csp_name(VkColorSpaceKHR csp)
{
    switch (csp) {
    case VK_COLOR_SPACE_SRGB_NONLINEAR_KHR: return "VK_COLOR_SPACE_SRGB_NONLINEAR_KHR";
    case VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT: return "VK_COLOR_SPACE_DISPLAY_P3_NONLINEAR_EXT";
    case VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT: return "VK_COLOR_SPACE_EXTENDED_SRGB_LINEAR_EXT";
    case VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT: return "VK_COLOR_SPACE_DISPLAY_P3_LINEAR_EXT";
    case VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT: return "VK_COLOR_SPACE_DCI_P3_NONLINEAR_EXT";
    case VK_COLOR_SPACE_BT709_LINEAR_EXT: return "VK_COLOR_SPACE_BT709_LINEAR_EXT";
    case VK_COLOR_SPACE_BT709_NONLINEAR_EXT: return "VK_COLOR_SPACE_BT709_NONLINEAR_EXT";
    case VK_COLOR_SPACE_BT2020_LINEAR_EXT: return "VK_COLOR_SPACE_BT2020_LINEAR_EXT";
    case VK_COLOR_SPACE_HDR10_ST2084_EXT: return "VK_COLOR_SPACE_HDR10_ST2084_EXT";
    case VK_COLOR_SPACE_DOLBYVISION_EXT: return "VK_COLOR_SPACE_DOLBYVISION_EXT";
    case VK_COLOR_SPACE_HDR10_HLG_EXT: return "VK_COLOR_SPACE_HDR10_HLG_EXT";
    case VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT: return "VK_COLOR_SPACE_ADOBERGB_LINEAR_EXT";
    case VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT: return "VK_COLOR_SPACE_ADOBERGB_NONLINEAR_EXT";
    case VK_COLOR_SPACE_PASS_THROUGH_EXT: return "VK_COLOR_SPACE_PASS_THROUGH_EXT";
    case VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT: return "VK_COLOR_SPACE_EXTENDED_SRGB_NONLINEAR_EXT";
    case VK_COLOR_SPACE_DISPLAY_NATIVE_AMD: return "VK_COLOR_SPACE_DISPLAY_NATIVE_AMD";

    default: return "unknown color space";
    }
}

const char *vk_handle_name(VkExternalMemoryHandleTypeFlagBitsKHR handle)
{
    switch (handle) {
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_FD_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_OPAQUE_WIN32_KMT_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D11_TEXTURE_KMT_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_HEAP_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_D3D12_RESOURCE_BIT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_DMA_BUF_BIT_EXT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_ALLOCATION_BIT_EXT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_HOST_MAPPED_FOREIGN_MEMORY_BIT_EXT";
    case VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV: return "VK_EXTERNAL_MEMORY_HANDLE_TYPE_RDMA_ADDRESS_BIT_NV";

    default: return "unknown handle type";
    }
}

const char *vk_alpha_mode(VkCompositeAlphaFlagsKHR alpha)
{
    switch (alpha) {
    case VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR: return "VK_COMPOSITE_ALPHA_OPAQUE_BIT_KHR";
    case VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR: return "VK_COMPOSITE_ALPHA_PRE_MULTIPLIED_BIT_KHR";
    case VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR: return "VK_COMPOSITE_ALPHA_POST_MULTIPLIED_BIT_KHR";
    case VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR: return "VK_COMPOSITE_ALPHA_INHERIT_BIT_KHR";

    default: return "unknown alpha mode";
    }
}

const char *vk_surface_transform(VkSurfaceTransformFlagsKHR tf)
{
    switch (tf) {
    case VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR: return "VK_SURFACE_TRANSFORM_IDENTITY_BIT_KHR";
    case VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR: return "VK_SURFACE_TRANSFORM_ROTATE_90_BIT_KHR";
    case VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR: return "VK_SURFACE_TRANSFORM_ROTATE_180_BIT_KHR";
    case VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR: return "VK_SURFACE_TRANSFORM_ROTATE_270_BIT_KHR";
    case VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR: return "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_BIT_KHR";
    case VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR: return "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_90_BIT_KHR";
    case VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR: return "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_180_BIT_KHR";
    case VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR: return "VK_SURFACE_TRANSFORM_HORIZONTAL_MIRROR_ROTATE_270_BIT_KHR";
    case VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR: return "VK_SURFACE_TRANSFORM_INHERIT_BIT_KHR";

    default: return "unknown surface transform";
    }
}


const char *vk_obj_type(VkObjectType obj)
{
    switch (obj) {
    case VK_OBJECT_TYPE_INSTANCE: return "VkInstance";
    case VK_OBJECT_TYPE_PHYSICAL_DEVICE: return "VkPhysicalDevice";
    case VK_OBJECT_TYPE_DEVICE: return "VkDevice";
    case VK_OBJECT_TYPE_QUEUE: return "VkQueue";
    case VK_OBJECT_TYPE_COMMAND_BUFFER: return "VkCommandBuffer";
    case VK_OBJECT_TYPE_DEVICE_MEMORY: return "VkDeviceMemory";
    case VK_OBJECT_TYPE_COMMAND_POOL: return "VkCommandPool";
    case VK_OBJECT_TYPE_BUFFER: return "VkBuffer";
    case VK_OBJECT_TYPE_BUFFER_VIEW: return "VkBufferView";
    case VK_OBJECT_TYPE_IMAGE: return "VkImage";
    case VK_OBJECT_TYPE_IMAGE_VIEW: return "VkImageView";
    case VK_OBJECT_TYPE_SHADER_MODULE: return "VkShaderModule";
    case VK_OBJECT_TYPE_PIPELINE: return "VkPipeline";
    case VK_OBJECT_TYPE_PIPELINE_LAYOUT: return "VkPipelineLayout";
    case VK_OBJECT_TYPE_SAMPLER: return "VkSampler";
    case VK_OBJECT_TYPE_DESCRIPTOR_SET: return "VkDescriptorSet";
    case VK_OBJECT_TYPE_DESCRIPTOR_SET_LAYOUT: return "VkDescriptorSetLayout";
    case VK_OBJECT_TYPE_DESCRIPTOR_POOL: return "VkDescriptorPool";
    case VK_OBJECT_TYPE_FENCE: return "VkFence";
    case VK_OBJECT_TYPE_SEMAPHORE: return "VkSemaphore";
    case VK_OBJECT_TYPE_EVENT: return "VkEvent";
    case VK_OBJECT_TYPE_QUERY_POOL: return "VkQueryPool";
    case VK_OBJECT_TYPE_FRAMEBUFFER: return "VkFramebuffer";
    case VK_OBJECT_TYPE_RENDER_PASS: return "VkRenderPass";
    case VK_OBJECT_TYPE_PIPELINE_CACHE: return "VkPipelineCache";
    case VK_OBJECT_TYPE_PIPELINE_BINARY_KHR: return "VkPipelineBinaryKHR";
    case VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_NV: return "VkIndirectCommandsLayoutNV";
    case VK_OBJECT_TYPE_INDIRECT_COMMANDS_LAYOUT_EXT: return "VkIndirectCommandsLayoutEXT";
    case VK_OBJECT_TYPE_INDIRECT_EXECUTION_SET_EXT: return "VkIndirectExecutionSetEXT";
    case VK_OBJECT_TYPE_DESCRIPTOR_UPDATE_TEMPLATE: return "VkDescriptorUpdateTemplate";
    case VK_OBJECT_TYPE_SAMPLER_YCBCR_CONVERSION: return "VkSamplerYcbcrConversion";
    case VK_OBJECT_TYPE_VALIDATION_CACHE_EXT: return "VkValidationCacheEXT";
    case VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_KHR: return "VkAccelerationStructureKHR";
    case VK_OBJECT_TYPE_ACCELERATION_STRUCTURE_NV: return "VkAccelerationStructureNV";
    case VK_OBJECT_TYPE_PERFORMANCE_CONFIGURATION_INTEL: return "VkPerformanceConfigurationINTEL";
    case VK_OBJECT_TYPE_DEFERRED_OPERATION_KHR: return "VkDeferredOperationKHR";
    case VK_OBJECT_TYPE_PRIVATE_DATA_SLOT: return "VkPrivateDataSlot";
    case VK_OBJECT_TYPE_CU_MODULE_NVX: return "VkCuModuleNVX";
    case VK_OBJECT_TYPE_CU_FUNCTION_NVX: return "VkCuFunctionNVX";
    case VK_OBJECT_TYPE_OPTICAL_FLOW_SESSION_NV: return "VkOpticalFlowSessionNV";
    case VK_OBJECT_TYPE_MICROMAP_EXT: return "VkMicromapEXT";
    case VK_OBJECT_TYPE_SHADER_EXT: return "VkShaderEXT";
    case VK_OBJECT_TYPE_DISPLAY_KHR: return "VkDisplayKHR";
    case VK_OBJECT_TYPE_DISPLAY_MODE_KHR: return "VkDisplayModeKHR";
    case VK_OBJECT_TYPE_SURFACE_KHR: return "VkSurfaceKHR";
    case VK_OBJECT_TYPE_SWAPCHAIN_KHR: return "VkSwapchainKHR";
    case VK_OBJECT_TYPE_DEBUG_REPORT_CALLBACK_EXT: return "VkDebugReportCallbackEXT";
    case VK_OBJECT_TYPE_DEBUG_UTILS_MESSENGER_EXT: return "VkDebugUtilsMessengerEXT";
    case VK_OBJECT_TYPE_VIDEO_SESSION_KHR: return "VkVideoSessionKHR";
    case VK_OBJECT_TYPE_VIDEO_SESSION_PARAMETERS_KHR: return "VkVideoSessionParametersKHR";

    default: return "unknown object";
    }
}

size_t vk_struct_size(VkStructureType stype)
{
    switch (stype) {
    case VK_STRUCTURE_TYPE_APPLICATION_INFO: return sizeof(VkApplicationInfo);
    case VK_STRUCTURE_TYPE_DEVICE_QUEUE_CREATE_INFO: return sizeof(VkDeviceQueueCreateInfo);
    case VK_STRUCTURE_TYPE_DEVICE_CREATE_INFO: return sizeof(VkDeviceCreateInfo);
    case VK_STRUCTURE_TYPE_INSTANCE_CREATE_INFO: return sizeof(VkInstanceCreateInfo);
    case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_INFO: return sizeof(VkMemoryAllocateInfo);
    case VK_STRUCTURE_TYPE_MAPPED_MEMORY_RANGE: return sizeof(VkMappedMemoryRange);
    case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET: return sizeof(VkWriteDescriptorSet);
    case VK_STRUCTURE_TYPE_COPY_DESCRIPTOR_SET: return sizeof(VkCopyDescriptorSet);
    case VK_STRUCTURE_TYPE_BUFFER_USAGE_FLAGS_2_CREATE_INFO: return sizeof(VkBufferUsageFlags2CreateInfo);
    case VK_STRUCTURE_TYPE_BUFFER_CREATE_INFO: return sizeof(VkBufferCreateInfo);
    case VK_STRUCTURE_TYPE_BUFFER_VIEW_CREATE_INFO: return sizeof(VkBufferViewCreateInfo);
    case VK_STRUCTURE_TYPE_MEMORY_BARRIER: return sizeof(VkMemoryBarrier);
    case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER: return sizeof(VkBufferMemoryBarrier);
    case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER: return sizeof(VkImageMemoryBarrier);
    case VK_STRUCTURE_TYPE_IMAGE_CREATE_INFO: return sizeof(VkImageCreateInfo);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_CREATE_INFO: return sizeof(VkImageViewCreateInfo);
    case VK_STRUCTURE_TYPE_BIND_SPARSE_INFO: return sizeof(VkBindSparseInfo);
    case VK_STRUCTURE_TYPE_SHADER_MODULE_CREATE_INFO: return sizeof(VkShaderModuleCreateInfo);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_CREATE_INFO: return sizeof(VkDescriptorSetLayoutCreateInfo);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_CREATE_INFO: return sizeof(VkDescriptorPoolCreateInfo);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_ALLOCATE_INFO: return sizeof(VkDescriptorSetAllocateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_CREATE_INFO: return sizeof(VkPipelineShaderStageCreateInfo);
    case VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_CREATE_INFO: return sizeof(VkComputePipelineCreateInfo);
    case VK_STRUCTURE_TYPE_COMPUTE_PIPELINE_INDIRECT_BUFFER_INFO_NV: return sizeof(VkComputePipelineIndirectBufferInfoNV);
    case VK_STRUCTURE_TYPE_PIPELINE_CREATE_FLAGS_2_CREATE_INFO: return sizeof(VkPipelineCreateFlags2CreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_STATE_CREATE_INFO: return sizeof(VkPipelineVertexInputStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_INPUT_ASSEMBLY_STATE_CREATE_INFO: return sizeof(VkPipelineInputAssemblyStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_STATE_CREATE_INFO: return sizeof(VkPipelineTessellationStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_STATE_CREATE_INFO: return sizeof(VkPipelineViewportStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_CREATE_INFO: return sizeof(VkPipelineRasterizationStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_MULTISAMPLE_STATE_CREATE_INFO: return sizeof(VkPipelineMultisampleStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_STATE_CREATE_INFO: return sizeof(VkPipelineColorBlendStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_DYNAMIC_STATE_CREATE_INFO: return sizeof(VkPipelineDynamicStateCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_DEPTH_STENCIL_STATE_CREATE_INFO: return sizeof(VkPipelineDepthStencilStateCreateInfo);
    case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_CREATE_INFO: return sizeof(VkGraphicsPipelineCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_CACHE_CREATE_INFO: return sizeof(VkPipelineCacheCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_BINARY_CREATE_INFO_KHR: return sizeof(VkPipelineBinaryCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_BINARY_HANDLES_INFO_KHR: return sizeof(VkPipelineBinaryHandlesInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_BINARY_KEY_KHR: return sizeof(VkPipelineBinaryKeyKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_BINARY_INFO_KHR: return sizeof(VkPipelineBinaryInfoKHR);
    case VK_STRUCTURE_TYPE_RELEASE_CAPTURED_PIPELINE_DATA_INFO_KHR: return sizeof(VkReleaseCapturedPipelineDataInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_BINARY_DATA_INFO_KHR: return sizeof(VkPipelineBinaryDataInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_CREATE_INFO_KHR: return sizeof(VkPipelineCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_LAYOUT_CREATE_INFO: return sizeof(VkPipelineLayoutCreateInfo);
    case VK_STRUCTURE_TYPE_SAMPLER_CREATE_INFO: return sizeof(VkSamplerCreateInfo);
    case VK_STRUCTURE_TYPE_COMMAND_POOL_CREATE_INFO: return sizeof(VkCommandPoolCreateInfo);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_ALLOCATE_INFO: return sizeof(VkCommandBufferAllocateInfo);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_INFO: return sizeof(VkCommandBufferInheritanceInfo);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_BEGIN_INFO: return sizeof(VkCommandBufferBeginInfo);
    case VK_STRUCTURE_TYPE_RENDER_PASS_BEGIN_INFO: return sizeof(VkRenderPassBeginInfo);
    case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO: return sizeof(VkRenderPassCreateInfo);
    case VK_STRUCTURE_TYPE_EVENT_CREATE_INFO: return sizeof(VkEventCreateInfo);
    case VK_STRUCTURE_TYPE_FENCE_CREATE_INFO: return sizeof(VkFenceCreateInfo);
    case VK_STRUCTURE_TYPE_SEMAPHORE_CREATE_INFO: return sizeof(VkSemaphoreCreateInfo);
    case VK_STRUCTURE_TYPE_QUERY_POOL_CREATE_INFO: return sizeof(VkQueryPoolCreateInfo);
    case VK_STRUCTURE_TYPE_FRAMEBUFFER_CREATE_INFO: return sizeof(VkFramebufferCreateInfo);
    case VK_STRUCTURE_TYPE_SUBMIT_INFO: return sizeof(VkSubmitInfo);
    case VK_STRUCTURE_TYPE_DISPLAY_MODE_CREATE_INFO_KHR: return sizeof(VkDisplayModeCreateInfoKHR);
    case VK_STRUCTURE_TYPE_DISPLAY_SURFACE_CREATE_INFO_KHR: return sizeof(VkDisplaySurfaceCreateInfoKHR);
    case VK_STRUCTURE_TYPE_DISPLAY_SURFACE_STEREO_CREATE_INFO_NV: return sizeof(VkDisplaySurfaceStereoCreateInfoNV);
    case VK_STRUCTURE_TYPE_DISPLAY_PRESENT_INFO_KHR: return sizeof(VkDisplayPresentInfoKHR);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_CREATE_INFO_KHR: return sizeof(VkSwapchainCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PRESENT_INFO_KHR: return sizeof(VkPresentInfoKHR);
    case VK_STRUCTURE_TYPE_DEBUG_REPORT_CALLBACK_CREATE_INFO_EXT: return sizeof(VkDebugReportCallbackCreateInfoEXT);
    case VK_STRUCTURE_TYPE_VALIDATION_FLAGS_EXT: return sizeof(VkValidationFlagsEXT);
    case VK_STRUCTURE_TYPE_VALIDATION_FEATURES_EXT: return sizeof(VkValidationFeaturesEXT);
    case VK_STRUCTURE_TYPE_LAYER_SETTINGS_CREATE_INFO_EXT: return sizeof(VkLayerSettingsCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_RASTERIZATION_ORDER_AMD: return sizeof(VkPipelineRasterizationStateRasterizationOrderAMD);
    case VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_NAME_INFO_EXT: return sizeof(VkDebugMarkerObjectNameInfoEXT);
    case VK_STRUCTURE_TYPE_DEBUG_MARKER_OBJECT_TAG_INFO_EXT: return sizeof(VkDebugMarkerObjectTagInfoEXT);
    case VK_STRUCTURE_TYPE_DEBUG_MARKER_MARKER_INFO_EXT: return sizeof(VkDebugMarkerMarkerInfoEXT);
    case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_IMAGE_CREATE_INFO_NV: return sizeof(VkDedicatedAllocationImageCreateInfoNV);
    case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_BUFFER_CREATE_INFO_NV: return sizeof(VkDedicatedAllocationBufferCreateInfoNV);
    case VK_STRUCTURE_TYPE_DEDICATED_ALLOCATION_MEMORY_ALLOCATE_INFO_NV: return sizeof(VkDedicatedAllocationMemoryAllocateInfoNV);
    case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO_NV: return sizeof(VkExternalMemoryImageCreateInfoNV);
    case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO_NV: return sizeof(VkExportMemoryAllocateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: return sizeof(VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV: return sizeof(VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV);
    case VK_STRUCTURE_TYPE_DEVICE_PRIVATE_DATA_CREATE_INFO: return sizeof(VkDevicePrivateDataCreateInfo);
    case VK_STRUCTURE_TYPE_PRIVATE_DATA_SLOT_CREATE_INFO: return sizeof(VkPrivateDataSlotCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: return sizeof(VkPhysicalDevicePrivateDataFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_NV: return sizeof(VkPhysicalDeviceDeviceGeneratedCommandsPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV: return sizeof(VkPhysicalDeviceClusterAccelerationStructureFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_PROPERTIES_NV: return sizeof(VkPhysicalDeviceClusterAccelerationStructurePropertiesNV);
    case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CLUSTER_ACCELERATION_STRUCTURE_CREATE_INFO_NV: return sizeof(VkRayTracingPipelineClusterAccelerationStructureCreateInfoNV);
    case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_CLUSTERS_BOTTOM_LEVEL_INPUT_NV: return sizeof(VkClusterAccelerationStructureClustersBottomLevelInputNV);
    case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_TRIANGLE_CLUSTER_INPUT_NV: return sizeof(VkClusterAccelerationStructureTriangleClusterInputNV);
    case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_MOVE_OBJECTS_INPUT_NV: return sizeof(VkClusterAccelerationStructureMoveObjectsInputNV);
    case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_INPUT_INFO_NV: return sizeof(VkClusterAccelerationStructureInputInfoNV);
    case VK_STRUCTURE_TYPE_CLUSTER_ACCELERATION_STRUCTURE_COMMANDS_INFO_NV: return sizeof(VkClusterAccelerationStructureCommandsInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceMultiDrawPropertiesEXT);
    case VK_STRUCTURE_TYPE_GRAPHICS_SHADER_GROUP_CREATE_INFO_NV: return sizeof(VkGraphicsShaderGroupCreateInfoNV);
    case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_SHADER_GROUPS_CREATE_INFO_NV: return sizeof(VkGraphicsPipelineShaderGroupsCreateInfoNV);
    case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_NV: return sizeof(VkIndirectCommandsLayoutTokenNV);
    case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_NV: return sizeof(VkIndirectCommandsLayoutCreateInfoNV);
    case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_NV: return sizeof(VkGeneratedCommandsInfoNV);
    case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_NV: return sizeof(VkGeneratedCommandsMemoryRequirementsInfoNV);
    case VK_STRUCTURE_TYPE_PIPELINE_INDIRECT_DEVICE_ADDRESS_INFO_NV: return sizeof(VkPipelineIndirectDeviceAddressInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: return sizeof(VkPhysicalDeviceFeatures2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROPERTIES_2: return sizeof(VkPhysicalDeviceProperties2);
    case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_2: return sizeof(VkFormatProperties2);
    case VK_STRUCTURE_TYPE_IMAGE_FORMAT_PROPERTIES_2: return sizeof(VkImageFormatProperties2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_FORMAT_INFO_2: return sizeof(VkPhysicalDeviceImageFormatInfo2);
    case VK_STRUCTURE_TYPE_QUEUE_FAMILY_PROPERTIES_2: return sizeof(VkQueueFamilyProperties2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PROPERTIES_2: return sizeof(VkPhysicalDeviceMemoryProperties2);
    case VK_STRUCTURE_TYPE_SPARSE_IMAGE_FORMAT_PROPERTIES_2: return sizeof(VkSparseImageFormatProperties2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SPARSE_IMAGE_FORMAT_INFO_2: return sizeof(VkPhysicalDeviceSparseImageFormatInfo2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PUSH_DESCRIPTOR_PROPERTIES: return sizeof(VkPhysicalDevicePushDescriptorProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRIVER_PROPERTIES: return sizeof(VkPhysicalDeviceDriverProperties);
    case VK_STRUCTURE_TYPE_PRESENT_REGIONS_KHR: return sizeof(VkPresentRegionsKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: return sizeof(VkPhysicalDeviceVariablePointersFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_IMAGE_FORMAT_INFO: return sizeof(VkPhysicalDeviceExternalImageFormatInfo);
    case VK_STRUCTURE_TYPE_EXTERNAL_IMAGE_FORMAT_PROPERTIES: return sizeof(VkExternalImageFormatProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_BUFFER_INFO: return sizeof(VkPhysicalDeviceExternalBufferInfo);
    case VK_STRUCTURE_TYPE_EXTERNAL_BUFFER_PROPERTIES: return sizeof(VkExternalBufferProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ID_PROPERTIES: return sizeof(VkPhysicalDeviceIDProperties);
    case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_IMAGE_CREATE_INFO: return sizeof(VkExternalMemoryImageCreateInfo);
    case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_BUFFER_CREATE_INFO: return sizeof(VkExternalMemoryBufferCreateInfo);
    case VK_STRUCTURE_TYPE_EXPORT_MEMORY_ALLOCATE_INFO: return sizeof(VkExportMemoryAllocateInfo);
    case VK_STRUCTURE_TYPE_IMPORT_MEMORY_FD_INFO_KHR: return sizeof(VkImportMemoryFdInfoKHR);
    case VK_STRUCTURE_TYPE_MEMORY_FD_PROPERTIES_KHR: return sizeof(VkMemoryFdPropertiesKHR);
    case VK_STRUCTURE_TYPE_MEMORY_GET_FD_INFO_KHR: return sizeof(VkMemoryGetFdInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_SEMAPHORE_INFO: return sizeof(VkPhysicalDeviceExternalSemaphoreInfo);
    case VK_STRUCTURE_TYPE_EXTERNAL_SEMAPHORE_PROPERTIES: return sizeof(VkExternalSemaphoreProperties);
    case VK_STRUCTURE_TYPE_EXPORT_SEMAPHORE_CREATE_INFO: return sizeof(VkExportSemaphoreCreateInfo);
    case VK_STRUCTURE_TYPE_IMPORT_SEMAPHORE_FD_INFO_KHR: return sizeof(VkImportSemaphoreFdInfoKHR);
    case VK_STRUCTURE_TYPE_SEMAPHORE_GET_FD_INFO_KHR: return sizeof(VkSemaphoreGetFdInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_FENCE_INFO: return sizeof(VkPhysicalDeviceExternalFenceInfo);
    case VK_STRUCTURE_TYPE_EXTERNAL_FENCE_PROPERTIES: return sizeof(VkExternalFenceProperties);
    case VK_STRUCTURE_TYPE_EXPORT_FENCE_CREATE_INFO: return sizeof(VkExportFenceCreateInfo);
    case VK_STRUCTURE_TYPE_IMPORT_FENCE_FD_INFO_KHR: return sizeof(VkImportFenceFdInfoKHR);
    case VK_STRUCTURE_TYPE_FENCE_GET_FD_INFO_KHR: return sizeof(VkFenceGetFdInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: return sizeof(VkPhysicalDeviceMultiviewFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PROPERTIES: return sizeof(VkPhysicalDeviceMultiviewProperties);
    case VK_STRUCTURE_TYPE_RENDER_PASS_MULTIVIEW_CREATE_INFO: return sizeof(VkRenderPassMultiviewCreateInfo);
    case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_EXT: return sizeof(VkSurfaceCapabilities2EXT);
    case VK_STRUCTURE_TYPE_DISPLAY_POWER_INFO_EXT: return sizeof(VkDisplayPowerInfoEXT);
    case VK_STRUCTURE_TYPE_DEVICE_EVENT_INFO_EXT: return sizeof(VkDeviceEventInfoEXT);
    case VK_STRUCTURE_TYPE_DISPLAY_EVENT_INFO_EXT: return sizeof(VkDisplayEventInfoEXT);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_COUNTER_CREATE_INFO_EXT: return sizeof(VkSwapchainCounterCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GROUP_PROPERTIES: return sizeof(VkPhysicalDeviceGroupProperties);
    case VK_STRUCTURE_TYPE_MEMORY_ALLOCATE_FLAGS_INFO: return sizeof(VkMemoryAllocateFlagsInfo);
    case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_INFO: return sizeof(VkBindBufferMemoryInfo);
    case VK_STRUCTURE_TYPE_BIND_BUFFER_MEMORY_DEVICE_GROUP_INFO: return sizeof(VkBindBufferMemoryDeviceGroupInfo);
    case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_INFO: return sizeof(VkBindImageMemoryInfo);
    case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_DEVICE_GROUP_INFO: return sizeof(VkBindImageMemoryDeviceGroupInfo);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_RENDER_PASS_BEGIN_INFO: return sizeof(VkDeviceGroupRenderPassBeginInfo);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_COMMAND_BUFFER_BEGIN_INFO: return sizeof(VkDeviceGroupCommandBufferBeginInfo);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_SUBMIT_INFO: return sizeof(VkDeviceGroupSubmitInfo);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_BIND_SPARSE_INFO: return sizeof(VkDeviceGroupBindSparseInfo);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_CAPABILITIES_KHR: return sizeof(VkDeviceGroupPresentCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_IMAGE_SWAPCHAIN_CREATE_INFO_KHR: return sizeof(VkImageSwapchainCreateInfoKHR);
    case VK_STRUCTURE_TYPE_BIND_IMAGE_MEMORY_SWAPCHAIN_INFO_KHR: return sizeof(VkBindImageMemorySwapchainInfoKHR);
    case VK_STRUCTURE_TYPE_ACQUIRE_NEXT_IMAGE_INFO_KHR: return sizeof(VkAcquireNextImageInfoKHR);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_PRESENT_INFO_KHR: return sizeof(VkDeviceGroupPresentInfoKHR);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_DEVICE_CREATE_INFO: return sizeof(VkDeviceGroupDeviceCreateInfo);
    case VK_STRUCTURE_TYPE_DEVICE_GROUP_SWAPCHAIN_CREATE_INFO_KHR: return sizeof(VkDeviceGroupSwapchainCreateInfoKHR);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_UPDATE_TEMPLATE_CREATE_INFO: return sizeof(VkDescriptorUpdateTemplateCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR: return sizeof(VkPhysicalDevicePresentIdFeaturesKHR);
    case VK_STRUCTURE_TYPE_PRESENT_ID_KHR: return sizeof(VkPresentIdKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR: return sizeof(VkPhysicalDevicePresentWaitFeaturesKHR);
    case VK_STRUCTURE_TYPE_HDR_METADATA_EXT: return sizeof(VkHdrMetadataEXT);
    case VK_STRUCTURE_TYPE_HDR_VIVID_DYNAMIC_METADATA_HUAWEI: return sizeof(VkHdrVividDynamicMetadataHUAWEI);
    case VK_STRUCTURE_TYPE_DISPLAY_NATIVE_HDR_SURFACE_CAPABILITIES_AMD: return sizeof(VkDisplayNativeHdrSurfaceCapabilitiesAMD);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_DISPLAY_NATIVE_HDR_CREATE_INFO_AMD: return sizeof(VkSwapchainDisplayNativeHdrCreateInfoAMD);
    case VK_STRUCTURE_TYPE_PRESENT_TIMES_INFO_GOOGLE: return sizeof(VkPresentTimesInfoGOOGLE);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_W_SCALING_STATE_CREATE_INFO_NV: return sizeof(VkPipelineViewportWScalingStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SWIZZLE_STATE_CREATE_INFO_NV: return sizeof(VkPipelineViewportSwizzleStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DISCARD_RECTANGLE_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceDiscardRectanglePropertiesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_DISCARD_RECTANGLE_STATE_CREATE_INFO_EXT: return sizeof(VkPipelineDiscardRectangleStateCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_ATTRIBUTES_PROPERTIES_NVX: return sizeof(VkPhysicalDeviceMultiviewPerViewAttributesPropertiesNVX);
    case VK_STRUCTURE_TYPE_RENDER_PASS_INPUT_ATTACHMENT_ASPECT_CREATE_INFO: return sizeof(VkRenderPassInputAttachmentAspectCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SURFACE_INFO_2_KHR: return sizeof(VkPhysicalDeviceSurfaceInfo2KHR);
    case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_2_KHR: return sizeof(VkSurfaceCapabilities2KHR);
    case VK_STRUCTURE_TYPE_SURFACE_FORMAT_2_KHR: return sizeof(VkSurfaceFormat2KHR);
    case VK_STRUCTURE_TYPE_DISPLAY_PROPERTIES_2_KHR: return sizeof(VkDisplayProperties2KHR);
    case VK_STRUCTURE_TYPE_DISPLAY_PLANE_PROPERTIES_2_KHR: return sizeof(VkDisplayPlaneProperties2KHR);
    case VK_STRUCTURE_TYPE_DISPLAY_MODE_PROPERTIES_2_KHR: return sizeof(VkDisplayModeProperties2KHR);
    case VK_STRUCTURE_TYPE_DISPLAY_MODE_STEREO_PROPERTIES_NV: return sizeof(VkDisplayModeStereoPropertiesNV);
    case VK_STRUCTURE_TYPE_DISPLAY_PLANE_INFO_2_KHR: return sizeof(VkDisplayPlaneInfo2KHR);
    case VK_STRUCTURE_TYPE_DISPLAY_PLANE_CAPABILITIES_2_KHR: return sizeof(VkDisplayPlaneCapabilities2KHR);
    case VK_STRUCTURE_TYPE_SHARED_PRESENT_SURFACE_CAPABILITIES_KHR: return sizeof(VkSharedPresentSurfaceCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: return sizeof(VkPhysicalDevice16BitStorageFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_PROPERTIES: return sizeof(VkPhysicalDeviceSubgroupProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: return sizeof(VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures);
    case VK_STRUCTURE_TYPE_BUFFER_MEMORY_REQUIREMENTS_INFO_2: return sizeof(VkBufferMemoryRequirementsInfo2);
    case VK_STRUCTURE_TYPE_DEVICE_BUFFER_MEMORY_REQUIREMENTS: return sizeof(VkDeviceBufferMemoryRequirements);
    case VK_STRUCTURE_TYPE_IMAGE_MEMORY_REQUIREMENTS_INFO_2: return sizeof(VkImageMemoryRequirementsInfo2);
    case VK_STRUCTURE_TYPE_IMAGE_SPARSE_MEMORY_REQUIREMENTS_INFO_2: return sizeof(VkImageSparseMemoryRequirementsInfo2);
    case VK_STRUCTURE_TYPE_DEVICE_IMAGE_MEMORY_REQUIREMENTS: return sizeof(VkDeviceImageMemoryRequirements);
    case VK_STRUCTURE_TYPE_MEMORY_REQUIREMENTS_2: return sizeof(VkMemoryRequirements2);
    case VK_STRUCTURE_TYPE_SPARSE_IMAGE_MEMORY_REQUIREMENTS_2: return sizeof(VkSparseImageMemoryRequirements2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_POINT_CLIPPING_PROPERTIES: return sizeof(VkPhysicalDevicePointClippingProperties);
    case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_REQUIREMENTS: return sizeof(VkMemoryDedicatedRequirements);
    case VK_STRUCTURE_TYPE_MEMORY_DEDICATED_ALLOCATE_INFO: return sizeof(VkMemoryDedicatedAllocateInfo);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_USAGE_CREATE_INFO: return sizeof(VkImageViewUsageCreateInfo);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_SLICED_CREATE_INFO_EXT: return sizeof(VkImageViewSlicedCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_TESSELLATION_DOMAIN_ORIGIN_STATE_CREATE_INFO: return sizeof(VkPipelineTessellationDomainOriginStateCreateInfo);
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_INFO: return sizeof(VkSamplerYcbcrConversionInfo);
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_CREATE_INFO: return sizeof(VkSamplerYcbcrConversionCreateInfo);
    case VK_STRUCTURE_TYPE_BIND_IMAGE_PLANE_MEMORY_INFO: return sizeof(VkBindImagePlaneMemoryInfo);
    case VK_STRUCTURE_TYPE_IMAGE_PLANE_MEMORY_REQUIREMENTS_INFO: return sizeof(VkImagePlaneMemoryRequirementsInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: return sizeof(VkPhysicalDeviceSamplerYcbcrConversionFeatures);
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_IMAGE_FORMAT_PROPERTIES: return sizeof(VkSamplerYcbcrConversionImageFormatProperties);
    case VK_STRUCTURE_TYPE_TEXTURE_LOD_GATHER_FORMAT_PROPERTIES_AMD: return sizeof(VkTextureLODGatherFormatPropertiesAMD);
    case VK_STRUCTURE_TYPE_CONDITIONAL_RENDERING_BEGIN_INFO_EXT: return sizeof(VkConditionalRenderingBeginInfoEXT);
    case VK_STRUCTURE_TYPE_PROTECTED_SUBMIT_INFO: return sizeof(VkProtectedSubmitInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: return sizeof(VkPhysicalDeviceProtectedMemoryFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_PROPERTIES: return sizeof(VkPhysicalDeviceProtectedMemoryProperties);
    case VK_STRUCTURE_TYPE_DEVICE_QUEUE_INFO_2: return sizeof(VkDeviceQueueInfo2);
    case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_TO_COLOR_STATE_CREATE_INFO_NV: return sizeof(VkPipelineCoverageToColorStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_FILTER_MINMAX_PROPERTIES: return sizeof(VkPhysicalDeviceSamplerFilterMinmaxProperties);
    case VK_STRUCTURE_TYPE_SAMPLE_LOCATIONS_INFO_EXT: return sizeof(VkSampleLocationsInfoEXT);
    case VK_STRUCTURE_TYPE_RENDER_PASS_SAMPLE_LOCATIONS_BEGIN_INFO_EXT: return sizeof(VkRenderPassSampleLocationsBeginInfoEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_SAMPLE_LOCATIONS_STATE_CREATE_INFO_EXT: return sizeof(VkPipelineSampleLocationsStateCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLE_LOCATIONS_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceSampleLocationsPropertiesEXT);
    case VK_STRUCTURE_TYPE_MULTISAMPLE_PROPERTIES_EXT: return sizeof(VkMultisamplePropertiesEXT);
    case VK_STRUCTURE_TYPE_SAMPLER_REDUCTION_MODE_CREATE_INFO: return sizeof(VkSamplerReductionModeCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: return sizeof(VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT: return sizeof(VkPhysicalDeviceMultiDrawFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceBlendOperationAdvancedPropertiesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_COLOR_BLEND_ADVANCED_STATE_CREATE_INFO_EXT: return sizeof(VkPipelineColorBlendAdvancedStateCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: return sizeof(VkPhysicalDeviceInlineUniformBlockFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_PROPERTIES: return sizeof(VkPhysicalDeviceInlineUniformBlockProperties);
    case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_INLINE_UNIFORM_BLOCK: return sizeof(VkWriteDescriptorSetInlineUniformBlock);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_POOL_INLINE_UNIFORM_BLOCK_CREATE_INFO: return sizeof(VkDescriptorPoolInlineUniformBlockCreateInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_MODULATION_STATE_CREATE_INFO_NV: return sizeof(VkPipelineCoverageModulationStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_IMAGE_FORMAT_LIST_CREATE_INFO: return sizeof(VkImageFormatListCreateInfo);
    case VK_STRUCTURE_TYPE_VALIDATION_CACHE_CREATE_INFO_EXT: return sizeof(VkValidationCacheCreateInfoEXT);
    case VK_STRUCTURE_TYPE_SHADER_MODULE_VALIDATION_CACHE_CREATE_INFO_EXT: return sizeof(VkShaderModuleValidationCacheCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_3_PROPERTIES: return sizeof(VkPhysicalDeviceMaintenance3Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: return sizeof(VkPhysicalDeviceMaintenance4Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_PROPERTIES: return sizeof(VkPhysicalDeviceMaintenance4Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES: return sizeof(VkPhysicalDeviceMaintenance5Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_PROPERTIES: return sizeof(VkPhysicalDeviceMaintenance5Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES: return sizeof(VkPhysicalDeviceMaintenance6Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_PROPERTIES: return sizeof(VkPhysicalDeviceMaintenance6Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR: return sizeof(VkPhysicalDeviceMaintenance7FeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceMaintenance7PropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_LIST_KHR: return sizeof(VkPhysicalDeviceLayeredApiPropertiesListKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceLayeredApiPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_API_VULKAN_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceLayeredApiVulkanPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR: return sizeof(VkPhysicalDeviceMaintenance8FeaturesKHR);
    case VK_STRUCTURE_TYPE_RENDERING_AREA_INFO: return sizeof(VkRenderingAreaInfo);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_SUPPORT: return sizeof(VkDescriptorSetLayoutSupport);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: return sizeof(VkPhysicalDeviceShaderDrawParametersFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: return sizeof(VkPhysicalDeviceShaderFloat16Int8Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FLOAT_CONTROLS_PROPERTIES: return sizeof(VkPhysicalDeviceFloatControlsProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: return sizeof(VkPhysicalDeviceHostQueryResetFeatures);
    case VK_STRUCTURE_TYPE_DEVICE_QUEUE_GLOBAL_PRIORITY_CREATE_INFO: return sizeof(VkDeviceQueueGlobalPriorityCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES: return sizeof(VkPhysicalDeviceGlobalPriorityQueryFeatures);
    case VK_STRUCTURE_TYPE_QUEUE_FAMILY_GLOBAL_PRIORITY_PROPERTIES: return sizeof(VkQueueFamilyGlobalPriorityProperties);
    case VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_NAME_INFO_EXT: return sizeof(VkDebugUtilsObjectNameInfoEXT);
    case VK_STRUCTURE_TYPE_DEBUG_UTILS_OBJECT_TAG_INFO_EXT: return sizeof(VkDebugUtilsObjectTagInfoEXT);
    case VK_STRUCTURE_TYPE_DEBUG_UTILS_LABEL_EXT: return sizeof(VkDebugUtilsLabelEXT);
    case VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CREATE_INFO_EXT: return sizeof(VkDebugUtilsMessengerCreateInfoEXT);
    case VK_STRUCTURE_TYPE_DEBUG_UTILS_MESSENGER_CALLBACK_DATA_EXT: return sizeof(VkDebugUtilsMessengerCallbackDataEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: return sizeof(VkPhysicalDeviceDeviceMemoryReportFeaturesEXT);
    case VK_STRUCTURE_TYPE_DEVICE_DEVICE_MEMORY_REPORT_CREATE_INFO_EXT: return sizeof(VkDeviceDeviceMemoryReportCreateInfoEXT);
    case VK_STRUCTURE_TYPE_DEVICE_MEMORY_REPORT_CALLBACK_DATA_EXT: return sizeof(VkDeviceMemoryReportCallbackDataEXT);
    case VK_STRUCTURE_TYPE_IMPORT_MEMORY_HOST_POINTER_INFO_EXT: return sizeof(VkImportMemoryHostPointerInfoEXT);
    case VK_STRUCTURE_TYPE_MEMORY_HOST_POINTER_PROPERTIES_EXT: return sizeof(VkMemoryHostPointerPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_HOST_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceExternalMemoryHostPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONSERVATIVE_RASTERIZATION_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceConservativeRasterizationPropertiesEXT);
    case VK_STRUCTURE_TYPE_CALIBRATED_TIMESTAMP_INFO_KHR: return sizeof(VkCalibratedTimestampInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_AMD: return sizeof(VkPhysicalDeviceShaderCorePropertiesAMD);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_2_AMD: return sizeof(VkPhysicalDeviceShaderCoreProperties2AMD);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_CONSERVATIVE_STATE_CREATE_INFO_EXT: return sizeof(VkPipelineRasterizationConservativeStateCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: return sizeof(VkPhysicalDeviceDescriptorIndexingFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_PROPERTIES: return sizeof(VkPhysicalDeviceDescriptorIndexingProperties);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_BINDING_FLAGS_CREATE_INFO: return sizeof(VkDescriptorSetLayoutBindingFlagsCreateInfo);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_ALLOCATE_INFO: return sizeof(VkDescriptorSetVariableDescriptorCountAllocateInfo);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_VARIABLE_DESCRIPTOR_COUNT_LAYOUT_SUPPORT: return sizeof(VkDescriptorSetVariableDescriptorCountLayoutSupport);
    case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_2: return sizeof(VkAttachmentDescription2);
    case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_2: return sizeof(VkAttachmentReference2);
    case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_2: return sizeof(VkSubpassDescription2);
    case VK_STRUCTURE_TYPE_SUBPASS_DEPENDENCY_2: return sizeof(VkSubpassDependency2);
    case VK_STRUCTURE_TYPE_RENDER_PASS_CREATE_INFO_2: return sizeof(VkRenderPassCreateInfo2);
    case VK_STRUCTURE_TYPE_SUBPASS_BEGIN_INFO: return sizeof(VkSubpassBeginInfo);
    case VK_STRUCTURE_TYPE_SUBPASS_END_INFO: return sizeof(VkSubpassEndInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: return sizeof(VkPhysicalDeviceTimelineSemaphoreFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_PROPERTIES: return sizeof(VkPhysicalDeviceTimelineSemaphoreProperties);
    case VK_STRUCTURE_TYPE_SEMAPHORE_TYPE_CREATE_INFO: return sizeof(VkSemaphoreTypeCreateInfo);
    case VK_STRUCTURE_TYPE_TIMELINE_SEMAPHORE_SUBMIT_INFO: return sizeof(VkTimelineSemaphoreSubmitInfo);
    case VK_STRUCTURE_TYPE_SEMAPHORE_WAIT_INFO: return sizeof(VkSemaphoreWaitInfo);
    case VK_STRUCTURE_TYPE_SEMAPHORE_SIGNAL_INFO: return sizeof(VkSemaphoreSignalInfo);
    case VK_STRUCTURE_TYPE_PIPELINE_VERTEX_INPUT_DIVISOR_STATE_CREATE_INFO: return sizeof(VkPipelineVertexInputDivisorStateCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceVertexAttributeDivisorPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_PROPERTIES: return sizeof(VkPhysicalDeviceVertexAttributeDivisorProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PCI_BUS_INFO_PROPERTIES_EXT: return sizeof(VkPhysicalDevicePCIBusInfoPropertiesEXT);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_CONDITIONAL_RENDERING_INFO_EXT: return sizeof(VkCommandBufferInheritanceConditionalRenderingInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: return sizeof(VkPhysicalDevice8BitStorageFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: return sizeof(VkPhysicalDeviceConditionalRenderingFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: return sizeof(VkPhysicalDeviceVulkanMemoryModelFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: return sizeof(VkPhysicalDeviceShaderAtomicInt64Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderAtomicFloatFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES: return sizeof(VkPhysicalDeviceVertexAttributeDivisorFeatures);
    case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_NV: return sizeof(VkQueueFamilyCheckpointPropertiesNV);
    case VK_STRUCTURE_TYPE_CHECKPOINT_DATA_NV: return sizeof(VkCheckpointDataNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_STENCIL_RESOLVE_PROPERTIES: return sizeof(VkPhysicalDeviceDepthStencilResolveProperties);
    case VK_STRUCTURE_TYPE_SUBPASS_DESCRIPTION_DEPTH_STENCIL_RESOLVE: return sizeof(VkSubpassDescriptionDepthStencilResolve);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_ASTC_DECODE_MODE_EXT: return sizeof(VkImageViewASTCDecodeModeEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: return sizeof(VkPhysicalDeviceASTCDecodeFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: return sizeof(VkPhysicalDeviceTransformFeedbackFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceTransformFeedbackPropertiesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_STATE_STREAM_CREATE_INFO_EXT: return sizeof(VkPipelineRasterizationStateStreamCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: return sizeof(VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV);
    case VK_STRUCTURE_TYPE_PIPELINE_REPRESENTATIVE_FRAGMENT_TEST_STATE_CREATE_INFO_NV: return sizeof(VkPipelineRepresentativeFragmentTestStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: return sizeof(VkPhysicalDeviceExclusiveScissorFeaturesNV);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_EXCLUSIVE_SCISSOR_STATE_CREATE_INFO_NV: return sizeof(VkPipelineViewportExclusiveScissorStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: return sizeof(VkPhysicalDeviceCornerSampledImageFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR: return sizeof(VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceComputeShaderDerivativesPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: return sizeof(VkPhysicalDeviceShaderImageFootprintFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: return sizeof(VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV: return sizeof(VkPhysicalDeviceCopyMemoryIndirectFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_PROPERTIES_NV: return sizeof(VkPhysicalDeviceCopyMemoryIndirectPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV: return sizeof(VkPhysicalDeviceMemoryDecompressionFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_PROPERTIES_NV: return sizeof(VkPhysicalDeviceMemoryDecompressionPropertiesNV);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_SHADING_RATE_IMAGE_STATE_CREATE_INFO_NV: return sizeof(VkPipelineViewportShadingRateImageStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: return sizeof(VkPhysicalDeviceShadingRateImageFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_PROPERTIES_NV: return sizeof(VkPhysicalDeviceShadingRateImagePropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI: return sizeof(VkPhysicalDeviceInvocationMaskFeaturesHUAWEI);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_COARSE_SAMPLE_ORDER_STATE_CREATE_INFO_NV: return sizeof(VkPipelineViewportCoarseSampleOrderStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: return sizeof(VkPhysicalDeviceMeshShaderFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_NV: return sizeof(VkPhysicalDeviceMeshShaderPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT: return sizeof(VkPhysicalDeviceMeshShaderFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceMeshShaderPropertiesEXT);
    case VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_NV: return sizeof(VkRayTracingShaderGroupCreateInfoNV);
    case VK_STRUCTURE_TYPE_RAY_TRACING_SHADER_GROUP_CREATE_INFO_KHR: return sizeof(VkRayTracingShaderGroupCreateInfoKHR);
    case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_NV: return sizeof(VkRayTracingPipelineCreateInfoNV);
    case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_CREATE_INFO_KHR: return sizeof(VkRayTracingPipelineCreateInfoKHR);
    case VK_STRUCTURE_TYPE_GEOMETRY_TRIANGLES_NV: return sizeof(VkGeometryTrianglesNV);
    case VK_STRUCTURE_TYPE_GEOMETRY_AABB_NV: return sizeof(VkGeometryAABBNV);
    case VK_STRUCTURE_TYPE_GEOMETRY_NV: return sizeof(VkGeometryNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_INFO_NV: return sizeof(VkAccelerationStructureInfoNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_NV: return sizeof(VkAccelerationStructureCreateInfoNV);
    case VK_STRUCTURE_TYPE_BIND_ACCELERATION_STRUCTURE_MEMORY_INFO_NV: return sizeof(VkBindAccelerationStructureMemoryInfoNV);
    case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_KHR: return sizeof(VkWriteDescriptorSetAccelerationStructureKHR);
    case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_ACCELERATION_STRUCTURE_NV: return sizeof(VkWriteDescriptorSetAccelerationStructureNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MEMORY_REQUIREMENTS_INFO_NV: return sizeof(VkAccelerationStructureMemoryRequirementsInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR: return sizeof(VkPhysicalDeviceAccelerationStructureFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR: return sizeof(VkPhysicalDeviceRayTracingPipelineFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR: return sizeof(VkPhysicalDeviceRayQueryFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceAccelerationStructurePropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceRayTracingPipelinePropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PROPERTIES_NV: return sizeof(VkPhysicalDeviceRayTracingPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR: return sizeof(VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR);
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_EXT: return sizeof(VkDrmFormatModifierPropertiesListEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_DRM_FORMAT_MODIFIER_INFO_EXT: return sizeof(VkPhysicalDeviceImageDrmFormatModifierInfoEXT);
    case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_LIST_CREATE_INFO_EXT: return sizeof(VkImageDrmFormatModifierListCreateInfoEXT);
    case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_EXPLICIT_CREATE_INFO_EXT: return sizeof(VkImageDrmFormatModifierExplicitCreateInfoEXT);
    case VK_STRUCTURE_TYPE_IMAGE_DRM_FORMAT_MODIFIER_PROPERTIES_EXT: return sizeof(VkImageDrmFormatModifierPropertiesEXT);
    case VK_STRUCTURE_TYPE_IMAGE_STENCIL_USAGE_CREATE_INFO: return sizeof(VkImageStencilUsageCreateInfo);
    case VK_STRUCTURE_TYPE_DEVICE_MEMORY_OVERALLOCATION_CREATE_INFO_AMD: return sizeof(VkDeviceMemoryOverallocationCreateInfoAMD);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: return sizeof(VkPhysicalDeviceFragmentDensityMapFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: return sizeof(VkPhysicalDeviceFragmentDensityMap2FeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM: return sizeof(VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceFragmentDensityMapPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceFragmentDensityMap2PropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_PROPERTIES_QCOM: return sizeof(VkPhysicalDeviceFragmentDensityMapOffsetPropertiesQCOM);
    case VK_STRUCTURE_TYPE_RENDER_PASS_FRAGMENT_DENSITY_MAP_CREATE_INFO_EXT: return sizeof(VkRenderPassFragmentDensityMapCreateInfoEXT);
    case VK_STRUCTURE_TYPE_SUBPASS_FRAGMENT_DENSITY_MAP_OFFSET_END_INFO_QCOM: return sizeof(VkSubpassFragmentDensityMapOffsetEndInfoQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: return sizeof(VkPhysicalDeviceScalarBlockLayoutFeatures);
    case VK_STRUCTURE_TYPE_SURFACE_PROTECTED_CAPABILITIES_KHR: return sizeof(VkSurfaceProtectedCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: return sizeof(VkPhysicalDeviceUniformBufferStandardLayoutFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: return sizeof(VkPhysicalDeviceDepthClipEnableFeaturesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_DEPTH_CLIP_STATE_CREATE_INFO_EXT: return sizeof(VkPipelineRasterizationDepthClipStateCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_BUDGET_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceMemoryBudgetPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: return sizeof(VkPhysicalDeviceMemoryPriorityFeaturesEXT);
    case VK_STRUCTURE_TYPE_MEMORY_PRIORITY_ALLOCATE_INFO_EXT: return sizeof(VkMemoryPriorityAllocateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT: return sizeof(VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: return sizeof(VkPhysicalDeviceBufferDeviceAddressFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: return sizeof(VkPhysicalDeviceBufferDeviceAddressFeaturesEXT);
    case VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_INFO: return sizeof(VkBufferDeviceAddressInfo);
    case VK_STRUCTURE_TYPE_BUFFER_OPAQUE_CAPTURE_ADDRESS_CREATE_INFO: return sizeof(VkBufferOpaqueCaptureAddressCreateInfo);
    case VK_STRUCTURE_TYPE_BUFFER_DEVICE_ADDRESS_CREATE_INFO_EXT: return sizeof(VkBufferDeviceAddressCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_IMAGE_FORMAT_INFO_EXT: return sizeof(VkPhysicalDeviceImageViewImageFormatInfoEXT);
    case VK_STRUCTURE_TYPE_FILTER_CUBIC_IMAGE_VIEW_IMAGE_FORMAT_PROPERTIES_EXT: return sizeof(VkFilterCubicImageViewImageFormatPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: return sizeof(VkPhysicalDeviceImagelessFramebufferFeatures);
    case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENTS_CREATE_INFO: return sizeof(VkFramebufferAttachmentsCreateInfo);
    case VK_STRUCTURE_TYPE_FRAMEBUFFER_ATTACHMENT_IMAGE_INFO: return sizeof(VkFramebufferAttachmentImageInfo);
    case VK_STRUCTURE_TYPE_RENDER_PASS_ATTACHMENT_BEGIN_INFO: return sizeof(VkRenderPassAttachmentBeginInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: return sizeof(VkPhysicalDeviceTextureCompressionASTCHDRFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: return sizeof(VkPhysicalDeviceCooperativeMatrixFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_NV: return sizeof(VkPhysicalDeviceCooperativeMatrixPropertiesNV);
    case VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_NV: return sizeof(VkCooperativeMatrixPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: return sizeof(VkPhysicalDeviceYcbcrImageArraysFeaturesEXT);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_HANDLE_INFO_NVX: return sizeof(VkImageViewHandleInfoNVX);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_ADDRESS_PROPERTIES_NVX: return sizeof(VkImageViewAddressPropertiesNVX);
    case VK_STRUCTURE_TYPE_PIPELINE_CREATION_FEEDBACK_CREATE_INFO: return sizeof(VkPipelineCreationFeedbackCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV: return sizeof(VkPhysicalDevicePresentBarrierFeaturesNV);
    case VK_STRUCTURE_TYPE_SURFACE_CAPABILITIES_PRESENT_BARRIER_NV: return sizeof(VkSurfaceCapabilitiesPresentBarrierNV);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_BARRIER_CREATE_INFO_NV: return sizeof(VkSwapchainPresentBarrierCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: return sizeof(VkPhysicalDevicePerformanceQueryFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_PROPERTIES_KHR: return sizeof(VkPhysicalDevicePerformanceQueryPropertiesKHR);
    case VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_KHR: return sizeof(VkPerformanceCounterKHR);
    case VK_STRUCTURE_TYPE_PERFORMANCE_COUNTER_DESCRIPTION_KHR: return sizeof(VkPerformanceCounterDescriptionKHR);
    case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_CREATE_INFO_KHR: return sizeof(VkQueryPoolPerformanceCreateInfoKHR);
    case VK_STRUCTURE_TYPE_ACQUIRE_PROFILING_LOCK_INFO_KHR: return sizeof(VkAcquireProfilingLockInfoKHR);
    case VK_STRUCTURE_TYPE_PERFORMANCE_QUERY_SUBMIT_INFO_KHR: return sizeof(VkPerformanceQuerySubmitInfoKHR);
    case VK_STRUCTURE_TYPE_HEADLESS_SURFACE_CREATE_INFO_EXT: return sizeof(VkHeadlessSurfaceCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: return sizeof(VkPhysicalDeviceCoverageReductionModeFeaturesNV);
    case VK_STRUCTURE_TYPE_PIPELINE_COVERAGE_REDUCTION_STATE_CREATE_INFO_NV: return sizeof(VkPipelineCoverageReductionStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_FRAMEBUFFER_MIXED_SAMPLES_COMBINATION_NV: return sizeof(VkFramebufferMixedSamplesCombinationNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: return sizeof(VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL);
    case VK_STRUCTURE_TYPE_INITIALIZE_PERFORMANCE_API_INFO_INTEL: return sizeof(VkInitializePerformanceApiInfoINTEL);
    case VK_STRUCTURE_TYPE_QUERY_POOL_PERFORMANCE_QUERY_CREATE_INFO_INTEL: return sizeof(VkQueryPoolPerformanceQueryCreateInfoINTEL);
    case VK_STRUCTURE_TYPE_PERFORMANCE_MARKER_INFO_INTEL: return sizeof(VkPerformanceMarkerInfoINTEL);
    case VK_STRUCTURE_TYPE_PERFORMANCE_STREAM_MARKER_INFO_INTEL: return sizeof(VkPerformanceStreamMarkerInfoINTEL);
    case VK_STRUCTURE_TYPE_PERFORMANCE_OVERRIDE_INFO_INTEL: return sizeof(VkPerformanceOverrideInfoINTEL);
    case VK_STRUCTURE_TYPE_PERFORMANCE_CONFIGURATION_ACQUIRE_INFO_INTEL: return sizeof(VkPerformanceConfigurationAcquireInfoINTEL);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: return sizeof(VkPhysicalDeviceShaderClockFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES: return sizeof(VkPhysicalDeviceIndexTypeUint8Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_PROPERTIES_NV: return sizeof(VkPhysicalDeviceShaderSMBuiltinsPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: return sizeof(VkPhysicalDeviceShaderSMBuiltinsFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: return sizeof(VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: return sizeof(VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures);
    case VK_STRUCTURE_TYPE_ATTACHMENT_REFERENCE_STENCIL_LAYOUT: return sizeof(VkAttachmentReferenceStencilLayout);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: return sizeof(VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT);
    case VK_STRUCTURE_TYPE_ATTACHMENT_DESCRIPTION_STENCIL_LAYOUT: return sizeof(VkAttachmentDescriptionStencilLayout);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: return sizeof(VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_INFO_KHR: return sizeof(VkPipelineInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_PROPERTIES_KHR: return sizeof(VkPipelineExecutablePropertiesKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INFO_KHR: return sizeof(VkPipelineExecutableInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_STATISTIC_KHR: return sizeof(VkPipelineExecutableStatisticKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_EXECUTABLE_INTERNAL_REPRESENTATION_KHR: return sizeof(VkPipelineExecutableInternalRepresentationKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: return sizeof(VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: return sizeof(VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_PROPERTIES: return sizeof(VkPhysicalDeviceTexelBufferAlignmentProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: return sizeof(VkPhysicalDeviceSubgroupSizeControlFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_PROPERTIES: return sizeof(VkPhysicalDeviceSubgroupSizeControlProperties);
    case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_REQUIRED_SUBGROUP_SIZE_CREATE_INFO: return sizeof(VkPipelineShaderStageRequiredSubgroupSizeCreateInfo);
    case VK_STRUCTURE_TYPE_SUBPASS_SHADING_PIPELINE_CREATE_INFO_HUAWEI: return sizeof(VkSubpassShadingPipelineCreateInfoHUAWEI);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_PROPERTIES_HUAWEI: return sizeof(VkPhysicalDeviceSubpassShadingPropertiesHUAWEI);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_PROPERTIES_HUAWEI: return sizeof(VkPhysicalDeviceClusterCullingShaderPropertiesHUAWEI);
    case VK_STRUCTURE_TYPE_MEMORY_OPAQUE_CAPTURE_ADDRESS_ALLOCATE_INFO: return sizeof(VkMemoryOpaqueCaptureAddressAllocateInfo);
    case VK_STRUCTURE_TYPE_DEVICE_MEMORY_OPAQUE_CAPTURE_ADDRESS_INFO: return sizeof(VkDeviceMemoryOpaqueCaptureAddressInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES: return sizeof(VkPhysicalDeviceLineRasterizationFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_PROPERTIES: return sizeof(VkPhysicalDeviceLineRasterizationProperties);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_LINE_STATE_CREATE_INFO: return sizeof(VkPipelineRasterizationLineStateCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: return sizeof(VkPhysicalDevicePipelineCreationCacheControlFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: return sizeof(VkPhysicalDeviceVulkan11Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_PROPERTIES: return sizeof(VkPhysicalDeviceVulkan11Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: return sizeof(VkPhysicalDeviceVulkan12Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_PROPERTIES: return sizeof(VkPhysicalDeviceVulkan12Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: return sizeof(VkPhysicalDeviceVulkan13Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_PROPERTIES: return sizeof(VkPhysicalDeviceVulkan13Properties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES: return sizeof(VkPhysicalDeviceVulkan14Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_PROPERTIES: return sizeof(VkPhysicalDeviceVulkan14Properties);
    case VK_STRUCTURE_TYPE_PIPELINE_COMPILER_CONTROL_CREATE_INFO_AMD: return sizeof(VkPipelineCompilerControlCreateInfoAMD);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: return sizeof(VkPhysicalDeviceCoherentMemoryFeaturesAMD);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TOOL_PROPERTIES: return sizeof(VkPhysicalDeviceToolProperties);
    case VK_STRUCTURE_TYPE_SAMPLER_CUSTOM_BORDER_COLOR_CREATE_INFO_EXT: return sizeof(VkSamplerCustomBorderColorCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceCustomBorderColorPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: return sizeof(VkPhysicalDeviceCustomBorderColorFeaturesEXT);
    case VK_STRUCTURE_TYPE_SAMPLER_BORDER_COLOR_COMPONENT_MAPPING_CREATE_INFO_EXT: return sizeof(VkSamplerBorderColorComponentMappingCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT: return sizeof(VkPhysicalDeviceBorderColorSwizzleFeaturesEXT);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_TRIANGLES_DATA_KHR: return sizeof(VkAccelerationStructureGeometryTrianglesDataKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_AABBS_DATA_KHR: return sizeof(VkAccelerationStructureGeometryAabbsDataKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_INSTANCES_DATA_KHR: return sizeof(VkAccelerationStructureGeometryInstancesDataKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_LINEAR_SWEPT_SPHERES_DATA_NV: return sizeof(VkAccelerationStructureGeometryLinearSweptSpheresDataNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_SPHERES_DATA_NV: return sizeof(VkAccelerationStructureGeometrySpheresDataNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_KHR: return sizeof(VkAccelerationStructureGeometryKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_GEOMETRY_INFO_KHR: return sizeof(VkAccelerationStructureBuildGeometryInfoKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CREATE_INFO_KHR: return sizeof(VkAccelerationStructureCreateInfoKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_DEVICE_ADDRESS_INFO_KHR: return sizeof(VkAccelerationStructureDeviceAddressInfoKHR);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_VERSION_INFO_KHR: return sizeof(VkAccelerationStructureVersionInfoKHR);
    case VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_INFO_KHR: return sizeof(VkCopyAccelerationStructureInfoKHR);
    case VK_STRUCTURE_TYPE_COPY_ACCELERATION_STRUCTURE_TO_MEMORY_INFO_KHR: return sizeof(VkCopyAccelerationStructureToMemoryInfoKHR);
    case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_ACCELERATION_STRUCTURE_INFO_KHR: return sizeof(VkCopyMemoryToAccelerationStructureInfoKHR);
    case VK_STRUCTURE_TYPE_RAY_TRACING_PIPELINE_INTERFACE_CREATE_INFO_KHR: return sizeof(VkRayTracingPipelineInterfaceCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_LIBRARY_CREATE_INFO_KHR: return sizeof(VkPipelineLibraryCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: return sizeof(VkPhysicalDeviceExtendedDynamicStateFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: return sizeof(VkPhysicalDeviceExtendedDynamicState2FeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT: return sizeof(VkPhysicalDeviceExtendedDynamicState3FeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceExtendedDynamicState3PropertiesEXT);
    case VK_STRUCTURE_TYPE_RENDER_PASS_TRANSFORM_BEGIN_INFO_QCOM: return sizeof(VkRenderPassTransformBeginInfoQCOM);
    case VK_STRUCTURE_TYPE_COPY_COMMAND_TRANSFORM_INFO_QCOM: return sizeof(VkCopyCommandTransformInfoQCOM);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDER_PASS_TRANSFORM_INFO_QCOM: return sizeof(VkCommandBufferInheritanceRenderPassTransformInfoQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV: return sizeof(VkPhysicalDevicePartitionedAccelerationStructureFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_PROPERTIES_NV: return sizeof(VkPhysicalDevicePartitionedAccelerationStructurePropertiesNV);
    case VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_FLAGS_NV: return sizeof(VkPartitionedAccelerationStructureFlagsNV);
    case VK_STRUCTURE_TYPE_WRITE_DESCRIPTOR_SET_PARTITIONED_ACCELERATION_STRUCTURE_NV: return sizeof(VkWriteDescriptorSetPartitionedAccelerationStructureNV);
    case VK_STRUCTURE_TYPE_PARTITIONED_ACCELERATION_STRUCTURE_INSTANCES_INPUT_NV: return sizeof(VkPartitionedAccelerationStructureInstancesInputNV);
    case VK_STRUCTURE_TYPE_BUILD_PARTITIONED_ACCELERATION_STRUCTURE_INFO_NV: return sizeof(VkBuildPartitionedAccelerationStructureInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: return sizeof(VkPhysicalDeviceDiagnosticsConfigFeaturesNV);
    case VK_STRUCTURE_TYPE_DEVICE_DIAGNOSTICS_CONFIG_CREATE_INFO_NV: return sizeof(VkDeviceDiagnosticsConfigCreateInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: return sizeof(VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR: return sizeof(VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: return sizeof(VkPhysicalDeviceRobustness2FeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceRobustness2PropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: return sizeof(VkPhysicalDeviceImageRobustnessFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR: return sizeof(VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: return sizeof(VkPhysicalDevice4444FormatsFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI: return sizeof(VkPhysicalDeviceSubpassShadingFeaturesHUAWEI);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI: return sizeof(VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_VRS_FEATURES_HUAWEI: return sizeof(VkPhysicalDeviceClusterCullingShaderVrsFeaturesHUAWEI);
    case VK_STRUCTURE_TYPE_BUFFER_COPY_2: return sizeof(VkBufferCopy2);
    case VK_STRUCTURE_TYPE_IMAGE_COPY_2: return sizeof(VkImageCopy2);
    case VK_STRUCTURE_TYPE_IMAGE_BLIT_2: return sizeof(VkImageBlit2);
    case VK_STRUCTURE_TYPE_BUFFER_IMAGE_COPY_2: return sizeof(VkBufferImageCopy2);
    case VK_STRUCTURE_TYPE_IMAGE_RESOLVE_2: return sizeof(VkImageResolve2);
    case VK_STRUCTURE_TYPE_COPY_BUFFER_INFO_2: return sizeof(VkCopyBufferInfo2);
    case VK_STRUCTURE_TYPE_COPY_IMAGE_INFO_2: return sizeof(VkCopyImageInfo2);
    case VK_STRUCTURE_TYPE_BLIT_IMAGE_INFO_2: return sizeof(VkBlitImageInfo2);
    case VK_STRUCTURE_TYPE_COPY_BUFFER_TO_IMAGE_INFO_2: return sizeof(VkCopyBufferToImageInfo2);
    case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_BUFFER_INFO_2: return sizeof(VkCopyImageToBufferInfo2);
    case VK_STRUCTURE_TYPE_RESOLVE_IMAGE_INFO_2: return sizeof(VkResolveImageInfo2);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT);
    case VK_STRUCTURE_TYPE_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: return sizeof(VkFragmentShadingRateAttachmentInfoKHR);
    case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_STATE_CREATE_INFO_KHR: return sizeof(VkPipelineFragmentShadingRateStateCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: return sizeof(VkPhysicalDeviceFragmentShadingRateFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceFragmentShadingRatePropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_KHR: return sizeof(VkPhysicalDeviceFragmentShadingRateKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: return sizeof(VkPhysicalDeviceShaderTerminateInvocationFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV: return sizeof(VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_PROPERTIES_NV: return sizeof(VkPhysicalDeviceFragmentShadingRateEnumsPropertiesNV);
    case VK_STRUCTURE_TYPE_PIPELINE_FRAGMENT_SHADING_RATE_ENUM_STATE_CREATE_INFO_NV: return sizeof(VkPipelineFragmentShadingRateEnumStateCreateInfoNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_BUILD_SIZES_INFO_KHR: return sizeof(VkAccelerationStructureBuildSizesInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT: return sizeof(VkPhysicalDeviceImage2DViewOf3DFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT: return sizeof(VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT: return sizeof(VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT: return sizeof(VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceLegacyVertexAttributesPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT: return sizeof(VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT);
    case VK_STRUCTURE_TYPE_MUTABLE_DESCRIPTOR_TYPE_CREATE_INFO_EXT: return sizeof(VkMutableDescriptorTypeCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT: return sizeof(VkPhysicalDeviceDepthClipControlFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT: return sizeof(VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceDeviceGeneratedCommandsPropertiesEXT);
    case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_PIPELINE_INFO_EXT: return sizeof(VkGeneratedCommandsPipelineInfoEXT);
    case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_SHADER_INFO_EXT: return sizeof(VkGeneratedCommandsShaderInfoEXT);
    case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_MEMORY_REQUIREMENTS_INFO_EXT: return sizeof(VkGeneratedCommandsMemoryRequirementsInfoEXT);
    case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_PIPELINE_INFO_EXT: return sizeof(VkIndirectExecutionSetPipelineInfoEXT);
    case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_LAYOUT_INFO_EXT: return sizeof(VkIndirectExecutionSetShaderLayoutInfoEXT);
    case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_SHADER_INFO_EXT: return sizeof(VkIndirectExecutionSetShaderInfoEXT);
    case VK_STRUCTURE_TYPE_INDIRECT_EXECUTION_SET_CREATE_INFO_EXT: return sizeof(VkIndirectExecutionSetCreateInfoEXT);
    case VK_STRUCTURE_TYPE_GENERATED_COMMANDS_INFO_EXT: return sizeof(VkGeneratedCommandsInfoEXT);
    case VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_PIPELINE_EXT: return sizeof(VkWriteIndirectExecutionSetPipelineEXT);
    case VK_STRUCTURE_TYPE_WRITE_INDIRECT_EXECUTION_SET_SHADER_EXT: return sizeof(VkWriteIndirectExecutionSetShaderEXT);
    case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_CREATE_INFO_EXT: return sizeof(VkIndirectCommandsLayoutCreateInfoEXT);
    case VK_STRUCTURE_TYPE_INDIRECT_COMMANDS_LAYOUT_TOKEN_EXT: return sizeof(VkIndirectCommandsLayoutTokenEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLIP_CONTROL_CREATE_INFO_EXT: return sizeof(VkPipelineViewportDepthClipControlCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT: return sizeof(VkPhysicalDeviceDepthClampControlFeaturesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_VIEWPORT_DEPTH_CLAMP_CONTROL_CREATE_INFO_EXT: return sizeof(VkPipelineViewportDepthClampControlCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT: return sizeof(VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV: return sizeof(VkPhysicalDeviceExternalMemoryRDMAFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR: return sizeof(VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR);
    case VK_STRUCTURE_TYPE_VERTEX_INPUT_BINDING_DESCRIPTION_2_EXT: return sizeof(VkVertexInputBindingDescription2EXT);
    case VK_STRUCTURE_TYPE_VERTEX_INPUT_ATTRIBUTE_DESCRIPTION_2_EXT: return sizeof(VkVertexInputAttributeDescription2EXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT: return sizeof(VkPhysicalDeviceColorWriteEnableFeaturesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_COLOR_WRITE_CREATE_INFO_EXT: return sizeof(VkPipelineColorWriteCreateInfoEXT);
    case VK_STRUCTURE_TYPE_MEMORY_BARRIER_2: return sizeof(VkMemoryBarrier2);
    case VK_STRUCTURE_TYPE_IMAGE_MEMORY_BARRIER_2: return sizeof(VkImageMemoryBarrier2);
    case VK_STRUCTURE_TYPE_BUFFER_MEMORY_BARRIER_2: return sizeof(VkBufferMemoryBarrier2);
    case VK_STRUCTURE_TYPE_MEMORY_BARRIER_ACCESS_FLAGS_3_KHR: return sizeof(VkMemoryBarrierAccessFlags3KHR);
    case VK_STRUCTURE_TYPE_DEPENDENCY_INFO: return sizeof(VkDependencyInfo);
    case VK_STRUCTURE_TYPE_SEMAPHORE_SUBMIT_INFO: return sizeof(VkSemaphoreSubmitInfo);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_SUBMIT_INFO: return sizeof(VkCommandBufferSubmitInfo);
    case VK_STRUCTURE_TYPE_SUBMIT_INFO_2: return sizeof(VkSubmitInfo2);
    case VK_STRUCTURE_TYPE_QUEUE_FAMILY_CHECKPOINT_PROPERTIES_2_NV: return sizeof(VkQueueFamilyCheckpointProperties2NV);
    case VK_STRUCTURE_TYPE_CHECKPOINT_DATA_2_NV: return sizeof(VkCheckpointData2NV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: return sizeof(VkPhysicalDeviceSynchronization2Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES: return sizeof(VkPhysicalDeviceHostImageCopyFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_PROPERTIES: return sizeof(VkPhysicalDeviceHostImageCopyProperties);
    case VK_STRUCTURE_TYPE_MEMORY_TO_IMAGE_COPY: return sizeof(VkMemoryToImageCopy);
    case VK_STRUCTURE_TYPE_IMAGE_TO_MEMORY_COPY: return sizeof(VkImageToMemoryCopy);
    case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_IMAGE_INFO: return sizeof(VkCopyMemoryToImageInfo);
    case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_MEMORY_INFO: return sizeof(VkCopyImageToMemoryInfo);
    case VK_STRUCTURE_TYPE_COPY_IMAGE_TO_IMAGE_INFO: return sizeof(VkCopyImageToImageInfo);
    case VK_STRUCTURE_TYPE_HOST_IMAGE_LAYOUT_TRANSITION_INFO: return sizeof(VkHostImageLayoutTransitionInfo);
    case VK_STRUCTURE_TYPE_SUBRESOURCE_HOST_MEMCPY_SIZE: return sizeof(VkSubresourceHostMemcpySize);
    case VK_STRUCTURE_TYPE_HOST_IMAGE_COPY_DEVICE_PERFORMANCE_QUERY: return sizeof(VkHostImageCopyDevicePerformanceQuery);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT: return sizeof(VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT: return sizeof(VkPhysicalDeviceLegacyDitheringFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT: return sizeof(VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT);
    case VK_STRUCTURE_TYPE_SUBPASS_RESOLVE_PERFORMANCE_QUERY_EXT: return sizeof(VkSubpassResolvePerformanceQueryEXT);
    case VK_STRUCTURE_TYPE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_INFO_EXT: return sizeof(VkMultisampledRenderToSingleSampledInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES: return sizeof(VkPhysicalDevicePipelineProtectedAccessFeatures);
    case VK_STRUCTURE_TYPE_QUEUE_FAMILY_VIDEO_PROPERTIES_KHR: return sizeof(VkQueueFamilyVideoPropertiesKHR);
    case VK_STRUCTURE_TYPE_QUEUE_FAMILY_QUERY_RESULT_STATUS_PROPERTIES_KHR: return sizeof(VkQueueFamilyQueryResultStatusPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_PROFILE_LIST_INFO_KHR: return sizeof(VkVideoProfileListInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_FORMAT_INFO_KHR: return sizeof(VkPhysicalDeviceVideoFormatInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_FORMAT_PROPERTIES_KHR: return sizeof(VkVideoFormatPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_CAPABILITIES_KHR: return sizeof(VkVideoEncodeQuantizationMapCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUANTIZATION_MAP_CAPABILITIES_KHR: return sizeof(VkVideoEncodeH264QuantizationMapCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUANTIZATION_MAP_CAPABILITIES_KHR: return sizeof(VkVideoEncodeH265QuantizationMapCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUANTIZATION_MAP_CAPABILITIES_KHR: return sizeof(VkVideoEncodeAV1QuantizationMapCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_FORMAT_QUANTIZATION_MAP_PROPERTIES_KHR: return sizeof(VkVideoFormatQuantizationMapPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_FORMAT_H265_QUANTIZATION_MAP_PROPERTIES_KHR: return sizeof(VkVideoFormatH265QuantizationMapPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_FORMAT_AV1_QUANTIZATION_MAP_PROPERTIES_KHR: return sizeof(VkVideoFormatAV1QuantizationMapPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_PROFILE_INFO_KHR: return sizeof(VkVideoProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_CAPABILITIES_KHR: return sizeof(VkVideoCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_SESSION_MEMORY_REQUIREMENTS_KHR: return sizeof(VkVideoSessionMemoryRequirementsKHR);
    case VK_STRUCTURE_TYPE_BIND_VIDEO_SESSION_MEMORY_INFO_KHR: return sizeof(VkBindVideoSessionMemoryInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_PICTURE_RESOURCE_INFO_KHR: return sizeof(VkVideoPictureResourceInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_REFERENCE_SLOT_INFO_KHR: return sizeof(VkVideoReferenceSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_CAPABILITIES_KHR: return sizeof(VkVideoDecodeCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_USAGE_INFO_KHR: return sizeof(VkVideoDecodeUsageInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_INFO_KHR: return sizeof(VkVideoDecodeInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR: return sizeof(VkPhysicalDeviceVideoMaintenance1FeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR: return sizeof(VkPhysicalDeviceVideoMaintenance2FeaturesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_INLINE_QUERY_INFO_KHR: return sizeof(VkVideoInlineQueryInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PROFILE_INFO_KHR: return sizeof(VkVideoDecodeH264ProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_CAPABILITIES_KHR: return sizeof(VkVideoDecodeH264CapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR: return sizeof(VkVideoDecodeH264SessionParametersAddInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoDecodeH264SessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_INLINE_SESSION_PARAMETERS_INFO_KHR: return sizeof(VkVideoDecodeH264InlineSessionParametersInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_PICTURE_INFO_KHR: return sizeof(VkVideoDecodeH264PictureInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H264_DPB_SLOT_INFO_KHR: return sizeof(VkVideoDecodeH264DpbSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PROFILE_INFO_KHR: return sizeof(VkVideoDecodeH265ProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_CAPABILITIES_KHR: return sizeof(VkVideoDecodeH265CapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR: return sizeof(VkVideoDecodeH265SessionParametersAddInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoDecodeH265SessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_INLINE_SESSION_PARAMETERS_INFO_KHR: return sizeof(VkVideoDecodeH265InlineSessionParametersInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_PICTURE_INFO_KHR: return sizeof(VkVideoDecodeH265PictureInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_H265_DPB_SLOT_INFO_KHR: return sizeof(VkVideoDecodeH265DpbSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PROFILE_INFO_KHR: return sizeof(VkVideoDecodeAV1ProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_CAPABILITIES_KHR: return sizeof(VkVideoDecodeAV1CapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoDecodeAV1SessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_INLINE_SESSION_PARAMETERS_INFO_KHR: return sizeof(VkVideoDecodeAV1InlineSessionParametersInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_PICTURE_INFO_KHR: return sizeof(VkVideoDecodeAV1PictureInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_DECODE_AV1_DPB_SLOT_INFO_KHR: return sizeof(VkVideoDecodeAV1DpbSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_SESSION_CREATE_INFO_KHR: return sizeof(VkVideoSessionCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoSessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_SESSION_PARAMETERS_UPDATE_INFO_KHR: return sizeof(VkVideoSessionParametersUpdateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_GET_INFO_KHR: return sizeof(VkVideoEncodeSessionParametersGetInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_SESSION_PARAMETERS_FEEDBACK_INFO_KHR: return sizeof(VkVideoEncodeSessionParametersFeedbackInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_BEGIN_CODING_INFO_KHR: return sizeof(VkVideoBeginCodingInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_END_CODING_INFO_KHR: return sizeof(VkVideoEndCodingInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_CODING_CONTROL_INFO_KHR: return sizeof(VkVideoCodingControlInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_USAGE_INFO_KHR: return sizeof(VkVideoEncodeUsageInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_INFO_KHR: return sizeof(VkVideoEncodeInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_INFO_KHR: return sizeof(VkVideoEncodeQuantizationMapInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUANTIZATION_MAP_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoEncodeQuantizationMapSessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR: return sizeof(VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR);
    case VK_STRUCTURE_TYPE_QUERY_POOL_VIDEO_ENCODE_FEEDBACK_CREATE_INFO_KHR: return sizeof(VkQueryPoolVideoEncodeFeedbackCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR: return sizeof(VkVideoEncodeQualityLevelInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUALITY_LEVEL_INFO_KHR: return sizeof(VkPhysicalDeviceVideoEncodeQualityLevelInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_QUALITY_LEVEL_PROPERTIES_KHR: return sizeof(VkVideoEncodeQualityLevelPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_INFO_KHR: return sizeof(VkVideoEncodeRateControlInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_RATE_CONTROL_LAYER_INFO_KHR: return sizeof(VkVideoEncodeRateControlLayerInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_CAPABILITIES_KHR: return sizeof(VkVideoEncodeCapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_CAPABILITIES_KHR: return sizeof(VkVideoEncodeH264CapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_QUALITY_LEVEL_PROPERTIES_KHR: return sizeof(VkVideoEncodeH264QualityLevelPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_CREATE_INFO_KHR: return sizeof(VkVideoEncodeH264SessionCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_ADD_INFO_KHR: return sizeof(VkVideoEncodeH264SessionParametersAddInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoEncodeH264SessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_GET_INFO_KHR: return sizeof(VkVideoEncodeH264SessionParametersGetInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_SESSION_PARAMETERS_FEEDBACK_INFO_KHR: return sizeof(VkVideoEncodeH264SessionParametersFeedbackInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_DPB_SLOT_INFO_KHR: return sizeof(VkVideoEncodeH264DpbSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PICTURE_INFO_KHR: return sizeof(VkVideoEncodeH264PictureInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_PROFILE_INFO_KHR: return sizeof(VkVideoEncodeH264ProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_NALU_SLICE_INFO_KHR: return sizeof(VkVideoEncodeH264NaluSliceInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_INFO_KHR: return sizeof(VkVideoEncodeH264RateControlInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_GOP_REMAINING_FRAME_INFO_KHR: return sizeof(VkVideoEncodeH264GopRemainingFrameInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H264_RATE_CONTROL_LAYER_INFO_KHR: return sizeof(VkVideoEncodeH264RateControlLayerInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_CAPABILITIES_KHR: return sizeof(VkVideoEncodeH265CapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_QUALITY_LEVEL_PROPERTIES_KHR: return sizeof(VkVideoEncodeH265QualityLevelPropertiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_CREATE_INFO_KHR: return sizeof(VkVideoEncodeH265SessionCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_ADD_INFO_KHR: return sizeof(VkVideoEncodeH265SessionParametersAddInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoEncodeH265SessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_GET_INFO_KHR: return sizeof(VkVideoEncodeH265SessionParametersGetInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_SESSION_PARAMETERS_FEEDBACK_INFO_KHR: return sizeof(VkVideoEncodeH265SessionParametersFeedbackInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PICTURE_INFO_KHR: return sizeof(VkVideoEncodeH265PictureInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_NALU_SLICE_SEGMENT_INFO_KHR: return sizeof(VkVideoEncodeH265NaluSliceSegmentInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_INFO_KHR: return sizeof(VkVideoEncodeH265RateControlInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_GOP_REMAINING_FRAME_INFO_KHR: return sizeof(VkVideoEncodeH265GopRemainingFrameInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_RATE_CONTROL_LAYER_INFO_KHR: return sizeof(VkVideoEncodeH265RateControlLayerInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_PROFILE_INFO_KHR: return sizeof(VkVideoEncodeH265ProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_H265_DPB_SLOT_INFO_KHR: return sizeof(VkVideoEncodeH265DpbSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_CAPABILITIES_KHR: return sizeof(VkVideoEncodeAV1CapabilitiesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_QUALITY_LEVEL_PROPERTIES_KHR: return sizeof(VkVideoEncodeAV1QualityLevelPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR: return sizeof(VkPhysicalDeviceVideoEncodeAV1FeaturesKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_CREATE_INFO_KHR: return sizeof(VkVideoEncodeAV1SessionCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_SESSION_PARAMETERS_CREATE_INFO_KHR: return sizeof(VkVideoEncodeAV1SessionParametersCreateInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_DPB_SLOT_INFO_KHR: return sizeof(VkVideoEncodeAV1DpbSlotInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PICTURE_INFO_KHR: return sizeof(VkVideoEncodeAV1PictureInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_PROFILE_INFO_KHR: return sizeof(VkVideoEncodeAV1ProfileInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_INFO_KHR: return sizeof(VkVideoEncodeAV1RateControlInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_GOP_REMAINING_FRAME_INFO_KHR: return sizeof(VkVideoEncodeAV1GopRemainingFrameInfoKHR);
    case VK_STRUCTURE_TYPE_VIDEO_ENCODE_AV1_RATE_CONTROL_LAYER_INFO_KHR: return sizeof(VkVideoEncodeAV1RateControlLayerInfoKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV: return sizeof(VkPhysicalDeviceInheritedViewportScissorFeaturesNV);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_VIEWPORT_SCISSOR_INFO_NV: return sizeof(VkCommandBufferInheritanceViewportScissorInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: return sizeof(VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: return sizeof(VkPhysicalDeviceProvokingVertexFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceProvokingVertexPropertiesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_RASTERIZATION_PROVOKING_VERTEX_STATE_CREATE_INFO_EXT: return sizeof(VkPipelineRasterizationProvokingVertexStateCreateInfoEXT);
    case VK_STRUCTURE_TYPE_CU_MODULE_CREATE_INFO_NVX: return sizeof(VkCuModuleCreateInfoNVX);
    case VK_STRUCTURE_TYPE_CU_MODULE_TEXTURING_MODE_CREATE_INFO_NVX: return sizeof(VkCuModuleTexturingModeCreateInfoNVX);
    case VK_STRUCTURE_TYPE_CU_FUNCTION_CREATE_INFO_NVX: return sizeof(VkCuFunctionCreateInfoNVX);
    case VK_STRUCTURE_TYPE_CU_LAUNCH_INFO_NVX: return sizeof(VkCuLaunchInfoNVX);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT: return sizeof(VkPhysicalDeviceDescriptorBufferFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceDescriptorBufferPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_DENSITY_MAP_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceDescriptorBufferDensityMapPropertiesEXT);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_ADDRESS_INFO_EXT: return sizeof(VkDescriptorAddressInfoEXT);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_INFO_EXT: return sizeof(VkDescriptorBufferBindingInfoEXT);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_BUFFER_BINDING_PUSH_DESCRIPTOR_BUFFER_HANDLE_EXT: return sizeof(VkDescriptorBufferBindingPushDescriptorBufferHandleEXT);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_GET_INFO_EXT: return sizeof(VkDescriptorGetInfoEXT);
    case VK_STRUCTURE_TYPE_BUFFER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT: return sizeof(VkBufferCaptureDescriptorDataInfoEXT);
    case VK_STRUCTURE_TYPE_IMAGE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT: return sizeof(VkImageCaptureDescriptorDataInfoEXT);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_CAPTURE_DESCRIPTOR_DATA_INFO_EXT: return sizeof(VkImageViewCaptureDescriptorDataInfoEXT);
    case VK_STRUCTURE_TYPE_SAMPLER_CAPTURE_DESCRIPTOR_DATA_INFO_EXT: return sizeof(VkSamplerCaptureDescriptorDataInfoEXT);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_CAPTURE_DESCRIPTOR_DATA_INFO_EXT: return sizeof(VkAccelerationStructureCaptureDescriptorDataInfoEXT);
    case VK_STRUCTURE_TYPE_OPAQUE_CAPTURE_DESCRIPTOR_DATA_CREATE_INFO_EXT: return sizeof(VkOpaqueCaptureDescriptorDataCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: return sizeof(VkPhysicalDeviceShaderIntegerDotProductFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_PROPERTIES: return sizeof(VkPhysicalDeviceShaderIntegerDotProductProperties);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DRM_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceDrmPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR: return sizeof(VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceFragmentShaderBarycentricPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV: return sizeof(VkPhysicalDeviceRayTracingMotionBlurFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV: return sizeof(VkPhysicalDeviceRayTracingValidationFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV: return sizeof(VkPhysicalDeviceRayTracingLinearSweptSpheresFeaturesNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_GEOMETRY_MOTION_TRIANGLES_DATA_NV: return sizeof(VkAccelerationStructureGeometryMotionTrianglesDataNV);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_MOTION_INFO_NV: return sizeof(VkAccelerationStructureMotionInfoNV);
    case VK_STRUCTURE_TYPE_MEMORY_GET_REMOTE_ADDRESS_INFO_NV: return sizeof(VkMemoryGetRemoteAddressInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT: return sizeof(VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT);
    case VK_STRUCTURE_TYPE_FORMAT_PROPERTIES_3: return sizeof(VkFormatProperties3);
    case VK_STRUCTURE_TYPE_DRM_FORMAT_MODIFIER_PROPERTIES_LIST_2_EXT: return sizeof(VkDrmFormatModifierPropertiesList2EXT);
    case VK_STRUCTURE_TYPE_PIPELINE_RENDERING_CREATE_INFO: return sizeof(VkPipelineRenderingCreateInfo);
    case VK_STRUCTURE_TYPE_RENDERING_INFO: return sizeof(VkRenderingInfo);
    case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_INFO: return sizeof(VkRenderingAttachmentInfo);
    case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_SHADING_RATE_ATTACHMENT_INFO_KHR: return sizeof(VkRenderingFragmentShadingRateAttachmentInfoKHR);
    case VK_STRUCTURE_TYPE_RENDERING_FRAGMENT_DENSITY_MAP_ATTACHMENT_INFO_EXT: return sizeof(VkRenderingFragmentDensityMapAttachmentInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: return sizeof(VkPhysicalDeviceDynamicRenderingFeatures);
    case VK_STRUCTURE_TYPE_COMMAND_BUFFER_INHERITANCE_RENDERING_INFO: return sizeof(VkCommandBufferInheritanceRenderingInfo);
    case VK_STRUCTURE_TYPE_ATTACHMENT_SAMPLE_COUNT_INFO_AMD: return sizeof(VkAttachmentSampleCountInfoAMD);
    case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_ATTRIBUTES_INFO_NVX: return sizeof(VkMultiviewPerViewAttributesInfoNVX);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT: return sizeof(VkPhysicalDeviceImageViewMinLodFeaturesEXT);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_MIN_LOD_CREATE_INFO_EXT: return sizeof(VkImageViewMinLodCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT: return sizeof(VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV: return sizeof(VkPhysicalDeviceLinearColorAttachmentFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT: return sizeof(VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR: return sizeof(VkPhysicalDevicePipelineBinaryFeaturesKHR);
    case VK_STRUCTURE_TYPE_DEVICE_PIPELINE_BINARY_INTERNAL_CACHE_CONTROL_KHR: return sizeof(VkDevicePipelineBinaryInternalCacheControlKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_PROPERTIES_KHR: return sizeof(VkPhysicalDevicePipelineBinaryPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceGraphicsPipelineLibraryPropertiesEXT);
    case VK_STRUCTURE_TYPE_GRAPHICS_PIPELINE_LIBRARY_CREATE_INFO_EXT: return sizeof(VkGraphicsPipelineLibraryCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE: return sizeof(VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_BINDING_REFERENCE_VALVE: return sizeof(VkDescriptorSetBindingReferenceVALVE);
    case VK_STRUCTURE_TYPE_DESCRIPTOR_SET_LAYOUT_HOST_MAPPING_INFO_VALVE: return sizeof(VkDescriptorSetLayoutHostMappingInfoVALVE);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT: return sizeof(VkPhysicalDeviceNestedCommandBufferFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceNestedCommandBufferPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceShaderModuleIdentifierPropertiesEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_SHADER_STAGE_MODULE_IDENTIFIER_CREATE_INFO_EXT: return sizeof(VkPipelineShaderStageModuleIdentifierCreateInfoEXT);
    case VK_STRUCTURE_TYPE_SHADER_MODULE_IDENTIFIER_EXT: return sizeof(VkShaderModuleIdentifierEXT);
    case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_CONTROL_EXT: return sizeof(VkImageCompressionControlEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: return sizeof(VkPhysicalDeviceImageCompressionControlFeaturesEXT);
    case VK_STRUCTURE_TYPE_IMAGE_COMPRESSION_PROPERTIES_EXT: return sizeof(VkImageCompressionPropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: return sizeof(VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT);
    case VK_STRUCTURE_TYPE_IMAGE_SUBRESOURCE_2: return sizeof(VkImageSubresource2);
    case VK_STRUCTURE_TYPE_SUBRESOURCE_LAYOUT_2: return sizeof(VkSubresourceLayout2);
    case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_CONTROL_EXT: return sizeof(VkRenderPassCreationControlEXT);
    case VK_STRUCTURE_TYPE_RENDER_PASS_CREATION_FEEDBACK_CREATE_INFO_EXT: return sizeof(VkRenderPassCreationFeedbackCreateInfoEXT);
    case VK_STRUCTURE_TYPE_RENDER_PASS_SUBPASS_FEEDBACK_CREATE_INFO_EXT: return sizeof(VkRenderPassSubpassFeedbackCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT: return sizeof(VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT);
    case VK_STRUCTURE_TYPE_MICROMAP_BUILD_INFO_EXT: return sizeof(VkMicromapBuildInfoEXT);
    case VK_STRUCTURE_TYPE_MICROMAP_CREATE_INFO_EXT: return sizeof(VkMicromapCreateInfoEXT);
    case VK_STRUCTURE_TYPE_MICROMAP_VERSION_INFO_EXT: return sizeof(VkMicromapVersionInfoEXT);
    case VK_STRUCTURE_TYPE_COPY_MICROMAP_INFO_EXT: return sizeof(VkCopyMicromapInfoEXT);
    case VK_STRUCTURE_TYPE_COPY_MICROMAP_TO_MEMORY_INFO_EXT: return sizeof(VkCopyMicromapToMemoryInfoEXT);
    case VK_STRUCTURE_TYPE_COPY_MEMORY_TO_MICROMAP_INFO_EXT: return sizeof(VkCopyMemoryToMicromapInfoEXT);
    case VK_STRUCTURE_TYPE_MICROMAP_BUILD_SIZES_INFO_EXT: return sizeof(VkMicromapBuildSizesInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT: return sizeof(VkPhysicalDeviceOpacityMicromapFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceOpacityMicromapPropertiesEXT);
    case VK_STRUCTURE_TYPE_ACCELERATION_STRUCTURE_TRIANGLES_OPACITY_MICROMAP_EXT: return sizeof(VkAccelerationStructureTrianglesOpacityMicromapEXT);
    case VK_STRUCTURE_TYPE_PIPELINE_PROPERTIES_IDENTIFIER_EXT: return sizeof(VkPipelinePropertiesIdentifierEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT: return sizeof(VkPhysicalDevicePipelinePropertiesFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD: return sizeof(VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD);
    case VK_STRUCTURE_TYPE_EXTERNAL_MEMORY_ACQUIRE_UNMODIFIED_EXT: return sizeof(VkExternalMemoryAcquireUnmodifiedEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT: return sizeof(VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES: return sizeof(VkPhysicalDevicePipelineRobustnessFeatures);
    case VK_STRUCTURE_TYPE_PIPELINE_ROBUSTNESS_CREATE_INFO: return sizeof(VkPipelineRobustnessCreateInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_PROPERTIES: return sizeof(VkPhysicalDevicePipelineRobustnessProperties);
    case VK_STRUCTURE_TYPE_IMAGE_VIEW_SAMPLE_WEIGHT_CREATE_INFO_QCOM: return sizeof(VkImageViewSampleWeightCreateInfoQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM: return sizeof(VkPhysicalDeviceImageProcessingFeaturesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_PROPERTIES_QCOM: return sizeof(VkPhysicalDeviceImageProcessingPropertiesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM: return sizeof(VkPhysicalDeviceTilePropertiesFeaturesQCOM);
    case VK_STRUCTURE_TYPE_TILE_PROPERTIES_QCOM: return sizeof(VkTilePropertiesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC: return sizeof(VkPhysicalDeviceAmigoProfilingFeaturesSEC);
    case VK_STRUCTURE_TYPE_AMIGO_PROFILING_SUBMIT_INFO_SEC: return sizeof(VkAmigoProfilingSubmitInfoSEC);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT: return sizeof(VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT: return sizeof(VkPhysicalDeviceAddressBindingReportFeaturesEXT);
    case VK_STRUCTURE_TYPE_DEVICE_ADDRESS_BINDING_CALLBACK_DATA_EXT: return sizeof(VkDeviceAddressBindingCallbackDataEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV: return sizeof(VkPhysicalDeviceOpticalFlowFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_PROPERTIES_NV: return sizeof(VkPhysicalDeviceOpticalFlowPropertiesNV);
    case VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_INFO_NV: return sizeof(VkOpticalFlowImageFormatInfoNV);
    case VK_STRUCTURE_TYPE_OPTICAL_FLOW_IMAGE_FORMAT_PROPERTIES_NV: return sizeof(VkOpticalFlowImageFormatPropertiesNV);
    case VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_INFO_NV: return sizeof(VkOpticalFlowSessionCreateInfoNV);
    case VK_STRUCTURE_TYPE_OPTICAL_FLOW_SESSION_CREATE_PRIVATE_DATA_INFO_NV: return sizeof(VkOpticalFlowSessionCreatePrivateDataInfoNV);
    case VK_STRUCTURE_TYPE_OPTICAL_FLOW_EXECUTE_INFO_NV: return sizeof(VkOpticalFlowExecuteInfoNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT: return sizeof(VkPhysicalDeviceFaultFeaturesEXT);
    case VK_STRUCTURE_TYPE_DEVICE_FAULT_COUNTS_EXT: return sizeof(VkDeviceFaultCountsEXT);
    case VK_STRUCTURE_TYPE_DEVICE_FAULT_INFO_EXT: return sizeof(VkDeviceFaultInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT: return sizeof(VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT);
    case VK_STRUCTURE_TYPE_DEPTH_BIAS_INFO_EXT: return sizeof(VkDepthBiasInfoEXT);
    case VK_STRUCTURE_TYPE_DEPTH_BIAS_REPRESENTATION_INFO_EXT: return sizeof(VkDepthBiasRepresentationInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_PROPERTIES_ARM: return sizeof(VkPhysicalDeviceShaderCoreBuiltinsPropertiesARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM: return sizeof(VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM);
    case VK_STRUCTURE_TYPE_FRAME_BOUNDARY_EXT: return sizeof(VkFrameBoundaryEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT: return sizeof(VkPhysicalDeviceFrameBoundaryFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT: return sizeof(VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT);
    case VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_EXT: return sizeof(VkSurfacePresentModeEXT);
    case VK_STRUCTURE_TYPE_SURFACE_PRESENT_SCALING_CAPABILITIES_EXT: return sizeof(VkSurfacePresentScalingCapabilitiesEXT);
    case VK_STRUCTURE_TYPE_SURFACE_PRESENT_MODE_COMPATIBILITY_EXT: return sizeof(VkSurfacePresentModeCompatibilityEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: return sizeof(VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_FENCE_INFO_EXT: return sizeof(VkSwapchainPresentFenceInfoEXT);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODES_CREATE_INFO_EXT: return sizeof(VkSwapchainPresentModesCreateInfoEXT);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_MODE_INFO_EXT: return sizeof(VkSwapchainPresentModeInfoEXT);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_PRESENT_SCALING_CREATE_INFO_EXT: return sizeof(VkSwapchainPresentScalingCreateInfoEXT);
    case VK_STRUCTURE_TYPE_RELEASE_SWAPCHAIN_IMAGES_INFO_EXT: return sizeof(VkReleaseSwapchainImagesInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT: return sizeof(VkPhysicalDeviceDepthBiasControlFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV: return sizeof(VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_PROPERTIES_NV: return sizeof(VkPhysicalDeviceRayTracingInvocationReorderPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV: return sizeof(VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_PROPERTIES_NV: return sizeof(VkPhysicalDeviceExtendedSparseAddressSpacePropertiesNV);
    case VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_INFO_LUNARG: return sizeof(VkDirectDriverLoadingInfoLUNARG);
    case VK_STRUCTURE_TYPE_DIRECT_DRIVER_LOADING_LIST_LUNARG: return sizeof(VkDirectDriverLoadingListLUNARG);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM: return sizeof(VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR: return sizeof(VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR);
    case VK_STRUCTURE_TYPE_DEVICE_IMAGE_SUBRESOURCE_INFO: return sizeof(VkDeviceImageSubresourceInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_PROPERTIES_ARM: return sizeof(VkPhysicalDeviceShaderCorePropertiesARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM: return sizeof(VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM);
    case VK_STRUCTURE_TYPE_MULTIVIEW_PER_VIEW_RENDER_AREAS_RENDER_PASS_BEGIN_INFO_QCOM: return sizeof(VkMultiviewPerViewRenderAreasRenderPassBeginInfoQCOM);
    case VK_STRUCTURE_TYPE_QUERY_LOW_LATENCY_SUPPORT_NV: return sizeof(VkQueryLowLatencySupportNV);
    case VK_STRUCTURE_TYPE_MEMORY_MAP_INFO: return sizeof(VkMemoryMapInfo);
    case VK_STRUCTURE_TYPE_MEMORY_UNMAP_INFO: return sizeof(VkMemoryUnmapInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderObjectFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceShaderObjectPropertiesEXT);
    case VK_STRUCTURE_TYPE_SHADER_CREATE_INFO_EXT: return sizeof(VkShaderCreateInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderTileImageFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceShaderTileImagePropertiesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR: return sizeof(VkPhysicalDeviceCooperativeMatrixFeaturesKHR);
    case VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_PROPERTIES_KHR: return sizeof(VkCooperativeMatrixPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_PROPERTIES_KHR: return sizeof(VkPhysicalDeviceCooperativeMatrixPropertiesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD: return sizeof(VkPhysicalDeviceAntiLagFeaturesAMD);
    case VK_STRUCTURE_TYPE_ANTI_LAG_DATA_AMD: return sizeof(VkAntiLagDataAMD);
    case VK_STRUCTURE_TYPE_ANTI_LAG_PRESENTATION_INFO_AMD: return sizeof(VkAntiLagPresentationInfoAMD);
    case VK_STRUCTURE_TYPE_BIND_MEMORY_STATUS: return sizeof(VkBindMemoryStatus);
    case VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_SETS_INFO: return sizeof(VkBindDescriptorSetsInfo);
    case VK_STRUCTURE_TYPE_PUSH_CONSTANTS_INFO: return sizeof(VkPushConstantsInfo);
    case VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_INFO: return sizeof(VkPushDescriptorSetInfo);
    case VK_STRUCTURE_TYPE_PUSH_DESCRIPTOR_SET_WITH_TEMPLATE_INFO: return sizeof(VkPushDescriptorSetWithTemplateInfo);
    case VK_STRUCTURE_TYPE_SET_DESCRIPTOR_BUFFER_OFFSETS_INFO_EXT: return sizeof(VkSetDescriptorBufferOffsetsInfoEXT);
    case VK_STRUCTURE_TYPE_BIND_DESCRIPTOR_BUFFER_EMBEDDED_SAMPLERS_INFO_EXT: return sizeof(VkBindDescriptorBufferEmbeddedSamplersInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM: return sizeof(VkPhysicalDeviceCubicClampFeaturesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM: return sizeof(VkPhysicalDeviceYcbcrDegammaFeaturesQCOM);
    case VK_STRUCTURE_TYPE_SAMPLER_YCBCR_CONVERSION_YCBCR_DEGAMMA_CREATE_INFO_QCOM: return sizeof(VkSamplerYcbcrConversionYcbcrDegammaCreateInfoQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM: return sizeof(VkPhysicalDeviceCubicWeightsFeaturesQCOM);
    case VK_STRUCTURE_TYPE_SAMPLER_CUBIC_WEIGHTS_CREATE_INFO_QCOM: return sizeof(VkSamplerCubicWeightsCreateInfoQCOM);
    case VK_STRUCTURE_TYPE_BLIT_IMAGE_CUBIC_WEIGHTS_INFO_QCOM: return sizeof(VkBlitImageCubicWeightsInfoQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM: return sizeof(VkPhysicalDeviceImageProcessing2FeaturesQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_PROPERTIES_QCOM: return sizeof(VkPhysicalDeviceImageProcessing2PropertiesQCOM);
    case VK_STRUCTURE_TYPE_SAMPLER_BLOCK_MATCH_WINDOW_CREATE_INFO_QCOM: return sizeof(VkSamplerBlockMatchWindowCreateInfoQCOM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV: return sizeof(VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LAYERED_DRIVER_PROPERTIES_MSFT: return sizeof(VkPhysicalDeviceLayeredDriverPropertiesMSFT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV: return sizeof(VkPhysicalDevicePerStageDescriptorSetFeaturesNV);
    case VK_STRUCTURE_TYPE_LATENCY_SLEEP_MODE_INFO_NV: return sizeof(VkLatencySleepModeInfoNV);
    case VK_STRUCTURE_TYPE_LATENCY_SLEEP_INFO_NV: return sizeof(VkLatencySleepInfoNV);
    case VK_STRUCTURE_TYPE_SET_LATENCY_MARKER_INFO_NV: return sizeof(VkSetLatencyMarkerInfoNV);
    case VK_STRUCTURE_TYPE_GET_LATENCY_MARKER_INFO_NV: return sizeof(VkGetLatencyMarkerInfoNV);
    case VK_STRUCTURE_TYPE_LATENCY_TIMINGS_FRAME_REPORT_NV: return sizeof(VkLatencyTimingsFrameReportNV);
    case VK_STRUCTURE_TYPE_OUT_OF_BAND_QUEUE_TYPE_INFO_NV: return sizeof(VkOutOfBandQueueTypeInfoNV);
    case VK_STRUCTURE_TYPE_LATENCY_SUBMISSION_PRESENT_ID_NV: return sizeof(VkLatencySubmissionPresentIdNV);
    case VK_STRUCTURE_TYPE_SWAPCHAIN_LATENCY_CREATE_INFO_NV: return sizeof(VkSwapchainLatencyCreateInfoNV);
    case VK_STRUCTURE_TYPE_LATENCY_SURFACE_CAPABILITIES_NV: return sizeof(VkLatencySurfaceCapabilitiesNV);
    case VK_STRUCTURE_TYPE_DEVICE_QUEUE_SHADER_CORE_CONTROL_CREATE_INFO_ARM: return sizeof(VkDeviceQueueShaderCoreControlCreateInfoARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM: return sizeof(VkPhysicalDeviceSchedulingControlsFeaturesARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_PROPERTIES_ARM: return sizeof(VkPhysicalDeviceSchedulingControlsPropertiesARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG: return sizeof(VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM: return sizeof(VkPhysicalDeviceRenderPassStripedFeaturesARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_PROPERTIES_ARM: return sizeof(VkPhysicalDeviceRenderPassStripedPropertiesARM);
    case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_INFO_ARM: return sizeof(VkRenderPassStripeInfoARM);
    case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_BEGIN_INFO_ARM: return sizeof(VkRenderPassStripeBeginInfoARM);
    case VK_STRUCTURE_TYPE_RENDER_PASS_STRIPE_SUBMIT_INFO_ARM: return sizeof(VkRenderPassStripeSubmitInfoARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM: return sizeof(VkPhysicalDevicePipelineOpacityMicromapFeaturesARM);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR: return sizeof(VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES: return sizeof(VkPhysicalDeviceShaderSubgroupRotateFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES: return sizeof(VkPhysicalDeviceShaderExpectAssumeFeatures);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES: return sizeof(VkPhysicalDeviceShaderFloatControls2Features);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES: return sizeof(VkPhysicalDeviceDynamicRenderingLocalReadFeatures);
    case VK_STRUCTURE_TYPE_RENDERING_ATTACHMENT_LOCATION_INFO: return sizeof(VkRenderingAttachmentLocationInfo);
    case VK_STRUCTURE_TYPE_RENDERING_INPUT_ATTACHMENT_INDEX_INFO: return sizeof(VkRenderingInputAttachmentIndexInfo);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR: return sizeof(VkPhysicalDeviceShaderQuadControlFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV: return sizeof(VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT: return sizeof(VkPhysicalDeviceMapMemoryPlacedFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_PROPERTIES_EXT: return sizeof(VkPhysicalDeviceMapMemoryPlacedPropertiesEXT);
    case VK_STRUCTURE_TYPE_MEMORY_MAP_PLACED_INFO_EXT: return sizeof(VkMemoryMapPlacedInfoEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV: return sizeof(VkPhysicalDeviceRawAccessChainsFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV: return sizeof(VkPhysicalDeviceCommandBufferInheritanceFeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA: return sizeof(VkPhysicalDeviceImageAlignmentControlFeaturesMESA);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_PROPERTIES_MESA: return sizeof(VkPhysicalDeviceImageAlignmentControlPropertiesMESA);
    case VK_STRUCTURE_TYPE_IMAGE_ALIGNMENT_CONTROL_CREATE_INFO_MESA: return sizeof(VkImageAlignmentControlCreateInfoMESA);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT: return sizeof(VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_EXT: return sizeof(VkPhysicalDevicePresentModeFifoLatestReadyFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV: return sizeof(VkPhysicalDeviceCooperativeMatrix2FeaturesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_PROPERTIES_NV: return sizeof(VkPhysicalDeviceCooperativeMatrix2PropertiesNV);
    case VK_STRUCTURE_TYPE_COOPERATIVE_MATRIX_FLEXIBLE_DIMENSIONS_PROPERTIES_NV: return sizeof(VkCooperativeMatrixFlexibleDimensionsPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI: return sizeof(VkPhysicalDeviceHdrVividFeaturesHUAWEI);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT: return sizeof(VkPhysicalDeviceVertexAttributeRobustnessFeaturesEXT);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR: return sizeof(VkPhysicalDeviceDepthClampZeroOneFeaturesKHR);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV: return sizeof(VkPhysicalDeviceCooperativeVectorFeaturesNV);
    case VK_STRUCTURE_TYPE_COOPERATIVE_VECTOR_PROPERTIES_NV: return sizeof(VkCooperativeVectorPropertiesNV);
    case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_PROPERTIES_NV: return sizeof(VkPhysicalDeviceCooperativeVectorPropertiesNV);
    case VK_STRUCTURE_TYPE_CONVERT_COOPERATIVE_VECTOR_MATRIX_INFO_NV: return sizeof(VkConvertCooperativeVectorMatrixInfoNV);

    default: return 0;
    }
}

uint32_t vk_ext_promoted_ver(const char *extension)
{
    if (!strcmp(extension, "VK_KHR_sampler_mirror_clamp_to_edge"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_dynamic_rendering"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_multiview"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_get_physical_device_properties2"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_device_group"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_shader_draw_parameters"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_EXT_texture_compression_astc_hdr"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_pipeline_robustness"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_maintenance1"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_device_group_creation"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_external_memory_capabilities"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_external_memory"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_external_semaphore_capabilities"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_external_semaphore"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_push_descriptor"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_shader_float16_int8"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_16bit_storage"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_descriptor_update_template"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_imageless_framebuffer"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_create_renderpass2"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_external_fence_capabilities"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_external_fence"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_maintenance2"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_variable_pointers"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_dedicated_allocation"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_EXT_sampler_filter_minmax"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_storage_buffer_storage_class"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_EXT_inline_uniform_block"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_relaxed_block_layout"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_get_memory_requirements2"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_image_format_list"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_sampler_ycbcr_conversion"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_bind_memory2"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_EXT_descriptor_indexing"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_EXT_shader_viewport_index_layer"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_maintenance3"))
        return VK_API_VERSION_1_1;
    if (!strcmp(extension, "VK_KHR_draw_indirect_count"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_shader_subgroup_extended_types"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_8bit_storage"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_shader_atomic_int64"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_global_priority"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_EXT_pipeline_creation_feedback"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_driver_properties"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_shader_float_controls"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_depth_stencil_resolve"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_timeline_semaphore"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_vulkan_memory_model"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_shader_terminate_invocation"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_scalar_block_layout"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_EXT_subgroup_size_control"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_dynamic_rendering_local_read"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_spirv_1_4"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_separate_depth_stencil_layouts"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_EXT_tooling_info"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_separate_stencil_usage"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_uniform_buffer_standard_layout"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_KHR_buffer_device_address"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_EXT_host_query_reset"))
        return VK_API_VERSION_1_2;
    if (!strcmp(extension, "VK_EXT_extended_dynamic_state"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_host_image_copy"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_map_memory2"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_EXT_shader_demote_to_helper_invocation"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_shader_integer_dot_product"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_texel_buffer_alignment"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_shader_non_semantic_info"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_private_data"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_pipeline_creation_cache_control"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_synchronization2"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_zero_initialize_workgroup_memory"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_ycbcr_2plane_444_formats"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_image_robustness"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_copy_commands2"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_4444_formats"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_format_feature_flags2"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_EXT_extended_dynamic_state2"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_maintenance4"))
        return VK_API_VERSION_1_3;
    if (!strcmp(extension, "VK_KHR_shader_subgroup_rotate"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_EXT_pipeline_protected_access"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_maintenance5"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_vertex_attribute_divisor"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_load_store_op_none"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_shader_float_controls2"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_index_type_uint8"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_line_rasterization"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_shader_expect_assume"))
        return VK_API_VERSION_1_4;
    if (!strcmp(extension, "VK_KHR_maintenance6"))
        return VK_API_VERSION_1_4;
    return 0;
}

void vk_features_normalize(void *alloc, const VkPhysicalDeviceFeatures2 *fin,
                           uint32_t api_ver, VkPhysicalDeviceFeatures2 *out)
{
    for (const VkBaseInStructure *in = (void *) fin; in; in = in->pNext) {
        switch (in->sType) {
        default: break;
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FEATURES_2: {
            const VkPhysicalDeviceFeatures2 *i = (const void *) in;
            if (i->features.robustBufferAccess) {
                out->features.robustBufferAccess = true;
            }
            if (i->features.fullDrawIndexUint32) {
                out->features.fullDrawIndexUint32 = true;
            }
            if (i->features.imageCubeArray) {
                out->features.imageCubeArray = true;
            }
            if (i->features.independentBlend) {
                out->features.independentBlend = true;
            }
            if (i->features.geometryShader) {
                out->features.geometryShader = true;
            }
            if (i->features.tessellationShader) {
                out->features.tessellationShader = true;
            }
            if (i->features.sampleRateShading) {
                out->features.sampleRateShading = true;
            }
            if (i->features.dualSrcBlend) {
                out->features.dualSrcBlend = true;
            }
            if (i->features.logicOp) {
                out->features.logicOp = true;
            }
            if (i->features.multiDrawIndirect) {
                out->features.multiDrawIndirect = true;
            }
            if (i->features.drawIndirectFirstInstance) {
                out->features.drawIndirectFirstInstance = true;
            }
            if (i->features.depthClamp) {
                out->features.depthClamp = true;
            }
            if (i->features.depthBiasClamp) {
                out->features.depthBiasClamp = true;
            }
            if (i->features.fillModeNonSolid) {
                out->features.fillModeNonSolid = true;
            }
            if (i->features.depthBounds) {
                out->features.depthBounds = true;
            }
            if (i->features.wideLines) {
                out->features.wideLines = true;
            }
            if (i->features.largePoints) {
                out->features.largePoints = true;
            }
            if (i->features.alphaToOne) {
                out->features.alphaToOne = true;
            }
            if (i->features.multiViewport) {
                out->features.multiViewport = true;
            }
            if (i->features.samplerAnisotropy) {
                out->features.samplerAnisotropy = true;
            }
            if (i->features.textureCompressionETC2) {
                out->features.textureCompressionETC2 = true;
            }
            if (i->features.textureCompressionASTC_LDR) {
                out->features.textureCompressionASTC_LDR = true;
            }
            if (i->features.textureCompressionBC) {
                out->features.textureCompressionBC = true;
            }
            if (i->features.occlusionQueryPrecise) {
                out->features.occlusionQueryPrecise = true;
            }
            if (i->features.pipelineStatisticsQuery) {
                out->features.pipelineStatisticsQuery = true;
            }
            if (i->features.vertexPipelineStoresAndAtomics) {
                out->features.vertexPipelineStoresAndAtomics = true;
            }
            if (i->features.fragmentStoresAndAtomics) {
                out->features.fragmentStoresAndAtomics = true;
            }
            if (i->features.shaderTessellationAndGeometryPointSize) {
                out->features.shaderTessellationAndGeometryPointSize = true;
            }
            if (i->features.shaderImageGatherExtended) {
                out->features.shaderImageGatherExtended = true;
            }
            if (i->features.shaderStorageImageExtendedFormats) {
                out->features.shaderStorageImageExtendedFormats = true;
            }
            if (i->features.shaderStorageImageMultisample) {
                out->features.shaderStorageImageMultisample = true;
            }
            if (i->features.shaderStorageImageReadWithoutFormat) {
                out->features.shaderStorageImageReadWithoutFormat = true;
            }
            if (i->features.shaderStorageImageWriteWithoutFormat) {
                out->features.shaderStorageImageWriteWithoutFormat = true;
            }
            if (i->features.shaderUniformBufferArrayDynamicIndexing) {
                out->features.shaderUniformBufferArrayDynamicIndexing = true;
            }
            if (i->features.shaderSampledImageArrayDynamicIndexing) {
                out->features.shaderSampledImageArrayDynamicIndexing = true;
            }
            if (i->features.shaderStorageBufferArrayDynamicIndexing) {
                out->features.shaderStorageBufferArrayDynamicIndexing = true;
            }
            if (i->features.shaderStorageImageArrayDynamicIndexing) {
                out->features.shaderStorageImageArrayDynamicIndexing = true;
            }
            if (i->features.shaderClipDistance) {
                out->features.shaderClipDistance = true;
            }
            if (i->features.shaderCullDistance) {
                out->features.shaderCullDistance = true;
            }
            if (i->features.shaderFloat64) {
                out->features.shaderFloat64 = true;
            }
            if (i->features.shaderInt64) {
                out->features.shaderInt64 = true;
            }
            if (i->features.shaderInt16) {
                out->features.shaderInt16 = true;
            }
            if (i->features.shaderResourceResidency) {
                out->features.shaderResourceResidency = true;
            }
            if (i->features.shaderResourceMinLod) {
                out->features.shaderResourceMinLod = true;
            }
            if (i->features.sparseBinding) {
                out->features.sparseBinding = true;
            }
            if (i->features.sparseResidencyBuffer) {
                out->features.sparseResidencyBuffer = true;
            }
            if (i->features.sparseResidencyImage2D) {
                out->features.sparseResidencyImage2D = true;
            }
            if (i->features.sparseResidencyImage3D) {
                out->features.sparseResidencyImage3D = true;
            }
            if (i->features.sparseResidency2Samples) {
                out->features.sparseResidency2Samples = true;
            }
            if (i->features.sparseResidency4Samples) {
                out->features.sparseResidency4Samples = true;
            }
            if (i->features.sparseResidency8Samples) {
                out->features.sparseResidency8Samples = true;
            }
            if (i->features.sparseResidency16Samples) {
                out->features.sparseResidency16Samples = true;
            }
            if (i->features.sparseResidencyAliased) {
                out->features.sparseResidencyAliased = true;
            }
            if (i->features.variableMultisampleRate) {
                out->features.variableMultisampleRate = true;
            }
            if (i->features.inheritedQueries) {
                out->features.inheritedQueries = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV: {
            const VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV *i = (const void *) in;
            if (i->deviceGeneratedCommands) {
                ((VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV))->deviceGeneratedCommands = true;
                ((VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT))->deviceGeneratedCommands = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV: {
            const VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV *i = (const void *) in;
            if (i->deviceGeneratedCompute) {
                ((VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV))->deviceGeneratedCompute = true;
            }
            if (i->deviceGeneratedComputePipelines) {
                ((VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV))->deviceGeneratedComputePipelines = true;
            }
            if (i->deviceGeneratedComputeCaptureReplay) {
                ((VkPhysicalDeviceDeviceGeneratedCommandsComputeFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_COMPUTE_FEATURES_NV))->deviceGeneratedComputeCaptureReplay = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES: {
            const VkPhysicalDevicePrivateDataFeatures *i = (const void *) in;
            if (i->privateData) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDevicePrivateDataFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES))->privateData = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->privateData = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV: {
            const VkPhysicalDeviceClusterAccelerationStructureFeaturesNV *i = (const void *) in;
            if (i->clusterAccelerationStructure) {
                ((VkPhysicalDeviceClusterAccelerationStructureFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_ACCELERATION_STRUCTURE_FEATURES_NV))->clusterAccelerationStructure = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES: {
            const VkPhysicalDeviceVariablePointersFeatures *i = (const void *) in;
            if (i->variablePointersStorageBuffer) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVariablePointersFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES))->variablePointersStorageBuffer = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->variablePointersStorageBuffer = true;
            }
            if (i->variablePointers) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVariablePointersFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES))->variablePointers = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->variablePointers = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES: {
            const VkPhysicalDeviceMultiviewFeatures *i = (const void *) in;
            if (i->multiview) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceMultiviewFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES))->multiview = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->multiview = true;
            }
            if (i->multiviewGeometryShader) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceMultiviewFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES))->multiviewGeometryShader = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->multiviewGeometryShader = true;
            }
            if (i->multiviewTessellationShader) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceMultiviewFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES))->multiviewTessellationShader = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->multiviewTessellationShader = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR: {
            const VkPhysicalDevicePresentIdFeaturesKHR *i = (const void *) in;
            if (i->presentId) {
                ((VkPhysicalDevicePresentIdFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_ID_FEATURES_KHR))->presentId = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR: {
            const VkPhysicalDevicePresentWaitFeaturesKHR *i = (const void *) in;
            if (i->presentWait) {
                ((VkPhysicalDevicePresentWaitFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_WAIT_FEATURES_KHR))->presentWait = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES: {
            const VkPhysicalDevice16BitStorageFeatures *i = (const void *) in;
            if (i->storageBuffer16BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->storageBuffer16BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->storageBuffer16BitAccess = true;
            }
            if (i->uniformAndStorageBuffer16BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->uniformAndStorageBuffer16BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->uniformAndStorageBuffer16BitAccess = true;
            }
            if (i->storagePushConstant16) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->storagePushConstant16 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->storagePushConstant16 = true;
            }
            if (i->storageInputOutput16) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->storageInputOutput16 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->storageInputOutput16 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES: {
            const VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *i = (const void *) in;
            if (i->shaderSubgroupExtendedTypes) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES))->shaderSubgroupExtendedTypes = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderSubgroupExtendedTypes = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES: {
            const VkPhysicalDeviceSamplerYcbcrConversionFeatures *i = (const void *) in;
            if (i->samplerYcbcrConversion) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceSamplerYcbcrConversionFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES))->samplerYcbcrConversion = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->samplerYcbcrConversion = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES: {
            const VkPhysicalDeviceProtectedMemoryFeatures *i = (const void *) in;
            if (i->protectedMemory) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceProtectedMemoryFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES))->protectedMemory = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->protectedMemory = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT: {
            const VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *i = (const void *) in;
            if (i->advancedBlendCoherentOperations) {
                ((VkPhysicalDeviceBlendOperationAdvancedFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BLEND_OPERATION_ADVANCED_FEATURES_EXT))->advancedBlendCoherentOperations = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT: {
            const VkPhysicalDeviceMultiDrawFeaturesEXT *i = (const void *) in;
            if (i->multiDraw) {
                ((VkPhysicalDeviceMultiDrawFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTI_DRAW_FEATURES_EXT))->multiDraw = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES: {
            const VkPhysicalDeviceInlineUniformBlockFeatures *i = (const void *) in;
            if (i->inlineUniformBlock) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceInlineUniformBlockFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES))->inlineUniformBlock = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->inlineUniformBlock = true;
            }
            if (i->descriptorBindingInlineUniformBlockUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceInlineUniformBlockFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES))->descriptorBindingInlineUniformBlockUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->descriptorBindingInlineUniformBlockUpdateAfterBind = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES: {
            const VkPhysicalDeviceMaintenance4Features *i = (const void *) in;
            if (i->maintenance4) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceMaintenance4Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES))->maintenance4 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->maintenance4 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES: {
            const VkPhysicalDeviceMaintenance5Features *i = (const void *) in;
            if (i->maintenance5) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceMaintenance5Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES))->maintenance5 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->maintenance5 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES: {
            const VkPhysicalDeviceMaintenance6Features *i = (const void *) in;
            if (i->maintenance6) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceMaintenance6Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES))->maintenance6 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->maintenance6 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR: {
            const VkPhysicalDeviceMaintenance7FeaturesKHR *i = (const void *) in;
            if (i->maintenance7) {
                ((VkPhysicalDeviceMaintenance7FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_7_FEATURES_KHR))->maintenance7 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR: {
            const VkPhysicalDeviceMaintenance8FeaturesKHR *i = (const void *) in;
            if (i->maintenance8) {
                ((VkPhysicalDeviceMaintenance8FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_8_FEATURES_KHR))->maintenance8 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES: {
            const VkPhysicalDeviceShaderDrawParametersFeatures *i = (const void *) in;
            if (i->shaderDrawParameters) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceShaderDrawParametersFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES))->shaderDrawParameters = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->shaderDrawParameters = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES: {
            const VkPhysicalDeviceShaderFloat16Int8Features *i = (const void *) in;
            if (i->shaderFloat16) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderFloat16Int8Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES))->shaderFloat16 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderFloat16 = true;
            }
            if (i->shaderInt8) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderFloat16Int8Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES))->shaderInt8 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderInt8 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES: {
            const VkPhysicalDeviceHostQueryResetFeatures *i = (const void *) in;
            if (i->hostQueryReset) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceHostQueryResetFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES))->hostQueryReset = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->hostQueryReset = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES: {
            const VkPhysicalDeviceGlobalPriorityQueryFeatures *i = (const void *) in;
            if (i->globalPriorityQuery) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceGlobalPriorityQueryFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES))->globalPriorityQuery = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->globalPriorityQuery = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT: {
            const VkPhysicalDeviceDeviceMemoryReportFeaturesEXT *i = (const void *) in;
            if (i->deviceMemoryReport) {
                ((VkPhysicalDeviceDeviceMemoryReportFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_MEMORY_REPORT_FEATURES_EXT))->deviceMemoryReport = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES: {
            const VkPhysicalDeviceDescriptorIndexingFeatures *i = (const void *) in;
            if (i->shaderInputAttachmentArrayDynamicIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderInputAttachmentArrayDynamicIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderInputAttachmentArrayDynamicIndexing = true;
            }
            if (i->shaderUniformTexelBufferArrayDynamicIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderUniformTexelBufferArrayDynamicIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderUniformTexelBufferArrayDynamicIndexing = true;
            }
            if (i->shaderStorageTexelBufferArrayDynamicIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageTexelBufferArrayDynamicIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageTexelBufferArrayDynamicIndexing = true;
            }
            if (i->shaderUniformBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderUniformBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderUniformBufferArrayNonUniformIndexing = true;
            }
            if (i->shaderSampledImageArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderSampledImageArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderSampledImageArrayNonUniformIndexing = true;
            }
            if (i->shaderStorageBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageBufferArrayNonUniformIndexing = true;
            }
            if (i->shaderStorageImageArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageImageArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageImageArrayNonUniformIndexing = true;
            }
            if (i->shaderInputAttachmentArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderInputAttachmentArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderInputAttachmentArrayNonUniformIndexing = true;
            }
            if (i->shaderUniformTexelBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderUniformTexelBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderUniformTexelBufferArrayNonUniformIndexing = true;
            }
            if (i->shaderStorageTexelBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageTexelBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageTexelBufferArrayNonUniformIndexing = true;
            }
            if (i->descriptorBindingUniformBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingUniformBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingUniformBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingSampledImageUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingSampledImageUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingSampledImageUpdateAfterBind = true;
            }
            if (i->descriptorBindingStorageImageUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingStorageImageUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingStorageImageUpdateAfterBind = true;
            }
            if (i->descriptorBindingStorageBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingStorageBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingStorageBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingUniformTexelBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingUniformTexelBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingUniformTexelBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingStorageTexelBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingStorageTexelBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingStorageTexelBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingUpdateUnusedWhilePending) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingUpdateUnusedWhilePending = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingUpdateUnusedWhilePending = true;
            }
            if (i->descriptorBindingPartiallyBound) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingPartiallyBound = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingPartiallyBound = true;
            }
            if (i->descriptorBindingVariableDescriptorCount) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingVariableDescriptorCount = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingVariableDescriptorCount = true;
            }
            if (i->runtimeDescriptorArray) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->runtimeDescriptorArray = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->runtimeDescriptorArray = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES: {
            const VkPhysicalDeviceTimelineSemaphoreFeatures *i = (const void *) in;
            if (i->timelineSemaphore) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceTimelineSemaphoreFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES))->timelineSemaphore = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->timelineSemaphore = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES: {
            const VkPhysicalDevice8BitStorageFeatures *i = (const void *) in;
            if (i->storageBuffer8BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDevice8BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES))->storageBuffer8BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->storageBuffer8BitAccess = true;
            }
            if (i->uniformAndStorageBuffer8BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDevice8BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES))->uniformAndStorageBuffer8BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->uniformAndStorageBuffer8BitAccess = true;
            }
            if (i->storagePushConstant8) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDevice8BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES))->storagePushConstant8 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->storagePushConstant8 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT: {
            const VkPhysicalDeviceConditionalRenderingFeaturesEXT *i = (const void *) in;
            if (i->conditionalRendering) {
                ((VkPhysicalDeviceConditionalRenderingFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT))->conditionalRendering = true;
            }
            if (i->inheritedConditionalRendering) {
                ((VkPhysicalDeviceConditionalRenderingFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CONDITIONAL_RENDERING_FEATURES_EXT))->inheritedConditionalRendering = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES: {
            const VkPhysicalDeviceVulkanMemoryModelFeatures *i = (const void *) in;
            if (i->vulkanMemoryModel) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkanMemoryModelFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES))->vulkanMemoryModel = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->vulkanMemoryModel = true;
            }
            if (i->vulkanMemoryModelDeviceScope) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkanMemoryModelFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES))->vulkanMemoryModelDeviceScope = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->vulkanMemoryModelDeviceScope = true;
            }
            if (i->vulkanMemoryModelAvailabilityVisibilityChains) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkanMemoryModelFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES))->vulkanMemoryModelAvailabilityVisibilityChains = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->vulkanMemoryModelAvailabilityVisibilityChains = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES: {
            const VkPhysicalDeviceShaderAtomicInt64Features *i = (const void *) in;
            if (i->shaderBufferInt64Atomics) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderAtomicInt64Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES))->shaderBufferInt64Atomics = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderBufferInt64Atomics = true;
            }
            if (i->shaderSharedInt64Atomics) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderAtomicInt64Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES))->shaderSharedInt64Atomics = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderSharedInt64Atomics = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT: {
            const VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *i = (const void *) in;
            if (i->shaderBufferFloat32Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderBufferFloat32Atomics = true;
            }
            if (i->shaderBufferFloat32AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderBufferFloat32AtomicAdd = true;
            }
            if (i->shaderBufferFloat64Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderBufferFloat64Atomics = true;
            }
            if (i->shaderBufferFloat64AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderBufferFloat64AtomicAdd = true;
            }
            if (i->shaderSharedFloat32Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderSharedFloat32Atomics = true;
            }
            if (i->shaderSharedFloat32AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderSharedFloat32AtomicAdd = true;
            }
            if (i->shaderSharedFloat64Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderSharedFloat64Atomics = true;
            }
            if (i->shaderSharedFloat64AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderSharedFloat64AtomicAdd = true;
            }
            if (i->shaderImageFloat32Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderImageFloat32Atomics = true;
            }
            if (i->shaderImageFloat32AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->shaderImageFloat32AtomicAdd = true;
            }
            if (i->sparseImageFloat32Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->sparseImageFloat32Atomics = true;
            }
            if (i->sparseImageFloat32AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloatFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_FEATURES_EXT))->sparseImageFloat32AtomicAdd = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT: {
            const VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *i = (const void *) in;
            if (i->shaderBufferFloat16Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderBufferFloat16Atomics = true;
            }
            if (i->shaderBufferFloat16AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderBufferFloat16AtomicAdd = true;
            }
            if (i->shaderBufferFloat16AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderBufferFloat16AtomicMinMax = true;
            }
            if (i->shaderBufferFloat32AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderBufferFloat32AtomicMinMax = true;
            }
            if (i->shaderBufferFloat64AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderBufferFloat64AtomicMinMax = true;
            }
            if (i->shaderSharedFloat16Atomics) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderSharedFloat16Atomics = true;
            }
            if (i->shaderSharedFloat16AtomicAdd) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderSharedFloat16AtomicAdd = true;
            }
            if (i->shaderSharedFloat16AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderSharedFloat16AtomicMinMax = true;
            }
            if (i->shaderSharedFloat32AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderSharedFloat32AtomicMinMax = true;
            }
            if (i->shaderSharedFloat64AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderSharedFloat64AtomicMinMax = true;
            }
            if (i->shaderImageFloat32AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->shaderImageFloat32AtomicMinMax = true;
            }
            if (i->sparseImageFloat32AtomicMinMax) {
                ((VkPhysicalDeviceShaderAtomicFloat2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT_2_FEATURES_EXT))->sparseImageFloat32AtomicMinMax = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES: {
            const VkPhysicalDeviceVertexAttributeDivisorFeatures *i = (const void *) in;
            if (i->vertexAttributeInstanceRateDivisor) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVertexAttributeDivisorFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES))->vertexAttributeInstanceRateDivisor = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->vertexAttributeInstanceRateDivisor = true;
            }
            if (i->vertexAttributeInstanceRateZeroDivisor) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVertexAttributeDivisorFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES))->vertexAttributeInstanceRateZeroDivisor = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->vertexAttributeInstanceRateZeroDivisor = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT: {
            const VkPhysicalDeviceASTCDecodeFeaturesEXT *i = (const void *) in;
            if (i->decodeModeSharedExponent) {
                ((VkPhysicalDeviceASTCDecodeFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ASTC_DECODE_FEATURES_EXT))->decodeModeSharedExponent = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT: {
            const VkPhysicalDeviceTransformFeedbackFeaturesEXT *i = (const void *) in;
            if (i->transformFeedback) {
                ((VkPhysicalDeviceTransformFeedbackFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT))->transformFeedback = true;
            }
            if (i->geometryStreams) {
                ((VkPhysicalDeviceTransformFeedbackFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TRANSFORM_FEEDBACK_FEATURES_EXT))->geometryStreams = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV: {
            const VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV *i = (const void *) in;
            if (i->representativeFragmentTest) {
                ((VkPhysicalDeviceRepresentativeFragmentTestFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_REPRESENTATIVE_FRAGMENT_TEST_FEATURES_NV))->representativeFragmentTest = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV: {
            const VkPhysicalDeviceExclusiveScissorFeaturesNV *i = (const void *) in;
            if (i->exclusiveScissor) {
                ((VkPhysicalDeviceExclusiveScissorFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXCLUSIVE_SCISSOR_FEATURES_NV))->exclusiveScissor = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV: {
            const VkPhysicalDeviceCornerSampledImageFeaturesNV *i = (const void *) in;
            if (i->cornerSampledImage) {
                ((VkPhysicalDeviceCornerSampledImageFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CORNER_SAMPLED_IMAGE_FEATURES_NV))->cornerSampledImage = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR: {
            const VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *i = (const void *) in;
            if (i->computeDerivativeGroupQuads) {
                ((VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR))->computeDerivativeGroupQuads = true;
            }
            if (i->computeDerivativeGroupLinear) {
                ((VkPhysicalDeviceComputeShaderDerivativesFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMPUTE_SHADER_DERIVATIVES_FEATURES_KHR))->computeDerivativeGroupLinear = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV: {
            const VkPhysicalDeviceShaderImageFootprintFeaturesNV *i = (const void *) in;
            if (i->imageFootprint) {
                ((VkPhysicalDeviceShaderImageFootprintFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_FOOTPRINT_FEATURES_NV))->imageFootprint = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV: {
            const VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV *i = (const void *) in;
            if (i->dedicatedAllocationImageAliasing) {
                ((VkPhysicalDeviceDedicatedAllocationImageAliasingFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEDICATED_ALLOCATION_IMAGE_ALIASING_FEATURES_NV))->dedicatedAllocationImageAliasing = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV: {
            const VkPhysicalDeviceCopyMemoryIndirectFeaturesNV *i = (const void *) in;
            if (i->indirectCopy) {
                ((VkPhysicalDeviceCopyMemoryIndirectFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COPY_MEMORY_INDIRECT_FEATURES_NV))->indirectCopy = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV: {
            const VkPhysicalDeviceMemoryDecompressionFeaturesNV *i = (const void *) in;
            if (i->memoryDecompression) {
                ((VkPhysicalDeviceMemoryDecompressionFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_DECOMPRESSION_FEATURES_NV))->memoryDecompression = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV: {
            const VkPhysicalDeviceShadingRateImageFeaturesNV *i = (const void *) in;
            if (i->shadingRateImage) {
                ((VkPhysicalDeviceShadingRateImageFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV))->shadingRateImage = true;
            }
            if (i->shadingRateCoarseSampleOrder) {
                ((VkPhysicalDeviceShadingRateImageFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADING_RATE_IMAGE_FEATURES_NV))->shadingRateCoarseSampleOrder = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI: {
            const VkPhysicalDeviceInvocationMaskFeaturesHUAWEI *i = (const void *) in;
            if (i->invocationMask) {
                ((VkPhysicalDeviceInvocationMaskFeaturesHUAWEI *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INVOCATION_MASK_FEATURES_HUAWEI))->invocationMask = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV: {
            const VkPhysicalDeviceMeshShaderFeaturesNV *i = (const void *) in;
            if (i->taskShader) {
                ((VkPhysicalDeviceMeshShaderFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV))->taskShader = true;
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->taskShader = true;
            }
            if (i->meshShader) {
                ((VkPhysicalDeviceMeshShaderFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV))->meshShader = true;
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->meshShader = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT: {
            const VkPhysicalDeviceMeshShaderFeaturesEXT *i = (const void *) in;
            if (i->taskShader) {
                ((VkPhysicalDeviceMeshShaderFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV))->taskShader = true;
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->taskShader = true;
            }
            if (i->meshShader) {
                ((VkPhysicalDeviceMeshShaderFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_NV))->meshShader = true;
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->meshShader = true;
            }
            if (i->multiviewMeshShader) {
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->multiviewMeshShader = true;
            }
            if (i->primitiveFragmentShadingRateMeshShader) {
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->primitiveFragmentShadingRateMeshShader = true;
            }
            if (i->meshShaderQueries) {
                ((VkPhysicalDeviceMeshShaderFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MESH_SHADER_FEATURES_EXT))->meshShaderQueries = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR: {
            const VkPhysicalDeviceAccelerationStructureFeaturesKHR *i = (const void *) in;
            if (i->accelerationStructure) {
                ((VkPhysicalDeviceAccelerationStructureFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR))->accelerationStructure = true;
            }
            if (i->accelerationStructureCaptureReplay) {
                ((VkPhysicalDeviceAccelerationStructureFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR))->accelerationStructureCaptureReplay = true;
            }
            if (i->accelerationStructureIndirectBuild) {
                ((VkPhysicalDeviceAccelerationStructureFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR))->accelerationStructureIndirectBuild = true;
            }
            if (i->accelerationStructureHostCommands) {
                ((VkPhysicalDeviceAccelerationStructureFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR))->accelerationStructureHostCommands = true;
            }
            if (i->descriptorBindingAccelerationStructureUpdateAfterBind) {
                ((VkPhysicalDeviceAccelerationStructureFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ACCELERATION_STRUCTURE_FEATURES_KHR))->descriptorBindingAccelerationStructureUpdateAfterBind = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR: {
            const VkPhysicalDeviceRayTracingPipelineFeaturesKHR *i = (const void *) in;
            if (i->rayTracingPipeline) {
                ((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR))->rayTracingPipeline = true;
            }
            if (i->rayTracingPipelineShaderGroupHandleCaptureReplay) {
                ((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR))->rayTracingPipelineShaderGroupHandleCaptureReplay = true;
            }
            if (i->rayTracingPipelineShaderGroupHandleCaptureReplayMixed) {
                ((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR))->rayTracingPipelineShaderGroupHandleCaptureReplayMixed = true;
            }
            if (i->rayTracingPipelineTraceRaysIndirect) {
                ((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR))->rayTracingPipelineTraceRaysIndirect = true;
            }
            if (i->rayTraversalPrimitiveCulling) {
                ((VkPhysicalDeviceRayTracingPipelineFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_PIPELINE_FEATURES_KHR))->rayTraversalPrimitiveCulling = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR: {
            const VkPhysicalDeviceRayQueryFeaturesKHR *i = (const void *) in;
            if (i->rayQuery) {
                ((VkPhysicalDeviceRayQueryFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_QUERY_FEATURES_KHR))->rayQuery = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR: {
            const VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *i = (const void *) in;
            if (i->rayTracingMaintenance1) {
                ((VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR))->rayTracingMaintenance1 = true;
            }
            if (i->rayTracingPipelineTraceRaysIndirect2) {
                ((VkPhysicalDeviceRayTracingMaintenance1FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MAINTENANCE_1_FEATURES_KHR))->rayTracingPipelineTraceRaysIndirect2 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT: {
            const VkPhysicalDeviceFragmentDensityMapFeaturesEXT *i = (const void *) in;
            if (i->fragmentDensityMap) {
                ((VkPhysicalDeviceFragmentDensityMapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT))->fragmentDensityMap = true;
            }
            if (i->fragmentDensityMapDynamic) {
                ((VkPhysicalDeviceFragmentDensityMapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT))->fragmentDensityMapDynamic = true;
            }
            if (i->fragmentDensityMapNonSubsampledImages) {
                ((VkPhysicalDeviceFragmentDensityMapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_FEATURES_EXT))->fragmentDensityMapNonSubsampledImages = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT: {
            const VkPhysicalDeviceFragmentDensityMap2FeaturesEXT *i = (const void *) in;
            if (i->fragmentDensityMapDeferred) {
                ((VkPhysicalDeviceFragmentDensityMap2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_2_FEATURES_EXT))->fragmentDensityMapDeferred = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM: {
            const VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM *i = (const void *) in;
            if (i->fragmentDensityMapOffset) {
                ((VkPhysicalDeviceFragmentDensityMapOffsetFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_DENSITY_MAP_OFFSET_FEATURES_QCOM))->fragmentDensityMapOffset = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES: {
            const VkPhysicalDeviceScalarBlockLayoutFeatures *i = (const void *) in;
            if (i->scalarBlockLayout) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceScalarBlockLayoutFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES))->scalarBlockLayout = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->scalarBlockLayout = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES: {
            const VkPhysicalDeviceUniformBufferStandardLayoutFeatures *i = (const void *) in;
            if (i->uniformBufferStandardLayout) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES))->uniformBufferStandardLayout = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->uniformBufferStandardLayout = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT: {
            const VkPhysicalDeviceDepthClipEnableFeaturesEXT *i = (const void *) in;
            if (i->depthClipEnable) {
                ((VkPhysicalDeviceDepthClipEnableFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_ENABLE_FEATURES_EXT))->depthClipEnable = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT: {
            const VkPhysicalDeviceMemoryPriorityFeaturesEXT *i = (const void *) in;
            if (i->memoryPriority) {
                ((VkPhysicalDeviceMemoryPriorityFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MEMORY_PRIORITY_FEATURES_EXT))->memoryPriority = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT: {
            const VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT *i = (const void *) in;
            if (i->pageableDeviceLocalMemory) {
                ((VkPhysicalDevicePageableDeviceLocalMemoryFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PAGEABLE_DEVICE_LOCAL_MEMORY_FEATURES_EXT))->pageableDeviceLocalMemory = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES: {
            const VkPhysicalDeviceBufferDeviceAddressFeatures *i = (const void *) in;
            if (i->bufferDeviceAddress) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddress = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddress = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddress = true;
            }
            if (i->bufferDeviceAddressCaptureReplay) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddressCaptureReplay = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddressCaptureReplay = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddressCaptureReplay = true;
            }
            if (i->bufferDeviceAddressMultiDevice) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddressMultiDevice = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddressMultiDevice = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddressMultiDevice = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT: {
            const VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *i = (const void *) in;
            if (i->bufferDeviceAddress) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddress = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddress = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddress = true;
            }
            if (i->bufferDeviceAddressCaptureReplay) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddressCaptureReplay = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddressCaptureReplay = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddressCaptureReplay = true;
            }
            if (i->bufferDeviceAddressMultiDevice) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddressMultiDevice = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddressMultiDevice = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddressMultiDevice = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES: {
            const VkPhysicalDeviceImagelessFramebufferFeatures *i = (const void *) in;
            if (i->imagelessFramebuffer) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceImagelessFramebufferFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES))->imagelessFramebuffer = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->imagelessFramebuffer = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES: {
            const VkPhysicalDeviceTextureCompressionASTCHDRFeatures *i = (const void *) in;
            if (i->textureCompressionASTC_HDR) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES))->textureCompressionASTC_HDR = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->textureCompressionASTC_HDR = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV: {
            const VkPhysicalDeviceCooperativeMatrixFeaturesNV *i = (const void *) in;
            if (i->cooperativeMatrix) {
                ((VkPhysicalDeviceCooperativeMatrixFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV))->cooperativeMatrix = true;
                ((VkPhysicalDeviceCooperativeMatrixFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR))->cooperativeMatrix = true;
            }
            if (i->cooperativeMatrixRobustBufferAccess) {
                ((VkPhysicalDeviceCooperativeMatrixFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV))->cooperativeMatrixRobustBufferAccess = true;
                ((VkPhysicalDeviceCooperativeMatrixFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR))->cooperativeMatrixRobustBufferAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT: {
            const VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *i = (const void *) in;
            if (i->ycbcrImageArrays) {
                ((VkPhysicalDeviceYcbcrImageArraysFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_IMAGE_ARRAYS_FEATURES_EXT))->ycbcrImageArrays = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV: {
            const VkPhysicalDevicePresentBarrierFeaturesNV *i = (const void *) in;
            if (i->presentBarrier) {
                ((VkPhysicalDevicePresentBarrierFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_BARRIER_FEATURES_NV))->presentBarrier = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR: {
            const VkPhysicalDevicePerformanceQueryFeaturesKHR *i = (const void *) in;
            if (i->performanceCounterQueryPools) {
                ((VkPhysicalDevicePerformanceQueryFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR))->performanceCounterQueryPools = true;
            }
            if (i->performanceCounterMultipleQueryPools) {
                ((VkPhysicalDevicePerformanceQueryFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PERFORMANCE_QUERY_FEATURES_KHR))->performanceCounterMultipleQueryPools = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV: {
            const VkPhysicalDeviceCoverageReductionModeFeaturesNV *i = (const void *) in;
            if (i->coverageReductionMode) {
                ((VkPhysicalDeviceCoverageReductionModeFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COVERAGE_REDUCTION_MODE_FEATURES_NV))->coverageReductionMode = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL: {
            const VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL *i = (const void *) in;
            if (i->shaderIntegerFunctions2) {
                ((VkPhysicalDeviceShaderIntegerFunctions2FeaturesINTEL *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_FUNCTIONS_2_FEATURES_INTEL))->shaderIntegerFunctions2 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR: {
            const VkPhysicalDeviceShaderClockFeaturesKHR *i = (const void *) in;
            if (i->shaderSubgroupClock) {
                ((VkPhysicalDeviceShaderClockFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR))->shaderSubgroupClock = true;
            }
            if (i->shaderDeviceClock) {
                ((VkPhysicalDeviceShaderClockFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CLOCK_FEATURES_KHR))->shaderDeviceClock = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES: {
            const VkPhysicalDeviceIndexTypeUint8Features *i = (const void *) in;
            if (i->indexTypeUint8) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceIndexTypeUint8Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES))->indexTypeUint8 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->indexTypeUint8 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV: {
            const VkPhysicalDeviceShaderSMBuiltinsFeaturesNV *i = (const void *) in;
            if (i->shaderSMBuiltins) {
                ((VkPhysicalDeviceShaderSMBuiltinsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SM_BUILTINS_FEATURES_NV))->shaderSMBuiltins = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT: {
            const VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *i = (const void *) in;
            if (i->fragmentShaderSampleInterlock) {
                ((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT))->fragmentShaderSampleInterlock = true;
            }
            if (i->fragmentShaderPixelInterlock) {
                ((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT))->fragmentShaderPixelInterlock = true;
            }
            if (i->fragmentShaderShadingRateInterlock) {
                ((VkPhysicalDeviceFragmentShaderInterlockFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_INTERLOCK_FEATURES_EXT))->fragmentShaderShadingRateInterlock = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES: {
            const VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *i = (const void *) in;
            if (i->separateDepthStencilLayouts) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES))->separateDepthStencilLayouts = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->separateDepthStencilLayouts = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT: {
            const VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *i = (const void *) in;
            if (i->primitiveTopologyListRestart) {
                ((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT))->primitiveTopologyListRestart = true;
            }
            if (i->primitiveTopologyPatchListRestart) {
                ((VkPhysicalDevicePrimitiveTopologyListRestartFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVE_TOPOLOGY_LIST_RESTART_FEATURES_EXT))->primitiveTopologyPatchListRestart = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR: {
            const VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR *i = (const void *) in;
            if (i->pipelineExecutableInfo) {
                ((VkPhysicalDevicePipelineExecutablePropertiesFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_EXECUTABLE_PROPERTIES_FEATURES_KHR))->pipelineExecutableInfo = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES: {
            const VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *i = (const void *) in;
            if (i->shaderDemoteToHelperInvocation) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES))->shaderDemoteToHelperInvocation = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderDemoteToHelperInvocation = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT: {
            const VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *i = (const void *) in;
            if (i->texelBufferAlignment) {
                ((VkPhysicalDeviceTexelBufferAlignmentFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXEL_BUFFER_ALIGNMENT_FEATURES_EXT))->texelBufferAlignment = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES: {
            const VkPhysicalDeviceSubgroupSizeControlFeatures *i = (const void *) in;
            if (i->subgroupSizeControl) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceSubgroupSizeControlFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES))->subgroupSizeControl = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->subgroupSizeControl = true;
            }
            if (i->computeFullSubgroups) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceSubgroupSizeControlFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES))->computeFullSubgroups = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->computeFullSubgroups = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES: {
            const VkPhysicalDeviceLineRasterizationFeatures *i = (const void *) in;
            if (i->rectangularLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->rectangularLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->rectangularLines = true;
            }
            if (i->bresenhamLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->bresenhamLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->bresenhamLines = true;
            }
            if (i->smoothLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->smoothLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->smoothLines = true;
            }
            if (i->stippledRectangularLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->stippledRectangularLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->stippledRectangularLines = true;
            }
            if (i->stippledBresenhamLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->stippledBresenhamLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->stippledBresenhamLines = true;
            }
            if (i->stippledSmoothLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->stippledSmoothLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->stippledSmoothLines = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES: {
            const VkPhysicalDevicePipelineCreationCacheControlFeatures *i = (const void *) in;
            if (i->pipelineCreationCacheControl) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDevicePipelineCreationCacheControlFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES))->pipelineCreationCacheControl = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->pipelineCreationCacheControl = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES: {
            const VkPhysicalDeviceVulkan11Features *i = (const void *) in;
            if (i->storageBuffer16BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->storageBuffer16BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->storageBuffer16BitAccess = true;
            }
            if (i->uniformAndStorageBuffer16BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->uniformAndStorageBuffer16BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->uniformAndStorageBuffer16BitAccess = true;
            }
            if (i->storagePushConstant16) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->storagePushConstant16 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->storagePushConstant16 = true;
            }
            if (i->storageInputOutput16) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDevice16BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_16BIT_STORAGE_FEATURES))->storageInputOutput16 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->storageInputOutput16 = true;
            }
            if (i->multiview) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceMultiviewFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES))->multiview = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->multiview = true;
            }
            if (i->multiviewGeometryShader) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceMultiviewFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES))->multiviewGeometryShader = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->multiviewGeometryShader = true;
            }
            if (i->multiviewTessellationShader) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceMultiviewFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_FEATURES))->multiviewTessellationShader = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->multiviewTessellationShader = true;
            }
            if (i->variablePointersStorageBuffer) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVariablePointersFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES))->variablePointersStorageBuffer = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->variablePointersStorageBuffer = true;
            }
            if (i->variablePointers) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVariablePointersFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VARIABLE_POINTERS_FEATURES))->variablePointers = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->variablePointers = true;
            }
            if (i->protectedMemory) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceProtectedMemoryFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROTECTED_MEMORY_FEATURES))->protectedMemory = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->protectedMemory = true;
            }
            if (i->samplerYcbcrConversion) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceSamplerYcbcrConversionFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SAMPLER_YCBCR_CONVERSION_FEATURES))->samplerYcbcrConversion = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->samplerYcbcrConversion = true;
            }
            if (i->shaderDrawParameters) {
               if (!api_ver || api_ver < VK_API_VERSION_1_1)
                ((VkPhysicalDeviceShaderDrawParametersFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DRAW_PARAMETERS_FEATURES))->shaderDrawParameters = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_1)
                ((VkPhysicalDeviceVulkan11Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_1_FEATURES))->shaderDrawParameters = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES: {
            const VkPhysicalDeviceVulkan12Features *i = (const void *) in;
            if (i->samplerMirrorClampToEdge) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->samplerMirrorClampToEdge = true;
            }
            if (i->drawIndirectCount) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->drawIndirectCount = true;
            }
            if (i->storageBuffer8BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDevice8BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES))->storageBuffer8BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->storageBuffer8BitAccess = true;
            }
            if (i->uniformAndStorageBuffer8BitAccess) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDevice8BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES))->uniformAndStorageBuffer8BitAccess = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->uniformAndStorageBuffer8BitAccess = true;
            }
            if (i->storagePushConstant8) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDevice8BitStorageFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_8BIT_STORAGE_FEATURES))->storagePushConstant8 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->storagePushConstant8 = true;
            }
            if (i->shaderBufferInt64Atomics) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderAtomicInt64Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES))->shaderBufferInt64Atomics = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderBufferInt64Atomics = true;
            }
            if (i->shaderSharedInt64Atomics) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderAtomicInt64Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_INT64_FEATURES))->shaderSharedInt64Atomics = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderSharedInt64Atomics = true;
            }
            if (i->shaderFloat16) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderFloat16Int8Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES))->shaderFloat16 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderFloat16 = true;
            }
            if (i->shaderInt8) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderFloat16Int8Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT16_INT8_FEATURES))->shaderInt8 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderInt8 = true;
            }
            if (i->descriptorIndexing) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorIndexing = true;
            }
            if (i->shaderInputAttachmentArrayDynamicIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderInputAttachmentArrayDynamicIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderInputAttachmentArrayDynamicIndexing = true;
            }
            if (i->shaderUniformTexelBufferArrayDynamicIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderUniformTexelBufferArrayDynamicIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderUniformTexelBufferArrayDynamicIndexing = true;
            }
            if (i->shaderStorageTexelBufferArrayDynamicIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageTexelBufferArrayDynamicIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageTexelBufferArrayDynamicIndexing = true;
            }
            if (i->shaderUniformBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderUniformBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderUniformBufferArrayNonUniformIndexing = true;
            }
            if (i->shaderSampledImageArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderSampledImageArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderSampledImageArrayNonUniformIndexing = true;
            }
            if (i->shaderStorageBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageBufferArrayNonUniformIndexing = true;
            }
            if (i->shaderStorageImageArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageImageArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageImageArrayNonUniformIndexing = true;
            }
            if (i->shaderInputAttachmentArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderInputAttachmentArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderInputAttachmentArrayNonUniformIndexing = true;
            }
            if (i->shaderUniformTexelBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderUniformTexelBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderUniformTexelBufferArrayNonUniformIndexing = true;
            }
            if (i->shaderStorageTexelBufferArrayNonUniformIndexing) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->shaderStorageTexelBufferArrayNonUniformIndexing = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderStorageTexelBufferArrayNonUniformIndexing = true;
            }
            if (i->descriptorBindingUniformBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingUniformBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingUniformBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingSampledImageUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingSampledImageUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingSampledImageUpdateAfterBind = true;
            }
            if (i->descriptorBindingStorageImageUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingStorageImageUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingStorageImageUpdateAfterBind = true;
            }
            if (i->descriptorBindingStorageBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingStorageBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingStorageBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingUniformTexelBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingUniformTexelBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingUniformTexelBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingStorageTexelBufferUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingStorageTexelBufferUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingStorageTexelBufferUpdateAfterBind = true;
            }
            if (i->descriptorBindingUpdateUnusedWhilePending) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingUpdateUnusedWhilePending = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingUpdateUnusedWhilePending = true;
            }
            if (i->descriptorBindingPartiallyBound) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingPartiallyBound = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingPartiallyBound = true;
            }
            if (i->descriptorBindingVariableDescriptorCount) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->descriptorBindingVariableDescriptorCount = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->descriptorBindingVariableDescriptorCount = true;
            }
            if (i->runtimeDescriptorArray) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceDescriptorIndexingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_INDEXING_FEATURES))->runtimeDescriptorArray = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->runtimeDescriptorArray = true;
            }
            if (i->samplerFilterMinmax) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->samplerFilterMinmax = true;
            }
            if (i->scalarBlockLayout) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceScalarBlockLayoutFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCALAR_BLOCK_LAYOUT_FEATURES))->scalarBlockLayout = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->scalarBlockLayout = true;
            }
            if (i->imagelessFramebuffer) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceImagelessFramebufferFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGELESS_FRAMEBUFFER_FEATURES))->imagelessFramebuffer = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->imagelessFramebuffer = true;
            }
            if (i->uniformBufferStandardLayout) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceUniformBufferStandardLayoutFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_UNIFORM_BUFFER_STANDARD_LAYOUT_FEATURES))->uniformBufferStandardLayout = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->uniformBufferStandardLayout = true;
            }
            if (i->shaderSubgroupExtendedTypes) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceShaderSubgroupExtendedTypesFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_EXTENDED_TYPES_FEATURES))->shaderSubgroupExtendedTypes = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderSubgroupExtendedTypes = true;
            }
            if (i->separateDepthStencilLayouts) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceSeparateDepthStencilLayoutsFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SEPARATE_DEPTH_STENCIL_LAYOUTS_FEATURES))->separateDepthStencilLayouts = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->separateDepthStencilLayouts = true;
            }
            if (i->hostQueryReset) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceHostQueryResetFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_QUERY_RESET_FEATURES))->hostQueryReset = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->hostQueryReset = true;
            }
            if (i->timelineSemaphore) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceTimelineSemaphoreFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TIMELINE_SEMAPHORE_FEATURES))->timelineSemaphore = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->timelineSemaphore = true;
            }
            if (i->bufferDeviceAddress) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddress = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddress = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddress = true;
            }
            if (i->bufferDeviceAddressCaptureReplay) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddressCaptureReplay = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddressCaptureReplay = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddressCaptureReplay = true;
            }
            if (i->bufferDeviceAddressMultiDevice) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES))->bufferDeviceAddressMultiDevice = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceBufferDeviceAddressFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BUFFER_DEVICE_ADDRESS_FEATURES_EXT))->bufferDeviceAddressMultiDevice = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->bufferDeviceAddressMultiDevice = true;
            }
            if (i->vulkanMemoryModel) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkanMemoryModelFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES))->vulkanMemoryModel = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->vulkanMemoryModel = true;
            }
            if (i->vulkanMemoryModelDeviceScope) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkanMemoryModelFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES))->vulkanMemoryModelDeviceScope = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->vulkanMemoryModelDeviceScope = true;
            }
            if (i->vulkanMemoryModelAvailabilityVisibilityChains) {
               if (!api_ver || api_ver < VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkanMemoryModelFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_MEMORY_MODEL_FEATURES))->vulkanMemoryModelAvailabilityVisibilityChains = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->vulkanMemoryModelAvailabilityVisibilityChains = true;
            }
            if (i->shaderOutputViewportIndex) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderOutputViewportIndex = true;
            }
            if (i->shaderOutputLayer) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->shaderOutputLayer = true;
            }
            if (i->subgroupBroadcastDynamicId) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_2)
                ((VkPhysicalDeviceVulkan12Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_2_FEATURES))->subgroupBroadcastDynamicId = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES: {
            const VkPhysicalDeviceVulkan13Features *i = (const void *) in;
            if (i->robustImageAccess) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->robustImageAccess = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceImageRobustnessFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES))->robustImageAccess = true;
            }
            if (i->inlineUniformBlock) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceInlineUniformBlockFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES))->inlineUniformBlock = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->inlineUniformBlock = true;
            }
            if (i->descriptorBindingInlineUniformBlockUpdateAfterBind) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceInlineUniformBlockFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INLINE_UNIFORM_BLOCK_FEATURES))->descriptorBindingInlineUniformBlockUpdateAfterBind = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->descriptorBindingInlineUniformBlockUpdateAfterBind = true;
            }
            if (i->pipelineCreationCacheControl) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDevicePipelineCreationCacheControlFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_CREATION_CACHE_CONTROL_FEATURES))->pipelineCreationCacheControl = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->pipelineCreationCacheControl = true;
            }
            if (i->privateData) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDevicePrivateDataFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIVATE_DATA_FEATURES))->privateData = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->privateData = true;
            }
            if (i->shaderDemoteToHelperInvocation) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceShaderDemoteToHelperInvocationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_DEMOTE_TO_HELPER_INVOCATION_FEATURES))->shaderDemoteToHelperInvocation = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderDemoteToHelperInvocation = true;
            }
            if (i->shaderTerminateInvocation) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderTerminateInvocation = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceShaderTerminateInvocationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES))->shaderTerminateInvocation = true;
            }
            if (i->subgroupSizeControl) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceSubgroupSizeControlFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES))->subgroupSizeControl = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->subgroupSizeControl = true;
            }
            if (i->computeFullSubgroups) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceSubgroupSizeControlFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBGROUP_SIZE_CONTROL_FEATURES))->computeFullSubgroups = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->computeFullSubgroups = true;
            }
            if (i->synchronization2) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->synchronization2 = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceSynchronization2Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES))->synchronization2 = true;
            }
            if (i->textureCompressionASTC_HDR) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceTextureCompressionASTCHDRFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TEXTURE_COMPRESSION_ASTC_HDR_FEATURES))->textureCompressionASTC_HDR = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->textureCompressionASTC_HDR = true;
            }
            if (i->shaderZeroInitializeWorkgroupMemory) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderZeroInitializeWorkgroupMemory = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES))->shaderZeroInitializeWorkgroupMemory = true;
            }
            if (i->dynamicRendering) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->dynamicRendering = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceDynamicRenderingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES))->dynamicRendering = true;
            }
            if (i->shaderIntegerDotProduct) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderIntegerDotProduct = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceShaderIntegerDotProductFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES))->shaderIntegerDotProduct = true;
            }
            if (i->maintenance4) {
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceMaintenance4Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_4_FEATURES))->maintenance4 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->maintenance4 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES: {
            const VkPhysicalDeviceVulkan14Features *i = (const void *) in;
            if (i->globalPriorityQuery) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceGlobalPriorityQueryFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GLOBAL_PRIORITY_QUERY_FEATURES))->globalPriorityQuery = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->globalPriorityQuery = true;
            }
            if (i->shaderSubgroupRotate) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderSubgroupRotate = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderSubgroupRotateFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES))->shaderSubgroupRotate = true;
            }
            if (i->shaderSubgroupRotateClustered) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderSubgroupRotateClustered = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderSubgroupRotateFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES))->shaderSubgroupRotateClustered = true;
            }
            if (i->shaderFloatControls2) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderFloatControls2 = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderFloatControls2Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES))->shaderFloatControls2 = true;
            }
            if (i->shaderExpectAssume) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderExpectAssume = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderExpectAssumeFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES))->shaderExpectAssume = true;
            }
            if (i->rectangularLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->rectangularLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->rectangularLines = true;
            }
            if (i->bresenhamLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->bresenhamLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->bresenhamLines = true;
            }
            if (i->smoothLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->smoothLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->smoothLines = true;
            }
            if (i->stippledRectangularLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->stippledRectangularLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->stippledRectangularLines = true;
            }
            if (i->stippledBresenhamLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->stippledBresenhamLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->stippledBresenhamLines = true;
            }
            if (i->stippledSmoothLines) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceLineRasterizationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINE_RASTERIZATION_FEATURES))->stippledSmoothLines = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->stippledSmoothLines = true;
            }
            if (i->vertexAttributeInstanceRateDivisor) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVertexAttributeDivisorFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES))->vertexAttributeInstanceRateDivisor = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->vertexAttributeInstanceRateDivisor = true;
            }
            if (i->vertexAttributeInstanceRateZeroDivisor) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVertexAttributeDivisorFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_DIVISOR_FEATURES))->vertexAttributeInstanceRateZeroDivisor = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->vertexAttributeInstanceRateZeroDivisor = true;
            }
            if (i->indexTypeUint8) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceIndexTypeUint8Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INDEX_TYPE_UINT8_FEATURES))->indexTypeUint8 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->indexTypeUint8 = true;
            }
            if (i->dynamicRenderingLocalRead) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->dynamicRenderingLocalRead = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceDynamicRenderingLocalReadFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES))->dynamicRenderingLocalRead = true;
            }
            if (i->maintenance5) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceMaintenance5Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_5_FEATURES))->maintenance5 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->maintenance5 = true;
            }
            if (i->maintenance6) {
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceMaintenance6Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAINTENANCE_6_FEATURES))->maintenance6 = true;
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->maintenance6 = true;
            }
            if (i->pipelineProtectedAccess) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->pipelineProtectedAccess = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDevicePipelineProtectedAccessFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES))->pipelineProtectedAccess = true;
            }
            if (i->pipelineRobustness) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->pipelineRobustness = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDevicePipelineRobustnessFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES))->pipelineRobustness = true;
            }
            if (i->hostImageCopy) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->hostImageCopy = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceHostImageCopyFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES))->hostImageCopy = true;
            }
            if (i->pushDescriptor) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->pushDescriptor = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD: {
            const VkPhysicalDeviceCoherentMemoryFeaturesAMD *i = (const void *) in;
            if (i->deviceCoherentMemory) {
                ((VkPhysicalDeviceCoherentMemoryFeaturesAMD *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COHERENT_MEMORY_FEATURES_AMD))->deviceCoherentMemory = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT: {
            const VkPhysicalDeviceCustomBorderColorFeaturesEXT *i = (const void *) in;
            if (i->customBorderColors) {
                ((VkPhysicalDeviceCustomBorderColorFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT))->customBorderColors = true;
            }
            if (i->customBorderColorWithoutFormat) {
                ((VkPhysicalDeviceCustomBorderColorFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUSTOM_BORDER_COLOR_FEATURES_EXT))->customBorderColorWithoutFormat = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT: {
            const VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *i = (const void *) in;
            if (i->borderColorSwizzle) {
                ((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT))->borderColorSwizzle = true;
            }
            if (i->borderColorSwizzleFromImage) {
                ((VkPhysicalDeviceBorderColorSwizzleFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_BORDER_COLOR_SWIZZLE_FEATURES_EXT))->borderColorSwizzleFromImage = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT: {
            const VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *i = (const void *) in;
            if (i->extendedDynamicState) {
                ((VkPhysicalDeviceExtendedDynamicStateFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_FEATURES_EXT))->extendedDynamicState = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT: {
            const VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *i = (const void *) in;
            if (i->extendedDynamicState2) {
                ((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT))->extendedDynamicState2 = true;
            }
            if (i->extendedDynamicState2LogicOp) {
                ((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT))->extendedDynamicState2LogicOp = true;
            }
            if (i->extendedDynamicState2PatchControlPoints) {
                ((VkPhysicalDeviceExtendedDynamicState2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_2_FEATURES_EXT))->extendedDynamicState2PatchControlPoints = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT: {
            const VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *i = (const void *) in;
            if (i->extendedDynamicState3TessellationDomainOrigin) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3TessellationDomainOrigin = true;
            }
            if (i->extendedDynamicState3DepthClampEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3DepthClampEnable = true;
            }
            if (i->extendedDynamicState3PolygonMode) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3PolygonMode = true;
            }
            if (i->extendedDynamicState3RasterizationSamples) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3RasterizationSamples = true;
            }
            if (i->extendedDynamicState3SampleMask) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3SampleMask = true;
            }
            if (i->extendedDynamicState3AlphaToCoverageEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3AlphaToCoverageEnable = true;
            }
            if (i->extendedDynamicState3AlphaToOneEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3AlphaToOneEnable = true;
            }
            if (i->extendedDynamicState3LogicOpEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3LogicOpEnable = true;
            }
            if (i->extendedDynamicState3ColorBlendEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ColorBlendEnable = true;
            }
            if (i->extendedDynamicState3ColorBlendEquation) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ColorBlendEquation = true;
            }
            if (i->extendedDynamicState3ColorWriteMask) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ColorWriteMask = true;
            }
            if (i->extendedDynamicState3RasterizationStream) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3RasterizationStream = true;
            }
            if (i->extendedDynamicState3ConservativeRasterizationMode) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ConservativeRasterizationMode = true;
            }
            if (i->extendedDynamicState3ExtraPrimitiveOverestimationSize) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ExtraPrimitiveOverestimationSize = true;
            }
            if (i->extendedDynamicState3DepthClipEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3DepthClipEnable = true;
            }
            if (i->extendedDynamicState3SampleLocationsEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3SampleLocationsEnable = true;
            }
            if (i->extendedDynamicState3ColorBlendAdvanced) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ColorBlendAdvanced = true;
            }
            if (i->extendedDynamicState3ProvokingVertexMode) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ProvokingVertexMode = true;
            }
            if (i->extendedDynamicState3LineRasterizationMode) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3LineRasterizationMode = true;
            }
            if (i->extendedDynamicState3LineStippleEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3LineStippleEnable = true;
            }
            if (i->extendedDynamicState3DepthClipNegativeOneToOne) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3DepthClipNegativeOneToOne = true;
            }
            if (i->extendedDynamicState3ViewportWScalingEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ViewportWScalingEnable = true;
            }
            if (i->extendedDynamicState3ViewportSwizzle) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ViewportSwizzle = true;
            }
            if (i->extendedDynamicState3CoverageToColorEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3CoverageToColorEnable = true;
            }
            if (i->extendedDynamicState3CoverageToColorLocation) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3CoverageToColorLocation = true;
            }
            if (i->extendedDynamicState3CoverageModulationMode) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3CoverageModulationMode = true;
            }
            if (i->extendedDynamicState3CoverageModulationTableEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3CoverageModulationTableEnable = true;
            }
            if (i->extendedDynamicState3CoverageModulationTable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3CoverageModulationTable = true;
            }
            if (i->extendedDynamicState3CoverageReductionMode) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3CoverageReductionMode = true;
            }
            if (i->extendedDynamicState3RepresentativeFragmentTestEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3RepresentativeFragmentTestEnable = true;
            }
            if (i->extendedDynamicState3ShadingRateImageEnable) {
                ((VkPhysicalDeviceExtendedDynamicState3FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_DYNAMIC_STATE_3_FEATURES_EXT))->extendedDynamicState3ShadingRateImageEnable = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV: {
            const VkPhysicalDevicePartitionedAccelerationStructureFeaturesNV *i = (const void *) in;
            if (i->partitionedAccelerationStructure) {
                ((VkPhysicalDevicePartitionedAccelerationStructureFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PARTITIONED_ACCELERATION_STRUCTURE_FEATURES_NV))->partitionedAccelerationStructure = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV: {
            const VkPhysicalDeviceDiagnosticsConfigFeaturesNV *i = (const void *) in;
            if (i->diagnosticsConfig) {
                ((VkPhysicalDeviceDiagnosticsConfigFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DIAGNOSTICS_CONFIG_FEATURES_NV))->diagnosticsConfig = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES: {
            const VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *i = (const void *) in;
            if (i->shaderZeroInitializeWorkgroupMemory) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderZeroInitializeWorkgroupMemory = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceZeroInitializeWorkgroupMemoryFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ZERO_INITIALIZE_WORKGROUP_MEMORY_FEATURES))->shaderZeroInitializeWorkgroupMemory = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR: {
            const VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *i = (const void *) in;
            if (i->shaderSubgroupUniformControlFlow) {
                ((VkPhysicalDeviceShaderSubgroupUniformControlFlowFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_UNIFORM_CONTROL_FLOW_FEATURES_KHR))->shaderSubgroupUniformControlFlow = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT: {
            const VkPhysicalDeviceRobustness2FeaturesEXT *i = (const void *) in;
            if (i->robustBufferAccess2) {
                ((VkPhysicalDeviceRobustness2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT))->robustBufferAccess2 = true;
            }
            if (i->robustImageAccess2) {
                ((VkPhysicalDeviceRobustness2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT))->robustImageAccess2 = true;
            }
            if (i->nullDescriptor) {
                ((VkPhysicalDeviceRobustness2FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ROBUSTNESS_2_FEATURES_EXT))->nullDescriptor = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES: {
            const VkPhysicalDeviceImageRobustnessFeatures *i = (const void *) in;
            if (i->robustImageAccess) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->robustImageAccess = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceImageRobustnessFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ROBUSTNESS_FEATURES))->robustImageAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR: {
            const VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *i = (const void *) in;
            if (i->workgroupMemoryExplicitLayout) {
                ((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR))->workgroupMemoryExplicitLayout = true;
            }
            if (i->workgroupMemoryExplicitLayoutScalarBlockLayout) {
                ((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR))->workgroupMemoryExplicitLayoutScalarBlockLayout = true;
            }
            if (i->workgroupMemoryExplicitLayout8BitAccess) {
                ((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR))->workgroupMemoryExplicitLayout8BitAccess = true;
            }
            if (i->workgroupMemoryExplicitLayout16BitAccess) {
                ((VkPhysicalDeviceWorkgroupMemoryExplicitLayoutFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_WORKGROUP_MEMORY_EXPLICIT_LAYOUT_FEATURES_KHR))->workgroupMemoryExplicitLayout16BitAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT: {
            const VkPhysicalDevice4444FormatsFeaturesEXT *i = (const void *) in;
            if (i->formatA4R4G4B4) {
                ((VkPhysicalDevice4444FormatsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT))->formatA4R4G4B4 = true;
            }
            if (i->formatA4B4G4R4) {
                ((VkPhysicalDevice4444FormatsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_4444_FORMATS_FEATURES_EXT))->formatA4B4G4R4 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI: {
            const VkPhysicalDeviceSubpassShadingFeaturesHUAWEI *i = (const void *) in;
            if (i->subpassShading) {
                ((VkPhysicalDeviceSubpassShadingFeaturesHUAWEI *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_SHADING_FEATURES_HUAWEI))->subpassShading = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI: {
            const VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI *i = (const void *) in;
            if (i->clustercullingShader) {
                ((VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI))->clustercullingShader = true;
            }
            if (i->multiviewClusterCullingShader) {
                ((VkPhysicalDeviceClusterCullingShaderFeaturesHUAWEI *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CLUSTER_CULLING_SHADER_FEATURES_HUAWEI))->multiviewClusterCullingShader = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT: {
            const VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *i = (const void *) in;
            if (i->shaderImageInt64Atomics) {
                ((VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT))->shaderImageInt64Atomics = true;
            }
            if (i->sparseImageInt64Atomics) {
                ((VkPhysicalDeviceShaderImageAtomicInt64FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_IMAGE_ATOMIC_INT64_FEATURES_EXT))->sparseImageInt64Atomics = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR: {
            const VkPhysicalDeviceFragmentShadingRateFeaturesKHR *i = (const void *) in;
            if (i->pipelineFragmentShadingRate) {
                ((VkPhysicalDeviceFragmentShadingRateFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR))->pipelineFragmentShadingRate = true;
            }
            if (i->primitiveFragmentShadingRate) {
                ((VkPhysicalDeviceFragmentShadingRateFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR))->primitiveFragmentShadingRate = true;
            }
            if (i->attachmentFragmentShadingRate) {
                ((VkPhysicalDeviceFragmentShadingRateFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_FEATURES_KHR))->attachmentFragmentShadingRate = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES: {
            const VkPhysicalDeviceShaderTerminateInvocationFeatures *i = (const void *) in;
            if (i->shaderTerminateInvocation) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderTerminateInvocation = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceShaderTerminateInvocationFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TERMINATE_INVOCATION_FEATURES))->shaderTerminateInvocation = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV: {
            const VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV *i = (const void *) in;
            if (i->fragmentShadingRateEnums) {
                ((VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV))->fragmentShadingRateEnums = true;
            }
            if (i->supersampleFragmentShadingRates) {
                ((VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV))->supersampleFragmentShadingRates = true;
            }
            if (i->noInvocationFragmentShadingRates) {
                ((VkPhysicalDeviceFragmentShadingRateEnumsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADING_RATE_ENUMS_FEATURES_NV))->noInvocationFragmentShadingRates = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT: {
            const VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *i = (const void *) in;
            if (i->image2DViewOf3D) {
                ((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT))->image2DViewOf3D = true;
            }
            if (i->sampler2DViewOf3D) {
                ((VkPhysicalDeviceImage2DViewOf3DFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_2D_VIEW_OF_3D_FEATURES_EXT))->sampler2DViewOf3D = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT: {
            const VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *i = (const void *) in;
            if (i->imageSlicedViewOf3D) {
                ((VkPhysicalDeviceImageSlicedViewOf3DFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_SLICED_VIEW_OF_3D_FEATURES_EXT))->imageSlicedViewOf3D = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT: {
            const VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *i = (const void *) in;
            if (i->attachmentFeedbackLoopDynamicState) {
                ((VkPhysicalDeviceAttachmentFeedbackLoopDynamicStateFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_DYNAMIC_STATE_FEATURES_EXT))->attachmentFeedbackLoopDynamicState = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT: {
            const VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *i = (const void *) in;
            if (i->legacyVertexAttributes) {
                ((VkPhysicalDeviceLegacyVertexAttributesFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_VERTEX_ATTRIBUTES_FEATURES_EXT))->legacyVertexAttributes = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT: {
            const VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *i = (const void *) in;
            if (i->mutableDescriptorType) {
                ((VkPhysicalDeviceMutableDescriptorTypeFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MUTABLE_DESCRIPTOR_TYPE_FEATURES_EXT))->mutableDescriptorType = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT: {
            const VkPhysicalDeviceDepthClipControlFeaturesEXT *i = (const void *) in;
            if (i->depthClipControl) {
                ((VkPhysicalDeviceDepthClipControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLIP_CONTROL_FEATURES_EXT))->depthClipControl = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT: {
            const VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT *i = (const void *) in;
            if (i->deviceGeneratedCommands) {
                ((VkPhysicalDeviceDeviceGeneratedCommandsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_NV))->deviceGeneratedCommands = true;
                ((VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT))->deviceGeneratedCommands = true;
            }
            if (i->dynamicGeneratedPipelineLayout) {
                ((VkPhysicalDeviceDeviceGeneratedCommandsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEVICE_GENERATED_COMMANDS_FEATURES_EXT))->dynamicGeneratedPipelineLayout = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT: {
            const VkPhysicalDeviceDepthClampControlFeaturesEXT *i = (const void *) in;
            if (i->depthClampControl) {
                ((VkPhysicalDeviceDepthClampControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_CONTROL_FEATURES_EXT))->depthClampControl = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT: {
            const VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *i = (const void *) in;
            if (i->vertexInputDynamicState) {
                ((VkPhysicalDeviceVertexInputDynamicStateFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_INPUT_DYNAMIC_STATE_FEATURES_EXT))->vertexInputDynamicState = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV: {
            const VkPhysicalDeviceExternalMemoryRDMAFeaturesNV *i = (const void *) in;
            if (i->externalMemoryRDMA) {
                ((VkPhysicalDeviceExternalMemoryRDMAFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTERNAL_MEMORY_RDMA_FEATURES_NV))->externalMemoryRDMA = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR: {
            const VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *i = (const void *) in;
            if (i->shaderRelaxedExtendedInstruction) {
                ((VkPhysicalDeviceShaderRelaxedExtendedInstructionFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_RELAXED_EXTENDED_INSTRUCTION_FEATURES_KHR))->shaderRelaxedExtendedInstruction = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT: {
            const VkPhysicalDeviceColorWriteEnableFeaturesEXT *i = (const void *) in;
            if (i->colorWriteEnable) {
                ((VkPhysicalDeviceColorWriteEnableFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COLOR_WRITE_ENABLE_FEATURES_EXT))->colorWriteEnable = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES: {
            const VkPhysicalDeviceSynchronization2Features *i = (const void *) in;
            if (i->synchronization2) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->synchronization2 = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceSynchronization2Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SYNCHRONIZATION_2_FEATURES))->synchronization2 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES: {
            const VkPhysicalDeviceHostImageCopyFeatures *i = (const void *) in;
            if (i->hostImageCopy) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->hostImageCopy = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceHostImageCopyFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HOST_IMAGE_COPY_FEATURES))->hostImageCopy = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT: {
            const VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *i = (const void *) in;
            if (i->primitivesGeneratedQuery) {
                ((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT))->primitivesGeneratedQuery = true;
            }
            if (i->primitivesGeneratedQueryWithRasterizerDiscard) {
                ((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT))->primitivesGeneratedQueryWithRasterizerDiscard = true;
            }
            if (i->primitivesGeneratedQueryWithNonZeroStreams) {
                ((VkPhysicalDevicePrimitivesGeneratedQueryFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRIMITIVES_GENERATED_QUERY_FEATURES_EXT))->primitivesGeneratedQueryWithNonZeroStreams = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT: {
            const VkPhysicalDeviceLegacyDitheringFeaturesEXT *i = (const void *) in;
            if (i->legacyDithering) {
                ((VkPhysicalDeviceLegacyDitheringFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LEGACY_DITHERING_FEATURES_EXT))->legacyDithering = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT: {
            const VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *i = (const void *) in;
            if (i->multisampledRenderToSingleSampled) {
                ((VkPhysicalDeviceMultisampledRenderToSingleSampledFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTISAMPLED_RENDER_TO_SINGLE_SAMPLED_FEATURES_EXT))->multisampledRenderToSingleSampled = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES: {
            const VkPhysicalDevicePipelineProtectedAccessFeatures *i = (const void *) in;
            if (i->pipelineProtectedAccess) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->pipelineProtectedAccess = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDevicePipelineProtectedAccessFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROTECTED_ACCESS_FEATURES))->pipelineProtectedAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR: {
            const VkPhysicalDeviceVideoMaintenance1FeaturesKHR *i = (const void *) in;
            if (i->videoMaintenance1) {
                ((VkPhysicalDeviceVideoMaintenance1FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_1_FEATURES_KHR))->videoMaintenance1 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR: {
            const VkPhysicalDeviceVideoMaintenance2FeaturesKHR *i = (const void *) in;
            if (i->videoMaintenance2) {
                ((VkPhysicalDeviceVideoMaintenance2FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_MAINTENANCE_2_FEATURES_KHR))->videoMaintenance2 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR: {
            const VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR *i = (const void *) in;
            if (i->videoEncodeQuantizationMap) {
                ((VkPhysicalDeviceVideoEncodeQuantizationMapFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_QUANTIZATION_MAP_FEATURES_KHR))->videoEncodeQuantizationMap = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR: {
            const VkPhysicalDeviceVideoEncodeAV1FeaturesKHR *i = (const void *) in;
            if (i->videoEncodeAV1) {
                ((VkPhysicalDeviceVideoEncodeAV1FeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VIDEO_ENCODE_AV1_FEATURES_KHR))->videoEncodeAV1 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV: {
            const VkPhysicalDeviceInheritedViewportScissorFeaturesNV *i = (const void *) in;
            if (i->inheritedViewportScissor2D) {
                ((VkPhysicalDeviceInheritedViewportScissorFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_INHERITED_VIEWPORT_SCISSOR_FEATURES_NV))->inheritedViewportScissor2D = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT: {
            const VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *i = (const void *) in;
            if (i->ycbcr2plane444Formats) {
                ((VkPhysicalDeviceYcbcr2Plane444FormatsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_2_PLANE_444_FORMATS_FEATURES_EXT))->ycbcr2plane444Formats = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT: {
            const VkPhysicalDeviceProvokingVertexFeaturesEXT *i = (const void *) in;
            if (i->provokingVertexLast) {
                ((VkPhysicalDeviceProvokingVertexFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT))->provokingVertexLast = true;
            }
            if (i->transformFeedbackPreservesProvokingVertex) {
                ((VkPhysicalDeviceProvokingVertexFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PROVOKING_VERTEX_FEATURES_EXT))->transformFeedbackPreservesProvokingVertex = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT: {
            const VkPhysicalDeviceDescriptorBufferFeaturesEXT *i = (const void *) in;
            if (i->descriptorBuffer) {
                ((VkPhysicalDeviceDescriptorBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT))->descriptorBuffer = true;
            }
            if (i->descriptorBufferCaptureReplay) {
                ((VkPhysicalDeviceDescriptorBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT))->descriptorBufferCaptureReplay = true;
            }
            if (i->descriptorBufferImageLayoutIgnored) {
                ((VkPhysicalDeviceDescriptorBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT))->descriptorBufferImageLayoutIgnored = true;
            }
            if (i->descriptorBufferPushDescriptors) {
                ((VkPhysicalDeviceDescriptorBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_BUFFER_FEATURES_EXT))->descriptorBufferPushDescriptors = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES: {
            const VkPhysicalDeviceShaderIntegerDotProductFeatures *i = (const void *) in;
            if (i->shaderIntegerDotProduct) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->shaderIntegerDotProduct = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceShaderIntegerDotProductFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_INTEGER_DOT_PRODUCT_FEATURES))->shaderIntegerDotProduct = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR: {
            const VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *i = (const void *) in;
            if (i->fragmentShaderBarycentric) {
                ((VkPhysicalDeviceFragmentShaderBarycentricFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAGMENT_SHADER_BARYCENTRIC_FEATURES_KHR))->fragmentShaderBarycentric = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV: {
            const VkPhysicalDeviceRayTracingMotionBlurFeaturesNV *i = (const void *) in;
            if (i->rayTracingMotionBlur) {
                ((VkPhysicalDeviceRayTracingMotionBlurFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV))->rayTracingMotionBlur = true;
            }
            if (i->rayTracingMotionBlurPipelineTraceRaysIndirect) {
                ((VkPhysicalDeviceRayTracingMotionBlurFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_MOTION_BLUR_FEATURES_NV))->rayTracingMotionBlurPipelineTraceRaysIndirect = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV: {
            const VkPhysicalDeviceRayTracingValidationFeaturesNV *i = (const void *) in;
            if (i->rayTracingValidation) {
                ((VkPhysicalDeviceRayTracingValidationFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_VALIDATION_FEATURES_NV))->rayTracingValidation = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV: {
            const VkPhysicalDeviceRayTracingLinearSweptSpheresFeaturesNV *i = (const void *) in;
            if (i->spheres) {
                ((VkPhysicalDeviceRayTracingLinearSweptSpheresFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV))->spheres = true;
            }
            if (i->linearSweptSpheres) {
                ((VkPhysicalDeviceRayTracingLinearSweptSpheresFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_LINEAR_SWEPT_SPHERES_FEATURES_NV))->linearSweptSpheres = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT: {
            const VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT *i = (const void *) in;
            if (i->formatRgba10x6WithoutYCbCrSampler) {
                ((VkPhysicalDeviceRGBA10X6FormatsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RGBA10X6_FORMATS_FEATURES_EXT))->formatRgba10x6WithoutYCbCrSampler = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES: {
            const VkPhysicalDeviceDynamicRenderingFeatures *i = (const void *) in;
            if (i->dynamicRendering) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_3)
                ((VkPhysicalDeviceVulkan13Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_3_FEATURES))->dynamicRendering = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_3)
                ((VkPhysicalDeviceDynamicRenderingFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_FEATURES))->dynamicRendering = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT: {
            const VkPhysicalDeviceImageViewMinLodFeaturesEXT *i = (const void *) in;
            if (i->minLod) {
                ((VkPhysicalDeviceImageViewMinLodFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_VIEW_MIN_LOD_FEATURES_EXT))->minLod = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT: {
            const VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *i = (const void *) in;
            if (i->rasterizationOrderColorAttachmentAccess) {
                ((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT))->rasterizationOrderColorAttachmentAccess = true;
            }
            if (i->rasterizationOrderDepthAttachmentAccess) {
                ((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT))->rasterizationOrderDepthAttachmentAccess = true;
            }
            if (i->rasterizationOrderStencilAttachmentAccess) {
                ((VkPhysicalDeviceRasterizationOrderAttachmentAccessFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RASTERIZATION_ORDER_ATTACHMENT_ACCESS_FEATURES_EXT))->rasterizationOrderStencilAttachmentAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV: {
            const VkPhysicalDeviceLinearColorAttachmentFeaturesNV *i = (const void *) in;
            if (i->linearColorAttachment) {
                ((VkPhysicalDeviceLinearColorAttachmentFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_LINEAR_COLOR_ATTACHMENT_FEATURES_NV))->linearColorAttachment = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT: {
            const VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *i = (const void *) in;
            if (i->graphicsPipelineLibrary) {
                ((VkPhysicalDeviceGraphicsPipelineLibraryFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_GRAPHICS_PIPELINE_LIBRARY_FEATURES_EXT))->graphicsPipelineLibrary = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR: {
            const VkPhysicalDevicePipelineBinaryFeaturesKHR *i = (const void *) in;
            if (i->pipelineBinaries) {
                ((VkPhysicalDevicePipelineBinaryFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_BINARY_FEATURES_KHR))->pipelineBinaries = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE: {
            const VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE *i = (const void *) in;
            if (i->descriptorSetHostMapping) {
                ((VkPhysicalDeviceDescriptorSetHostMappingFeaturesVALVE *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_SET_HOST_MAPPING_FEATURES_VALVE))->descriptorSetHostMapping = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT: {
            const VkPhysicalDeviceNestedCommandBufferFeaturesEXT *i = (const void *) in;
            if (i->nestedCommandBuffer) {
                ((VkPhysicalDeviceNestedCommandBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT))->nestedCommandBuffer = true;
            }
            if (i->nestedCommandBufferRendering) {
                ((VkPhysicalDeviceNestedCommandBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT))->nestedCommandBufferRendering = true;
            }
            if (i->nestedCommandBufferSimultaneousUse) {
                ((VkPhysicalDeviceNestedCommandBufferFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NESTED_COMMAND_BUFFER_FEATURES_EXT))->nestedCommandBufferSimultaneousUse = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT: {
            const VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT *i = (const void *) in;
            if (i->shaderModuleIdentifier) {
                ((VkPhysicalDeviceShaderModuleIdentifierFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MODULE_IDENTIFIER_FEATURES_EXT))->shaderModuleIdentifier = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT: {
            const VkPhysicalDeviceImageCompressionControlFeaturesEXT *i = (const void *) in;
            if (i->imageCompressionControl) {
                ((VkPhysicalDeviceImageCompressionControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_FEATURES_EXT))->imageCompressionControl = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT: {
            const VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT *i = (const void *) in;
            if (i->imageCompressionControlSwapchain) {
                ((VkPhysicalDeviceImageCompressionControlSwapchainFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_COMPRESSION_CONTROL_SWAPCHAIN_FEATURES_EXT))->imageCompressionControlSwapchain = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT: {
            const VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT *i = (const void *) in;
            if (i->subpassMergeFeedback) {
                ((VkPhysicalDeviceSubpassMergeFeedbackFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SUBPASS_MERGE_FEEDBACK_FEATURES_EXT))->subpassMergeFeedback = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT: {
            const VkPhysicalDeviceOpacityMicromapFeaturesEXT *i = (const void *) in;
            if (i->micromap) {
                ((VkPhysicalDeviceOpacityMicromapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT))->micromap = true;
            }
            if (i->micromapCaptureReplay) {
                ((VkPhysicalDeviceOpacityMicromapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT))->micromapCaptureReplay = true;
            }
            if (i->micromapHostCommands) {
                ((VkPhysicalDeviceOpacityMicromapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPACITY_MICROMAP_FEATURES_EXT))->micromapHostCommands = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT: {
            const VkPhysicalDevicePipelinePropertiesFeaturesEXT *i = (const void *) in;
            if (i->pipelinePropertiesIdentifier) {
                ((VkPhysicalDevicePipelinePropertiesFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_PROPERTIES_FEATURES_EXT))->pipelinePropertiesIdentifier = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD: {
            const VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD *i = (const void *) in;
            if (i->shaderEarlyAndLateFragmentTests) {
                ((VkPhysicalDeviceShaderEarlyAndLateFragmentTestsFeaturesAMD *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EARLY_AND_LATE_FRAGMENT_TESTS_FEATURES_AMD))->shaderEarlyAndLateFragmentTests = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT: {
            const VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *i = (const void *) in;
            if (i->nonSeamlessCubeMap) {
                ((VkPhysicalDeviceNonSeamlessCubeMapFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_NON_SEAMLESS_CUBE_MAP_FEATURES_EXT))->nonSeamlessCubeMap = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES: {
            const VkPhysicalDevicePipelineRobustnessFeatures *i = (const void *) in;
            if (i->pipelineRobustness) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->pipelineRobustness = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDevicePipelineRobustnessFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_ROBUSTNESS_FEATURES))->pipelineRobustness = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM: {
            const VkPhysicalDeviceImageProcessingFeaturesQCOM *i = (const void *) in;
            if (i->textureSampleWeighted) {
                ((VkPhysicalDeviceImageProcessingFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM))->textureSampleWeighted = true;
            }
            if (i->textureBoxFilter) {
                ((VkPhysicalDeviceImageProcessingFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM))->textureBoxFilter = true;
            }
            if (i->textureBlockMatch) {
                ((VkPhysicalDeviceImageProcessingFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_FEATURES_QCOM))->textureBlockMatch = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM: {
            const VkPhysicalDeviceTilePropertiesFeaturesQCOM *i = (const void *) in;
            if (i->tileProperties) {
                ((VkPhysicalDeviceTilePropertiesFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_TILE_PROPERTIES_FEATURES_QCOM))->tileProperties = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC: {
            const VkPhysicalDeviceAmigoProfilingFeaturesSEC *i = (const void *) in;
            if (i->amigoProfiling) {
                ((VkPhysicalDeviceAmigoProfilingFeaturesSEC *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_AMIGO_PROFILING_FEATURES_SEC))->amigoProfiling = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT: {
            const VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *i = (const void *) in;
            if (i->attachmentFeedbackLoopLayout) {
                ((VkPhysicalDeviceAttachmentFeedbackLoopLayoutFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ATTACHMENT_FEEDBACK_LOOP_LAYOUT_FEATURES_EXT))->attachmentFeedbackLoopLayout = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT: {
            const VkPhysicalDeviceAddressBindingReportFeaturesEXT *i = (const void *) in;
            if (i->reportAddressBinding) {
                ((VkPhysicalDeviceAddressBindingReportFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ADDRESS_BINDING_REPORT_FEATURES_EXT))->reportAddressBinding = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV: {
            const VkPhysicalDeviceOpticalFlowFeaturesNV *i = (const void *) in;
            if (i->opticalFlow) {
                ((VkPhysicalDeviceOpticalFlowFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_OPTICAL_FLOW_FEATURES_NV))->opticalFlow = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT: {
            const VkPhysicalDeviceFaultFeaturesEXT *i = (const void *) in;
            if (i->deviceFault) {
                ((VkPhysicalDeviceFaultFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT))->deviceFault = true;
            }
            if (i->deviceFaultVendorBinary) {
                ((VkPhysicalDeviceFaultFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FAULT_FEATURES_EXT))->deviceFaultVendorBinary = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT: {
            const VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *i = (const void *) in;
            if (i->pipelineLibraryGroupHandles) {
                ((VkPhysicalDevicePipelineLibraryGroupHandlesFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_LIBRARY_GROUP_HANDLES_FEATURES_EXT))->pipelineLibraryGroupHandles = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM: {
            const VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM *i = (const void *) in;
            if (i->shaderCoreBuiltins) {
                ((VkPhysicalDeviceShaderCoreBuiltinsFeaturesARM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_CORE_BUILTINS_FEATURES_ARM))->shaderCoreBuiltins = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT: {
            const VkPhysicalDeviceFrameBoundaryFeaturesEXT *i = (const void *) in;
            if (i->frameBoundary) {
                ((VkPhysicalDeviceFrameBoundaryFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_FRAME_BOUNDARY_FEATURES_EXT))->frameBoundary = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT: {
            const VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *i = (const void *) in;
            if (i->dynamicRenderingUnusedAttachments) {
                ((VkPhysicalDeviceDynamicRenderingUnusedAttachmentsFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_UNUSED_ATTACHMENTS_FEATURES_EXT))->dynamicRenderingUnusedAttachments = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT: {
            const VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT *i = (const void *) in;
            if (i->swapchainMaintenance1) {
                ((VkPhysicalDeviceSwapchainMaintenance1FeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SWAPCHAIN_MAINTENANCE_1_FEATURES_EXT))->swapchainMaintenance1 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT: {
            const VkPhysicalDeviceDepthBiasControlFeaturesEXT *i = (const void *) in;
            if (i->depthBiasControl) {
                ((VkPhysicalDeviceDepthBiasControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT))->depthBiasControl = true;
            }
            if (i->leastRepresentableValueForceUnormRepresentation) {
                ((VkPhysicalDeviceDepthBiasControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT))->leastRepresentableValueForceUnormRepresentation = true;
            }
            if (i->floatRepresentation) {
                ((VkPhysicalDeviceDepthBiasControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT))->floatRepresentation = true;
            }
            if (i->depthBiasExact) {
                ((VkPhysicalDeviceDepthBiasControlFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_BIAS_CONTROL_FEATURES_EXT))->depthBiasExact = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV: {
            const VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV *i = (const void *) in;
            if (i->rayTracingInvocationReorder) {
                ((VkPhysicalDeviceRayTracingInvocationReorderFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_INVOCATION_REORDER_FEATURES_NV))->rayTracingInvocationReorder = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV: {
            const VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV *i = (const void *) in;
            if (i->extendedSparseAddressSpace) {
                ((VkPhysicalDeviceExtendedSparseAddressSpaceFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_EXTENDED_SPARSE_ADDRESS_SPACE_FEATURES_NV))->extendedSparseAddressSpace = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM: {
            const VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM *i = (const void *) in;
            if (i->multiviewPerViewViewports) {
                ((VkPhysicalDeviceMultiviewPerViewViewportsFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_VIEWPORTS_FEATURES_QCOM))->multiviewPerViewViewports = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR: {
            const VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *i = (const void *) in;
            if (i->rayTracingPositionFetch) {
                ((VkPhysicalDeviceRayTracingPositionFetchFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAY_TRACING_POSITION_FETCH_FEATURES_KHR))->rayTracingPositionFetch = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM: {
            const VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM *i = (const void *) in;
            if (i->multiviewPerViewRenderAreas) {
                ((VkPhysicalDeviceMultiviewPerViewRenderAreasFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MULTIVIEW_PER_VIEW_RENDER_AREAS_FEATURES_QCOM))->multiviewPerViewRenderAreas = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT: {
            const VkPhysicalDeviceShaderObjectFeaturesEXT *i = (const void *) in;
            if (i->shaderObject) {
                ((VkPhysicalDeviceShaderObjectFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_OBJECT_FEATURES_EXT))->shaderObject = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT: {
            const VkPhysicalDeviceShaderTileImageFeaturesEXT *i = (const void *) in;
            if (i->shaderTileImageColorReadAccess) {
                ((VkPhysicalDeviceShaderTileImageFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT))->shaderTileImageColorReadAccess = true;
            }
            if (i->shaderTileImageDepthReadAccess) {
                ((VkPhysicalDeviceShaderTileImageFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT))->shaderTileImageDepthReadAccess = true;
            }
            if (i->shaderTileImageStencilReadAccess) {
                ((VkPhysicalDeviceShaderTileImageFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_TILE_IMAGE_FEATURES_EXT))->shaderTileImageStencilReadAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR: {
            const VkPhysicalDeviceCooperativeMatrixFeaturesKHR *i = (const void *) in;
            if (i->cooperativeMatrix) {
                ((VkPhysicalDeviceCooperativeMatrixFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV))->cooperativeMatrix = true;
                ((VkPhysicalDeviceCooperativeMatrixFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR))->cooperativeMatrix = true;
            }
            if (i->cooperativeMatrixRobustBufferAccess) {
                ((VkPhysicalDeviceCooperativeMatrixFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_NV))->cooperativeMatrixRobustBufferAccess = true;
                ((VkPhysicalDeviceCooperativeMatrixFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_FEATURES_KHR))->cooperativeMatrixRobustBufferAccess = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD: {
            const VkPhysicalDeviceAntiLagFeaturesAMD *i = (const void *) in;
            if (i->antiLag) {
                ((VkPhysicalDeviceAntiLagFeaturesAMD *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_ANTI_LAG_FEATURES_AMD))->antiLag = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM: {
            const VkPhysicalDeviceCubicClampFeaturesQCOM *i = (const void *) in;
            if (i->cubicRangeClamp) {
                ((VkPhysicalDeviceCubicClampFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_CLAMP_FEATURES_QCOM))->cubicRangeClamp = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM: {
            const VkPhysicalDeviceYcbcrDegammaFeaturesQCOM *i = (const void *) in;
            if (i->ycbcrDegamma) {
                ((VkPhysicalDeviceYcbcrDegammaFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_YCBCR_DEGAMMA_FEATURES_QCOM))->ycbcrDegamma = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM: {
            const VkPhysicalDeviceCubicWeightsFeaturesQCOM *i = (const void *) in;
            if (i->selectableCubicWeights) {
                ((VkPhysicalDeviceCubicWeightsFeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_CUBIC_WEIGHTS_FEATURES_QCOM))->selectableCubicWeights = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM: {
            const VkPhysicalDeviceImageProcessing2FeaturesQCOM *i = (const void *) in;
            if (i->textureBlockMatch2) {
                ((VkPhysicalDeviceImageProcessing2FeaturesQCOM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_PROCESSING_2_FEATURES_QCOM))->textureBlockMatch2 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV: {
            const VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV *i = (const void *) in;
            if (i->descriptorPoolOverallocation) {
                ((VkPhysicalDeviceDescriptorPoolOverallocationFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DESCRIPTOR_POOL_OVERALLOCATION_FEATURES_NV))->descriptorPoolOverallocation = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV: {
            const VkPhysicalDevicePerStageDescriptorSetFeaturesNV *i = (const void *) in;
            if (i->perStageDescriptorSet) {
                ((VkPhysicalDevicePerStageDescriptorSetFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV))->perStageDescriptorSet = true;
            }
            if (i->dynamicPipelineLayout) {
                ((VkPhysicalDevicePerStageDescriptorSetFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PER_STAGE_DESCRIPTOR_SET_FEATURES_NV))->dynamicPipelineLayout = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM: {
            const VkPhysicalDeviceSchedulingControlsFeaturesARM *i = (const void *) in;
            if (i->schedulingControls) {
                ((VkPhysicalDeviceSchedulingControlsFeaturesARM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SCHEDULING_CONTROLS_FEATURES_ARM))->schedulingControls = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG: {
            const VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG *i = (const void *) in;
            if (i->relaxedLineRasterization) {
                ((VkPhysicalDeviceRelaxedLineRasterizationFeaturesIMG *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RELAXED_LINE_RASTERIZATION_FEATURES_IMG))->relaxedLineRasterization = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM: {
            const VkPhysicalDeviceRenderPassStripedFeaturesARM *i = (const void *) in;
            if (i->renderPassStriped) {
                ((VkPhysicalDeviceRenderPassStripedFeaturesARM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RENDER_PASS_STRIPED_FEATURES_ARM))->renderPassStriped = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM: {
            const VkPhysicalDevicePipelineOpacityMicromapFeaturesARM *i = (const void *) in;
            if (i->pipelineOpacityMicromap) {
                ((VkPhysicalDevicePipelineOpacityMicromapFeaturesARM *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PIPELINE_OPACITY_MICROMAP_FEATURES_ARM))->pipelineOpacityMicromap = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR: {
            const VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *i = (const void *) in;
            if (i->shaderMaximalReconvergence) {
                ((VkPhysicalDeviceShaderMaximalReconvergenceFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_MAXIMAL_RECONVERGENCE_FEATURES_KHR))->shaderMaximalReconvergence = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES: {
            const VkPhysicalDeviceShaderSubgroupRotateFeatures *i = (const void *) in;
            if (i->shaderSubgroupRotate) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderSubgroupRotate = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderSubgroupRotateFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES))->shaderSubgroupRotate = true;
            }
            if (i->shaderSubgroupRotateClustered) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderSubgroupRotateClustered = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderSubgroupRotateFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_SUBGROUP_ROTATE_FEATURES))->shaderSubgroupRotateClustered = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES: {
            const VkPhysicalDeviceShaderExpectAssumeFeatures *i = (const void *) in;
            if (i->shaderExpectAssume) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderExpectAssume = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderExpectAssumeFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_EXPECT_ASSUME_FEATURES))->shaderExpectAssume = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES: {
            const VkPhysicalDeviceShaderFloatControls2Features *i = (const void *) in;
            if (i->shaderFloatControls2) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->shaderFloatControls2 = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceShaderFloatControls2Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_FLOAT_CONTROLS_2_FEATURES))->shaderFloatControls2 = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES: {
            const VkPhysicalDeviceDynamicRenderingLocalReadFeatures *i = (const void *) in;
            if (i->dynamicRenderingLocalRead) {
               if (!api_ver || api_ver >= VK_API_VERSION_1_4)
                ((VkPhysicalDeviceVulkan14Features *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VULKAN_1_4_FEATURES))->dynamicRenderingLocalRead = true;
               if (!api_ver || api_ver < VK_API_VERSION_1_4)
                ((VkPhysicalDeviceDynamicRenderingLocalReadFeatures *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DYNAMIC_RENDERING_LOCAL_READ_FEATURES))->dynamicRenderingLocalRead = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR: {
            const VkPhysicalDeviceShaderQuadControlFeaturesKHR *i = (const void *) in;
            if (i->shaderQuadControl) {
                ((VkPhysicalDeviceShaderQuadControlFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_QUAD_CONTROL_FEATURES_KHR))->shaderQuadControl = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV: {
            const VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV *i = (const void *) in;
            if (i->shaderFloat16VectorAtomics) {
                ((VkPhysicalDeviceShaderAtomicFloat16VectorFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_ATOMIC_FLOAT16_VECTOR_FEATURES_NV))->shaderFloat16VectorAtomics = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT: {
            const VkPhysicalDeviceMapMemoryPlacedFeaturesEXT *i = (const void *) in;
            if (i->memoryMapPlaced) {
                ((VkPhysicalDeviceMapMemoryPlacedFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT))->memoryMapPlaced = true;
            }
            if (i->memoryMapRangePlaced) {
                ((VkPhysicalDeviceMapMemoryPlacedFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT))->memoryMapRangePlaced = true;
            }
            if (i->memoryUnmapReserve) {
                ((VkPhysicalDeviceMapMemoryPlacedFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_MAP_MEMORY_PLACED_FEATURES_EXT))->memoryUnmapReserve = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV: {
            const VkPhysicalDeviceRawAccessChainsFeaturesNV *i = (const void *) in;
            if (i->shaderRawAccessChains) {
                ((VkPhysicalDeviceRawAccessChainsFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_RAW_ACCESS_CHAINS_FEATURES_NV))->shaderRawAccessChains = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV: {
            const VkPhysicalDeviceCommandBufferInheritanceFeaturesNV *i = (const void *) in;
            if (i->commandBufferInheritance) {
                ((VkPhysicalDeviceCommandBufferInheritanceFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COMMAND_BUFFER_INHERITANCE_FEATURES_NV))->commandBufferInheritance = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA: {
            const VkPhysicalDeviceImageAlignmentControlFeaturesMESA *i = (const void *) in;
            if (i->imageAlignmentControl) {
                ((VkPhysicalDeviceImageAlignmentControlFeaturesMESA *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_IMAGE_ALIGNMENT_CONTROL_FEATURES_MESA))->imageAlignmentControl = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT: {
            const VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *i = (const void *) in;
            if (i->shaderReplicatedComposites) {
                ((VkPhysicalDeviceShaderReplicatedCompositesFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_SHADER_REPLICATED_COMPOSITES_FEATURES_EXT))->shaderReplicatedComposites = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_EXT: {
            const VkPhysicalDevicePresentModeFifoLatestReadyFeaturesEXT *i = (const void *) in;
            if (i->presentModeFifoLatestReady) {
                ((VkPhysicalDevicePresentModeFifoLatestReadyFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_PRESENT_MODE_FIFO_LATEST_READY_FEATURES_EXT))->presentModeFifoLatestReady = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV: {
            const VkPhysicalDeviceCooperativeMatrix2FeaturesNV *i = (const void *) in;
            if (i->cooperativeMatrixWorkgroupScope) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixWorkgroupScope = true;
            }
            if (i->cooperativeMatrixFlexibleDimensions) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixFlexibleDimensions = true;
            }
            if (i->cooperativeMatrixReductions) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixReductions = true;
            }
            if (i->cooperativeMatrixConversions) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixConversions = true;
            }
            if (i->cooperativeMatrixPerElementOperations) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixPerElementOperations = true;
            }
            if (i->cooperativeMatrixTensorAddressing) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixTensorAddressing = true;
            }
            if (i->cooperativeMatrixBlockLoads) {
                ((VkPhysicalDeviceCooperativeMatrix2FeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_MATRIX_2_FEATURES_NV))->cooperativeMatrixBlockLoads = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI: {
            const VkPhysicalDeviceHdrVividFeaturesHUAWEI *i = (const void *) in;
            if (i->hdrVivid) {
                ((VkPhysicalDeviceHdrVividFeaturesHUAWEI *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_HDR_VIVID_FEATURES_HUAWEI))->hdrVivid = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT: {
            const VkPhysicalDeviceVertexAttributeRobustnessFeaturesEXT *i = (const void *) in;
            if (i->vertexAttributeRobustness) {
                ((VkPhysicalDeviceVertexAttributeRobustnessFeaturesEXT *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_VERTEX_ATTRIBUTE_ROBUSTNESS_FEATURES_EXT))->vertexAttributeRobustness = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR: {
            const VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *i = (const void *) in;
            if (i->depthClampZeroOne) {
                ((VkPhysicalDeviceDepthClampZeroOneFeaturesKHR *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_DEPTH_CLAMP_ZERO_ONE_FEATURES_KHR))->depthClampZeroOne = true;
            }
            break;
        }
        case VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV: {
            const VkPhysicalDeviceCooperativeVectorFeaturesNV *i = (const void *) in;
            if (i->cooperativeVector) {
                ((VkPhysicalDeviceCooperativeVectorFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV))->cooperativeVector = true;
            }
            if (i->cooperativeVectorTraining) {
                ((VkPhysicalDeviceCooperativeVectorFeaturesNV *) vk_chain_alloc(alloc, out, VK_STRUCTURE_TYPE_PHYSICAL_DEVICE_COOPERATIVE_VECTOR_FEATURES_NV))->cooperativeVectorTraining = true;
            }
            break;
        }
        }
    }
}

const VkAccessFlags2 vk_access_read = 0x17ab05baaabfLLU;
const VkAccessFlags2 vk_access_write = 0x28540a455540LLU;