include(${CMAKE_CURRENT_LIST_DIR}/TestVariable.cmake)

get_filename_component(_parent_dir "${CMAKE_SOURCE_DIR}" DIRECTORY)
test_variable(CMAKE_BINARY_DIR "" "${CMAKE_SOURCE_DIR}/build")
test_variable(CMAKE_GENERATOR "" "${RunCMake_GENERATOR}")
test_variable(TEST_SOURCE_DIR "PATH" "${CMAKE_SOURCE_DIR}")
test_variable(TEST_SOURCE_PARENT_DIR "PATH" "${_parent_dir}")
test_variable(TEST_SOURCE_LIST "FILEPATH" "${CMAKE_SOURCE_DIR}/CMakeLists.txt")
test_variable(TEST_TRUE "BOOL" "TRUE")
test_variable(TEST_OFF "BOOL" "OFF")
test_variable(TEST_BOOL_TRUE "BOOL" "TRUE")
test_variable(TEST_BOOL_FALSE "BOOL" "FALSE")
test_variable(TEST_TYPED_BOOL_TRUE "STRING" "TRUE")
test_variable(TEST_TYPED_BOOL_FALSE "STRING" "FALSE")
test_variable(TEST_UNTYPED_BOOL_TRUE "UNINITIALIZED" "TRUE")
test_variable(TEST_UNTYPED_BOOL_FALSE "UNINITIALIZED" "FALSE")
test_variable(TEST_PRESET_NAME "STRING" "xGoodx")
test_variable(TEST_GENERATOR "UNINITIALIZED" "x${CMAKE_GENERATOR}x")
test_variable(TEST_DOLLAR "UNINITIALIZED" "$")
test_variable(TEST_SOURCE_DIR_NAME "UNINITIALIZED" "Good")
test_variable(TEST_ENV_REF "UNINITIALIZED" "Environment variable")
test_variable(TEST_ENV "UNINITIALIZED" "Environment variable")
test_variable(TEST_D_ENV_REF "UNINITIALIZED" "xEnvironment variablex")
test_variable(TEST_ENV_OVERRIDE "UNINITIALIZED" "Overridden environment variable")
test_variable(TEST_PENV "UNINITIALIZED" "Process environment variable")
test_variable(TEST_ENV_REF_PENV "UNINITIALIZED" "prefix+suffix")
test_variable(TEST_ENV_REF_P "UNINITIALIZED" "")
test_variable(TEST_ENV_P "UNINITIALIZED" "")
test_variable(TEST_D_ENV_REF_P "UNINITIALIZED" "")
test_variable(TEST_ENV_OVERRIDE_P "UNINITIALIZED" "This environment variable will be overridden")
test_variable(TEST_PENV_P "UNINITIALIZED" "Process environment variable")
test_variable(TEST_ENV_REF_PENV_P "UNINITIALIZED" "suffix")
test_variable(TEST_MULTIPLE_MACROS "UNINITIALIZED" "Good ${CMAKE_GENERATOR}")
test_variable(TEST_EXPANSION "UNINITIALIZED" "\\Good \${dollar} \$unknown{namespace} \$en{NOT_ENV} \$enve{NOT_ENV} $ \\$ $a")
test_variable(TEST_TRAILING_DOLLAR "UNINITIALIZED" "a $")
test_variable(TEST_TRAILING_BACKSLASH "UNINITIALIZED" "a \\")
test_variable(TEST_TRAILING_UNKNOWN_NAMESPACE "UNINITIALIZED" "\$unknown{namespace")
test_variable(TEST_OVERRIDE_1 "UNINITIALIZED" "Overridden value")
test_variable(TEST_OVERRIDE_2 "STRING" "Overridden value")
test_variable(TEST_OVERRIDE_3 "STRING" "Default value")
test_variable(TEST_OVERRIDE_4 "INTERNAL" "Overridden value")

if(DEFINED TEST_UNDEF OR DEFINED CACHE{TEST_UNDEF})
  message(SEND_ERROR "TEST_UNDEF should not be defined")
endif()

test_environment_variable(TEST_ENV_REF "Environment variable")
test_environment_variable(TEST_ENV "Environment variable")
test_environment_variable(TEST_D_ENV_REF "xEnvironment variablex")
test_environment_variable(TEST_ENV_OVERRIDE "Overridden environment variable")
test_environment_variable(TEST_PENV "Process environment variable")
test_environment_variable(TEST_ENV_REF_PENV "prefix+suffix")
