; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=hawaii < %s | FileCheck -check-prefixes=GFX78,GFX7 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=fiji < %s | FileCheck -check-prefixes=GFX78,GFX8 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -mattr=+real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-TRUE16 %s
; RUN: llc -global-isel -mtriple=amdgcn-mesa-mesa3d -mcpu=gfx1100 -mattr=-real-true16 < %s | FileCheck -check-prefixes=GFX11,GFX11-FAKE16 %s

define i16 @v_powi_f16(i16 %l, i32 %r) {
; GFX7-LABEL: v_powi_f16:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX7-NEXT:    v_mov_b32_e32 v2, 0xc2fc0000
; GFX7-NEXT:    v_mov_b32_e32 v3, 0x42800000
; GFX7-NEXT:    v_log_f32_e32 v0, v0
; GFX7-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e32 v1, 0, v3, vcc
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_exp_f32_e32 v0, v0
; GFX7-NEXT:    v_not_b32_e32 v1, 63
; GFX7-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_powi_f16:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX8-NEXT:    v_log_f16_e32 v0, v0
; GFX8-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX8-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX8-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX8-NEXT:    v_exp_f16_e32 v0, v0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-TRUE16-LABEL: v_powi_f16:
; GFX11-TRUE16:       ; %bb.0:
; GFX11-TRUE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-TRUE16-NEXT:    v_log_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.h, v1
; GFX11-TRUE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v1, v0.l
; GFX11-TRUE16-NEXT:    v_cvt_f32_f16_e32 v0, v0.h
; GFX11-TRUE16-NEXT:    v_mul_dx9_zero_f32_e32 v0, v1, v0
; GFX11-TRUE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-TRUE16-NEXT:    v_cvt_f16_f32_e32 v0.l, v0
; GFX11-TRUE16-NEXT:    v_exp_f16_e32 v0.l, v0.l
; GFX11-TRUE16-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-FAKE16-LABEL: v_powi_f16:
; GFX11-FAKE16:       ; %bb.0:
; GFX11-FAKE16-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-FAKE16-NEXT:    v_log_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_3) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v1, v1
; GFX11-FAKE16-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_cvt_f32_f16_e32 v1, v1
; GFX11-FAKE16-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-FAKE16-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-FAKE16-NEXT:    v_cvt_f16_f32_e32 v0, v0
; GFX11-FAKE16-NEXT:    v_exp_f16_e32 v0, v0
; GFX11-FAKE16-NEXT:    s_setpc_b64 s[30:31]
  %l.cast = bitcast i16 %l to half
  %res = call half @llvm.powi.f16.i32(half %l.cast, i32 %r)
  %res.cast = bitcast half %res to i16
  ret i16 %res.cast
}

define float @v_powi_f32(float %l, i32 %r) {
; GFX7-LABEL: v_powi_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX7-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX7-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX7-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_log_f32_e32 v0, v0
; GFX7-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX7-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX7-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX7-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX7-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX7-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX7-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX7-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX7-NEXT:    v_exp_f32_e32 v0, v0
; GFX7-NEXT:    v_not_b32_e32 v1, 63
; GFX7-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX7-NEXT:    v_ldexp_f32_e32 v0, v0, v1
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_powi_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v2
; GFX8-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc
; GFX8-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX8-NEXT:    v_log_f32_e32 v0, v0
; GFX8-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42000000
; GFX8-NEXT:    v_cndmask_b32_e32 v2, 0, v2, vcc
; GFX8-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX8-NEXT:    v_mul_legacy_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_mov_b32_e32 v1, 0xc2fc0000
; GFX8-NEXT:    v_mov_b32_e32 v2, 0x42800000
; GFX8-NEXT:    v_cmp_lt_f32_e32 vcc, v0, v1
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v2, vcc
; GFX8-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX8-NEXT:    v_exp_f32_e32 v0, v0
; GFX8-NEXT:    v_not_b32_e32 v1, 63
; GFX8-NEXT:    v_cndmask_b32_e32 v1, 0, v1, vcc
; GFX8-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0x800000, v0
; GFX11-NEXT:    v_cvt_f32_i32_e32 v1, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 1, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_lshlrev_b32_e32 v2, 5, v2
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v2
; GFX11-NEXT:    v_cndmask_b32_e64 v2, 0, 0x42000000, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_log_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_sub_f32_e32 v0, v0, v2
; GFX11-NEXT:    v_mul_dx9_zero_f32_e32 v0, v0, v1
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_cmp_gt_f32_e32 vcc_lo, 0xc2fc0000, v0
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0x42800000, vcc_lo
; GFX11-NEXT:    v_add_f32_e32 v0, v0, v1
; GFX11-NEXT:    v_cndmask_b32_e64 v1, 0, 0xffffffc0, vcc_lo
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2)
; GFX11-NEXT:    v_exp_f32_e32 v0, v0
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_ldexp_f32 v0, v0, v1
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 %r)
  ret float %res
}

define float @v_powi_0_f32(float %l) {
; GFX78-LABEL: v_powi_0_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    v_mov_b32_e32 v0, 1.0
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_0_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mov_b32_e32 v0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 0)
  ret float %res
}

define float @v_powi_1_f32(float %l) {
; GFX78-LABEL: v_powi_1_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 1)
  ret float %res
}

define float @v_powi_neg1_f32(float %l) {
; GFX7-LABEL: v_powi_neg1_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_powi_neg1_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_neg1_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_2) | instskip(SKIP_2) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX11-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX11-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 -1)
  ret float %res
}

define float @v_powi_2_f32(float %l) {
; GFX78-LABEL: v_powi_2_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 2)
  ret float %res
}

define float @v_powi_neg2_f32(float %l) {
; GFX7-LABEL: v_powi_neg2_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_powi_neg2_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_neg2_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 -2)
  ret float %res
}

define float @v_powi_4_f32(float %l) {
; GFX78-LABEL: v_powi_4_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_4_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 4)
  ret float %res
}

define float @v_powi_8_f32(float %l) {
; GFX78-LABEL: v_powi_8_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_8_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 8)
  ret float %res
}

define float @v_powi_16_f32(float %l) {
; GFX78-LABEL: v_powi_16_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_16_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 16)
  ret float %res
}

define float @v_powi_128_f32(float %l) {
; GFX78-LABEL: v_powi_128_f32:
; GFX78:       ; %bb.0:
; GFX78-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX78-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_128_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 128)
  ret float %res
}

define float @v_powi_neg128_f32(float %l) {
; GFX7-LABEL: v_powi_neg128_f32:
; GFX7:       ; %bb.0:
; GFX7-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX7-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX7-NEXT:    v_rcp_f32_e32 v2, v1
; GFX7-NEXT:    v_div_scale_f32 v3, vcc, 1.0, v0, 1.0
; GFX7-NEXT:    v_fma_f32 v4, -v1, v2, 1.0
; GFX7-NEXT:    v_fma_f32 v2, v4, v2, v2
; GFX7-NEXT:    v_mul_f32_e32 v4, v3, v2
; GFX7-NEXT:    v_fma_f32 v5, -v1, v4, v3
; GFX7-NEXT:    v_fma_f32 v4, v5, v2, v4
; GFX7-NEXT:    v_fma_f32 v1, -v1, v4, v3
; GFX7-NEXT:    v_div_fmas_f32 v1, v1, v2, v4
; GFX7-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX7-NEXT:    s_setpc_b64 s[30:31]
;
; GFX8-LABEL: v_powi_neg128_f32:
; GFX8:       ; %bb.0:
; GFX8-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX8-NEXT:    v_div_scale_f32 v1, s[4:5], v0, v0, 1.0
; GFX8-NEXT:    v_div_scale_f32 v2, vcc, 1.0, v0, 1.0
; GFX8-NEXT:    v_rcp_f32_e32 v3, v1
; GFX8-NEXT:    v_fma_f32 v4, -v1, v3, 1.0
; GFX8-NEXT:    v_fma_f32 v3, v4, v3, v3
; GFX8-NEXT:    v_mul_f32_e32 v4, v2, v3
; GFX8-NEXT:    v_fma_f32 v5, -v1, v4, v2
; GFX8-NEXT:    v_fma_f32 v4, v5, v3, v4
; GFX8-NEXT:    v_fma_f32 v1, -v1, v4, v2
; GFX8-NEXT:    v_div_fmas_f32 v1, v1, v3, v4
; GFX8-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX8-NEXT:    s_setpc_b64 s[30:31]
;
; GFX11-LABEL: v_powi_neg128_f32:
; GFX11:       ; %bb.0:
; GFX11-NEXT:    s_waitcnt vmcnt(0) expcnt(0) lgkmcnt(0)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    v_mul_f32_e32 v0, v0, v0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(SKIP_1) | instid1(VALU_DEP_2)
; GFX11-NEXT:    v_div_scale_f32 v1, null, v0, v0, 1.0
; GFX11-NEXT:    v_div_scale_f32 v4, vcc_lo, 1.0, v0, 1.0
; GFX11-NEXT:    v_rcp_f32_e32 v2, v1
; GFX11-NEXT:    s_waitcnt_depctr 0xfff
; GFX11-NEXT:    v_fma_f32 v3, -v1, v2, 1.0
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fmac_f32_e32 v2, v3, v2
; GFX11-NEXT:    v_mul_f32_e32 v3, v4, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f32 v5, -v1, v3, v4
; GFX11-NEXT:    v_fmac_f32_e32 v3, v5, v2
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1) | instskip(NEXT) | instid1(VALU_DEP_1)
; GFX11-NEXT:    v_fma_f32 v1, -v1, v3, v4
; GFX11-NEXT:    v_div_fmas_f32 v1, v1, v2, v3
; GFX11-NEXT:    s_delay_alu instid0(VALU_DEP_1)
; GFX11-NEXT:    v_div_fixup_f32 v0, v1, v0, 1.0
; GFX11-NEXT:    s_setpc_b64 s[30:31]
  %res = call float @llvm.powi.f32.i32(float %l, i32 -128)
  ret float %res
}

; FIXME: f64 broken
; define double @v_powi_f64(double %l, i32 %r) {
;   %res = call double @llvm.powi.f64.i32(double %l, i32 %r)
;   ret double %res
; }

declare half @llvm.powi.f16.i32(half, i32) #0
declare float @llvm.powi.f32.i32(float, i32) #0
declare double @llvm.powi.f64.i32(double, i32) #0

attributes #0 = { nounwind readnone speculatable willreturn }
