# ConTeXt Chat

Typeset messenger chats with ConTeXt

2024 by Henning Hraban Ramm

## Introduction

In a youth novel that I’m writing, the actors frequently use a messenger app on
their smartphones to chat. I wanted to depict that accordingly, but simplified:
no need for a sophisticated user interface, for replies, reactions, images,
attachments etc.

## Usage

    \usemodule[chat]
    \setupChat[
      recipient=A,
    ]

    \starttext
    \startChat{A} Do you wanna chat?\stopChat
    \startChat{B} Maybe. What about?\stopChat
    \startChat{A} How about cats?\stopChat
    \startChat{A} or squirrels?\stopChat
    \stoptext

There’s no general environment around the messages. If you need to adapt the spacing or want a background, use ConTeXt’s usual possibilities.

The parameter of `\startChat` is the sender of that message, i.e. their avatar. I’m using emoji for that but I’m planning to add more options.

Every first message of a person shows their avatar and a speech bubble tail.
Follow-up messages by the same person have no avatar and no tail.
You can use `\resetChat` to reset this “memory”.

Each conversation has one recipient, that’s the person reading it. Their messages (also avatar and tail) are displayed on the right-hand side, all others on the left.

In my novel, the recipient is fixed by section, so I set it in a setup that is called like `\setuphead[section][before=\setup{section:before}]`.

I suggest using Roboto (Condensed) as base font. You must also setup a fallback font for emojis.

## Options

* `recipient`: Name of the person reading the conversation.
* `style`: text style; default: `\ss`
* `senderstyle`: style of the avatar text; default: `\ss\bf`
* `width`: maximum width of speech bubbles; default: `.8\textwidth`
* `distance`: vertical distance of speech bubbles, unreliable; default: `.25em`
* colors: You can change ChatColorI, ChatColorII, ChatNameColor and ChatFrameColor (switching to a palet soon).

Options regarding the bubble, frame and tail are still missing.

## Limitations

Configuration options are limited. I might enhance the possibilities on request.

* Avatars: I’m using emoji as avatars of the participants; I’m planning to make it work with initials (two characters) or graphics.
* Other planned features: status messages like “Admin added Person”
* Not currently planned features: images, emoji reactions, replies with quotes, read markers, date & time.
* Background: Since I’m going for a printed version, I’m not planning to include a general background or a dark mode.
* There are slightly different bubble forms for “solo”, “first”, “middle” and “last”, but ATM just “solo” and “middle” are used (automatically), since there’s no lookahead, i.e. the module can’t know what will come next. I’ll probably add an option to set the version manually.
* Only one frame color for all messages.
* No further documentation.

## Contributors

* Aditya Mahajan wrote a first draft of speech bubbles for me in 2022. His MetaPost code was more elegant than mine, but I didn’t manage to adapt it to my needs.
* Hans Hagen gave me some valuable hints when I showed him my first working version.

## License

[GPL 3.0+](LICENSE)
