/* Utils.c generated by valac 0.56.18-dirty, the Vala compiler
 * generated from Utils.vala, do not modify */

#include "power.h"
#include <glib.h>
#include <float.h>
#include <math.h>
#include <gdk/gdk.h>
#include <glib-object.h>
#include <gobject/gvaluecollector.h>

#define POWER_UTILS_BRIGHTNESS_STEP 5.0
#if !defined(VALA_STRICT_C)
#if !defined(__clang__) && defined(__GNUC__) && (__GNUC__ >= 14)
#pragma GCC diagnostic warning "-Wincompatible-pointer-types"
#elif defined(__clang__) && (__clang_major__ >= 16)
#pragma clang diagnostic ignored "-Wincompatible-function-pointer-types"
#pragma clang diagnostic ignored "-Wincompatible-pointer-types"
#endif
#endif

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _PowerParamSpecUtils PowerParamSpecUtils;

struct _PowerParamSpecUtils {
	GParamSpec parent_instance;
};

static gpointer power_utils_parent_class = NULL;
static gdouble power_utils_total_y_delta;
static gdouble power_utils_total_y_delta = (gdouble) 0;
static gdouble power_utils_total_x_delta;
static gdouble power_utils_total_x_delta = (gdouble) 0;

static void power_utils_finalize (PowerUtils * obj);
static GType power_utils_get_type_once (void);

static gpointer
_g_object_ref0 (gpointer self)
{
	return self ? g_object_ref (self) : NULL;
}

gboolean
power_utils_handle_scroll_event (GdkEventScroll* e,
                                 gboolean natural_scroll_mouse,
                                 gboolean natural_scroll_touchpad)
{
	gdouble dir = 0.0;
	gboolean natural_scroll = FALSE;
	GdkDevice* event_source_device = NULL;
	GdkDevice* _tmp0_;
	GdkDevice* _tmp1_;
	GdkDevice* _tmp2_;
	GdkDevice* _tmp3_;
	GdkInputSource _tmp4_;
	GdkInputSource _tmp5_;
	gboolean result;
	g_return_val_if_fail (e != NULL, FALSE);
	dir = 0.0;
	_tmp0_ = gdk_event_get_source_device ((GdkEvent*) e);
	_tmp1_ = _g_object_ref0 (_tmp0_);
	event_source_device = _tmp1_;
	_tmp2_ = event_source_device;
	if (_tmp2_ == NULL) {
		result = FALSE;
		_g_object_unref0 (event_source_device);
		return result;
	}
	_tmp3_ = event_source_device;
	g_object_get (_tmp3_, "input-source", &_tmp4_, NULL);
	_tmp5_ = _tmp4_;
	if (_tmp5_ == GDK_SOURCE_MOUSE) {
		natural_scroll = natural_scroll_mouse;
	} else {
		GdkDevice* _tmp6_;
		GdkInputSource _tmp7_;
		GdkInputSource _tmp8_;
		_tmp6_ = event_source_device;
		g_object_get (_tmp6_, "input-source", &_tmp7_, NULL);
		_tmp8_ = _tmp7_;
		if (_tmp8_ == GDK_SOURCE_TOUCHPAD) {
			natural_scroll = natural_scroll_touchpad;
		} else {
			natural_scroll = TRUE;
		}
	}
	switch (e->direction) {
		case GDK_SCROLL_SMOOTH:
		{
			gdouble abs_x = 0.0;
			gdouble abs_y = 0.0;
			abs_x = MAX (fabs (e->delta_x), 0.0001);
			abs_y = MAX (fabs (e->delta_y), 0.0001);
			if ((abs_y / abs_x) > 2.0) {
				power_utils_total_y_delta = power_utils_total_y_delta + e->delta_y;
			} else {
				if ((abs_x / abs_y) > 2.0) {
					power_utils_total_x_delta = power_utils_total_x_delta + e->delta_x;
				}
			}
			break;
		}
		case GDK_SCROLL_UP:
		{
			power_utils_total_y_delta = -1.0;
			break;
		}
		case GDK_SCROLL_DOWN:
		{
			power_utils_total_y_delta = 1.0;
			break;
		}
		case GDK_SCROLL_LEFT:
		{
			power_utils_total_x_delta = -1.0;
			break;
		}
		case GDK_SCROLL_RIGHT:
		{
			power_utils_total_x_delta = 1.0;
			break;
		}
		default:
		{
			break;
		}
	}
	if ((fabs (power_utils_total_y_delta) * POWER_UTILS_BRIGHTNESS_STEP) > 1.0) {
		gdouble _tmp9_ = 0.0;
		if (natural_scroll) {
			_tmp9_ = power_utils_total_y_delta;
		} else {
			_tmp9_ = -power_utils_total_y_delta;
		}
		dir = _tmp9_;
	} else {
		if ((fabs (power_utils_total_x_delta) * POWER_UTILS_BRIGHTNESS_STEP) > 1.0) {
			gdouble _tmp10_ = 0.0;
			if (natural_scroll) {
				_tmp10_ = -power_utils_total_x_delta;
			} else {
				_tmp10_ = power_utils_total_x_delta;
			}
			dir = _tmp10_;
		}
	}
	if (fabs (dir) > 0.0) {
		PowerServicesDeviceManager* _tmp11_;
		power_utils_total_y_delta = 0.0;
		power_utils_total_x_delta = 0.0;
		_tmp11_ = power_services_device_manager_get_default ();
		power_services_device_manager_change_brightness (_tmp11_, (gint) round (dir * POWER_UTILS_BRIGHTNESS_STEP));
	}
	result = GDK_EVENT_STOP;
	_g_object_unref0 (event_source_device);
	return result;
}

PowerUtils*
power_utils_construct (GType object_type)
{
	PowerUtils* self = NULL;
	self = (PowerUtils*) g_type_create_instance (object_type);
	return self;
}

PowerUtils*
power_utils_new (void)
{
	return power_utils_construct (POWER_TYPE_UTILS);
}

static void
power_value_utils_init (GValue* value)
{
	value->data[0].v_pointer = NULL;
}

static void
power_value_utils_free_value (GValue* value)
{
	if (value->data[0].v_pointer) {
		power_utils_unref (value->data[0].v_pointer);
	}
}

static void
power_value_utils_copy_value (const GValue* src_value,
                              GValue* dest_value)
{
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = power_utils_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}

static gpointer
power_value_utils_peek_pointer (const GValue* value)
{
	return value->data[0].v_pointer;
}

static gchar*
power_value_utils_collect_value (GValue* value,
                                 guint n_collect_values,
                                 GTypeCValue* collect_values,
                                 guint collect_flags)
{
	if (collect_values[0].v_pointer) {
		PowerUtils * object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = power_utils_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}

static gchar*
power_value_utils_lcopy_value (const GValue* value,
                               guint n_collect_values,
                               GTypeCValue* collect_values,
                               guint collect_flags)
{
	PowerUtils ** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = power_utils_ref (value->data[0].v_pointer);
	}
	return NULL;
}

GParamSpec*
power_param_spec_utils (const gchar* name,
                        const gchar* nick,
                        const gchar* blurb,
                        GType object_type,
                        GParamFlags flags)
{
	PowerParamSpecUtils* spec;
	g_return_val_if_fail (g_type_is_a (object_type, POWER_TYPE_UTILS), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}

gpointer
power_value_get_utils (const GValue* value)
{
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, POWER_TYPE_UTILS), NULL);
	return value->data[0].v_pointer;
}

void
power_value_set_utils (GValue* value,
                       gpointer v_object)
{
	PowerUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, POWER_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, POWER_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		power_utils_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		power_utils_unref (old);
	}
}

void
power_value_take_utils (GValue* value,
                        gpointer v_object)
{
	PowerUtils * old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, POWER_TYPE_UTILS));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, POWER_TYPE_UTILS));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		power_utils_unref (old);
	}
}

static void
power_utils_class_init (PowerUtilsClass * klass,
                        gpointer klass_data)
{
	power_utils_parent_class = g_type_class_peek_parent (klass);
	((PowerUtilsClass *) klass)->finalize = power_utils_finalize;
}

static void
power_utils_instance_init (PowerUtils * self,
                           gpointer klass)
{
	self->ref_count = 1;
}

static void
power_utils_finalize (PowerUtils * obj)
{
	PowerUtils * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, POWER_TYPE_UTILS, PowerUtils);
	g_signal_handlers_destroy (self);
}

static GType
power_utils_get_type_once (void)
{
	static const GTypeValueTable g_define_type_value_table = { power_value_utils_init, power_value_utils_free_value, power_value_utils_copy_value, power_value_utils_peek_pointer, "p", power_value_utils_collect_value, "p", power_value_utils_lcopy_value };
	static const GTypeInfo g_define_type_info = { sizeof (PowerUtilsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) power_utils_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PowerUtils), 0, (GInstanceInitFunc) power_utils_instance_init, &g_define_type_value_table };
	static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
	GType power_utils_type_id;
	power_utils_type_id = g_type_register_fundamental (g_type_fundamental_next (), "PowerUtils", &g_define_type_info, &g_define_type_fundamental_info, 0);
	return power_utils_type_id;
}

GType
power_utils_get_type (void)
{
	static volatile gsize power_utils_type_id__once = 0;
	if (g_once_init_enter (&power_utils_type_id__once)) {
		GType power_utils_type_id;
		power_utils_type_id = power_utils_get_type_once ();
		g_once_init_leave (&power_utils_type_id__once, power_utils_type_id);
	}
	return power_utils_type_id__once;
}

gpointer
power_utils_ref (gpointer instance)
{
	PowerUtils * self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}

void
power_utils_unref (gpointer instance)
{
	PowerUtils * self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		POWER_UTILS_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}

