// This file is automatically generated from CSSProperties.json by the process-css-properties.py script. Do not edit it.

#include "config.h"
#include "StyleInterpolationWrapperMap.h"

#include "StylePropertyShorthand.h"

#define STYLE_INTERPOLATION_GENERATED_INCLUDE_TRAP 1
#include "StyleInterpolationWrappers.h"
#undef STYLE_INTERPOLATION_GENERATED_INCLUDE_TRAP
namespace WebCore {
namespace Style {
namespace Interpolation {

static WrapperBase* makeShorthandWrapper(CSSPropertyID id, const std::array<WrapperBase*, cssPropertyIDEnumValueCount>& wrappers)
{
    auto shorthand = shorthandForProperty(id);
    ASSERT(shorthand.length());

    auto longhandWrappers = WTF::compactMap(shorthand, [&](auto longhand) -> std::optional<WrapperBase*> {
        auto wrapper = wrappers[longhand];
        if (!wrapper)
            return std::nullopt;
        return wrapper;
    });

    return new ShorthandWrapper(id, WTFMove(longhandWrappers));
}

WrapperMap::WrapperMap()
    : m_wrappers {
        nullptr, // CSSPropertyID::CSSPropertyInvalid
        nullptr, // CSSPropertyID::CSSPropertyCustom
        new DiscreteWrapper(CSSPropertyID::CSSPropertyColorScheme, &RenderStyle::colorScheme, &RenderStyle::setColorScheme), // CSSPropertyID::CSSPropertyColorScheme
        new DiscreteWrapper(CSSPropertyID::CSSPropertyRubyPosition, &RenderStyle::rubyPosition, &RenderStyle::setRubyPosition), // CSSPropertyID::CSSPropertyRubyPosition
        nullptr, // CSSPropertyID::CSSPropertyWritingMode - not animatable
        nullptr, // CSSPropertyID::CSSPropertyDirection - not animatable
        new NonNormalizedDiscreteWrapper<DisplayType>(CSSPropertyID::CSSPropertyDisplay, &RenderStyle::display, &RenderStyle::setDisplay), // CSSPropertyID::CSSPropertyDisplay
        new FontFamilyWrapper(), // CSSPropertyID::CSSPropertyFontFamily
        new FontFeatureSettingsWrapper(), // CSSPropertyID::CSSPropertyFontFeatureSettings
        new DiscreteFontDescriptionTypedWrapper<Kerning>(CSSPropertyID::CSSPropertyFontKerning, &FontCascadeDescription::kerning, &FontCascadeDescription::setKerning), // CSSPropertyID::CSSPropertyFontKerning
        new DiscreteWrapper(CSSPropertyID::CSSPropertyFontOpticalSizing, &RenderStyle::fontOpticalSizing, &RenderStyle::setFontOpticalSizing), // CSSPropertyID::CSSPropertyFontOpticalSizing
        new DiscreteWrapper(CSSPropertyID::CSSPropertyFontPalette, &RenderStyle::fontPalette, &RenderStyle::setFontPalette), // CSSPropertyID::CSSPropertyFontPalette
        new FontSizeWrapper(), // CSSPropertyID::CSSPropertyFontSize
        new FontSizeAdjustWrapper(), // CSSPropertyID::CSSPropertyFontSizeAdjust
        new FontStyleWrapper(), // CSSPropertyID::CSSPropertyFontStyle
        new DiscreteFontDescriptionTypedWrapper<FontSynthesisLonghandValue>(CSSPropertyID::CSSPropertyFontSynthesisSmallCaps, &FontCascadeDescription::fontSynthesisSmallCaps, &FontCascadeDescription::setFontSynthesisSmallCaps), // CSSPropertyID::CSSPropertyFontSynthesisSmallCaps
        new DiscreteFontDescriptionTypedWrapper<FontSynthesisLonghandValue>(CSSPropertyID::CSSPropertyFontSynthesisStyle, &FontCascadeDescription::fontSynthesisStyle, &FontCascadeDescription::setFontSynthesisStyle), // CSSPropertyID::CSSPropertyFontSynthesisStyle
        new DiscreteFontDescriptionTypedWrapper<FontSynthesisLonghandValue>(CSSPropertyID::CSSPropertyFontSynthesisWeight, &FontCascadeDescription::fontSynthesisWeight, &FontCascadeDescription::setFontSynthesisWeight), // CSSPropertyID::CSSPropertyFontSynthesisWeight
        new DiscreteFontDescriptionTypedWrapper<const FontVariantAlternates&>(CSSPropertyID::CSSPropertyFontVariantAlternates, &FontCascadeDescription::variantAlternates, &FontCascadeDescription::setVariantAlternates), // CSSPropertyID::CSSPropertyFontVariantAlternates
        new DiscreteFontDescriptionTypedWrapper<FontVariantCaps>(CSSPropertyID::CSSPropertyFontVariantCaps, &FontCascadeDescription::variantCaps, &FontCascadeDescription::setVariantCaps), // CSSPropertyID::CSSPropertyFontVariantCaps
        new FontVariantEastAsianWrapper(), // CSSPropertyID::CSSPropertyFontVariantEastAsian
        new DiscreteFontDescriptionTypedWrapper<FontVariantEmoji>(CSSPropertyID::CSSPropertyFontVariantEmoji, &FontCascadeDescription::variantEmoji, &FontCascadeDescription::setVariantEmoji), // CSSPropertyID::CSSPropertyFontVariantEmoji
        new FontVariantLigaturesWrapper(), // CSSPropertyID::CSSPropertyFontVariantLigatures
        new FontVariantNumericWrapper(), // CSSPropertyID::CSSPropertyFontVariantNumeric
        new DiscreteFontDescriptionTypedWrapper<FontVariantPosition>(CSSPropertyID::CSSPropertyFontVariantPosition, &FontCascadeDescription::variantPosition, &FontCascadeDescription::setVariantPosition), // CSSPropertyID::CSSPropertyFontVariantPosition
        new FontVariationSettingsWrapper(), // CSSPropertyID::CSSPropertyFontVariationSettings
        new FontWeightWrapper(), // CSSPropertyID::CSSPropertyFontWeight
        new Wrapper(CSSPropertyID::CSSPropertyFontWidth, &RenderStyle::fontWidth, &RenderStyle::setFontWidth), // CSSPropertyID::CSSPropertyFontWidth
        nullptr, // CSSPropertyID::CSSPropertyTextOrientation - not animatable
        new DiscreteFontDescriptionTypedWrapper<TextRenderingMode>(CSSPropertyID::CSSPropertyTextRendering, &FontCascadeDescription::textRenderingMode, &FontCascadeDescription::setTextRenderingMode), // CSSPropertyID::CSSPropertyTextRendering
        nullptr, // CSSPropertyID::CSSPropertyZoom - not animatable
        nullptr, // CSSPropertyID::CSSPropertyWebkitFontSmoothing - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitLocale - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextZoom - not animatable
        new LengthWrapper(CSSPropertyID::CSSPropertyLetterSpacing, &RenderStyle::computedLetterSpacing, &RenderStyle::setLetterSpacing, { LengthWrapper::Flags::IsLengthPercentage }), // CSSPropertyID::CSSPropertyLetterSpacing
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextAutospace, &RenderStyle::textAutospace, &RenderStyle::setTextAutospace), // CSSPropertyID::CSSPropertyTextAutospace
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextSpacingTrim, &RenderStyle::textSpacingTrim, &RenderStyle::setTextSpacingTrim), // CSSPropertyID::CSSPropertyTextSpacingTrim
        new AccentColorWrapper(), // CSSPropertyID::CSSPropertyAccentColor
        nullptr, // CSSPropertyID::CSSPropertyAdditiveSymbols - not animatable (descriptor only)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyAlignContent, &RenderStyle::alignContent, &RenderStyle::setAlignContent), // CSSPropertyID::CSSPropertyAlignContent
        new DiscreteWrapper(CSSPropertyID::CSSPropertyAlignItems, &RenderStyle::alignItems, &RenderStyle::setAlignItems), // CSSPropertyID::CSSPropertyAlignItems
        new DiscreteWrapper(CSSPropertyID::CSSPropertyAlignSelf, &RenderStyle::alignSelf, &RenderStyle::setAlignSelf), // CSSPropertyID::CSSPropertyAlignSelf
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyAlignmentBaseline, &SVGRenderStyle::alignmentBaseline, &SVGRenderStyle::setAlignmentBaseline), // CSSPropertyID::CSSPropertyAlignmentBaseline
        new DiscreteWrapper(CSSPropertyID::CSSPropertyAnchorName, &RenderStyle::anchorNames, &RenderStyle::setAnchorNames), // CSSPropertyID::CSSPropertyAnchorName
        new DiscreteWrapper(CSSPropertyID::CSSPropertyAnchorScope, &RenderStyle::anchorScope, &RenderStyle::setAnchorScope), // CSSPropertyID::CSSPropertyAnchorScope
        nullptr, // CSSPropertyID::CSSPropertyAnimationComposition - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationDelay - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationDirection - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationDuration - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationFillMode - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationIterationCount - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationName - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationPlayState - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationRangeEnd - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationRangeStart - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationTimeline - not animatable
        nullptr, // CSSPropertyID::CSSPropertyAnimationTimingFunction - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyAppearance, &RenderStyle::appearance, &RenderStyle::setAppearance), // CSSPropertyID::CSSPropertyAppearance
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyAspectRatio, &RenderStyle::aspectRatio, &RenderStyle::setAspectRatio), // CSSPropertyID::CSSPropertyAspectRatio
        new FilterWrapper(CSSPropertyID::CSSPropertyBackdropFilter, &RenderStyle::backdropFilter, &RenderStyle::setBackdropFilter), // CSSPropertyID::CSSPropertyBackdropFilter
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBackfaceVisibility, &RenderStyle::backfaceVisibility, &RenderStyle::setBackfaceVisibility), // CSSPropertyID::CSSPropertyBackfaceVisibility
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBackgroundAttachment, &RenderStyle::backgroundAttachment, &RenderStyle::setBackgroundAttachment), // CSSPropertyID::CSSPropertyBackgroundAttachment
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBackgroundBlendMode, &RenderStyle::backgroundBlendMode, &RenderStyle::setBackgroundBlendMode), // CSSPropertyID::CSSPropertyBackgroundBlendMode
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBackgroundClip, &RenderStyle::backgroundClip, &RenderStyle::setBackgroundClip), // CSSPropertyID::CSSPropertyBackgroundClip
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyBackgroundColor, &RenderStyle::backgroundColor, &RenderStyle::setBackgroundColor, &RenderStyle::visitedLinkBackgroundColor, &RenderStyle::setVisitedLinkBackgroundColor), // CSSPropertyID::CSSPropertyBackgroundColor
        new FillLayersWrapper(CSSPropertyID::CSSPropertyBackgroundImage, &RenderStyle::backgroundLayers, &RenderStyle::ensureBackgroundLayers), // CSSPropertyID::CSSPropertyBackgroundImage
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBackgroundOrigin, &RenderStyle::backgroundOrigin, &RenderStyle::setBackgroundOrigin), // CSSPropertyID::CSSPropertyBackgroundOrigin
        new FillLayersWrapper(CSSPropertyID::CSSPropertyBackgroundPositionX, &RenderStyle::backgroundLayers, &RenderStyle::ensureBackgroundLayers), // CSSPropertyID::CSSPropertyBackgroundPositionX
        new FillLayersWrapper(CSSPropertyID::CSSPropertyBackgroundPositionY, &RenderStyle::backgroundLayers, &RenderStyle::ensureBackgroundLayers), // CSSPropertyID::CSSPropertyBackgroundPositionY
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBackgroundRepeat, &RenderStyle::backgroundRepeat, &RenderStyle::setBackgroundRepeat), // CSSPropertyID::CSSPropertyBackgroundRepeat
        new FillLayersWrapper(CSSPropertyID::CSSPropertyBackgroundSize, &RenderStyle::backgroundLayers, &RenderStyle::ensureBackgroundLayers), // CSSPropertyID::CSSPropertyBackgroundSize
        nullptr, // CSSPropertyID::CSSPropertyBasePalette - not animatable (descriptor only)
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBaselineShift, &RenderStyle::baselineShift, &RenderStyle::setBaselineShift), // CSSPropertyID::CSSPropertyBaselineShift
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBlockEllipsis, &RenderStyle::blockEllipsis, &RenderStyle::setBlockEllipsis), // CSSPropertyID::CSSPropertyBlockEllipsis
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBlockStepAlign, &RenderStyle::blockStepAlign, &RenderStyle::setBlockStepAlign), // CSSPropertyID::CSSPropertyBlockStepAlign
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBlockStepInsert, &RenderStyle::blockStepInsert, &RenderStyle::setBlockStepInsert), // CSSPropertyID::CSSPropertyBlockStepInsert
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBlockStepRound, &RenderStyle::blockStepRound, &RenderStyle::setBlockStepRound), // CSSPropertyID::CSSPropertyBlockStepRound
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBlockStepSize, &RenderStyle::blockStepSize, &RenderStyle::setBlockStepSize), // CSSPropertyID::CSSPropertyBlockStepSize
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBorderCollapse, &RenderStyle::borderCollapse, &RenderStyle::setBorderCollapse), // CSSPropertyID::CSSPropertyBorderCollapse
        new LengthBoxWrapper(CSSPropertyID::CSSPropertyBorderImageOutset, &RenderStyle::borderImageOutset, &RenderStyle::setBorderImageOutset), // CSSPropertyID::CSSPropertyBorderImageOutset
        new NinePieceImageRepeatWrapper(CSSPropertyBorderImageRepeat, &RenderStyle::borderImageHorizontalRule, &RenderStyle::setBorderImageHorizontalRule, &RenderStyle::borderImageVerticalRule, &RenderStyle::setBorderImageVerticalRule), // CSSPropertyID::CSSPropertyBorderImageRepeat
        new LengthBoxWrapper(CSSPropertyID::CSSPropertyBorderImageSlice, &RenderStyle::borderImageSlice, &RenderStyle::setBorderImageSlice, { LengthBoxWrapper::Flags::UsesFillKeyword }), // CSSPropertyID::CSSPropertyBorderImageSlice
        new StyleImageWrapper(CSSPropertyID::CSSPropertyBorderImageSource, &RenderStyle::borderImageSource, &RenderStyle::setBorderImageSource), // CSSPropertyID::CSSPropertyBorderImageSource
        new LengthBoxWrapper(CSSPropertyID::CSSPropertyBorderImageWidth, &RenderStyle::borderImageWidth, &RenderStyle::setBorderImageWidth, { LengthBoxWrapper::Flags::IsLengthPercentage, LengthBoxWrapper::Flags::MayOverrideBorderWidths }), // CSSPropertyID::CSSPropertyBorderImageWidth
        new ShadowWrapper<BoxShadows>(CSSPropertyID::CSSPropertyBoxShadow, &RenderStyle::boxShadow, &RenderStyle::setBoxShadow), // CSSPropertyID::CSSPropertyBoxShadow
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBoxSizing, &RenderStyle::boxSizing, &RenderStyle::setBoxSizing), // CSSPropertyID::CSSPropertyBoxSizing
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBreakAfter, &RenderStyle::breakAfter, &RenderStyle::setBreakAfter), // CSSPropertyID::CSSPropertyBreakAfter
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBreakBefore, &RenderStyle::breakBefore, &RenderStyle::setBreakBefore), // CSSPropertyID::CSSPropertyBreakBefore
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBreakInside, &RenderStyle::breakInside, &RenderStyle::setBreakInside), // CSSPropertyID::CSSPropertyBreakInside
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyBufferedRendering, &SVGRenderStyle::bufferedRendering, &SVGRenderStyle::setBufferedRendering), // CSSPropertyID::CSSPropertyBufferedRendering
        new DiscreteWrapper(CSSPropertyID::CSSPropertyCaptionSide, &RenderStyle::captionSide, &RenderStyle::setCaptionSide), // CSSPropertyID::CSSPropertyCaptionSide
        new CaretColorWrapper(), // CSSPropertyID::CSSPropertyCaretColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyClear, &RenderStyle::clear, &RenderStyle::setClear), // CSSPropertyID::CSSPropertyClear
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyClip, &RenderStyle::clip, &RenderStyle::setClip), // CSSPropertyID::CSSPropertyClip
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyClipPath, &RenderStyle::clipPath, &RenderStyle::setClipPath), // CSSPropertyID::CSSPropertyClipPath
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyClipRule, &SVGRenderStyle::clipRule, &SVGRenderStyle::setClipRule), // CSSPropertyID::CSSPropertyClipRule
        new VisitedAffectedColorWrapper(CSSPropertyID::CSSPropertyColor, &RenderStyle::color, &RenderStyle::setColor, &RenderStyle::visitedLinkColor, &RenderStyle::setVisitedLinkColor), // CSSPropertyID::CSSPropertyColor
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyColorInterpolation, &SVGRenderStyle::colorInterpolation, &SVGRenderStyle::setColorInterpolation), // CSSPropertyID::CSSPropertyColorInterpolation
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyColorInterpolationFilters, &SVGRenderStyle::colorInterpolationFilters, &SVGRenderStyle::setColorInterpolationFilters), // CSSPropertyID::CSSPropertyColorInterpolationFilters
        new AutoWrapper<unsigned short>(CSSPropertyID::CSSPropertyColumnCount, &RenderStyle::columnCount, &RenderStyle::setColumnCount, &RenderStyle::hasAutoColumnCount, &RenderStyle::setHasAutoColumnCount, 1U), // CSSPropertyID::CSSPropertyColumnCount
        new DiscreteWrapper(CSSPropertyID::CSSPropertyColumnFill, &RenderStyle::columnFill, &RenderStyle::setColumnFill), // CSSPropertyID::CSSPropertyColumnFill
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyColumnGap, &RenderStyle::columnGap, &RenderStyle::setColumnGap), // CSSPropertyID::CSSPropertyColumnGap
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyColumnRuleColor, &RenderStyle::columnRuleColor, &RenderStyle::setColumnRuleColor, &RenderStyle::visitedLinkColumnRuleColor, &RenderStyle::setVisitedLinkColumnRuleColor), // CSSPropertyID::CSSPropertyColumnRuleColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyColumnRuleStyle, &RenderStyle::columnRuleStyle, &RenderStyle::setColumnRuleStyle), // CSSPropertyID::CSSPropertyColumnRuleStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyColumnRuleWidth, &RenderStyle::columnRuleWidth, &RenderStyle::setColumnRuleWidth), // CSSPropertyID::CSSPropertyColumnRuleWidth
        new DiscreteWrapper(CSSPropertyID::CSSPropertyColumnSpan, &RenderStyle::columnSpan, &RenderStyle::setColumnSpan), // CSSPropertyID::CSSPropertyColumnSpan
        new AutoWrapper<float>(CSSPropertyID::CSSPropertyColumnWidth, &RenderStyle::columnWidth, &RenderStyle::setColumnWidth, &RenderStyle::hasAutoColumnWidth, &RenderStyle::setHasAutoColumnWidth, 0.0f), // CSSPropertyID::CSSPropertyColumnWidth
        nullptr, // CSSPropertyID::CSSPropertyContain - not animatable
        nullptr, // CSSPropertyID::CSSPropertyContainerName - not animatable
        nullptr, // CSSPropertyID::CSSPropertyContainerType - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyContent, &RenderStyle::content, &RenderStyle::setContent), // CSSPropertyID::CSSPropertyContent
        new NonNormalizedDiscreteWrapper<ContentVisibility>(CSSPropertyID::CSSPropertyContentVisibility, &RenderStyle::contentVisibility, &RenderStyle::setContentVisibility), // CSSPropertyID::CSSPropertyContentVisibility
        new DiscreteWrapper(CSSPropertyID::CSSPropertyContinue, &RenderStyle::overflowContinue, &RenderStyle::setOverflowContinue), // CSSPropertyID::CSSPropertyContinue
        new CounterWrapper(CSSPropertyCounterIncrement), // CSSPropertyID::CSSPropertyCounterIncrement
        new CounterWrapper(CSSPropertyCounterReset), // CSSPropertyID::CSSPropertyCounterReset
        new CounterWrapper(CSSPropertyCounterSet), // CSSPropertyID::CSSPropertyCounterSet
        new DiscreteWrapper(CSSPropertyID::CSSPropertyCursor, &RenderStyle::cursor, &RenderStyle::setCursor), // CSSPropertyID::CSSPropertyCursor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyCx, &RenderStyle::cx, &RenderStyle::setCx), // CSSPropertyID::CSSPropertyCx
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyCy, &RenderStyle::cy, &RenderStyle::setCy), // CSSPropertyID::CSSPropertyCy
        new DWrapper(), // CSSPropertyID::CSSPropertyD
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyDominantBaseline, &SVGRenderStyle::dominantBaseline, &SVGRenderStyle::setDominantBaseline), // CSSPropertyID::CSSPropertyDominantBaseline
        nullptr, // CSSPropertyID::CSSPropertyDynamicRangeLimit - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyEmptyCells, &RenderStyle::emptyCells, &RenderStyle::setEmptyCells), // CSSPropertyID::CSSPropertyEmptyCells
        nullptr, // CSSPropertyID::CSSPropertyFallback - not animatable (descriptor only)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyFieldSizing, &RenderStyle::fieldSizing, &RenderStyle::setFieldSizing), // CSSPropertyID::CSSPropertyFieldSizing
        new VisitedAffectedStyleTypeWrapper<SVGPaint>(CSSPropertyID::CSSPropertyFill, &RenderStyle::fill, &RenderStyle::setFill, &RenderStyle::visitedLinkFill, &RenderStyle::setVisitedLinkFill), // CSSPropertyID::CSSPropertyFill
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyFillOpacity, &RenderStyle::fillOpacity, &RenderStyle::setFillOpacity), // CSSPropertyID::CSSPropertyFillOpacity
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyFillRule, &SVGRenderStyle::fillRule, &SVGRenderStyle::setFillRule), // CSSPropertyID::CSSPropertyFillRule
        new FilterWrapper(CSSPropertyID::CSSPropertyFilter, &RenderStyle::filter, &RenderStyle::setFilter), // CSSPropertyID::CSSPropertyFilter
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyFlexBasis, &RenderStyle::flexBasis, &RenderStyle::setFlexBasis), // CSSPropertyID::CSSPropertyFlexBasis
        new DiscreteWrapper(CSSPropertyID::CSSPropertyFlexDirection, &RenderStyle::flexDirection, &RenderStyle::setFlexDirection), // CSSPropertyID::CSSPropertyFlexDirection
        new FloatWrapper(CSSPropertyID::CSSPropertyFlexGrow, &RenderStyle::flexGrow, &RenderStyle::setFlexGrow, FloatWrapper::ValueRange::NonNegative), // CSSPropertyID::CSSPropertyFlexGrow
        new FloatWrapper(CSSPropertyID::CSSPropertyFlexShrink, &RenderStyle::flexShrink, &RenderStyle::setFlexShrink, FloatWrapper::ValueRange::NonNegative), // CSSPropertyID::CSSPropertyFlexShrink
        new DiscreteWrapper(CSSPropertyID::CSSPropertyFlexWrap, &RenderStyle::flexWrap, &RenderStyle::setFlexWrap), // CSSPropertyID::CSSPropertyFlexWrap
        new DiscreteWrapper(CSSPropertyID::CSSPropertyFloat, &RenderStyle::floating, &RenderStyle::setFloating), // CSSPropertyID::CSSPropertyFloat
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyFloodColor, &RenderStyle::floodColor, &RenderStyle::setFloodColor), // CSSPropertyID::CSSPropertyFloodColor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyFloodOpacity, &RenderStyle::floodOpacity, &RenderStyle::setFloodOpacity), // CSSPropertyID::CSSPropertyFloodOpacity
        nullptr, // CSSPropertyID::CSSPropertyFontDisplay - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyGlyphOrientationHorizontal - not animatable
        nullptr, // CSSPropertyID::CSSPropertyGlyphOrientationVertical - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridAutoColumns, &RenderStyle::gridAutoColumns, &RenderStyle::setGridAutoColumns), // CSSPropertyID::CSSPropertyGridAutoColumns
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridAutoFlow, &RenderStyle::gridAutoFlow, &RenderStyle::setGridAutoFlow), // CSSPropertyID::CSSPropertyGridAutoFlow
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridAutoRows, &RenderStyle::gridAutoRows, &RenderStyle::setGridAutoRows), // CSSPropertyID::CSSPropertyGridAutoRows
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridColumnEnd, &RenderStyle::gridItemColumnEnd, &RenderStyle::setGridItemColumnEnd), // CSSPropertyID::CSSPropertyGridColumnEnd
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridColumnStart, &RenderStyle::gridItemColumnStart, &RenderStyle::setGridItemColumnStart), // CSSPropertyID::CSSPropertyGridColumnStart
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridRowEnd, &RenderStyle::gridItemRowEnd, &RenderStyle::setGridItemRowEnd), // CSSPropertyID::CSSPropertyGridRowEnd
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridRowStart, &RenderStyle::gridItemRowStart, &RenderStyle::setGridItemRowStart), // CSSPropertyID::CSSPropertyGridRowStart
        new DiscreteWrapper(CSSPropertyID::CSSPropertyGridTemplateAreas, &RenderStyle::gridTemplateAreas, &RenderStyle::setGridTemplateAreas), // CSSPropertyID::CSSPropertyGridTemplateAreas
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyGridTemplateColumns, &RenderStyle::gridTemplateColumns, &RenderStyle::setGridTemplateColumns), // CSSPropertyID::CSSPropertyGridTemplateColumns
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyGridTemplateRows, &RenderStyle::gridTemplateRows, &RenderStyle::setGridTemplateRows), // CSSPropertyID::CSSPropertyGridTemplateRows
        new DiscreteWrapper(CSSPropertyID::CSSPropertyHangingPunctuation, &RenderStyle::hangingPunctuation, &RenderStyle::setHangingPunctuation), // CSSPropertyID::CSSPropertyHangingPunctuation
        new DiscreteWrapper(CSSPropertyID::CSSPropertyHyphenateCharacter, &RenderStyle::hyphenateCharacter, &RenderStyle::setHyphenateCharacter), // CSSPropertyID::CSSPropertyHyphenateCharacter
        new DiscreteWrapper(CSSPropertyID::CSSPropertyHyphens, &RenderStyle::hyphens, &RenderStyle::setHyphens), // CSSPropertyID::CSSPropertyHyphens
        new DiscreteWrapper(CSSPropertyID::CSSPropertyImageOrientation, &RenderStyle::imageOrientation, &RenderStyle::setImageOrientation), // CSSPropertyID::CSSPropertyImageOrientation
        new DiscreteWrapper(CSSPropertyID::CSSPropertyImageRendering, &RenderStyle::imageRendering, &RenderStyle::setImageRendering), // CSSPropertyID::CSSPropertyImageRendering
        nullptr, // CSSPropertyID::CSSPropertyInherits - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyInitialValue - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyInputSecurity - not animatable (needs triage)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyIsolation, &RenderStyle::isolation, &RenderStyle::setIsolation), // CSSPropertyID::CSSPropertyIsolation
        new DiscreteWrapper(CSSPropertyID::CSSPropertyJustifyContent, &RenderStyle::justifyContent, &RenderStyle::setJustifyContent), // CSSPropertyID::CSSPropertyJustifyContent
        new DiscreteWrapper(CSSPropertyID::CSSPropertyJustifyItems, &RenderStyle::justifyItems, &RenderStyle::setJustifyItems), // CSSPropertyID::CSSPropertyJustifyItems
        new DiscreteWrapper(CSSPropertyID::CSSPropertyJustifySelf, &RenderStyle::justifySelf, &RenderStyle::setJustifySelf), // CSSPropertyID::CSSPropertyJustifySelf
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyLightingColor, &RenderStyle::lightingColor, &RenderStyle::setLightingColor), // CSSPropertyID::CSSPropertyLightingColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyLineBreak, &RenderStyle::lineBreak, &RenderStyle::setLineBreak), // CSSPropertyID::CSSPropertyLineBreak
        new DiscreteWrapper(CSSPropertyID::CSSPropertyLineFitEdge, &RenderStyle::lineFitEdge, &RenderStyle::setLineFitEdge), // CSSPropertyID::CSSPropertyLineFitEdge
        new LineHeightWrapper(), // CSSPropertyID::CSSPropertyLineHeight
        new StyleImageWrapper(CSSPropertyID::CSSPropertyListStyleImage, &RenderStyle::listStyleImage, &RenderStyle::setListStyleImage), // CSSPropertyID::CSSPropertyListStyleImage
        new DiscreteWrapper(CSSPropertyID::CSSPropertyListStylePosition, &RenderStyle::listStylePosition, &RenderStyle::setListStylePosition), // CSSPropertyID::CSSPropertyListStylePosition
        new DiscreteWrapper(CSSPropertyID::CSSPropertyListStyleType, &RenderStyle::listStyleType, &RenderStyle::setListStyleType), // CSSPropertyID::CSSPropertyListStyleType
        new DiscreteWrapper(CSSPropertyID::CSSPropertyMarginTrim, &RenderStyle::marginTrim, &RenderStyle::setMarginTrim), // CSSPropertyID::CSSPropertyMarginTrim
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyMarkerEnd, &SVGRenderStyle::markerEndResource, &SVGRenderStyle::setMarkerEndResource), // CSSPropertyID::CSSPropertyMarkerEnd
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyMarkerMid, &SVGRenderStyle::markerMidResource, &SVGRenderStyle::setMarkerMidResource), // CSSPropertyID::CSSPropertyMarkerMid
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyMarkerStart, &SVGRenderStyle::markerStartResource, &SVGRenderStyle::setMarkerStartResource), // CSSPropertyID::CSSPropertyMarkerStart
        new LengthBoxWrapper(CSSPropertyID::CSSPropertyMaskBorderOutset, &RenderStyle::maskBorderOutset, &RenderStyle::setMaskBorderOutset), // CSSPropertyID::CSSPropertyMaskBorderOutset
        new NinePieceImageRepeatWrapper(CSSPropertyMaskBorderRepeat, &RenderStyle::maskBorderHorizontalRule, &RenderStyle::setMaskBorderHorizontalRule, &RenderStyle::maskBorderVerticalRule, &RenderStyle::setMaskBorderVerticalRule), // CSSPropertyID::CSSPropertyMaskBorderRepeat
        new LengthBoxWrapper(CSSPropertyID::CSSPropertyMaskBorderSlice, &RenderStyle::maskBorderSlice, &RenderStyle::setMaskBorderSlice, { LengthBoxWrapper::Flags::UsesFillKeyword }), // CSSPropertyID::CSSPropertyMaskBorderSlice
        new StyleImageWrapper(CSSPropertyID::CSSPropertyMaskBorderSource, &RenderStyle::maskBorderSource, &RenderStyle::setMaskBorderSource), // CSSPropertyID::CSSPropertyMaskBorderSource
        new LengthBoxWrapper(CSSPropertyID::CSSPropertyMaskBorderWidth, &RenderStyle::maskBorderWidth, &RenderStyle::setMaskBorderWidth, { LengthBoxWrapper::Flags::IsLengthPercentage }), // CSSPropertyID::CSSPropertyMaskBorderWidth
        new FillLayersWrapper(CSSPropertyID::CSSPropertyMaskClip, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyMaskClip
        new FillLayersWrapper(CSSPropertyID::CSSPropertyMaskComposite, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyMaskComposite
        new FillLayersWrapper(CSSPropertyID::CSSPropertyMaskImage, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyMaskImage
        new FillLayersWrapper(CSSPropertyID::CSSPropertyMaskMode, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyMaskMode
        new FillLayersWrapper(CSSPropertyID::CSSPropertyMaskOrigin, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyMaskOrigin
        new DiscreteWrapper(CSSPropertyID::CSSPropertyMaskRepeat, &RenderStyle::maskRepeat, &RenderStyle::setMaskRepeat), // CSSPropertyID::CSSPropertyMaskRepeat
        new FillLayersWrapper(CSSPropertyID::CSSPropertyMaskSize, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyMaskSize
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyMaskType, &SVGRenderStyle::maskType, &SVGRenderStyle::setMaskType), // CSSPropertyID::CSSPropertyMaskType
        nullptr, // CSSPropertyID::CSSPropertyMathStyle - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyMaxLines, &RenderStyle::maxLines, &RenderStyle::setMaxLines), // CSSPropertyID::CSSPropertyMaxLines
        new DiscreteWrapper(CSSPropertyID::CSSPropertyMixBlendMode, &RenderStyle::blendMode, &RenderStyle::setBlendMode), // CSSPropertyID::CSSPropertyMixBlendMode
        nullptr, // CSSPropertyID::CSSPropertyNavigation - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyNegative - not animatable (descriptor only)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyObjectFit, &RenderStyle::objectFit, &RenderStyle::setObjectFit), // CSSPropertyID::CSSPropertyObjectFit
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyObjectPosition, &RenderStyle::objectPosition, &RenderStyle::setObjectPosition), // CSSPropertyID::CSSPropertyObjectPosition
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOffsetAnchor, &RenderStyle::offsetAnchor, &RenderStyle::setOffsetAnchor), // CSSPropertyID::CSSPropertyOffsetAnchor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOffsetDistance, &RenderStyle::offsetDistance, &RenderStyle::setOffsetDistance), // CSSPropertyID::CSSPropertyOffsetDistance
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOffsetPath, &RenderStyle::offsetPath, &RenderStyle::setOffsetPath), // CSSPropertyID::CSSPropertyOffsetPath
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOffsetPosition, &RenderStyle::offsetPosition, &RenderStyle::setOffsetPosition), // CSSPropertyID::CSSPropertyOffsetPosition
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOffsetRotate, &RenderStyle::offsetRotate, &RenderStyle::setOffsetRotate), // CSSPropertyID::CSSPropertyOffsetRotate
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOpacity, &RenderStyle::opacity, &RenderStyle::setOpacity), // CSSPropertyID::CSSPropertyOpacity
        new Wrapper(CSSPropertyID::CSSPropertyOrder, &RenderStyle::order, &RenderStyle::setOrder), // CSSPropertyID::CSSPropertyOrder
        new PositiveWrapper<unsigned short>(CSSPropertyID::CSSPropertyOrphans, &RenderStyle::orphans, &RenderStyle::setOrphans), // CSSPropertyID::CSSPropertyOrphans
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyOutlineColor, &RenderStyle::outlineColor, &RenderStyle::setOutlineColor, &RenderStyle::visitedLinkOutlineColor, &RenderStyle::setVisitedLinkOutlineColor), // CSSPropertyID::CSSPropertyOutlineColor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOutlineOffset, &RenderStyle::outlineOffset, &RenderStyle::setOutlineOffset), // CSSPropertyID::CSSPropertyOutlineOffset
        new DiscreteWrapper(CSSPropertyID::CSSPropertyOutlineStyle, &RenderStyle::outlineStyle, &RenderStyle::setOutlineStyle), // CSSPropertyID::CSSPropertyOutlineStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyOutlineWidth, &RenderStyle::outlineWidth, &RenderStyle::setOutlineWidth), // CSSPropertyID::CSSPropertyOutlineWidth
        new DiscreteWrapper(CSSPropertyID::CSSPropertyOverflowAnchor, &RenderStyle::overflowAnchor, &RenderStyle::setOverflowAnchor), // CSSPropertyID::CSSPropertyOverflowAnchor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyOverflowWrap, &RenderStyle::overflowWrap, &RenderStyle::setOverflowWrap), // CSSPropertyID::CSSPropertyOverflowWrap
        nullptr, // CSSPropertyID::CSSPropertyOverrideColors - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyPad - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyPage - not animatable (needs triage)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPaintOrder, &RenderStyle::paintOrder, &RenderStyle::setPaintOrder), // CSSPropertyID::CSSPropertyPaintOrder
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPerspective, &RenderStyle::perspective, &RenderStyle::setPerspective), // CSSPropertyID::CSSPropertyPerspective
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPerspectiveOriginX, &RenderStyle::perspectiveOriginX, &RenderStyle::setPerspectiveOriginX), // CSSPropertyID::CSSPropertyPerspectiveOriginX
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPerspectiveOriginY, &RenderStyle::perspectiveOriginY, &RenderStyle::setPerspectiveOriginY), // CSSPropertyID::CSSPropertyPerspectiveOriginY
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPointerEvents, &RenderStyle::pointerEvents, &RenderStyle::setPointerEvents), // CSSPropertyID::CSSPropertyPointerEvents
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPosition, &RenderStyle::position, &RenderStyle::setPosition), // CSSPropertyID::CSSPropertyPosition
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPositionAnchor, &RenderStyle::positionAnchor, &RenderStyle::setPositionAnchor), // CSSPropertyID::CSSPropertyPositionAnchor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPositionArea, &RenderStyle::positionArea, &RenderStyle::setPositionArea), // CSSPropertyID::CSSPropertyPositionArea
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPositionTryFallbacks, &RenderStyle::positionTryFallbacks, &RenderStyle::setPositionTryFallbacks), // CSSPropertyID::CSSPropertyPositionTryFallbacks
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPositionTryOrder, &RenderStyle::positionTryOrder, &RenderStyle::setPositionTryOrder), // CSSPropertyID::CSSPropertyPositionTryOrder
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPositionVisibility, &RenderStyle::positionVisibility, &RenderStyle::setPositionVisibility), // CSSPropertyID::CSSPropertyPositionVisibility
        nullptr, // CSSPropertyID::CSSPropertyPrefix - not animatable (descriptor only)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyPrintColorAdjust, &RenderStyle::printColorAdjust, &RenderStyle::setPrintColorAdjust), // CSSPropertyID::CSSPropertyPrintColorAdjust
        new DiscreteWrapper(CSSPropertyID::CSSPropertyQuotes, &RenderStyle::quotes, &RenderStyle::setQuotes), // CSSPropertyID::CSSPropertyQuotes
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyR, &RenderStyle::r, &RenderStyle::setR), // CSSPropertyID::CSSPropertyR
        nullptr, // CSSPropertyID::CSSPropertyRange - not animatable (descriptor only)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyResize, &RenderStyle::resize, &RenderStyle::setResize), // CSSPropertyID::CSSPropertyResize
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyRotate, &RenderStyle::rotate, &RenderStyle::setRotate), // CSSPropertyID::CSSPropertyRotate
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyRowGap, &RenderStyle::rowGap, &RenderStyle::setRowGap), // CSSPropertyID::CSSPropertyRowGap
        new DiscreteWrapper(CSSPropertyID::CSSPropertyRubyAlign, &RenderStyle::rubyAlign, &RenderStyle::setRubyAlign), // CSSPropertyID::CSSPropertyRubyAlign
        new DiscreteWrapper(CSSPropertyID::CSSPropertyRubyOverhang, &RenderStyle::rubyOverhang, &RenderStyle::setRubyOverhang), // CSSPropertyID::CSSPropertyRubyOverhang
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyRx, &RenderStyle::rx, &RenderStyle::setRx), // CSSPropertyID::CSSPropertyRx
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyRy, &RenderStyle::ry, &RenderStyle::setRy), // CSSPropertyID::CSSPropertyRy
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyScale, &RenderStyle::scale, &RenderStyle::setScale), // CSSPropertyID::CSSPropertyScale
        new DiscreteWrapper(CSSPropertyID::CSSPropertyScrollBehavior, &RenderStyle::scrollBehavior, &RenderStyle::setScrollBehavior), // CSSPropertyID::CSSPropertyScrollBehavior
        new DiscreteWrapper(CSSPropertyID::CSSPropertyScrollSnapAlign, &RenderStyle::scrollSnapAlign, &RenderStyle::setScrollSnapAlign), // CSSPropertyID::CSSPropertyScrollSnapAlign
        new DiscreteWrapper(CSSPropertyID::CSSPropertyScrollSnapStop, &RenderStyle::scrollSnapStop, &RenderStyle::setScrollSnapStop), // CSSPropertyID::CSSPropertyScrollSnapStop
        new DiscreteWrapper(CSSPropertyID::CSSPropertyScrollSnapType, &RenderStyle::scrollSnapType, &RenderStyle::setScrollSnapType), // CSSPropertyID::CSSPropertyScrollSnapType
        nullptr, // CSSPropertyID::CSSPropertyScrollTimelineAxis - not animatable
        nullptr, // CSSPropertyID::CSSPropertyScrollTimelineName - not animatable
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyScrollbarColor, &RenderStyle::scrollbarColor, &RenderStyle::setScrollbarColor), // CSSPropertyID::CSSPropertyScrollbarColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyScrollbarGutter, &RenderStyle::scrollbarGutter, &RenderStyle::setScrollbarGutter), // CSSPropertyID::CSSPropertyScrollbarGutter
        new DiscreteWrapper(CSSPropertyID::CSSPropertyScrollbarWidth, &RenderStyle::scrollbarWidth, &RenderStyle::setScrollbarWidth), // CSSPropertyID::CSSPropertyScrollbarWidth
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyShapeImageThreshold, &RenderStyle::shapeImageThreshold, &RenderStyle::setShapeImageThreshold), // CSSPropertyID::CSSPropertyShapeImageThreshold
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyShapeMargin, &RenderStyle::shapeMargin, &RenderStyle::setShapeMargin), // CSSPropertyID::CSSPropertyShapeMargin
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyShapeOutside, &RenderStyle::shapeOutside, &RenderStyle::setShapeOutside), // CSSPropertyID::CSSPropertyShapeOutside
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyShapeRendering, &SVGRenderStyle::shapeRendering, &SVGRenderStyle::setShapeRendering), // CSSPropertyID::CSSPropertyShapeRendering
        nullptr, // CSSPropertyID::CSSPropertySize - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertySizeAdjust - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertySpeakAs - not animatable
        nullptr, // CSSPropertyID::CSSPropertySrc - not animatable (descriptor only)
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStopColor, &RenderStyle::stopColor, &RenderStyle::setStopColor), // CSSPropertyID::CSSPropertyStopColor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStopOpacity, &RenderStyle::stopOpacity, &RenderStyle::setStopOpacity), // CSSPropertyID::CSSPropertyStopOpacity
        new VisitedAffectedStyleTypeWrapper<SVGPaint>(CSSPropertyID::CSSPropertyStroke, &RenderStyle::stroke, &RenderStyle::setStroke, &RenderStyle::visitedLinkStroke, &RenderStyle::setVisitedLinkStroke), // CSSPropertyID::CSSPropertyStroke
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStrokeColor, &RenderStyle::strokeColor, &RenderStyle::setStrokeColor), // CSSPropertyID::CSSPropertyStrokeColor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStrokeDasharray, &RenderStyle::strokeDashArray, &RenderStyle::setStrokeDashArray), // CSSPropertyID::CSSPropertyStrokeDasharray
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStrokeDashoffset, &RenderStyle::strokeDashOffset, &RenderStyle::setStrokeDashOffset), // CSSPropertyID::CSSPropertyStrokeDashoffset
        new DiscreteWrapper(CSSPropertyID::CSSPropertyStrokeLinecap, &RenderStyle::capStyle, &RenderStyle::setCapStyle), // CSSPropertyID::CSSPropertyStrokeLinecap
        new DiscreteWrapper(CSSPropertyID::CSSPropertyStrokeLinejoin, &RenderStyle::joinStyle, &RenderStyle::setJoinStyle), // CSSPropertyID::CSSPropertyStrokeLinejoin
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStrokeMiterlimit, &RenderStyle::strokeMiterLimit, &RenderStyle::setStrokeMiterLimit), // CSSPropertyID::CSSPropertyStrokeMiterlimit
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStrokeOpacity, &RenderStyle::strokeOpacity, &RenderStyle::setStrokeOpacity), // CSSPropertyID::CSSPropertyStrokeOpacity
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyStrokeWidth, &RenderStyle::strokeWidth, &RenderStyle::setStrokeWidth), // CSSPropertyID::CSSPropertyStrokeWidth
        nullptr, // CSSPropertyID::CSSPropertySuffix - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertySymbols - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertySyntax - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertySystem - not animatable (descriptor only)
        new TabSizeWrapper(), // CSSPropertyID::CSSPropertyTabSize
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTableLayout, &RenderStyle::tableLayout, &RenderStyle::setTableLayout), // CSSPropertyID::CSSPropertyTableLayout
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextAlign, &RenderStyle::textAlign, &RenderStyle::setTextAlign), // CSSPropertyID::CSSPropertyTextAlign
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextAlignLast, &RenderStyle::textAlignLast, &RenderStyle::setTextAlignLast), // CSSPropertyID::CSSPropertyTextAlignLast
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyTextAnchor, &SVGRenderStyle::textAnchor, &SVGRenderStyle::setTextAnchor), // CSSPropertyID::CSSPropertyTextAnchor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextBoxEdge, &RenderStyle::textBoxEdge, &RenderStyle::setTextBoxEdge), // CSSPropertyID::CSSPropertyTextBoxEdge
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextBoxTrim, &RenderStyle::textBoxTrim, &RenderStyle::setTextBoxTrim), // CSSPropertyID::CSSPropertyTextBoxTrim
        nullptr, // CSSPropertyID::CSSPropertyTextCombineUpright - not animatable
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyTextDecorationColor, &RenderStyle::textDecorationColor, &RenderStyle::setTextDecorationColor, &RenderStyle::visitedLinkTextDecorationColor, &RenderStyle::setVisitedLinkTextDecorationColor), // CSSPropertyID::CSSPropertyTextDecorationColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextDecorationLine, &RenderStyle::textDecorationLine, &RenderStyle::setTextDecorationLine), // CSSPropertyID::CSSPropertyTextDecorationLine
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextDecorationSkipInk, &RenderStyle::textDecorationSkipInk, &RenderStyle::setTextDecorationSkipInk), // CSSPropertyID::CSSPropertyTextDecorationSkipInk
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextDecorationStyle, &RenderStyle::textDecorationStyle, &RenderStyle::setTextDecorationStyle), // CSSPropertyID::CSSPropertyTextDecorationStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTextDecorationThickness, &RenderStyle::textDecorationThickness, &RenderStyle::setTextDecorationThickness), // CSSPropertyID::CSSPropertyTextDecorationThickness
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyTextEmphasisColor, &RenderStyle::textEmphasisColor, &RenderStyle::setTextEmphasisColor, &RenderStyle::visitedLinkTextEmphasisColor, &RenderStyle::setVisitedLinkTextEmphasisColor), // CSSPropertyID::CSSPropertyTextEmphasisColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextEmphasisPosition, &RenderStyle::textEmphasisPosition, &RenderStyle::setTextEmphasisPosition), // CSSPropertyID::CSSPropertyTextEmphasisPosition
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextEmphasisStyle, &RenderStyle::textEmphasisStyle, &RenderStyle::setTextEmphasisStyle), // CSSPropertyID::CSSPropertyTextEmphasisStyle
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextGroupAlign, &RenderStyle::textGroupAlign, &RenderStyle::setTextGroupAlign), // CSSPropertyID::CSSPropertyTextGroupAlign
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTextIndent, &RenderStyle::textIndent, &RenderStyle::setTextIndent), // CSSPropertyID::CSSPropertyTextIndent
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextJustify, &RenderStyle::textJustify, &RenderStyle::setTextJustify), // CSSPropertyID::CSSPropertyTextJustify
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextOverflow, &RenderStyle::textOverflow, &RenderStyle::setTextOverflow), // CSSPropertyID::CSSPropertyTextOverflow
        new ShadowWrapper<TextShadows>(CSSPropertyID::CSSPropertyTextShadow, &RenderStyle::textShadow, &RenderStyle::setTextShadow), // CSSPropertyID::CSSPropertyTextShadow
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextTransform, &RenderStyle::textTransform, &RenderStyle::setTextTransform), // CSSPropertyID::CSSPropertyTextTransform
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTextUnderlineOffset, &RenderStyle::textUnderlineOffset, &RenderStyle::setTextUnderlineOffset), // CSSPropertyID::CSSPropertyTextUnderlineOffset
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextUnderlinePosition, &RenderStyle::textUnderlinePosition, &RenderStyle::setTextUnderlinePosition), // CSSPropertyID::CSSPropertyTextUnderlinePosition
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextWrapMode, &RenderStyle::textWrapMode, &RenderStyle::setTextWrapMode), // CSSPropertyID::CSSPropertyTextWrapMode
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTextWrapStyle, &RenderStyle::textWrapStyle, &RenderStyle::setTextWrapStyle), // CSSPropertyID::CSSPropertyTextWrapStyle
        nullptr, // CSSPropertyID::CSSPropertyTimelineScope - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTouchAction, &RenderStyle::touchActions, &RenderStyle::setTouchActions), // CSSPropertyID::CSSPropertyTouchAction
        new TransformOperationsWrapper(), // CSSPropertyID::CSSPropertyTransform
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTransformBox, &RenderStyle::transformBox, &RenderStyle::setTransformBox), // CSSPropertyID::CSSPropertyTransformBox
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTransformOriginX, &RenderStyle::transformOriginX, &RenderStyle::setTransformOriginX), // CSSPropertyID::CSSPropertyTransformOriginX
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTransformOriginY, &RenderStyle::transformOriginY, &RenderStyle::setTransformOriginY), // CSSPropertyID::CSSPropertyTransformOriginY
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTransformOriginZ, &RenderStyle::transformOriginZ, &RenderStyle::setTransformOriginZ), // CSSPropertyID::CSSPropertyTransformOriginZ
        new DiscreteWrapper(CSSPropertyID::CSSPropertyTransformStyle, &RenderStyle::transformStyle3D, &RenderStyle::setTransformStyle3D), // CSSPropertyID::CSSPropertyTransformStyle
        nullptr, // CSSPropertyID::CSSPropertyTransitionBehavior - not animatable
        nullptr, // CSSPropertyID::CSSPropertyTransitionDelay - not animatable
        nullptr, // CSSPropertyID::CSSPropertyTransitionDuration - not animatable
        nullptr, // CSSPropertyID::CSSPropertyTransitionProperty - not animatable
        nullptr, // CSSPropertyID::CSSPropertyTransitionTimingFunction - not animatable
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTranslate, &RenderStyle::translate, &RenderStyle::setTranslate), // CSSPropertyID::CSSPropertyTranslate
        nullptr, // CSSPropertyID::CSSPropertyTypes - not animatable (descriptor only)
        nullptr, // CSSPropertyID::CSSPropertyUnicodeBidi - not animatable
        nullptr, // CSSPropertyID::CSSPropertyUnicodeRange - not animatable (descriptor only)
        new DiscreteSVGWrapper(CSSPropertyID::CSSPropertyVectorEffect, &SVGRenderStyle::vectorEffect, &SVGRenderStyle::setVectorEffect), // CSSPropertyID::CSSPropertyVectorEffect
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyVerticalAlign, &RenderStyle::verticalAlign, &RenderStyle::setVerticalAlign), // CSSPropertyID::CSSPropertyVerticalAlign
        nullptr, // CSSPropertyID::CSSPropertyViewTimelineAxis - not animatable
        nullptr, // CSSPropertyID::CSSPropertyViewTimelineInset - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyViewTimelineName - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyViewTransitionClass, &RenderStyle::viewTransitionClasses, &RenderStyle::setViewTransitionClasses), // CSSPropertyID::CSSPropertyViewTransitionClass
        new DiscreteWrapper(CSSPropertyID::CSSPropertyViewTransitionName, &RenderStyle::viewTransitionName, &RenderStyle::setViewTransitionName), // CSSPropertyID::CSSPropertyViewTransitionName
        new VisibilityWrapper(), // CSSPropertyID::CSSPropertyVisibility
        new DiscreteWrapper(CSSPropertyID::CSSPropertyWhiteSpaceCollapse, &RenderStyle::whiteSpaceCollapse, &RenderStyle::setWhiteSpaceCollapse), // CSSPropertyID::CSSPropertyWhiteSpaceCollapse
        new PositiveWrapper<unsigned short>(CSSPropertyID::CSSPropertyWidows, &RenderStyle::widows, &RenderStyle::setWidows), // CSSPropertyID::CSSPropertyWidows
        nullptr, // CSSPropertyID::CSSPropertyWillChange - not animatable
        new DiscreteWrapper(CSSPropertyID::CSSPropertyWordBreak, &RenderStyle::wordBreak, &RenderStyle::setWordBreak), // CSSPropertyID::CSSPropertyWordBreak
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyX, &RenderStyle::x, &RenderStyle::setX), // CSSPropertyID::CSSPropertyX
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyY, &RenderStyle::y, &RenderStyle::setY), // CSSPropertyID::CSSPropertyY
        new AutoWrapper<int>(CSSPropertyID::CSSPropertyZIndex, &RenderStyle::specifiedZIndex, &RenderStyle::setSpecifiedZIndex, &RenderStyle::hasAutoSpecifiedZIndex, &RenderStyle::setHasAutoSpecifiedZIndex), // CSSPropertyID::CSSPropertyZIndex
        new FilterWrapper(CSSPropertyID::CSSPropertyAppleColorFilter, &RenderStyle::appleColorFilter, &RenderStyle::setAppleColorFilter), // CSSPropertyID::CSSPropertyAppleColorFilter
        new FilterWrapper(CSSPropertyID::CSSPropertyWebkitBackdropFilter, &RenderStyle::backdropFilter, &RenderStyle::setBackdropFilter), // CSSPropertyID::CSSPropertyWebkitBackdropFilter
        nullptr, // CSSPropertyID::CSSPropertyWebkitBackgroundClip - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBackgroundOrigin - not animatable (legacy)
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing, &RenderStyle::borderHorizontalSpacing, &RenderStyle::setBorderHorizontalSpacing), // CSSPropertyID::CSSPropertyWebkitBorderHorizontalSpacing
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing, &RenderStyle::borderVerticalSpacing, &RenderStyle::setBorderVerticalSpacing), // CSSPropertyID::CSSPropertyWebkitBorderVerticalSpacing
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxAlign - not animatable (legacy)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak, &RenderStyle::boxDecorationBreak, &RenderStyle::setBoxDecorationBreak), // CSSPropertyID::CSSPropertyWebkitBoxDecorationBreak
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxDirection - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxFlex - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxFlexGroup - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxLines - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxOrdinalGroup - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxOrient - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxPack - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitBoxReflect - not animatable (legacy)
        new ShadowWrapper<BoxShadows>(CSSPropertyID::CSSPropertyWebkitBoxShadow, &RenderStyle::boxShadow, &RenderStyle::setBoxShadow), // CSSPropertyID::CSSPropertyWebkitBoxShadow
        nullptr, // CSSPropertyID::CSSPropertyWebkitColumnAxis - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitColumnProgression - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitCursorVisibility - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitFontSizeDelta - not animatable (internal)
        nullptr, // CSSPropertyID::CSSPropertyWebkitHyphenateLimitAfter - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitHyphenateLimitBefore - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitHyphenateLimitLines - not animatable (legacy)
        new DiscreteWrapper(CSSPropertyID::CSSPropertyWebkitInitialLetter, &RenderStyle::initialLetter, &RenderStyle::setInitialLetter), // CSSPropertyID::CSSPropertyWebkitInitialLetter
        nullptr, // CSSPropertyID::CSSPropertyWebkitLineAlign - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitLineBoxContain - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitLineClamp - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitLineGrid - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitLineSnap - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMarqueeDirection - not animatable (internal)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMarqueeIncrement - not animatable (internal)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMarqueeRepetition - not animatable (internal)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMarqueeSpeed - not animatable (internal)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMarqueeStyle - not animatable (internal)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMaskClip - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitMaskComposite - not animatable (legacy)
        new FillLayersWrapper(CSSPropertyID::CSSPropertyWebkitMaskPositionX, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyWebkitMaskPositionX
        new FillLayersWrapper(CSSPropertyID::CSSPropertyWebkitMaskPositionY, &RenderStyle::maskLayers, &RenderStyle::ensureMaskLayers), // CSSPropertyID::CSSPropertyWebkitMaskPositionY
        nullptr, // CSSPropertyID::CSSPropertyWebkitMaskSourceType - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitNbspMode - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitRtlOrdering - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitRubyPosition - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitTapHighlightColor - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextCombine - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextDecorationsInEffect - not animatable (internal)
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyWebkitTextFillColor, &RenderStyle::textFillColor, &RenderStyle::setTextFillColor, &RenderStyle::visitedLinkTextFillColor, &RenderStyle::setVisitedLinkTextFillColor), // CSSPropertyID::CSSPropertyWebkitTextFillColor
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextSecurity - not animatable (legacy)
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyWebkitTextStrokeColor, &RenderStyle::textStrokeColor, &RenderStyle::setTextStrokeColor, &RenderStyle::visitedLinkTextStrokeColor, &RenderStyle::setVisitedLinkTextStrokeColor), // CSSPropertyID::CSSPropertyWebkitTextStrokeColor
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextStrokeWidth - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitUserDrag - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitUserModify - not animatable (legacy)
        nullptr, // CSSPropertyID::CSSPropertyWebkitUserSelect - not animatable (needs triage)
        new LengthWrapper(CSSPropertyID::CSSPropertyWordSpacing, &RenderStyle::computedWordSpacing, &RenderStyle::setWordSpacing, { LengthWrapper::Flags::IsLengthPercentage }), // CSSPropertyID::CSSPropertyWordSpacing
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyBorderBottomColor, &RenderStyle::borderBottomColor, &RenderStyle::setBorderBottomColor, &RenderStyle::visitedLinkBorderBottomColor, &RenderStyle::setVisitedLinkBorderBottomColor), // CSSPropertyID::CSSPropertyBorderBottomColor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderBottomLeftRadius, &RenderStyle::borderBottomLeftRadius, &RenderStyle::setBorderBottomLeftRadius), // CSSPropertyID::CSSPropertyBorderBottomLeftRadius
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderBottomRightRadius, &RenderStyle::borderBottomRightRadius, &RenderStyle::setBorderBottomRightRadius), // CSSPropertyID::CSSPropertyBorderBottomRightRadius
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBorderBottomStyle, &RenderStyle::borderBottomStyle, &RenderStyle::setBorderBottomStyle), // CSSPropertyID::CSSPropertyBorderBottomStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderBottomWidth, &RenderStyle::borderBottomWidth, &RenderStyle::setBorderBottomWidth), // CSSPropertyID::CSSPropertyBorderBottomWidth
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyBorderLeftColor, &RenderStyle::borderLeftColor, &RenderStyle::setBorderLeftColor, &RenderStyle::visitedLinkBorderLeftColor, &RenderStyle::setVisitedLinkBorderLeftColor), // CSSPropertyID::CSSPropertyBorderLeftColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBorderLeftStyle, &RenderStyle::borderLeftStyle, &RenderStyle::setBorderLeftStyle), // CSSPropertyID::CSSPropertyBorderLeftStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderLeftWidth, &RenderStyle::borderLeftWidth, &RenderStyle::setBorderLeftWidth), // CSSPropertyID::CSSPropertyBorderLeftWidth
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyBorderRightColor, &RenderStyle::borderRightColor, &RenderStyle::setBorderRightColor, &RenderStyle::visitedLinkBorderRightColor, &RenderStyle::setVisitedLinkBorderRightColor), // CSSPropertyID::CSSPropertyBorderRightColor
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBorderRightStyle, &RenderStyle::borderRightStyle, &RenderStyle::setBorderRightStyle), // CSSPropertyID::CSSPropertyBorderRightStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderRightWidth, &RenderStyle::borderRightWidth, &RenderStyle::setBorderRightWidth), // CSSPropertyID::CSSPropertyBorderRightWidth
        new VisitedAffectedStyleTypeWrapper(CSSPropertyID::CSSPropertyBorderTopColor, &RenderStyle::borderTopColor, &RenderStyle::setBorderTopColor, &RenderStyle::visitedLinkBorderTopColor, &RenderStyle::setVisitedLinkBorderTopColor), // CSSPropertyID::CSSPropertyBorderTopColor
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderTopLeftRadius, &RenderStyle::borderTopLeftRadius, &RenderStyle::setBorderTopLeftRadius), // CSSPropertyID::CSSPropertyBorderTopLeftRadius
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderTopRightRadius, &RenderStyle::borderTopRightRadius, &RenderStyle::setBorderTopRightRadius), // CSSPropertyID::CSSPropertyBorderTopRightRadius
        new DiscreteWrapper(CSSPropertyID::CSSPropertyBorderTopStyle, &RenderStyle::borderTopStyle, &RenderStyle::setBorderTopStyle), // CSSPropertyID::CSSPropertyBorderTopStyle
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBorderTopWidth, &RenderStyle::borderTopWidth, &RenderStyle::setBorderTopWidth), // CSSPropertyID::CSSPropertyBorderTopWidth
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyBottom, &RenderStyle::bottom, &RenderStyle::setBottom), // CSSPropertyID::CSSPropertyBottom
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyContainIntrinsicHeight, &RenderStyle::containIntrinsicHeight, &RenderStyle::setContainIntrinsicHeight), // CSSPropertyID::CSSPropertyContainIntrinsicHeight
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyContainIntrinsicWidth, &RenderStyle::containIntrinsicWidth, &RenderStyle::setContainIntrinsicWidth), // CSSPropertyID::CSSPropertyContainIntrinsicWidth
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyCornerBottomLeftShape, &RenderStyle::cornerBottomLeftShape, &RenderStyle::setCornerBottomLeftShape), // CSSPropertyID::CSSPropertyCornerBottomLeftShape
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyCornerBottomRightShape, &RenderStyle::cornerBottomRightShape, &RenderStyle::setCornerBottomRightShape), // CSSPropertyID::CSSPropertyCornerBottomRightShape
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyCornerTopLeftShape, &RenderStyle::cornerTopLeftShape, &RenderStyle::setCornerTopLeftShape), // CSSPropertyID::CSSPropertyCornerTopLeftShape
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyCornerTopRightShape, &RenderStyle::cornerTopRightShape, &RenderStyle::setCornerTopRightShape), // CSSPropertyID::CSSPropertyCornerTopRightShape
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyHeight, &RenderStyle::height, &RenderStyle::setHeight), // CSSPropertyID::CSSPropertyHeight
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyLeft, &RenderStyle::left, &RenderStyle::setLeft), // CSSPropertyID::CSSPropertyLeft
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMarginBottom, &RenderStyle::marginBottom, &RenderStyle::setMarginBottom), // CSSPropertyID::CSSPropertyMarginBottom
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMarginLeft, &RenderStyle::marginLeft, &RenderStyle::setMarginLeft), // CSSPropertyID::CSSPropertyMarginLeft
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMarginRight, &RenderStyle::marginRight, &RenderStyle::setMarginRight), // CSSPropertyID::CSSPropertyMarginRight
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMarginTop, &RenderStyle::marginTop, &RenderStyle::setMarginTop), // CSSPropertyID::CSSPropertyMarginTop
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMaxHeight, &RenderStyle::maxHeight, &RenderStyle::setMaxHeight), // CSSPropertyID::CSSPropertyMaxHeight
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMaxWidth, &RenderStyle::maxWidth, &RenderStyle::setMaxWidth), // CSSPropertyID::CSSPropertyMaxWidth
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMinHeight, &RenderStyle::minHeight, &RenderStyle::setMinHeight), // CSSPropertyID::CSSPropertyMinHeight
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyMinWidth, &RenderStyle::minWidth, &RenderStyle::setMinWidth), // CSSPropertyID::CSSPropertyMinWidth
        new DiscreteWrapper(CSSPropertyID::CSSPropertyOverflowX, &RenderStyle::overflowX, &RenderStyle::setOverflowX), // CSSPropertyID::CSSPropertyOverflowX
        new DiscreteWrapper(CSSPropertyID::CSSPropertyOverflowY, &RenderStyle::overflowY, &RenderStyle::setOverflowY), // CSSPropertyID::CSSPropertyOverflowY
        nullptr, // CSSPropertyID::CSSPropertyOverscrollBehaviorX - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyOverscrollBehaviorY - not animatable (needs triage)
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPaddingBottom, &RenderStyle::paddingBottom, &RenderStyle::setPaddingBottom), // CSSPropertyID::CSSPropertyPaddingBottom
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPaddingLeft, &RenderStyle::paddingLeft, &RenderStyle::setPaddingLeft), // CSSPropertyID::CSSPropertyPaddingLeft
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPaddingRight, &RenderStyle::paddingRight, &RenderStyle::setPaddingRight), // CSSPropertyID::CSSPropertyPaddingRight
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyPaddingTop, &RenderStyle::paddingTop, &RenderStyle::setPaddingTop), // CSSPropertyID::CSSPropertyPaddingTop
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyRight, &RenderStyle::right, &RenderStyle::setRight), // CSSPropertyID::CSSPropertyRight
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginBottom - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginLeft - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginRight - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginTop - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingBottom - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingLeft - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingRight - not animatable (needs triage)
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingTop - not animatable (needs triage)
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyTop, &RenderStyle::top, &RenderStyle::setTop), // CSSPropertyID::CSSPropertyTop
        new StyleTypeWrapper(CSSPropertyID::CSSPropertyWidth, &RenderStyle::width, &RenderStyle::setWidth), // CSSPropertyID::CSSPropertyWidth
        nullptr, // CSSPropertyID::CSSPropertyBlockSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockEndColor - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockEndStyle - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockEndWidth - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockStartColor - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockStartStyle - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockStartWidth - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderEndEndRadius - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderEndStartRadius - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineEndColor - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineEndStyle - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineEndWidth - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineStartColor - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineStartStyle - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineStartWidth - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderStartEndRadius - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyBorderStartStartRadius - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyContainIntrinsicBlockSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyContainIntrinsicInlineSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyCornerEndEndShape - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyCornerEndStartShape - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyCornerStartEndShape - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyCornerStartStartShape - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyInlineSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyInsetBlockEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyInsetBlockStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyInsetInlineEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyInsetInlineStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMarginBlockEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMarginBlockStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMarginInlineEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMarginInlineStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMaxBlockSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMaxInlineSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMinBlockSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyMinInlineSize - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyOverflowBlock - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyOverflowInline - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyOverscrollBehaviorBlock - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyOverscrollBehaviorInline - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyPaddingBlockEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyPaddingBlockStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyPaddingInlineEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyPaddingInlineStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginBlockEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginBlockStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginInlineEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginInlineStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingBlockEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingBlockStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingInlineEnd - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingInlineStart - logical, handled via resolution to physical
        nullptr, // CSSPropertyID::CSSPropertyAll - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyAnimation - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyAnimationRange - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyBackground - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBackgroundPosition - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBlockStep - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorder - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBlock - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockColor - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockEnd - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockStart - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockStyle - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBlockWidth - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderBottom - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderColor - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderImage - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderInline - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineColor - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineEnd - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineStart - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineStyle - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderInlineWidth - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderLeft - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderRadius - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderRight - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderSpacing - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderStyle - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderTop - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyBorderWidth - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyColumnRule - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyColumns - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyContainIntrinsicSize - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyContainer - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyCornerShape - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyFlex - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyFlexFlow - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyFont - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyFontSynthesis - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyFontVariant - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyGap - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyGrid - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyGridArea - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyGridColumn - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyGridRow - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyGridTemplate - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyInset - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyInsetBlock - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyInsetInline - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyLineClamp - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyListStyle - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMargin - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMarginBlock - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMarginInline - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMarker - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMask - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMaskBorder - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyMaskPosition - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyOffset - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyOutline - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyOverflow - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyOverscrollBehavior - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyPadding - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPaddingBlock - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPaddingInline - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPageBreakAfter - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPageBreakBefore - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPageBreakInside - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPerspectiveOrigin - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPlaceContent - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPlaceItems - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPlaceSelf - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyPositionTry - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyScrollMargin - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginBlock - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyScrollMarginInline - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyScrollPadding - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingBlock - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyScrollPaddingInline - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyScrollTimeline - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyTextBox - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyTextDecoration - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyTextDecorationSkip - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyTextEmphasis - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyTextWrap - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyTransformOrigin - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyTransition - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyViewTimeline - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyWhiteSpace - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitBackgroundSize - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitBorderImage - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitBorderRadius - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitColumnBreakAfter - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitColumnBreakBefore - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitColumnBreakInside - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitMask - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitMaskBoxImage - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitMaskPosition - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitPerspective - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextDecoration - shorthand, will perform fix-up below
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextOrientation - not animatable (shorthand, has no animatable longhands)
        nullptr, // CSSPropertyID::CSSPropertyWebkitTextStroke - shorthand, will perform fix-up below
    }
{
    // Build animatable shorthand wrappers from longhand wrappers initialized above.

    m_wrappers[CSSPropertyID::CSSPropertyAll] = makeShorthandWrapper(CSSPropertyID::CSSPropertyAll, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBackground] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBackground, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBackgroundPosition] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBackgroundPosition, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBlockStep] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBlockStep, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorder] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorder, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBlock] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBlock, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBlockColor] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBlockColor, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBlockEnd] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBlockEnd, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBlockStart] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBlockStart, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBlockStyle] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBlockStyle, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBlockWidth] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBlockWidth, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderBottom] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderBottom, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderColor] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderColor, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderImage] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderImage, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderInline] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderInline, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderInlineColor] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderInlineColor, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderInlineEnd] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderInlineEnd, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderInlineStart] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderInlineStart, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderInlineStyle] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderInlineStyle, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderInlineWidth] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderInlineWidth, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderLeft] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderLeft, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderRadius] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderRadius, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderRight] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderRight, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderSpacing] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderSpacing, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderStyle] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderStyle, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderTop] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderTop, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyBorderWidth] = makeShorthandWrapper(CSSPropertyID::CSSPropertyBorderWidth, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyColumnRule] = makeShorthandWrapper(CSSPropertyID::CSSPropertyColumnRule, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyColumns] = makeShorthandWrapper(CSSPropertyID::CSSPropertyColumns, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyContainIntrinsicSize] = makeShorthandWrapper(CSSPropertyID::CSSPropertyContainIntrinsicSize, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyCornerShape] = makeShorthandWrapper(CSSPropertyID::CSSPropertyCornerShape, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyFlex] = makeShorthandWrapper(CSSPropertyID::CSSPropertyFlex, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyFlexFlow] = makeShorthandWrapper(CSSPropertyID::CSSPropertyFlexFlow, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyFont] = makeShorthandWrapper(CSSPropertyID::CSSPropertyFont, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyFontSynthesis] = makeShorthandWrapper(CSSPropertyID::CSSPropertyFontSynthesis, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyFontVariant] = makeShorthandWrapper(CSSPropertyID::CSSPropertyFontVariant, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyGap] = makeShorthandWrapper(CSSPropertyID::CSSPropertyGap, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyGrid] = makeShorthandWrapper(CSSPropertyID::CSSPropertyGrid, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyGridArea] = makeShorthandWrapper(CSSPropertyID::CSSPropertyGridArea, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyGridColumn] = makeShorthandWrapper(CSSPropertyID::CSSPropertyGridColumn, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyGridRow] = makeShorthandWrapper(CSSPropertyID::CSSPropertyGridRow, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyGridTemplate] = makeShorthandWrapper(CSSPropertyID::CSSPropertyGridTemplate, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyInset] = makeShorthandWrapper(CSSPropertyID::CSSPropertyInset, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyInsetBlock] = makeShorthandWrapper(CSSPropertyID::CSSPropertyInsetBlock, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyInsetInline] = makeShorthandWrapper(CSSPropertyID::CSSPropertyInsetInline, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyLineClamp] = makeShorthandWrapper(CSSPropertyID::CSSPropertyLineClamp, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyListStyle] = makeShorthandWrapper(CSSPropertyID::CSSPropertyListStyle, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMargin] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMargin, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMarginBlock] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMarginBlock, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMarginInline] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMarginInline, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMarker] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMarker, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMask] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMask, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMaskBorder] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMaskBorder, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyMaskPosition] = makeShorthandWrapper(CSSPropertyID::CSSPropertyMaskPosition, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyOffset] = makeShorthandWrapper(CSSPropertyID::CSSPropertyOffset, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyOutline] = makeShorthandWrapper(CSSPropertyID::CSSPropertyOutline, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyOverflow] = makeShorthandWrapper(CSSPropertyID::CSSPropertyOverflow, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPadding] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPadding, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPaddingBlock] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPaddingBlock, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPaddingInline] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPaddingInline, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPageBreakAfter] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPageBreakAfter, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPageBreakBefore] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPageBreakBefore, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPageBreakInside] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPageBreakInside, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPerspectiveOrigin] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPerspectiveOrigin, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPlaceContent] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPlaceContent, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPlaceItems] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPlaceItems, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPlaceSelf] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPlaceSelf, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyPositionTry] = makeShorthandWrapper(CSSPropertyID::CSSPropertyPositionTry, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyTextBox] = makeShorthandWrapper(CSSPropertyID::CSSPropertyTextBox, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyTextDecoration] = makeShorthandWrapper(CSSPropertyID::CSSPropertyTextDecoration, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyTextDecorationSkip] = makeShorthandWrapper(CSSPropertyID::CSSPropertyTextDecorationSkip, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyTextEmphasis] = makeShorthandWrapper(CSSPropertyID::CSSPropertyTextEmphasis, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyTextWrap] = makeShorthandWrapper(CSSPropertyID::CSSPropertyTextWrap, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyTransformOrigin] = makeShorthandWrapper(CSSPropertyID::CSSPropertyTransformOrigin, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWhiteSpace] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWhiteSpace, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitBackgroundSize] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitBackgroundSize, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitBorderImage] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitBorderImage, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitBorderRadius] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitBorderRadius, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitColumnBreakAfter] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitColumnBreakAfter, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitColumnBreakBefore] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitColumnBreakBefore, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitColumnBreakInside] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitColumnBreakInside, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitMask] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitMask, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitMaskBoxImage] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitMaskBoxImage, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitMaskPosition] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitMaskPosition, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitPerspective] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitPerspective, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitTextDecoration] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitTextDecoration, m_wrappers);
    m_wrappers[CSSPropertyID::CSSPropertyWebkitTextStroke] = makeShorthandWrapper(CSSPropertyID::CSSPropertyWebkitTextStroke, m_wrappers);
}

} // namespace WebCore
} // namespace Style
} // namespace Interpolation

