/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(WEBGL)

#include "JSWebGLLoseContext.h"

#include "ActiveDOMObject.h"
#include "ContextDestructionObserverInlines.h"
#include "ExtendedDOMClientIsoSubspaces.h"
#include "ExtendedDOMIsoSubspaces.h"
#include "IDLTypes.h"
#include "JSDOMBinding.h"
#include "JSDOMConvertBase.h"
#include "JSDOMExceptionHandling.h"
#include "JSDOMOperation.h"
#include "JSDOMWrapperCache.h"
#include "ScriptExecutionContext.h"
#include "WebCoreJSClientData.h"
#include "WebCoreOpaqueRootInlines.h"
#include <JavaScriptCore/HeapAnalyzer.h>
#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSDestructibleObjectHeapCellType.h>
#include <JavaScriptCore/SlotVisitorMacros.h>
#include <JavaScriptCore/SubspaceInlines.h>
#include <wtf/GetPtr.h>
#include <wtf/PointerPreparations.h>
#include <wtf/URL.h>
#include <wtf/text/MakeString.h>

namespace WebCore {
using namespace JSC;

// Functions

static JSC_DECLARE_HOST_FUNCTION(jsWebGLLoseContextPrototypeFunction_loseContext);
static JSC_DECLARE_HOST_FUNCTION(jsWebGLLoseContextPrototypeFunction_restoreContext);

class JSWebGLLoseContextPrototype final : public JSC::JSNonFinalObject {
public:
    using Base = JSC::JSNonFinalObject;
    static JSWebGLLoseContextPrototype* create(JSC::VM& vm, JSDOMGlobalObject* globalObject, JSC::Structure* structure)
    {
        JSWebGLLoseContextPrototype* ptr = new (NotNull, JSC::allocateCell<JSWebGLLoseContextPrototype>(vm)) JSWebGLLoseContextPrototype(vm, globalObject, structure);
        ptr->finishCreation(vm);
        return ptr;
    }

    DECLARE_INFO;
    template<typename CellType, JSC::SubspaceAccess>
    static JSC::GCClient::IsoSubspace* subspaceFor(JSC::VM& vm)
    {
        STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLLoseContextPrototype, Base);
        return &vm.plainObjectSpace();
    }
    static JSC::Structure* createStructure(JSC::VM& vm, JSC::JSGlobalObject* globalObject, JSC::JSValue prototype)
    {
        return JSC::Structure::create(vm, globalObject, prototype, JSC::TypeInfo(JSC::ObjectType, StructureFlags), info());
    }

private:
    JSWebGLLoseContextPrototype(JSC::VM& vm, JSC::JSGlobalObject*, JSC::Structure* structure)
        : JSC::JSNonFinalObject(vm, structure)
    {
    }

    void finishCreation(JSC::VM&);
};
STATIC_ASSERT_ISO_SUBSPACE_SHARABLE(JSWebGLLoseContextPrototype, JSWebGLLoseContextPrototype::Base);

/* Hash table for prototype */

static const std::array<HashTableValue, 2> JSWebGLLoseContextPrototypeTableValues {
    HashTableValue { "loseContext"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLLoseContextPrototypeFunction_loseContext, 0 } },
    HashTableValue { "restoreContext"_s, static_cast<unsigned>(JSC::PropertyAttribute::Function), NoIntrinsic, { HashTableValue::NativeFunctionType, jsWebGLLoseContextPrototypeFunction_restoreContext, 0 } },
};

const ClassInfo JSWebGLLoseContextPrototype::s_info = { "WebGLLoseContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLLoseContextPrototype) };

void JSWebGLLoseContextPrototype::finishCreation(VM& vm)
{
    Base::finishCreation(vm);
    reifyStaticProperties(vm, JSWebGLLoseContext::info(), JSWebGLLoseContextPrototypeTableValues, *this);
    JSC_TO_STRING_TAG_WITHOUT_TRANSITION();
}

const ClassInfo JSWebGLLoseContext::s_info = { "WebGLLoseContext"_s, &Base::s_info, nullptr, nullptr, CREATE_METHOD_TABLE(JSWebGLLoseContext) };

JSWebGLLoseContext::JSWebGLLoseContext(Structure* structure, JSDOMGlobalObject& globalObject, Ref<WebGLLoseContext>&& impl)
    : JSDOMWrapper<WebGLLoseContext>(structure, globalObject, WTFMove(impl))
{
}

static_assert(!std::is_base_of<ActiveDOMObject, WebGLLoseContext>::value, "Interface is not marked as [ActiveDOMObject] even though implementation class subclasses ActiveDOMObject.");

JSObject* JSWebGLLoseContext::createPrototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    auto* structure = JSWebGLLoseContextPrototype::createStructure(vm, &globalObject, globalObject.objectPrototype());
    structure->setMayBePrototype(true);
    return JSWebGLLoseContextPrototype::create(vm, &globalObject, structure);
}

JSObject* JSWebGLLoseContext::prototype(VM& vm, JSDOMGlobalObject& globalObject)
{
    return getDOMPrototype<JSWebGLLoseContext>(vm, globalObject);
}

void JSWebGLLoseContext::destroy(JSC::JSCell* cell)
{
    JSWebGLLoseContext* thisObject = static_cast<JSWebGLLoseContext*>(cell);
    thisObject->JSWebGLLoseContext::~JSWebGLLoseContext();
}

static inline JSC::EncodedJSValue jsWebGLLoseContextPrototypeFunction_loseContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLLoseContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.loseContext(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLLoseContextPrototypeFunction_loseContext, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLLoseContext>::call<jsWebGLLoseContextPrototypeFunction_loseContextBody>(*lexicalGlobalObject, *callFrame, "loseContext");
}

static inline JSC::EncodedJSValue jsWebGLLoseContextPrototypeFunction_restoreContextBody(JSC::JSGlobalObject* lexicalGlobalObject, JSC::CallFrame* callFrame, typename IDLOperation<JSWebGLLoseContext>::ClassParameter castedThis)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    UNUSED_PARAM(throwScope);
    UNUSED_PARAM(callFrame);
    SUPPRESS_UNCOUNTED_LOCAL auto& impl = castedThis->wrapped();
    RELEASE_AND_RETURN(throwScope, JSValue::encode(toJS<IDLUndefined>(*lexicalGlobalObject, throwScope, [&]() -> decltype(auto) { return impl.restoreContext(); })));
}

JSC_DEFINE_HOST_FUNCTION(jsWebGLLoseContextPrototypeFunction_restoreContext, (JSGlobalObject* lexicalGlobalObject, CallFrame* callFrame))
{
    return IDLOperation<JSWebGLLoseContext>::call<jsWebGLLoseContextPrototypeFunction_restoreContextBody>(*lexicalGlobalObject, *callFrame, "restoreContext");
}

JSC::GCClient::IsoSubspace* JSWebGLLoseContext::subspaceForImpl(JSC::VM& vm)
{
    return WebCore::subspaceForImpl<JSWebGLLoseContext, UseCustomHeapCellType::No>(vm, "JSWebGLLoseContext"_s,
        [] (auto& spaces) { return spaces.m_clientSubspaceForWebGLLoseContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_clientSubspaceForWebGLLoseContext = std::forward<decltype(space)>(space); },
        [] (auto& spaces) { return spaces.m_subspaceForWebGLLoseContext.get(); },
        [] (auto& spaces, auto&& space) { spaces.m_subspaceForWebGLLoseContext = std::forward<decltype(space)>(space); }
    );
}

void JSWebGLLoseContext::analyzeHeap(JSCell* cell, HeapAnalyzer& analyzer)
{
    auto* thisObject = jsCast<JSWebGLLoseContext*>(cell);
    analyzer.setWrappedObjectForCell(cell, &thisObject->wrapped());
    if (RefPtr context = thisObject->scriptExecutionContext())
        analyzer.setLabelForCell(cell, makeString("url "_s, context->url().string()));
    Base::analyzeHeap(cell, analyzer);
}

bool JSWebGLLoseContextOwner::isReachableFromOpaqueRoots(JSC::Handle<JSC::Unknown> handle, void*, AbstractSlotVisitor& visitor, ASCIILiteral* reason)
{
    auto* jsWebGLLoseContext = jsCast<JSWebGLLoseContext*>(handle.slot()->asCell());
    auto& owner = jsWebGLLoseContext->wrapped();
    if (reason) [[unlikely]]
        *reason = "Reachable from jsWebGLLoseContext"_s;
    return containsWebCoreOpaqueRoot(visitor, owner);
}

void JSWebGLLoseContextOwner::finalize(JSC::Handle<JSC::Unknown> handle, void* context)
{
    auto* jsWebGLLoseContext = static_cast<JSWebGLLoseContext*>(handle.slot()->asCell());
    auto& world = *static_cast<DOMWrapperWorld*>(context);
    uncacheWrapper(world, jsWebGLLoseContext->protectedWrapped().ptr(), jsWebGLLoseContext);
}

WTF_ALLOW_UNSAFE_BUFFER_USAGE_BEGIN
#if ENABLE(BINDING_INTEGRITY)
#if PLATFORM(WIN)
#pragma warning(disable: 4483)
extern "C" { extern void (*const __identifier("??_7WebGLLoseContext@WebCore@@6B@")[])(); }
#else
extern "C" { extern void* _ZTVN7WebCore16WebGLLoseContextE[]; }
#endif
template<std::same_as<WebGLLoseContext> T>
static inline void verifyVTable(WebGLLoseContext* ptr) 
{
    if constexpr (std::is_polymorphic_v<T>) {
        const void* actualVTablePointer = getVTablePointer<T>(ptr);
#if PLATFORM(WIN)
        void* expectedVTablePointer = __identifier("??_7WebGLLoseContext@WebCore@@6B@");
#else
        void* expectedVTablePointer = &_ZTVN7WebCore16WebGLLoseContextE[2];
#endif

        // If you hit this assertion you either have a use after free bug, or
        // WebGLLoseContext has subclasses. If WebGLLoseContext has subclasses that get passed
        // to toJS() we currently require WebGLLoseContext you to opt out of binding hardening
        // by adding the SkipVTableValidation attribute to the interface IDL definition
        RELEASE_ASSERT(actualVTablePointer == expectedVTablePointer);
    }
}
#endif
WTF_ALLOW_UNSAFE_BUFFER_USAGE_END

JSC::JSValue toJSNewlyCreated(JSC::JSGlobalObject*, JSDOMGlobalObject* globalObject, Ref<WebGLLoseContext>&& impl)
{
#if ENABLE(BINDING_INTEGRITY)
    verifyVTable<WebGLLoseContext>(impl.ptr());
#endif
    return createWrapper<WebGLLoseContext>(globalObject, WTFMove(impl));
}

JSC::JSValue toJS(JSC::JSGlobalObject* lexicalGlobalObject, JSDOMGlobalObject* globalObject, WebGLLoseContext& impl)
{
    return wrap(lexicalGlobalObject, globalObject, impl);
}

WebGLLoseContext* JSWebGLLoseContext::toWrapped(JSC::VM&, JSC::JSValue value)
{
    if (auto* wrapper = jsDynamicCast<JSWebGLLoseContext*>(value))
        return &wrapper->wrapped();
    return nullptr;
}

}

#endif // ENABLE(WEBGL)
