/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSGPUBlendOperation.h"

#include <JavaScriptCore/JSCInlines.h>
#include <JavaScriptCore/JSString.h>
#include <wtf/NeverDestroyed.h>
#include <wtf/SortedArrayMap.h>



namespace WebCore {
using namespace JSC;

String convertEnumerationToString(GPUBlendOperation enumerationValue)
{
    static const std::array<NeverDestroyed<String>, 5> values {
        MAKE_STATIC_STRING_IMPL("add"),
        MAKE_STATIC_STRING_IMPL("subtract"),
        MAKE_STATIC_STRING_IMPL("reverse-subtract"),
        MAKE_STATIC_STRING_IMPL("min"),
        MAKE_STATIC_STRING_IMPL("max"),
    };
    static_assert(static_cast<size_t>(GPUBlendOperation::Add) == 0, "GPUBlendOperation::Add is not 0 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::Subtract) == 1, "GPUBlendOperation::Subtract is not 1 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::ReverseSubtract) == 2, "GPUBlendOperation::ReverseSubtract is not 2 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::Min) == 3, "GPUBlendOperation::Min is not 3 as expected");
    static_assert(static_cast<size_t>(GPUBlendOperation::Max) == 4, "GPUBlendOperation::Max is not 4 as expected");
    ASSERT(static_cast<size_t>(enumerationValue) < std::size(values));
    return values[static_cast<size_t>(enumerationValue)];
}

template<> JSString* convertEnumerationToJS(VM& vm, GPUBlendOperation enumerationValue)
{
    return jsStringWithCache(vm, convertEnumerationToString(enumerationValue));
}

template<> std::optional<GPUBlendOperation> parseEnumerationFromString<GPUBlendOperation>(const String& stringValue)
{
    static constexpr std::array<std::pair<ComparableASCIILiteral, GPUBlendOperation>, 5> mappings {
        std::pair<ComparableASCIILiteral, GPUBlendOperation> { "add"_s, GPUBlendOperation::Add },
        std::pair<ComparableASCIILiteral, GPUBlendOperation> { "max"_s, GPUBlendOperation::Max },
        std::pair<ComparableASCIILiteral, GPUBlendOperation> { "min"_s, GPUBlendOperation::Min },
        std::pair<ComparableASCIILiteral, GPUBlendOperation> { "reverse-subtract"_s, GPUBlendOperation::ReverseSubtract },
        std::pair<ComparableASCIILiteral, GPUBlendOperation> { "subtract"_s, GPUBlendOperation::Subtract },
    };
    static constexpr SortedArrayMap enumerationMapping { mappings };
    if (auto* enumerationValue = enumerationMapping.tryGet(stringValue); enumerationValue) [[likely]]
        return *enumerationValue;
    return std::nullopt;
}

template<> std::optional<GPUBlendOperation> parseEnumeration<GPUBlendOperation>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    return parseEnumerationFromString<GPUBlendOperation>(value.toWTFString(&lexicalGlobalObject));
}

template<> ASCIILiteral expectedEnumerationValues<GPUBlendOperation>()
{
    return "\"add\", \"subtract\", \"reverse-subtract\", \"min\", \"max\""_s;
}

} // namespace WebCore

