/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSDOMMatrix2DInit.h"

#include "JSDOMConvertNumbers.h"
#include <JavaScriptCore/JSCInlines.h>



namespace WebCore {
using namespace JSC;

template<> ConversionResult<IDLDictionary<DOMMatrix2DInit>> convertDictionary<DOMMatrix2DInit>(JSGlobalObject& lexicalGlobalObject, JSValue value)
{
    SUPPRESS_UNCOUNTED_LOCAL auto& vm = JSC::getVM(&lexicalGlobalObject);
    auto throwScope = DECLARE_THROW_SCOPE(vm);
    bool isNullOrUndefined = value.isUndefinedOrNull();
    auto* object = isNullOrUndefined ? nullptr : value.getObject();
    if (!isNullOrUndefined && !object) [[unlikely]] {
        throwTypeError(&lexicalGlobalObject, throwScope);
        return ConversionResultException { };
    }
    DOMMatrix2DInit result;
    JSValue aValue;
    if (isNullOrUndefined)
        aValue = jsUndefined();
    else {
        aValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "a"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!aValue.isUndefined()) {
        auto aConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, aValue);
        if (aConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.a = aConversionResult.releaseReturnValue();
    }
    JSValue bValue;
    if (isNullOrUndefined)
        bValue = jsUndefined();
    else {
        bValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "b"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!bValue.isUndefined()) {
        auto bConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, bValue);
        if (bConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.b = bConversionResult.releaseReturnValue();
    }
    JSValue cValue;
    if (isNullOrUndefined)
        cValue = jsUndefined();
    else {
        cValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "c"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!cValue.isUndefined()) {
        auto cConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, cValue);
        if (cConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.c = cConversionResult.releaseReturnValue();
    }
    JSValue dValue;
    if (isNullOrUndefined)
        dValue = jsUndefined();
    else {
        dValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "d"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!dValue.isUndefined()) {
        auto dConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, dValue);
        if (dConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.d = dConversionResult.releaseReturnValue();
    }
    JSValue eValue;
    if (isNullOrUndefined)
        eValue = jsUndefined();
    else {
        eValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "e"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!eValue.isUndefined()) {
        auto eConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, eValue);
        if (eConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.e = eConversionResult.releaseReturnValue();
    }
    JSValue fValue;
    if (isNullOrUndefined)
        fValue = jsUndefined();
    else {
        fValue = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "f"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!fValue.isUndefined()) {
        auto fConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, fValue);
        if (fConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.f = fConversionResult.releaseReturnValue();
    }
    JSValue m11Value;
    if (isNullOrUndefined)
        m11Value = jsUndefined();
    else {
        m11Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m11"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m11Value.isUndefined()) {
        auto m11ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m11Value);
        if (m11ConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.m11 = m11ConversionResult.releaseReturnValue();
    }
    JSValue m12Value;
    if (isNullOrUndefined)
        m12Value = jsUndefined();
    else {
        m12Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m12"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m12Value.isUndefined()) {
        auto m12ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m12Value);
        if (m12ConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.m12 = m12ConversionResult.releaseReturnValue();
    }
    JSValue m21Value;
    if (isNullOrUndefined)
        m21Value = jsUndefined();
    else {
        m21Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m21"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m21Value.isUndefined()) {
        auto m21ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m21Value);
        if (m21ConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.m21 = m21ConversionResult.releaseReturnValue();
    }
    JSValue m22Value;
    if (isNullOrUndefined)
        m22Value = jsUndefined();
    else {
        m22Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m22"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m22Value.isUndefined()) {
        auto m22ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m22Value);
        if (m22ConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.m22 = m22ConversionResult.releaseReturnValue();
    }
    JSValue m41Value;
    if (isNullOrUndefined)
        m41Value = jsUndefined();
    else {
        m41Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m41"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m41Value.isUndefined()) {
        auto m41ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m41Value);
        if (m41ConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.m41 = m41ConversionResult.releaseReturnValue();
    }
    JSValue m42Value;
    if (isNullOrUndefined)
        m42Value = jsUndefined();
    else {
        m42Value = object->get(&lexicalGlobalObject, Identifier::fromString(vm, "m42"_s));
        RETURN_IF_EXCEPTION(throwScope, ConversionResultException { });
    }
    if (!m42Value.isUndefined()) {
        auto m42ConversionResult = convert<IDLUnrestrictedDouble>(lexicalGlobalObject, m42Value);
        if (m42ConversionResult.hasException(throwScope)) [[unlikely]]
            return ConversionResultException { };
        result.m42 = m42ConversionResult.releaseReturnValue();
    }
    return result;
}

} // namespace WebCore

