#include <wayland-client-protocol.hpp>

using namespace wayland;
using namespace wayland::detail;

const wl_interface* display_interface_sync_request[1] = {
  &callback_interface,
};

const wl_interface* display_interface_get_registry_request[1] = {
  &registry_interface,
};

const wl_interface* display_interface_error_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* display_interface_delete_id_event[1] = {
  nullptr,
};

const wl_message display_interface_requests[2] = {
  {
    "sync",
    "n",
    display_interface_sync_request,
  },
  {
    "get_registry",
    "n",
    display_interface_get_registry_request,
  },
};

const wl_message display_interface_events[2] = {
  {
    "error",
    "ous",
    display_interface_error_event,
  },
  {
    "delete_id",
    "u",
    display_interface_delete_id_event,
  },
};

const wl_interface wayland::detail::display_interface =
  {
    "wl_display",
    1,
    2,
    display_interface_requests,
    2,
    display_interface_events,
  };

const wl_interface* registry_interface_bind_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* registry_interface_global_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* registry_interface_global_remove_event[1] = {
  nullptr,
};

const wl_message registry_interface_requests[1] = {
  {
    "bind",
    "usun",
    registry_interface_bind_request,
  },
};

const wl_message registry_interface_events[2] = {
  {
    "global",
    "usu",
    registry_interface_global_event,
  },
  {
    "global_remove",
    "u",
    registry_interface_global_remove_event,
  },
};

const wl_interface wayland::detail::registry_interface =
  {
    "wl_registry",
    1,
    1,
    registry_interface_requests,
    2,
    registry_interface_events,
  };

const wl_interface* callback_interface_done_event[1] = {
  nullptr,
};

const wl_message callback_interface_requests[0] = {
};

const wl_message callback_interface_events[1] = {
  {
    "done",
    "u",
    callback_interface_done_event,
  },
};

const wl_interface wayland::detail::callback_interface =
  {
    "wl_callback",
    1,
    0,
    callback_interface_requests,
    1,
    callback_interface_events,
  };

const wl_interface* compositor_interface_create_surface_request[1] = {
  &surface_interface,
};

const wl_interface* compositor_interface_create_region_request[1] = {
  &region_interface,
};

const wl_message compositor_interface_requests[2] = {
  {
    "create_surface",
    "n",
    compositor_interface_create_surface_request,
  },
  {
    "create_region",
    "n",
    compositor_interface_create_region_request,
  },
};

const wl_message compositor_interface_events[0] = {
};

const wl_interface wayland::detail::compositor_interface =
  {
    "wl_compositor",
    5,
    2,
    compositor_interface_requests,
    0,
    compositor_interface_events,
  };

const wl_interface* shm_pool_interface_create_buffer_request[6] = {
  &buffer_interface,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shm_pool_interface_destroy_request[0] = {
};

const wl_interface* shm_pool_interface_resize_request[1] = {
  nullptr,
};

const wl_message shm_pool_interface_requests[3] = {
  {
    "create_buffer",
    "niiiiu",
    shm_pool_interface_create_buffer_request,
  },
  {
    "destroy",
    "",
    shm_pool_interface_destroy_request,
  },
  {
    "resize",
    "i",
    shm_pool_interface_resize_request,
  },
};

const wl_message shm_pool_interface_events[0] = {
};

const wl_interface wayland::detail::shm_pool_interface =
  {
    "wl_shm_pool",
    1,
    3,
    shm_pool_interface_requests,
    0,
    shm_pool_interface_events,
  };

const wl_interface* shm_interface_create_pool_request[3] = {
  &shm_pool_interface,
  nullptr,
  nullptr,
};

const wl_interface* shm_interface_format_event[1] = {
  nullptr,
};

const wl_message shm_interface_requests[1] = {
  {
    "create_pool",
    "nhi",
    shm_interface_create_pool_request,
  },
};

const wl_message shm_interface_events[1] = {
  {
    "format",
    "u",
    shm_interface_format_event,
  },
};

const wl_interface wayland::detail::shm_interface =
  {
    "wl_shm",
    1,
    1,
    shm_interface_requests,
    1,
    shm_interface_events,
  };

const wl_interface* buffer_interface_destroy_request[0] = {
};

const wl_interface* buffer_interface_release_event[0] = {
};

const wl_message buffer_interface_requests[1] = {
  {
    "destroy",
    "",
    buffer_interface_destroy_request,
  },
};

const wl_message buffer_interface_events[1] = {
  {
    "release",
    "",
    buffer_interface_release_event,
  },
};

const wl_interface wayland::detail::buffer_interface =
  {
    "wl_buffer",
    1,
    1,
    buffer_interface_requests,
    1,
    buffer_interface_events,
  };

const wl_interface* data_offer_interface_accept_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_offer_interface_receive_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_offer_interface_destroy_request[0] = {
};

const wl_interface* data_offer_interface_finish_request[0] = {
};

const wl_interface* data_offer_interface_set_actions_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_offer_interface_offer_event[1] = {
  nullptr,
};

const wl_interface* data_offer_interface_source_actions_event[1] = {
  nullptr,
};

const wl_interface* data_offer_interface_action_event[1] = {
  nullptr,
};

const wl_message data_offer_interface_requests[5] = {
  {
    "accept",
    "u?s",
    data_offer_interface_accept_request,
  },
  {
    "receive",
    "sh",
    data_offer_interface_receive_request,
  },
  {
    "destroy",
    "",
    data_offer_interface_destroy_request,
  },
  {
    "finish",
    "3",
    data_offer_interface_finish_request,
  },
  {
    "set_actions",
    "3uu",
    data_offer_interface_set_actions_request,
  },
};

const wl_message data_offer_interface_events[3] = {
  {
    "offer",
    "s",
    data_offer_interface_offer_event,
  },
  {
    "source_actions",
    "3u",
    data_offer_interface_source_actions_event,
  },
  {
    "action",
    "3u",
    data_offer_interface_action_event,
  },
};

const wl_interface wayland::detail::data_offer_interface =
  {
    "wl_data_offer",
    3,
    5,
    data_offer_interface_requests,
    3,
    data_offer_interface_events,
  };

const wl_interface* data_source_interface_offer_request[1] = {
  nullptr,
};

const wl_interface* data_source_interface_destroy_request[0] = {
};

const wl_interface* data_source_interface_set_actions_request[1] = {
  nullptr,
};

const wl_interface* data_source_interface_target_event[1] = {
  nullptr,
};

const wl_interface* data_source_interface_send_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* data_source_interface_cancelled_event[0] = {
};

const wl_interface* data_source_interface_dnd_drop_performed_event[0] = {
};

const wl_interface* data_source_interface_dnd_finished_event[0] = {
};

const wl_interface* data_source_interface_action_event[1] = {
  nullptr,
};

const wl_message data_source_interface_requests[3] = {
  {
    "offer",
    "s",
    data_source_interface_offer_request,
  },
  {
    "destroy",
    "",
    data_source_interface_destroy_request,
  },
  {
    "set_actions",
    "3u",
    data_source_interface_set_actions_request,
  },
};

const wl_message data_source_interface_events[6] = {
  {
    "target",
    "?s",
    data_source_interface_target_event,
  },
  {
    "send",
    "sh",
    data_source_interface_send_event,
  },
  {
    "cancelled",
    "",
    data_source_interface_cancelled_event,
  },
  {
    "dnd_drop_performed",
    "3",
    data_source_interface_dnd_drop_performed_event,
  },
  {
    "dnd_finished",
    "3",
    data_source_interface_dnd_finished_event,
  },
  {
    "action",
    "3u",
    data_source_interface_action_event,
  },
};

const wl_interface wayland::detail::data_source_interface =
  {
    "wl_data_source",
    3,
    3,
    data_source_interface_requests,
    6,
    data_source_interface_events,
  };

const wl_interface* data_device_interface_start_drag_request[4] = {
  &data_source_interface,
  &surface_interface,
  &surface_interface,
  nullptr,
};

const wl_interface* data_device_interface_set_selection_request[2] = {
  &data_source_interface,
  nullptr,
};

const wl_interface* data_device_interface_release_request[0] = {
};

const wl_interface* data_device_interface_data_offer_event[1] = {
  &data_offer_interface,
};

const wl_interface* data_device_interface_enter_event[5] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
  &data_offer_interface,
};

const wl_interface* data_device_interface_leave_event[0] = {
};

const wl_interface* data_device_interface_motion_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* data_device_interface_drop_event[0] = {
};

const wl_interface* data_device_interface_selection_event[1] = {
  &data_offer_interface,
};

const wl_message data_device_interface_requests[3] = {
  {
    "start_drag",
    "?oo?ou",
    data_device_interface_start_drag_request,
  },
  {
    "set_selection",
    "?ou",
    data_device_interface_set_selection_request,
  },
  {
    "release",
    "2",
    data_device_interface_release_request,
  },
};

const wl_message data_device_interface_events[6] = {
  {
    "data_offer",
    "n",
    data_device_interface_data_offer_event,
  },
  {
    "enter",
    "uoff?o",
    data_device_interface_enter_event,
  },
  {
    "leave",
    "",
    data_device_interface_leave_event,
  },
  {
    "motion",
    "uff",
    data_device_interface_motion_event,
  },
  {
    "drop",
    "",
    data_device_interface_drop_event,
  },
  {
    "selection",
    "?o",
    data_device_interface_selection_event,
  },
};

const wl_interface wayland::detail::data_device_interface =
  {
    "wl_data_device",
    3,
    3,
    data_device_interface_requests,
    6,
    data_device_interface_events,
  };

const wl_interface* data_device_manager_interface_create_data_source_request[1] = {
  &data_source_interface,
};

const wl_interface* data_device_manager_interface_get_data_device_request[2] = {
  &data_device_interface,
  &seat_interface,
};

const wl_message data_device_manager_interface_requests[2] = {
  {
    "create_data_source",
    "n",
    data_device_manager_interface_create_data_source_request,
  },
  {
    "get_data_device",
    "no",
    data_device_manager_interface_get_data_device_request,
  },
};

const wl_message data_device_manager_interface_events[0] = {
};

const wl_interface wayland::detail::data_device_manager_interface =
  {
    "wl_data_device_manager",
    3,
    2,
    data_device_manager_interface_requests,
    0,
    data_device_manager_interface_events,
  };

const wl_interface* shell_interface_get_shell_surface_request[2] = {
  &shell_surface_interface,
  &surface_interface,
};

const wl_message shell_interface_requests[1] = {
  {
    "get_shell_surface",
    "no",
    shell_interface_get_shell_surface_request,
  },
};

const wl_message shell_interface_events[0] = {
};

const wl_interface wayland::detail::shell_interface =
  {
    "wl_shell",
    1,
    1,
    shell_interface_requests,
    0,
    shell_interface_events,
  };

const wl_interface* shell_surface_interface_pong_request[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_move_request[2] = {
  &seat_interface,
  nullptr,
};

const wl_interface* shell_surface_interface_resize_request[3] = {
  &seat_interface,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_set_toplevel_request[0] = {
};

const wl_interface* shell_surface_interface_set_transient_request[4] = {
  &surface_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_set_fullscreen_request[3] = {
  nullptr,
  nullptr,
  &output_interface,
};

const wl_interface* shell_surface_interface_set_popup_request[6] = {
  &seat_interface,
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_set_maximized_request[1] = {
  &output_interface,
};

const wl_interface* shell_surface_interface_set_title_request[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_set_class_request[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_ping_event[1] = {
  nullptr,
};

const wl_interface* shell_surface_interface_configure_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* shell_surface_interface_popup_done_event[0] = {
};

const wl_message shell_surface_interface_requests[10] = {
  {
    "pong",
    "u",
    shell_surface_interface_pong_request,
  },
  {
    "move",
    "ou",
    shell_surface_interface_move_request,
  },
  {
    "resize",
    "ouu",
    shell_surface_interface_resize_request,
  },
  {
    "set_toplevel",
    "",
    shell_surface_interface_set_toplevel_request,
  },
  {
    "set_transient",
    "oiiu",
    shell_surface_interface_set_transient_request,
  },
  {
    "set_fullscreen",
    "uu?o",
    shell_surface_interface_set_fullscreen_request,
  },
  {
    "set_popup",
    "ouoiiu",
    shell_surface_interface_set_popup_request,
  },
  {
    "set_maximized",
    "?o",
    shell_surface_interface_set_maximized_request,
  },
  {
    "set_title",
    "s",
    shell_surface_interface_set_title_request,
  },
  {
    "set_class",
    "s",
    shell_surface_interface_set_class_request,
  },
};

const wl_message shell_surface_interface_events[3] = {
  {
    "ping",
    "u",
    shell_surface_interface_ping_event,
  },
  {
    "configure",
    "uii",
    shell_surface_interface_configure_event,
  },
  {
    "popup_done",
    "",
    shell_surface_interface_popup_done_event,
  },
};

const wl_interface wayland::detail::shell_surface_interface =
  {
    "wl_shell_surface",
    1,
    10,
    shell_surface_interface_requests,
    3,
    shell_surface_interface_events,
  };

const wl_interface* surface_interface_destroy_request[0] = {
};

const wl_interface* surface_interface_attach_request[3] = {
  &buffer_interface,
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_damage_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_frame_request[1] = {
  &callback_interface,
};

const wl_interface* surface_interface_set_opaque_region_request[1] = {
  &region_interface,
};

const wl_interface* surface_interface_set_input_region_request[1] = {
  &region_interface,
};

const wl_interface* surface_interface_commit_request[0] = {
};

const wl_interface* surface_interface_set_buffer_transform_request[1] = {
  nullptr,
};

const wl_interface* surface_interface_set_buffer_scale_request[1] = {
  nullptr,
};

const wl_interface* surface_interface_damage_buffer_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_offset_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* surface_interface_enter_event[1] = {
  &output_interface,
};

const wl_interface* surface_interface_leave_event[1] = {
  &output_interface,
};

const wl_message surface_interface_requests[11] = {
  {
    "destroy",
    "",
    surface_interface_destroy_request,
  },
  {
    "attach",
    "?oii",
    surface_interface_attach_request,
  },
  {
    "damage",
    "iiii",
    surface_interface_damage_request,
  },
  {
    "frame",
    "n",
    surface_interface_frame_request,
  },
  {
    "set_opaque_region",
    "?o",
    surface_interface_set_opaque_region_request,
  },
  {
    "set_input_region",
    "?o",
    surface_interface_set_input_region_request,
  },
  {
    "commit",
    "",
    surface_interface_commit_request,
  },
  {
    "set_buffer_transform",
    "2i",
    surface_interface_set_buffer_transform_request,
  },
  {
    "set_buffer_scale",
    "3i",
    surface_interface_set_buffer_scale_request,
  },
  {
    "damage_buffer",
    "4iiii",
    surface_interface_damage_buffer_request,
  },
  {
    "offset",
    "5ii",
    surface_interface_offset_request,
  },
};

const wl_message surface_interface_events[2] = {
  {
    "enter",
    "o",
    surface_interface_enter_event,
  },
  {
    "leave",
    "o",
    surface_interface_leave_event,
  },
};

const wl_interface wayland::detail::surface_interface =
  {
    "wl_surface",
    5,
    11,
    surface_interface_requests,
    2,
    surface_interface_events,
  };

const wl_interface* seat_interface_get_pointer_request[1] = {
  &pointer_interface,
};

const wl_interface* seat_interface_get_keyboard_request[1] = {
  &keyboard_interface,
};

const wl_interface* seat_interface_get_touch_request[1] = {
  &touch_interface,
};

const wl_interface* seat_interface_release_request[0] = {
};

const wl_interface* seat_interface_capabilities_event[1] = {
  nullptr,
};

const wl_interface* seat_interface_name_event[1] = {
  nullptr,
};

const wl_message seat_interface_requests[4] = {
  {
    "get_pointer",
    "n",
    seat_interface_get_pointer_request,
  },
  {
    "get_keyboard",
    "n",
    seat_interface_get_keyboard_request,
  },
  {
    "get_touch",
    "n",
    seat_interface_get_touch_request,
  },
  {
    "release",
    "5",
    seat_interface_release_request,
  },
};

const wl_message seat_interface_events[2] = {
  {
    "capabilities",
    "u",
    seat_interface_capabilities_event,
  },
  {
    "name",
    "2s",
    seat_interface_name_event,
  },
};

const wl_interface wayland::detail::seat_interface =
  {
    "wl_seat",
    8,
    4,
    seat_interface_requests,
    2,
    seat_interface_events,
  };

const wl_interface* pointer_interface_set_cursor_request[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_release_request[0] = {
};

const wl_interface* pointer_interface_enter_event[4] = {
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_leave_event[2] = {
  nullptr,
  &surface_interface,
};

const wl_interface* pointer_interface_motion_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_button_event[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_axis_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_frame_event[0] = {
};

const wl_interface* pointer_interface_axis_source_event[1] = {
  nullptr,
};

const wl_interface* pointer_interface_axis_stop_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_axis_discrete_event[2] = {
  nullptr,
  nullptr,
};

const wl_interface* pointer_interface_axis_value120_event[2] = {
  nullptr,
  nullptr,
};

const wl_message pointer_interface_requests[2] = {
  {
    "set_cursor",
    "u?oii",
    pointer_interface_set_cursor_request,
  },
  {
    "release",
    "3",
    pointer_interface_release_request,
  },
};

const wl_message pointer_interface_events[10] = {
  {
    "enter",
    "uoff",
    pointer_interface_enter_event,
  },
  {
    "leave",
    "uo",
    pointer_interface_leave_event,
  },
  {
    "motion",
    "uff",
    pointer_interface_motion_event,
  },
  {
    "button",
    "uuuu",
    pointer_interface_button_event,
  },
  {
    "axis",
    "uuf",
    pointer_interface_axis_event,
  },
  {
    "frame",
    "5",
    pointer_interface_frame_event,
  },
  {
    "axis_source",
    "5u",
    pointer_interface_axis_source_event,
  },
  {
    "axis_stop",
    "5uu",
    pointer_interface_axis_stop_event,
  },
  {
    "axis_discrete",
    "5ui",
    pointer_interface_axis_discrete_event,
  },
  {
    "axis_value120",
    "8ui",
    pointer_interface_axis_value120_event,
  },
};

const wl_interface wayland::detail::pointer_interface =
  {
    "wl_pointer",
    8,
    2,
    pointer_interface_requests,
    10,
    pointer_interface_events,
  };

const wl_interface* keyboard_interface_release_request[0] = {
};

const wl_interface* keyboard_interface_keymap_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* keyboard_interface_enter_event[3] = {
  nullptr,
  &surface_interface,
  nullptr,
};

const wl_interface* keyboard_interface_leave_event[2] = {
  nullptr,
  &surface_interface,
};

const wl_interface* keyboard_interface_key_event[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* keyboard_interface_modifiers_event[5] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* keyboard_interface_repeat_info_event[2] = {
  nullptr,
  nullptr,
};

const wl_message keyboard_interface_requests[1] = {
  {
    "release",
    "3",
    keyboard_interface_release_request,
  },
};

const wl_message keyboard_interface_events[6] = {
  {
    "keymap",
    "uhu",
    keyboard_interface_keymap_event,
  },
  {
    "enter",
    "uoa",
    keyboard_interface_enter_event,
  },
  {
    "leave",
    "uo",
    keyboard_interface_leave_event,
  },
  {
    "key",
    "uuuu",
    keyboard_interface_key_event,
  },
  {
    "modifiers",
    "uuuuu",
    keyboard_interface_modifiers_event,
  },
  {
    "repeat_info",
    "4ii",
    keyboard_interface_repeat_info_event,
  },
};

const wl_interface wayland::detail::keyboard_interface =
  {
    "wl_keyboard",
    8,
    1,
    keyboard_interface_requests,
    6,
    keyboard_interface_events,
  };

const wl_interface* touch_interface_release_request[0] = {
};

const wl_interface* touch_interface_down_event[6] = {
  nullptr,
  nullptr,
  &surface_interface,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_up_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_motion_event[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_frame_event[0] = {
};

const wl_interface* touch_interface_cancel_event[0] = {
};

const wl_interface* touch_interface_shape_event[3] = {
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* touch_interface_orientation_event[2] = {
  nullptr,
  nullptr,
};

const wl_message touch_interface_requests[1] = {
  {
    "release",
    "3",
    touch_interface_release_request,
  },
};

const wl_message touch_interface_events[7] = {
  {
    "down",
    "uuoiff",
    touch_interface_down_event,
  },
  {
    "up",
    "uui",
    touch_interface_up_event,
  },
  {
    "motion",
    "uiff",
    touch_interface_motion_event,
  },
  {
    "frame",
    "",
    touch_interface_frame_event,
  },
  {
    "cancel",
    "",
    touch_interface_cancel_event,
  },
  {
    "shape",
    "6iff",
    touch_interface_shape_event,
  },
  {
    "orientation",
    "6if",
    touch_interface_orientation_event,
  },
};

const wl_interface wayland::detail::touch_interface =
  {
    "wl_touch",
    8,
    1,
    touch_interface_requests,
    7,
    touch_interface_events,
  };

const wl_interface* output_interface_release_request[0] = {
};

const wl_interface* output_interface_geometry_event[8] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* output_interface_mode_event[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* output_interface_done_event[0] = {
};

const wl_interface* output_interface_scale_event[1] = {
  nullptr,
};

const wl_interface* output_interface_name_event[1] = {
  nullptr,
};

const wl_interface* output_interface_description_event[1] = {
  nullptr,
};

const wl_message output_interface_requests[1] = {
  {
    "release",
    "3",
    output_interface_release_request,
  },
};

const wl_message output_interface_events[6] = {
  {
    "geometry",
    "iiiiissi",
    output_interface_geometry_event,
  },
  {
    "mode",
    "uiii",
    output_interface_mode_event,
  },
  {
    "done",
    "2",
    output_interface_done_event,
  },
  {
    "scale",
    "2i",
    output_interface_scale_event,
  },
  {
    "name",
    "4s",
    output_interface_name_event,
  },
  {
    "description",
    "4s",
    output_interface_description_event,
  },
};

const wl_interface wayland::detail::output_interface =
  {
    "wl_output",
    4,
    1,
    output_interface_requests,
    6,
    output_interface_events,
  };

const wl_interface* region_interface_destroy_request[0] = {
};

const wl_interface* region_interface_add_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_interface* region_interface_subtract_request[4] = {
  nullptr,
  nullptr,
  nullptr,
  nullptr,
};

const wl_message region_interface_requests[3] = {
  {
    "destroy",
    "",
    region_interface_destroy_request,
  },
  {
    "add",
    "iiii",
    region_interface_add_request,
  },
  {
    "subtract",
    "iiii",
    region_interface_subtract_request,
  },
};

const wl_message region_interface_events[0] = {
};

const wl_interface wayland::detail::region_interface =
  {
    "wl_region",
    1,
    3,
    region_interface_requests,
    0,
    region_interface_events,
  };

const wl_interface* subcompositor_interface_destroy_request[0] = {
};

const wl_interface* subcompositor_interface_get_subsurface_request[3] = {
  &subsurface_interface,
  &surface_interface,
  &surface_interface,
};

const wl_message subcompositor_interface_requests[2] = {
  {
    "destroy",
    "",
    subcompositor_interface_destroy_request,
  },
  {
    "get_subsurface",
    "noo",
    subcompositor_interface_get_subsurface_request,
  },
};

const wl_message subcompositor_interface_events[0] = {
};

const wl_interface wayland::detail::subcompositor_interface =
  {
    "wl_subcompositor",
    1,
    2,
    subcompositor_interface_requests,
    0,
    subcompositor_interface_events,
  };

const wl_interface* subsurface_interface_destroy_request[0] = {
};

const wl_interface* subsurface_interface_set_position_request[2] = {
  nullptr,
  nullptr,
};

const wl_interface* subsurface_interface_place_above_request[1] = {
  &surface_interface,
};

const wl_interface* subsurface_interface_place_below_request[1] = {
  &surface_interface,
};

const wl_interface* subsurface_interface_set_sync_request[0] = {
};

const wl_interface* subsurface_interface_set_desync_request[0] = {
};

const wl_message subsurface_interface_requests[6] = {
  {
    "destroy",
    "",
    subsurface_interface_destroy_request,
  },
  {
    "set_position",
    "ii",
    subsurface_interface_set_position_request,
  },
  {
    "place_above",
    "o",
    subsurface_interface_place_above_request,
  },
  {
    "place_below",
    "o",
    subsurface_interface_place_below_request,
  },
  {
    "set_sync",
    "",
    subsurface_interface_set_sync_request,
  },
  {
    "set_desync",
    "",
    subsurface_interface_set_desync_request,
  },
};

const wl_message subsurface_interface_events[0] = {
};

const wl_interface wayland::detail::subsurface_interface =
  {
    "wl_subsurface",
    1,
    6,
    subsurface_interface_requests,
    0,
    subsurface_interface_events,
  };

registry_t::registry_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&registry_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return registry_t(p); });
}

registry_t::registry_t()
{
  set_interface(&registry_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return registry_t(p); });
}

registry_t::registry_t(wl_registry *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&registry_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return registry_t(p); });
}

registry_t::registry_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&registry_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return registry_t(p); });
}

registry_t registry_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string registry_t::interface_name = "wl_registry";

registry_t::operator wl_registry*() const
{
  return reinterpret_cast<wl_registry*> (c_ptr());
}

proxy_t registry_t::bind(uint32_t name, proxy_t &interface, uint32_t version)
{
  proxy_t p = marshal_constructor_versioned(0U, interface.interface, version, name, std::string(interface.interface->name), version, nullptr);
  interface = interface.copy_constructor(p);
  return interface;
}


std::function<void(uint32_t, std::string, uint32_t)> &registry_t::on_global()
{
  return std::static_pointer_cast<events_t>(get_events())->global;
}

std::function<void(uint32_t)> &registry_t::on_global_remove()
{
  return std::static_pointer_cast<events_t>(get_events())->global_remove;
}

int registry_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->global) events->global(args[0].get<uint32_t>(), args[1].get<std::string>(), args[2].get<uint32_t>());
      break;
    case 1:
      if(events->global_remove) events->global_remove(args[0].get<uint32_t>());
      break;
    }
  return 0;
}

callback_t::callback_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&callback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return callback_t(p); });
}

callback_t::callback_t()
{
  set_interface(&callback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return callback_t(p); });
}

callback_t::callback_t(wl_callback *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&callback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return callback_t(p); });
}

callback_t::callback_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&callback_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return callback_t(p); });
}

callback_t callback_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string callback_t::interface_name = "wl_callback";

callback_t::operator wl_callback*() const
{
  return reinterpret_cast<wl_callback*> (c_ptr());
}

std::function<void(uint32_t)> &callback_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

int callback_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->done) events->done(args[0].get<uint32_t>());
      break;
    }
  return 0;
}

compositor_t::compositor_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&compositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return compositor_t(p); });
}

compositor_t::compositor_t()
{
  set_interface(&compositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return compositor_t(p); });
}

compositor_t::compositor_t(wl_compositor *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&compositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return compositor_t(p); });
}

compositor_t::compositor_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&compositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return compositor_t(p); });
}

compositor_t compositor_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string compositor_t::interface_name = "wl_compositor";

compositor_t::operator wl_compositor*() const
{
  return reinterpret_cast<wl_compositor*> (c_ptr());
}

surface_t compositor_t::create_surface()
{
  proxy_t p = marshal_constructor(0U, &surface_interface, nullptr);
  return surface_t(p);
}


region_t compositor_t::create_region()
{
  proxy_t p = marshal_constructor(1U, &region_interface, nullptr);
  return region_t(p);
}


int compositor_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

shm_pool_t::shm_pool_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&shm_pool_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_pool_t(p); });
}

shm_pool_t::shm_pool_t()
{
  set_interface(&shm_pool_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_pool_t(p); });
}

shm_pool_t::shm_pool_t(wl_shm_pool *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&shm_pool_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_pool_t(p); });
}

shm_pool_t::shm_pool_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&shm_pool_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_pool_t(p); });
}

shm_pool_t shm_pool_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string shm_pool_t::interface_name = "wl_shm_pool";

shm_pool_t::operator wl_shm_pool*() const
{
  return reinterpret_cast<wl_shm_pool*> (c_ptr());
}

buffer_t shm_pool_t::create_buffer(int32_t offset, int32_t width, int32_t height, int32_t stride, shm_format const& format)
{
  proxy_t p = marshal_constructor(0U, &buffer_interface, nullptr, offset, width, height, stride, static_cast<uint32_t>(format));
  return buffer_t(p);
}


void shm_pool_t::resize(int32_t size)
{
  marshal(2U, size);
}


int shm_pool_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

shm_t::shm_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&shm_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_t(p); });
}

shm_t::shm_t()
{
  set_interface(&shm_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_t(p); });
}

shm_t::shm_t(wl_shm *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&shm_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_t(p); });
}

shm_t::shm_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&shm_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shm_t(p); });
}

shm_t shm_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string shm_t::interface_name = "wl_shm";

shm_t::operator wl_shm*() const
{
  return reinterpret_cast<wl_shm*> (c_ptr());
}

shm_pool_t shm_t::create_pool(int fd, int32_t size)
{
  proxy_t p = marshal_constructor(0U, &shm_pool_interface, nullptr, argument_t::fd(fd), size);
  return shm_pool_t(p);
}


std::function<void(shm_format)> &shm_t::on_format()
{
  return std::static_pointer_cast<events_t>(get_events())->format;
}

int shm_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->format) events->format(shm_format(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}



buffer_t::buffer_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&buffer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return buffer_t(p); });
}

buffer_t::buffer_t()
{
  set_interface(&buffer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return buffer_t(p); });
}

buffer_t::buffer_t(wl_buffer *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&buffer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return buffer_t(p); });
}

buffer_t::buffer_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&buffer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return buffer_t(p); });
}

buffer_t buffer_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string buffer_t::interface_name = "wl_buffer";

buffer_t::operator wl_buffer*() const
{
  return reinterpret_cast<wl_buffer*> (c_ptr());
}

std::function<void()> &buffer_t::on_release()
{
  return std::static_pointer_cast<events_t>(get_events())->release;
}

int buffer_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->release) events->release();
      break;
    }
  return 0;
}

data_offer_t::data_offer_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(2U);
    }
  set_interface(&data_offer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_offer_t(p); });
}

data_offer_t::data_offer_t()
{
  set_interface(&data_offer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_offer_t(p); });
}

data_offer_t::data_offer_t(wl_data_offer *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(2U);
    }
  set_interface(&data_offer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_offer_t(p); });
}

data_offer_t::data_offer_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&data_offer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_offer_t(p); });
}

data_offer_t data_offer_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string data_offer_t::interface_name = "wl_data_offer";

data_offer_t::operator wl_data_offer*() const
{
  return reinterpret_cast<wl_data_offer*> (c_ptr());
}

void data_offer_t::accept(uint32_t serial, std::string const& mime_type)
{
  marshal(0U, serial, mime_type);
}


void data_offer_t::receive(std::string const& mime_type, int fd)
{
  marshal(1U, mime_type, argument_t::fd(fd));
}


void data_offer_t::finish()
{
  marshal(3U);
}

bool data_offer_t::can_finish() const
{
  return (get_version() >= finish_since_version);
}


void data_offer_t::set_actions(data_device_manager_dnd_action const& dnd_actions, data_device_manager_dnd_action const& preferred_action)
{
  marshal(4U, static_cast<uint32_t>(dnd_actions), static_cast<uint32_t>(preferred_action));
}

bool data_offer_t::can_set_actions() const
{
  return (get_version() >= set_actions_since_version);
}


std::function<void(std::string)> &data_offer_t::on_offer()
{
  return std::static_pointer_cast<events_t>(get_events())->offer;
}

std::function<void(data_device_manager_dnd_action)> &data_offer_t::on_source_actions()
{
  return std::static_pointer_cast<events_t>(get_events())->source_actions;
}

std::function<void(data_device_manager_dnd_action)> &data_offer_t::on_action()
{
  return std::static_pointer_cast<events_t>(get_events())->action;
}

int data_offer_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->offer) events->offer(args[0].get<std::string>());
      break;
    case 1:
      if(events->source_actions) events->source_actions(data_device_manager_dnd_action(args[0].get<uint32_t>()));
      break;
    case 2:
      if(events->action) events->action(data_device_manager_dnd_action(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}


data_source_t::data_source_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&data_source_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_source_t(p); });
}

data_source_t::data_source_t()
{
  set_interface(&data_source_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_source_t(p); });
}

data_source_t::data_source_t(wl_data_source *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(1U);
    }
  set_interface(&data_source_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_source_t(p); });
}

data_source_t::data_source_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&data_source_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_source_t(p); });
}

data_source_t data_source_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string data_source_t::interface_name = "wl_data_source";

data_source_t::operator wl_data_source*() const
{
  return reinterpret_cast<wl_data_source*> (c_ptr());
}

void data_source_t::offer(std::string const& mime_type)
{
  marshal(0U, mime_type);
}


void data_source_t::set_actions(data_device_manager_dnd_action const& dnd_actions)
{
  marshal(2U, static_cast<uint32_t>(dnd_actions));
}

bool data_source_t::can_set_actions() const
{
  return (get_version() >= set_actions_since_version);
}


std::function<void(std::string)> &data_source_t::on_target()
{
  return std::static_pointer_cast<events_t>(get_events())->target;
}

std::function<void(std::string, int)> &data_source_t::on_send()
{
  return std::static_pointer_cast<events_t>(get_events())->send;
}

std::function<void()> &data_source_t::on_cancelled()
{
  return std::static_pointer_cast<events_t>(get_events())->cancelled;
}

std::function<void()> &data_source_t::on_dnd_drop_performed()
{
  return std::static_pointer_cast<events_t>(get_events())->dnd_drop_performed;
}

std::function<void()> &data_source_t::on_dnd_finished()
{
  return std::static_pointer_cast<events_t>(get_events())->dnd_finished;
}

std::function<void(data_device_manager_dnd_action)> &data_source_t::on_action()
{
  return std::static_pointer_cast<events_t>(get_events())->action;
}

int data_source_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->target) events->target(args[0].get<std::string>());
      break;
    case 1:
      if(events->send) events->send(args[0].get<std::string>(), args[1].get<int>());
      break;
    case 2:
      if(events->cancelled) events->cancelled();
      break;
    case 3:
      if(events->dnd_drop_performed) events->dnd_drop_performed();
      break;
    case 4:
      if(events->dnd_finished) events->dnd_finished();
      break;
    case 5:
      if(events->action) events->action(data_device_manager_dnd_action(args[0].get<uint32_t>()));
      break;
    }
  return 0;
}


data_device_t::data_device_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&data_device_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_t(p); });
}

data_device_t::data_device_t()
{
  set_interface(&data_device_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_t(p); });
}

data_device_t::data_device_t(wl_data_device *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&data_device_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_t(p); });
}

data_device_t::data_device_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&data_device_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_t(p); });
}

data_device_t data_device_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string data_device_t::interface_name = "wl_data_device";

data_device_t::operator wl_data_device*() const
{
  return reinterpret_cast<wl_data_device*> (c_ptr());
}

void data_device_t::start_drag(data_source_t const& source, surface_t const& origin, surface_t const& icon, uint32_t serial)
{
  marshal(0U, source.proxy_has_object() ? reinterpret_cast<wl_object*>(source.c_ptr()) : nullptr, origin.proxy_has_object() ? reinterpret_cast<wl_object*>(origin.c_ptr()) : nullptr, icon.proxy_has_object() ? reinterpret_cast<wl_object*>(icon.c_ptr()) : nullptr, serial);
}


void data_device_t::set_selection(data_source_t const& source, uint32_t serial)
{
  marshal(1U, source.proxy_has_object() ? reinterpret_cast<wl_object*>(source.c_ptr()) : nullptr, serial);
}


void data_device_t::release()
{
  marshal(2U);
}

bool data_device_t::can_release() const
{
  return (get_version() >= release_since_version);
}


std::function<void(data_offer_t)> &data_device_t::on_data_offer()
{
  return std::static_pointer_cast<events_t>(get_events())->data_offer;
}

std::function<void(uint32_t, surface_t, double, double, data_offer_t)> &data_device_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void()> &data_device_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

std::function<void(uint32_t, double, double)> &data_device_t::on_motion()
{
  return std::static_pointer_cast<events_t>(get_events())->motion;
}

std::function<void()> &data_device_t::on_drop()
{
  return std::static_pointer_cast<events_t>(get_events())->drop;
}

std::function<void(data_offer_t)> &data_device_t::on_selection()
{
  return std::static_pointer_cast<events_t>(get_events())->selection;
}

int data_device_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->data_offer) events->data_offer(data_offer_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->enter) events->enter(args[0].get<uint32_t>(), surface_t(args[1].get<proxy_t>()), args[2].get<double>(), args[3].get<double>(), data_offer_t(args[4].get<proxy_t>()));
      break;
    case 2:
      if(events->leave) events->leave();
      break;
    case 3:
      if(events->motion) events->motion(args[0].get<uint32_t>(), args[1].get<double>(), args[2].get<double>());
      break;
    case 4:
      if(events->drop) events->drop();
      break;
    case 5:
      if(events->selection) events->selection(data_offer_t(args[0].get<proxy_t>()));
      break;
    }
  return 0;
}


data_device_manager_t::data_device_manager_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&data_device_manager_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_manager_t(p); });
}

data_device_manager_t::data_device_manager_t()
{
  set_interface(&data_device_manager_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_manager_t(p); });
}

data_device_manager_t::data_device_manager_t(wl_data_device_manager *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&data_device_manager_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_manager_t(p); });
}

data_device_manager_t::data_device_manager_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&data_device_manager_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return data_device_manager_t(p); });
}

data_device_manager_t data_device_manager_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string data_device_manager_t::interface_name = "wl_data_device_manager";

data_device_manager_t::operator wl_data_device_manager*() const
{
  return reinterpret_cast<wl_data_device_manager*> (c_ptr());
}

data_source_t data_device_manager_t::create_data_source()
{
  proxy_t p = marshal_constructor(0U, &data_source_interface, nullptr);
  return data_source_t(p);
}


data_device_t data_device_manager_t::get_data_device(seat_t const& seat)
{
  proxy_t p = marshal_constructor(1U, &data_device_interface, nullptr, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr);
  return data_device_t(p);
}


int data_device_manager_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}
const bitfield<3, 6> data_device_manager_dnd_action::none{0};
const bitfield<3, 6> data_device_manager_dnd_action::copy{1};
const bitfield<3, 6> data_device_manager_dnd_action::move{2};
const bitfield<3, 6> data_device_manager_dnd_action::ask{4};


shell_t::shell_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&shell_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_t(p); });
}

shell_t::shell_t()
{
  set_interface(&shell_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_t(p); });
}

shell_t::shell_t(wl_shell *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&shell_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_t(p); });
}

shell_t::shell_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&shell_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_t(p); });
}

shell_t shell_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string shell_t::interface_name = "wl_shell";

shell_t::operator wl_shell*() const
{
  return reinterpret_cast<wl_shell*> (c_ptr());
}

shell_surface_t shell_t::get_shell_surface(surface_t const& surface)
{
  proxy_t p = marshal_constructor(0U, &shell_surface_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr);
  return shell_surface_t(p);
}


int shell_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


shell_surface_t::shell_surface_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&shell_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_surface_t(p); });
}

shell_surface_t::shell_surface_t()
{
  set_interface(&shell_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_surface_t(p); });
}

shell_surface_t::shell_surface_t(wl_shell_surface *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&shell_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_surface_t(p); });
}

shell_surface_t::shell_surface_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&shell_surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return shell_surface_t(p); });
}

shell_surface_t shell_surface_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string shell_surface_t::interface_name = "wl_shell_surface";

shell_surface_t::operator wl_shell_surface*() const
{
  return reinterpret_cast<wl_shell_surface*> (c_ptr());
}

void shell_surface_t::pong(uint32_t serial)
{
  marshal(0U, serial);
}


void shell_surface_t::move(seat_t const& seat, uint32_t serial)
{
  marshal(1U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial);
}


void shell_surface_t::resize(seat_t const& seat, uint32_t serial, shell_surface_resize const& edges)
{
  marshal(2U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial, static_cast<uint32_t>(edges));
}


void shell_surface_t::set_toplevel()
{
  marshal(3U);
}


void shell_surface_t::set_transient(surface_t const& parent, int32_t x, int32_t y, shell_surface_transient const& flags)
{
  marshal(4U, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr, x, y, static_cast<uint32_t>(flags));
}


void shell_surface_t::set_fullscreen(shell_surface_fullscreen_method const& method, uint32_t framerate, output_t const& output)
{
  marshal(5U, static_cast<uint32_t>(method), framerate, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}


void shell_surface_t::set_popup(seat_t const& seat, uint32_t serial, surface_t const& parent, int32_t x, int32_t y, shell_surface_transient const& flags)
{
  marshal(6U, seat.proxy_has_object() ? reinterpret_cast<wl_object*>(seat.c_ptr()) : nullptr, serial, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr, x, y, static_cast<uint32_t>(flags));
}


void shell_surface_t::set_maximized(output_t const& output)
{
  marshal(7U, output.proxy_has_object() ? reinterpret_cast<wl_object*>(output.c_ptr()) : nullptr);
}


void shell_surface_t::set_title(std::string const& title)
{
  marshal(8U, title);
}


void shell_surface_t::set_class(std::string const& class_)
{
  marshal(9U, class_);
}


std::function<void(uint32_t)> &shell_surface_t::on_ping()
{
  return std::static_pointer_cast<events_t>(get_events())->ping;
}

std::function<void(shell_surface_resize, int32_t, int32_t)> &shell_surface_t::on_configure()
{
  return std::static_pointer_cast<events_t>(get_events())->configure;
}

std::function<void()> &shell_surface_t::on_popup_done()
{
  return std::static_pointer_cast<events_t>(get_events())->popup_done;
}

int shell_surface_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->ping) events->ping(args[0].get<uint32_t>());
      break;
    case 1:
      if(events->configure) events->configure(shell_surface_resize(args[0].get<uint32_t>()), args[1].get<int32_t>(), args[2].get<int32_t>());
      break;
    case 2:
      if(events->popup_done) events->popup_done();
      break;
    }
  return 0;
}
const bitfield<4, 8> shell_surface_resize::none{0};
const bitfield<4, 8> shell_surface_resize::top{1};
const bitfield<4, 8> shell_surface_resize::bottom{2};
const bitfield<4, 8> shell_surface_resize::left{4};
const bitfield<4, 8> shell_surface_resize::top_left{5};
const bitfield<4, 8> shell_surface_resize::bottom_left{6};
const bitfield<4, 8> shell_surface_resize::right{8};
const bitfield<4, 8> shell_surface_resize::top_right{9};
const bitfield<4, 8> shell_surface_resize::bottom_right{10};

const bitfield<1, 9> shell_surface_transient::inactive{0x1};



surface_t::surface_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return surface_t(p); });
}

surface_t::surface_t()
{
  set_interface(&surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return surface_t(p); });
}

surface_t::surface_t(wl_surface *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return surface_t(p); });
}

surface_t::surface_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&surface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return surface_t(p); });
}

surface_t surface_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string surface_t::interface_name = "wl_surface";

surface_t::operator wl_surface*() const
{
  return reinterpret_cast<wl_surface*> (c_ptr());
}

void surface_t::attach(buffer_t const& buffer, int32_t x, int32_t y)
{
  marshal(1U, buffer.proxy_has_object() ? reinterpret_cast<wl_object*>(buffer.c_ptr()) : nullptr, x, y);
}


void surface_t::damage(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(2U, x, y, width, height);
}


callback_t surface_t::frame()
{
  proxy_t p = marshal_constructor(3U, &callback_interface, nullptr);
  return callback_t(p);
}


void surface_t::set_opaque_region(region_t const& region)
{
  marshal(4U, region.proxy_has_object() ? reinterpret_cast<wl_object*>(region.c_ptr()) : nullptr);
}


void surface_t::set_input_region(region_t const& region)
{
  marshal(5U, region.proxy_has_object() ? reinterpret_cast<wl_object*>(region.c_ptr()) : nullptr);
}


void surface_t::commit()
{
  marshal(6U);
}


void surface_t::set_buffer_transform(output_transform const& transform)
{
  marshal(7U, static_cast<int32_t>(transform));
}

bool surface_t::can_set_buffer_transform() const
{
  return (get_version() >= set_buffer_transform_since_version);
}


void surface_t::set_buffer_scale(int32_t scale)
{
  marshal(8U, scale);
}

bool surface_t::can_set_buffer_scale() const
{
  return (get_version() >= set_buffer_scale_since_version);
}


void surface_t::damage_buffer(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(9U, x, y, width, height);
}

bool surface_t::can_damage_buffer() const
{
  return (get_version() >= damage_buffer_since_version);
}


void surface_t::offset(int32_t x, int32_t y)
{
  marshal(10U, x, y);
}

bool surface_t::can_offset() const
{
  return (get_version() >= offset_since_version);
}


std::function<void(output_t)> &surface_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void(output_t)> &surface_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

int surface_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->enter) events->enter(output_t(args[0].get<proxy_t>()));
      break;
    case 1:
      if(events->leave) events->leave(output_t(args[0].get<proxy_t>()));
      break;
    }
  return 0;
}


seat_t::seat_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&seat_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return seat_t(p); });
}

seat_t::seat_t()
{
  set_interface(&seat_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return seat_t(p); });
}

seat_t::seat_t(wl_seat *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&seat_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return seat_t(p); });
}

seat_t::seat_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&seat_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return seat_t(p); });
}

seat_t seat_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string seat_t::interface_name = "wl_seat";

seat_t::operator wl_seat*() const
{
  return reinterpret_cast<wl_seat*> (c_ptr());
}

pointer_t seat_t::get_pointer()
{
  proxy_t p = marshal_constructor(0U, &pointer_interface, nullptr);
  return pointer_t(p);
}


keyboard_t seat_t::get_keyboard()
{
  proxy_t p = marshal_constructor(1U, &keyboard_interface, nullptr);
  return keyboard_t(p);
}


touch_t seat_t::get_touch()
{
  proxy_t p = marshal_constructor(2U, &touch_interface, nullptr);
  return touch_t(p);
}


void seat_t::release()
{
  marshal(3U);
}

bool seat_t::can_release() const
{
  return (get_version() >= release_since_version);
}


std::function<void(seat_capability)> &seat_t::on_capabilities()
{
  return std::static_pointer_cast<events_t>(get_events())->capabilities;
}

std::function<void(std::string)> &seat_t::on_name()
{
  return std::static_pointer_cast<events_t>(get_events())->name;
}

int seat_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->capabilities) events->capabilities(seat_capability(args[0].get<uint32_t>()));
      break;
    case 1:
      if(events->name) events->name(args[0].get<std::string>());
      break;
    }
  return 0;
}
const bitfield<3, 12> seat_capability::pointer{1};
const bitfield<3, 12> seat_capability::keyboard{2};
const bitfield<3, 12> seat_capability::touch{4};



pointer_t::pointer_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&pointer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return pointer_t(p); });
}

pointer_t::pointer_t()
{
  set_interface(&pointer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return pointer_t(p); });
}

pointer_t::pointer_t(wl_pointer *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&pointer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return pointer_t(p); });
}

pointer_t::pointer_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&pointer_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return pointer_t(p); });
}

pointer_t pointer_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string pointer_t::interface_name = "wl_pointer";

pointer_t::operator wl_pointer*() const
{
  return reinterpret_cast<wl_pointer*> (c_ptr());
}

void pointer_t::set_cursor(uint32_t serial, surface_t const& surface, int32_t hotspot_x, int32_t hotspot_y)
{
  marshal(0U, serial, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, hotspot_x, hotspot_y);
}


void pointer_t::release()
{
  marshal(1U);
}

bool pointer_t::can_release() const
{
  return (get_version() >= release_since_version);
}


std::function<void(uint32_t, surface_t, double, double)> &pointer_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void(uint32_t, surface_t)> &pointer_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

std::function<void(uint32_t, double, double)> &pointer_t::on_motion()
{
  return std::static_pointer_cast<events_t>(get_events())->motion;
}

std::function<void(uint32_t, uint32_t, uint32_t, pointer_button_state)> &pointer_t::on_button()
{
  return std::static_pointer_cast<events_t>(get_events())->button;
}

std::function<void(uint32_t, pointer_axis, double)> &pointer_t::on_axis()
{
  return std::static_pointer_cast<events_t>(get_events())->axis;
}

std::function<void()> &pointer_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}

std::function<void(pointer_axis_source)> &pointer_t::on_axis_source()
{
  return std::static_pointer_cast<events_t>(get_events())->axis_source;
}

std::function<void(uint32_t, pointer_axis)> &pointer_t::on_axis_stop()
{
  return std::static_pointer_cast<events_t>(get_events())->axis_stop;
}

std::function<void(pointer_axis, int32_t)> &pointer_t::on_axis_discrete()
{
  return std::static_pointer_cast<events_t>(get_events())->axis_discrete;
}

std::function<void(pointer_axis, int32_t)> &pointer_t::on_axis_value120()
{
  return std::static_pointer_cast<events_t>(get_events())->axis_value120;
}

int pointer_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->enter) events->enter(args[0].get<uint32_t>(), surface_t(args[1].get<proxy_t>()), args[2].get<double>(), args[3].get<double>());
      break;
    case 1:
      if(events->leave) events->leave(args[0].get<uint32_t>(), surface_t(args[1].get<proxy_t>()));
      break;
    case 2:
      if(events->motion) events->motion(args[0].get<uint32_t>(), args[1].get<double>(), args[2].get<double>());
      break;
    case 3:
      if(events->button) events->button(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), pointer_button_state(args[3].get<uint32_t>()));
      break;
    case 4:
      if(events->axis) events->axis(args[0].get<uint32_t>(), pointer_axis(args[1].get<uint32_t>()), args[2].get<double>());
      break;
    case 5:
      if(events->frame) events->frame();
      break;
    case 6:
      if(events->axis_source) events->axis_source(pointer_axis_source(args[0].get<uint32_t>()));
      break;
    case 7:
      if(events->axis_stop) events->axis_stop(args[0].get<uint32_t>(), pointer_axis(args[1].get<uint32_t>()));
      break;
    case 8:
      if(events->axis_discrete) events->axis_discrete(pointer_axis(args[0].get<uint32_t>()), args[1].get<int32_t>());
      break;
    case 9:
      if(events->axis_value120) events->axis_value120(pointer_axis(args[0].get<uint32_t>()), args[1].get<int32_t>());
      break;
    }
  return 0;
}





keyboard_t::keyboard_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&keyboard_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return keyboard_t(p); });
}

keyboard_t::keyboard_t()
{
  set_interface(&keyboard_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return keyboard_t(p); });
}

keyboard_t::keyboard_t(wl_keyboard *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&keyboard_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return keyboard_t(p); });
}

keyboard_t::keyboard_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&keyboard_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return keyboard_t(p); });
}

keyboard_t keyboard_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string keyboard_t::interface_name = "wl_keyboard";

keyboard_t::operator wl_keyboard*() const
{
  return reinterpret_cast<wl_keyboard*> (c_ptr());
}

void keyboard_t::release()
{
  marshal(0U);
}

bool keyboard_t::can_release() const
{
  return (get_version() >= release_since_version);
}


std::function<void(keyboard_keymap_format, int, uint32_t)> &keyboard_t::on_keymap()
{
  return std::static_pointer_cast<events_t>(get_events())->keymap;
}

std::function<void(uint32_t, surface_t, array_t)> &keyboard_t::on_enter()
{
  return std::static_pointer_cast<events_t>(get_events())->enter;
}

std::function<void(uint32_t, surface_t)> &keyboard_t::on_leave()
{
  return std::static_pointer_cast<events_t>(get_events())->leave;
}

std::function<void(uint32_t, uint32_t, uint32_t, keyboard_key_state)> &keyboard_t::on_key()
{
  return std::static_pointer_cast<events_t>(get_events())->key;
}

std::function<void(uint32_t, uint32_t, uint32_t, uint32_t, uint32_t)> &keyboard_t::on_modifiers()
{
  return std::static_pointer_cast<events_t>(get_events())->modifiers;
}

std::function<void(int32_t, int32_t)> &keyboard_t::on_repeat_info()
{
  return std::static_pointer_cast<events_t>(get_events())->repeat_info;
}

int keyboard_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->keymap) events->keymap(keyboard_keymap_format(args[0].get<uint32_t>()), args[1].get<int>(), args[2].get<uint32_t>());
      break;
    case 1:
      if(events->enter) events->enter(args[0].get<uint32_t>(), surface_t(args[1].get<proxy_t>()), args[2].get<array_t>());
      break;
    case 2:
      if(events->leave) events->leave(args[0].get<uint32_t>(), surface_t(args[1].get<proxy_t>()));
      break;
    case 3:
      if(events->key) events->key(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), keyboard_key_state(args[3].get<uint32_t>()));
      break;
    case 4:
      if(events->modifiers) events->modifiers(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<uint32_t>(), args[3].get<uint32_t>(), args[4].get<uint32_t>());
      break;
    case 5:
      if(events->repeat_info) events->repeat_info(args[0].get<int32_t>(), args[1].get<int32_t>());
      break;
    }
  return 0;
}



touch_t::touch_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&touch_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return touch_t(p); });
}

touch_t::touch_t()
{
  set_interface(&touch_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return touch_t(p); });
}

touch_t::touch_t(wl_touch *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&touch_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return touch_t(p); });
}

touch_t::touch_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&touch_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return touch_t(p); });
}

touch_t touch_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string touch_t::interface_name = "wl_touch";

touch_t::operator wl_touch*() const
{
  return reinterpret_cast<wl_touch*> (c_ptr());
}

void touch_t::release()
{
  marshal(0U);
}

bool touch_t::can_release() const
{
  return (get_version() >= release_since_version);
}


std::function<void(uint32_t, uint32_t, surface_t, int32_t, double, double)> &touch_t::on_down()
{
  return std::static_pointer_cast<events_t>(get_events())->down;
}

std::function<void(uint32_t, uint32_t, int32_t)> &touch_t::on_up()
{
  return std::static_pointer_cast<events_t>(get_events())->up;
}

std::function<void(uint32_t, int32_t, double, double)> &touch_t::on_motion()
{
  return std::static_pointer_cast<events_t>(get_events())->motion;
}

std::function<void()> &touch_t::on_frame()
{
  return std::static_pointer_cast<events_t>(get_events())->frame;
}

std::function<void()> &touch_t::on_cancel()
{
  return std::static_pointer_cast<events_t>(get_events())->cancel;
}

std::function<void(int32_t, double, double)> &touch_t::on_shape()
{
  return std::static_pointer_cast<events_t>(get_events())->shape;
}

std::function<void(int32_t, double)> &touch_t::on_orientation()
{
  return std::static_pointer_cast<events_t>(get_events())->orientation;
}

int touch_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->down) events->down(args[0].get<uint32_t>(), args[1].get<uint32_t>(), surface_t(args[2].get<proxy_t>()), args[3].get<int32_t>(), args[4].get<double>(), args[5].get<double>());
      break;
    case 1:
      if(events->up) events->up(args[0].get<uint32_t>(), args[1].get<uint32_t>(), args[2].get<int32_t>());
      break;
    case 2:
      if(events->motion) events->motion(args[0].get<uint32_t>(), args[1].get<int32_t>(), args[2].get<double>(), args[3].get<double>());
      break;
    case 3:
      if(events->frame) events->frame();
      break;
    case 4:
      if(events->cancel) events->cancel();
      break;
    case 5:
      if(events->shape) events->shape(args[0].get<int32_t>(), args[1].get<double>(), args[2].get<double>());
      break;
    case 6:
      if(events->orientation) events->orientation(args[0].get<int32_t>(), args[1].get<double>());
      break;
    }
  return 0;
}

output_t::output_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&output_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return output_t(p); });
}

output_t::output_t()
{
  set_interface(&output_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return output_t(p); });
}

output_t::output_t(wl_output *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
    }
  set_interface(&output_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return output_t(p); });
}

output_t::output_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&output_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return output_t(p); });
}

output_t output_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string output_t::interface_name = "wl_output";

output_t::operator wl_output*() const
{
  return reinterpret_cast<wl_output*> (c_ptr());
}

void output_t::release()
{
  marshal(0U);
}

bool output_t::can_release() const
{
  return (get_version() >= release_since_version);
}


std::function<void(int32_t, int32_t, int32_t, int32_t, output_subpixel, std::string, std::string, output_transform)> &output_t::on_geometry()
{
  return std::static_pointer_cast<events_t>(get_events())->geometry;
}

std::function<void(output_mode, int32_t, int32_t, int32_t)> &output_t::on_mode()
{
  return std::static_pointer_cast<events_t>(get_events())->mode;
}

std::function<void()> &output_t::on_done()
{
  return std::static_pointer_cast<events_t>(get_events())->done;
}

std::function<void(int32_t)> &output_t::on_scale()
{
  return std::static_pointer_cast<events_t>(get_events())->scale;
}

std::function<void(std::string)> &output_t::on_name()
{
  return std::static_pointer_cast<events_t>(get_events())->name;
}

std::function<void(std::string)> &output_t::on_description()
{
  return std::static_pointer_cast<events_t>(get_events())->description;
}

int output_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  std::shared_ptr<events_t> events = std::static_pointer_cast<events_t>(e);
  switch(opcode)
    {
    case 0:
      if(events->geometry) events->geometry(args[0].get<int32_t>(), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>(), output_subpixel(args[4].get<int32_t>()), args[5].get<std::string>(), args[6].get<std::string>(), output_transform(args[7].get<int32_t>()));
      break;
    case 1:
      if(events->mode) events->mode(output_mode(args[0].get<uint32_t>()), args[1].get<int32_t>(), args[2].get<int32_t>(), args[3].get<int32_t>());
      break;
    case 2:
      if(events->done) events->done();
      break;
    case 3:
      if(events->scale) events->scale(args[0].get<int32_t>());
      break;
    case 4:
      if(events->name) events->name(args[0].get<std::string>());
      break;
    case 5:
      if(events->description) events->description(args[0].get<std::string>());
      break;
    }
  return 0;
}

const bitfield<3, 21> output_transform::normal{0};
const bitfield<3, 21> output_transform::_90{1};
const bitfield<3, 21> output_transform::_180{2};
const bitfield<3, 21> output_transform::_270{3};
const bitfield<3, 21> output_transform::flipped{4};
const bitfield<3, 21> output_transform::flipped_90{5};
const bitfield<3, 21> output_transform::flipped_180{6};
const bitfield<3, 21> output_transform::flipped_270{7};

const bitfield<2, 22> output_mode::current{0x1};
const bitfield<2, 22> output_mode::preferred{0x2};


region_t::region_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&region_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return region_t(p); });
}

region_t::region_t()
{
  set_interface(&region_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return region_t(p); });
}

region_t::region_t(wl_region *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&region_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return region_t(p); });
}

region_t::region_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&region_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return region_t(p); });
}

region_t region_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string region_t::interface_name = "wl_region";

region_t::operator wl_region*() const
{
  return reinterpret_cast<wl_region*> (c_ptr());
}

void region_t::add(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(1U, x, y, width, height);
}


void region_t::subtract(int32_t x, int32_t y, int32_t width, int32_t height)
{
  marshal(2U, x, y, width, height);
}


int region_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}

subcompositor_t::subcompositor_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&subcompositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subcompositor_t(p); });
}

subcompositor_t::subcompositor_t()
{
  set_interface(&subcompositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subcompositor_t(p); });
}

subcompositor_t::subcompositor_t(wl_subcompositor *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&subcompositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subcompositor_t(p); });
}

subcompositor_t::subcompositor_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&subcompositor_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subcompositor_t(p); });
}

subcompositor_t subcompositor_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string subcompositor_t::interface_name = "wl_subcompositor";

subcompositor_t::operator wl_subcompositor*() const
{
  return reinterpret_cast<wl_subcompositor*> (c_ptr());
}

subsurface_t subcompositor_t::get_subsurface(surface_t const& surface, surface_t const& parent)
{
  proxy_t p = marshal_constructor(1U, &subsurface_interface, nullptr, surface.proxy_has_object() ? reinterpret_cast<wl_object*>(surface.c_ptr()) : nullptr, parent.proxy_has_object() ? reinterpret_cast<wl_object*>(parent.c_ptr()) : nullptr);
  return subsurface_t(p);
}


int subcompositor_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}


subsurface_t::subsurface_t(const proxy_t &p)
  : proxy_t(p)
{
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&subsurface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subsurface_t(p); });
}

subsurface_t::subsurface_t()
{
  set_interface(&subsurface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subsurface_t(p); });
}

subsurface_t::subsurface_t(wl_subsurface *p, wrapper_type t)
  : proxy_t(reinterpret_cast<wl_proxy*> (p), t){
  if(proxy_has_object() && get_wrapper_type() == wrapper_type::standard)
    {
      set_events(std::shared_ptr<detail::events_base_t>(new events_t), dispatcher);
      set_destroy_opcode(0U);
    }
  set_interface(&subsurface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subsurface_t(p); });
}

subsurface_t::subsurface_t(proxy_t const &wrapped_proxy, construct_proxy_wrapper_tag /*unused*/)
  : proxy_t(wrapped_proxy, construct_proxy_wrapper_tag()){
  set_interface(&subsurface_interface);
  set_copy_constructor([] (const proxy_t &p) -> proxy_t
    { return subsurface_t(p); });
}

subsurface_t subsurface_t::proxy_create_wrapper()
{
  return {*this, construct_proxy_wrapper_tag()};
}

const std::string subsurface_t::interface_name = "wl_subsurface";

subsurface_t::operator wl_subsurface*() const
{
  return reinterpret_cast<wl_subsurface*> (c_ptr());
}

void subsurface_t::set_position(int32_t x, int32_t y)
{
  marshal(1U, x, y);
}


void subsurface_t::place_above(surface_t const& sibling)
{
  marshal(2U, sibling.proxy_has_object() ? reinterpret_cast<wl_object*>(sibling.c_ptr()) : nullptr);
}


void subsurface_t::place_below(surface_t const& sibling)
{
  marshal(3U, sibling.proxy_has_object() ? reinterpret_cast<wl_object*>(sibling.c_ptr()) : nullptr);
}


void subsurface_t::set_sync()
{
  marshal(4U);
}


void subsurface_t::set_desync()
{
  marshal(5U);
}


int subsurface_t::dispatcher(uint32_t opcode, const std::vector<any>& args, const std::shared_ptr<detail::events_base_t>& e)
{
  return 0;
}



