// java wrapper for vtkDendrogramItem object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkDendrogramItem.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkContextItem_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkDendrogramItem_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkDendrogramItem",dType)) { return me; }
  if ((res= vtkContextItem_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDendrogramItem_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDendrogramItem_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDendrogramItem_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDendrogramItem_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetTree_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTree * temp0;
  temp0 = static_cast<vtkTree*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTree(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDendrogramItem_GetTree_15(JNIEnv* env, jobject obj)
{
  vtkTree * temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTree();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_CollapseToNumberOfLeafNodes_16(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->CollapseToNumberOfLeafNodes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkDendrogramItem_GetPrunedTree_17(JNIEnv* env, jobject obj)
{
  vtkTree * temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPrunedTree();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetColorArray_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorArray(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetExtendLeafNodes_19(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExtendLeafNodes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDendrogramItem_GetExtendLeafNodes_110(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExtendLeafNodes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_ExtendLeafNodesOn_111(JNIEnv* env, jobject obj)
{

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExtendLeafNodesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_ExtendLeafNodesOff_112(JNIEnv* env, jobject obj)
{

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->ExtendLeafNodesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetOrientation_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientation(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkDendrogramItem_GetOrientation_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientation();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDendrogramItem_GetAngleForOrientation_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAngleForOrientation(temp0);
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDendrogramItem_GetTextAngleForOrientation_116(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  double   temp20;
  temp0 = id0;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextAngleForOrientation(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetDrawLabels_117(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDrawLabels(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDendrogramItem_GetDrawLabels_118(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDrawLabels();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_DrawLabelsOn_119(JNIEnv* env, jobject obj)
{

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawLabelsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_DrawLabelsOff_120(JNIEnv* env, jobject obj)
{

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->DrawLabelsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetPosition_121(JNIEnv* env, jobject obj,jfloat id0,jfloat id1)
{
  float   temp0;
  float   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetPosition_122(JNIEnv* env, jobject obj,jfloatArray id0)
{
  float temp0[2];
  env->GetFloatArrayRegion(id0, 0, 2, &temp0[0]);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);

}

extern "C" JNIEXPORT jfloatArray  JNICALL Java_vtk_vtkDendrogramItem_GetPosition_123(JNIEnv* env, jobject obj)
{
  float * temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPosition();
  return vtkJavaMakeJArrayOfFloat(env, temp20, 2);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkDendrogramItem_GetLeafSpacing_124(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLeafSpacing();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetLeafSpacing_125(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLeafSpacing(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_PrepareToPaint_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrepareToPaint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_GetBounds_127(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[4];
  env->GetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 4, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_ComputeLabelWidth_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeLabelWidth(temp0);

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkDendrogramItem_GetLabelWidth_129(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabelWidth();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDendrogramItem_GetPositionOfVertex_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  std::string temp0;
  double temp1[2];
  bool   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 2, &temp1[0]);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPositionOfVertex(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDendrogramItem_Paint_131(JNIEnv* env, jobject obj,jobject id0)
{
  vtkContext2D * temp0;
  bool   temp20;
  temp0 = static_cast<vtkContext2D*>(vtkJavaGetPointerFromObject(env, id0));

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Paint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jfloat  JNICALL Java_vtk_vtkDendrogramItem_GetLineWidth_132(JNIEnv* env, jobject obj)
{
  float   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLineWidth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetLineWidth_133(JNIEnv* env, jobject obj,jfloat id0)
{
  float   temp0;
  temp0 = id0;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLineWidth(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetDisplayNumberOfCollapsedLeafNodes_134(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDisplayNumberOfCollapsedLeafNodes(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkDendrogramItem_GetDisplayNumberOfCollapsedLeafNodes_135(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDisplayNumberOfCollapsedLeafNodes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_DisplayNumberOfCollapsedLeafNodesOn_136(JNIEnv* env, jobject obj)
{

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayNumberOfCollapsedLeafNodesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_DisplayNumberOfCollapsedLeafNodesOff_137(JNIEnv* env, jobject obj)
{

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->DisplayNumberOfCollapsedLeafNodesOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDendrogramItem_GetDistanceArrayName_138(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDistanceArrayName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetDistanceArrayName_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDistanceArrayName(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkDendrogramItem_GetVertexNameArrayName_140(JNIEnv* env, jobject obj)
{
  vtkStdString   temp20;

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVertexNameArrayName();
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkDendrogramItem_SetVertexNameArrayName_141(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  vtkStdString   temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkDendrogramItem* op = static_cast<vtkDendrogramItem*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVertexNameArrayName(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkDendrogramItem_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkDendrogramItem::New());
}
