// java wrapper for vtkMultiVolume object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMultiVolume.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkVolume_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMultiVolume_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMultiVolume",dType)) { return me; }
  if ((res= vtkVolume_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMultiVolume_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMultiVolume_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMultiVolume_SetVolume_14(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkVolume * temp0;
  int   temp1;
  temp0 = static_cast<vtkVolume*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVolume(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetVolume_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkVolume * temp20;
  temp0 = id0;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVolume(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMultiVolume_RemoveVolume_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveVolume(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMultiVolume_SetProperty_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkVolumeProperty * temp0;
  temp0 = static_cast<vtkVolumeProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetProperty_18(JNIEnv* env, jobject obj)
{
  vtkVolumeProperty * temp20;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetMTime_19(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMultiVolume_ShallowCopy_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkProp * temp0;
  temp0 = static_cast<vtkProp*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetMatrix_111(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetTextureMatrix_112(JNIEnv* env, jobject obj)
{
  vtkMatrix4x4 * temp20;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureMatrix();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMultiVolume_GetBoundsTime_113(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundsTime();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMultiVolume_RenderVolumetricGeometry_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderVolumetricGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMultiVolume_GetMatrix_115(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMatrix4x4 * temp0;
  temp0 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id0));

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMultiVolume_GetMatrix_116(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[16];
  env->GetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

  vtkMultiVolume* op = static_cast<vtkMultiVolume*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetMatrix(temp0);
  env->SetDoubleArrayRegion(id0, 0, 16, &temp0[0]);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMultiVolume_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMultiVolume::New());
}
