// java wrapper for vtkOpenXRModel object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenXRModel.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkVRModel_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenXRModel_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenXRModel",dType)) { return me; }
  if ((res= vtkVRModel_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenXRModel_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRModel* op = static_cast<vtkOpenXRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenXRModel_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRModel* op = static_cast<vtkOpenXRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenXRModel_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRModel* op = static_cast<vtkOpenXRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenXRModel_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenXRModel* op = static_cast<vtkOpenXRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenXRModel_SetAssetPath_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkOpenXRModel* op = static_cast<vtkOpenXRModel*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssetPath(temp0);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenXRModel_GetAssetPath_15(JNIEnv* env, jobject obj)
{
  const std::string * temp20;

  vtkOpenXRModel* op = static_cast<vtkOpenXRModel*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetAssetPath();
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenXRModel_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenXRModel::New());
}
