// java wrapper for vtkLabelHierarchy object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLabelHierarchy.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLabelHierarchy_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLabelHierarchy",dType)) { return me; }
  if ((res= vtkPointSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabelHierarchy_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabelHierarchy_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetPoints_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPoints * temp0;
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_ComputeHierarchy_15(JNIEnv* env, jobject obj)
{

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeHierarchy();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetTargetLabelCount_16(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTargetLabelCount(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabelHierarchy_GetTargetLabelCount_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTargetLabelCount();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetMaximumDepth_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMaximumDepth(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabelHierarchy_GetMaximumDepth_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaximumDepth();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetTextProperty_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkTextProperty * temp0;
  temp0 = static_cast<vtkTextProperty*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextProperty(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetTextProperty_111(JNIEnv* env, jobject obj)
{
  vtkTextProperty * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetPriorities_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPriorities(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetPriorities_113(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPriorities();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetLabels_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractArray * temp0;
  temp0 = static_cast<vtkAbstractArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLabels(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetLabels_115(JNIEnv* env, jobject obj)
{
  vtkAbstractArray * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLabels();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetOrientations_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrientations(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetOrientations_117(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrientations();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetIconIndices_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIntArray * temp0;
  temp0 = static_cast<vtkIntArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetIconIndices(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetIconIndices_119(JNIEnv* env, jobject obj)
{
  vtkIntArray * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetIconIndices();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetSizes_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSizes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetSizes_121(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSizes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_SetBoundedSizes_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBoundedSizes(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetBoundedSizes_123(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBoundedSizes();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_NewIterator_124(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2,jdoubleArray id3,jboolean id4,jfloatArray id5)
{
  int   temp0;
  vtkRenderer * temp1;
  vtkCamera * temp2;
  double temp3[24];
  bool   temp4;
  float temp5[2];
  vtkLabelHierarchyIterator * temp20;
  temp0 = id0;
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCamera*>(vtkJavaGetPointerFromObject(env, id2));
  env->GetDoubleArrayRegion(id3, 0, 24, &temp3[0]);
  temp4 = (id4 != 0) ? true : false;
  env->GetFloatArrayRegion(id5, 0, 2, &temp5[0]);

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NewIterator(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetDoubleArrayRegion(id3, 0, 24, &temp3[0]);
  env->SetFloatArrayRegion(id5, 0, 2, &temp5[0]);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_GetDiscreteNodeCoordinatesFromWorldPoint_125(JNIEnv* env, jobject obj,jintArray id0,jdoubleArray id1,jint id2)
{
  int temp0[3];
  double temp1[3];
  int   temp2;
  env->GetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetDiscreteNodeCoordinatesFromWorldPoint(temp0,temp1,temp2);
  env->SetIntArrayRegion(id0, 0, 3, reinterpret_cast<jint*>(&temp0[0]));
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetNumberOfCells_126(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetCell_127(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_GetCell_128(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabelHierarchy_GetCellType_129(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_GetCellPoints_130(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_GetPointCells_131(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLabelHierarchy_GetMaxCellSize_132(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetCenterPts_133(JNIEnv* env, jobject obj)
{
  vtkPoints * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCenterPts();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetCoincidentPoints_134(JNIEnv* env, jobject obj)
{
  vtkCoincidentPoints * temp20;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCoincidentPoints();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLabelHierarchy_GetAnchorFrustumPlanes_135(JNIEnv* env, jobject obj,jdoubleArray id0,jobject id1,jobject id2)
{
  double temp0[24];
  vtkRenderer * temp1;
  vtkCoordinate * temp2;
  env->GetDoubleArrayRegion(id0, 0, 24, &temp0[0]);
  temp1 = static_cast<vtkRenderer*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCoordinate*>(vtkJavaGetPointerFromObject(env, id2));

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetAnchorFrustumPlanes(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id0, 0, 24, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLabelHierarchy_GetCell_136(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkLabelHierarchy* op = static_cast<vtkLabelHierarchy*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLabelHierarchy_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLabelHierarchy::New());
}
