// java wrapper for vtkUniforms object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUniforms.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUniforms_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUniforms",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniforms_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniforms_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniforms_GetUniformListMTime_14(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformListMTime();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkUniforms_TupleTypeToString_15(JNIEnv* env, jobject obj,jint id0)
{
  vtkUniforms::TupleType   temp0;
  std::string   temp20;
  temp0 = static_cast<vtkUniforms::TupleType>(id0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TupleTypeToString(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_StringToTupleType_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  vtkUniforms::TupleType   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StringToTupleType(temp0);
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkUniforms_ScalarTypeToString_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  std::string   temp20;
  temp0 = id0;

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ScalarTypeToString(temp0);
  return vtkJavaStringToUTF8(env, temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_StringToScalarType_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->StringToScalarType(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_RemoveUniform_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveUniform(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_RemoveAllUniforms_110(JNIEnv* env, jobject obj)
{

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllUniforms();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniformi_111(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformi(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniformf_112(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloat id1)
{
  char * temp0;
  float   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformf(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniform2i_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jintArray id1)
{
  char * temp0;
  int temp1[2];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniform2i(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniform2f_114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[2];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniform2f(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniform3f_115(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[3];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniform3f(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniform4f_116(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[4];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniform4f(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniform3f_117(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  char * temp0;
  double temp1[3];
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniform3f(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniformMatrix_118(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkMatrix3x3 * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformMatrix(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniforms_SetUniformMatrix_119(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkMatrix4x4 * temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUniformMatrix(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniform2i_120(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jintArray id1)
{
  char * temp0;
  int temp1[2];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniform2i(temp0,temp1);
  delete[] temp0;
  env->SetIntArrayRegion(id1, 0, 2, reinterpret_cast<jint*>(&temp1[0]));
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniform2f_121(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[2];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 2, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniform2f(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 2, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniform3f_122(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[3];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 3, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniform3f(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniform4f_123(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jfloatArray id1)
{
  char * temp0;
  float temp1[4];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetFloatArrayRegion(id1, 0, 4, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniform4f(temp0,temp1);
  delete[] temp0;
  env->SetFloatArrayRegion(id1, 0, 4, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniform3f_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jdoubleArray id1)
{
  char * temp0;
  double temp1[3];
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniform3f(temp0,temp1);
  delete[] temp0;
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniformMatrix_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkMatrix3x3 * temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkMatrix3x3*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformMatrix(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkUniforms_GetUniformMatrix_126(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jobject id1)
{
  char * temp0;
  vtkMatrix4x4 * temp1;
  bool   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = static_cast<vtkMatrix4x4*>(vtkJavaGetPointerFromObject(env, id1));

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformMatrix(temp0,temp1);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_GetNumberOfUniforms_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfUniforms();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkUniforms_GetNthUniformName_128(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  const char * temp20;
  temp0 = id0;

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNthUniformName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_GetUniformScalarType_129(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformScalarType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_GetUniformTupleType_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  vtkUniforms::TupleType   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformTupleType(temp0);
  delete[] temp0;
  return static_cast<jint>(temp20);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_GetUniformNumberOfComponents_131(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformNumberOfComponents(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniforms_GetUniformNumberOfTuples_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniforms* op = static_cast<vtkUniforms*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUniformNumberOfTuples(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUniforms_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUniforms::New());
}
