// java wrapper for vtkLightActor object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkLightActor.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkProp3D_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkLightActor_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkLightActor",dType)) { return me; }
  if ((res= vtkProp3D_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightActor_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightActor_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightActor_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightActor_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightActor_SetLight_14(JNIEnv* env, jobject obj,jobject id0)
{
  vtkLight * temp0;
  temp0 = static_cast<vtkLight*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLight(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightActor_GetLight_15(JNIEnv* env, jobject obj)
{
  vtkLight * temp20;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLight();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightActor_SetClippingRange_16(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClippingRange(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightActor_SetClippingRange_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetClippingRange(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkLightActor_GetClippingRange_18(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetClippingRange();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightActor_GetConeProperty_19(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConeProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightActor_GetFrustumProperty_110(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrustumProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightActor_RenderOpaqueGeometry_111(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkLightActor_HasTranslucentPolygonalGeometry_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkLightActor_ReleaseGraphicsResources_113(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkLightActor_GetMTime_114(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkLightActor* op = static_cast<vtkLightActor*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkLightActor_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkLightActor::New());
}
