// java wrapper for vtkTensorRepresentation object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkTensorRepresentation.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWidgetRepresentation_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkTensorRepresentation_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkTensorRepresentation",dType)) { return me; }
  if ((res= vtkWidgetRepresentation_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetTensor_14(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTensor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetSymmetricTensor_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSymmetricTensor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_GetTensor_16(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[9];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetTensor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_GetSymmetricTensor_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetSymmetricTensor(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_GetEigenvalues_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetEigenvalues(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_GetEigenvector_19(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1)
{
  int   temp0;
  double temp1[3];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetEigenvector(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetPosition_110(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_GetPosition_111(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPosition(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_GetPolyData_112(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPolyData(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetHandleProperty_113(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHandleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetSelectedHandleProperty_114(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedHandleProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetFaceProperty_115(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFaceProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetSelectedFaceProperty_116(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedFaceProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetOutlineProperty_117(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutlineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetSelectedOutlineProperty_118(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSelectedOutlineProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkTensorRepresentation_GetEllipsoidProperty_119(JNIEnv* env, jobject obj)
{
  vtkProperty * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEllipsoidProperty();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetOutlineFaceWires_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutlineFaceWires(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTensorRepresentation_GetOutlineFaceWires_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutlineFaceWires();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_OutlineFaceWiresOn_122(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineFaceWiresOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_OutlineFaceWiresOff_123(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineFaceWiresOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetOutlineCursorWires_124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutlineCursorWires(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTensorRepresentation_GetOutlineCursorWires_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutlineCursorWires();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_OutlineCursorWiresOn_126(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineCursorWiresOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_OutlineCursorWiresOff_127(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineCursorWiresOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_HandlesOn_128(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->HandlesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_HandlesOff_129(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->HandlesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetTensorEllipsoid_130(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTensorEllipsoid(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTensorRepresentation_GetTensorEllipsoid_131(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTensorEllipsoid();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_TensorEllipsoidOn_132(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->TensorEllipsoidOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_TensorEllipsoidOff_133(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->TensorEllipsoidOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_PlaceTensor_134(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[9];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceTensor(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 9, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_PlaceWidget_135(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->PlaceWidget(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_BuildRepresentation_136(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildRepresentation();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_ComputeInteractionState_137(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ComputeInteractionState(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_StartWidgetInteraction_138(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StartWidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_WidgetInteraction_139(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[2];
  env->GetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->WidgetInteraction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 2, &temp0[0]);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkTensorRepresentation_GetBounds_140(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_ReleaseGraphicsResources_141(JNIEnv* env, jobject obj,jobject id0)
{
  vtkWindow * temp0;
  temp0 = static_cast<vtkWindow*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReleaseGraphicsResources(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_RenderOpaqueGeometry_142(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderOpaqueGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_RenderTranslucentPolygonalGeometry_143(JNIEnv* env, jobject obj,jobject id0)
{
  vtkViewport * temp0;
  int   temp20;
  temp0 = static_cast<vtkViewport*>(vtkJavaGetPointerFromObject(env, id0));

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->RenderTranslucentPolygonalGeometry(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_HasTranslucentPolygonalGeometry_144(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->HasTranslucentPolygonalGeometry();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetInteractionState_145(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInteractionState(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTensorRepresentation_GetSnapToAxes_146(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetSnapToAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetSnapToAxes_147(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetSnapToAxes(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_StepForward_148(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StepForward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_StepBackward_149(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->StepBackward();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_RegisterPickers_150(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->RegisterPickers();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_GetTranslationAxis_151(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationAxis();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetTranslationAxis_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationAxis(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_GetTranslationAxisMinValue_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationAxisMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkTensorRepresentation_GetTranslationAxisMaxValue_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationAxisMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetXTranslationAxisOn_155(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXTranslationAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetYTranslationAxisOn_156(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYTranslationAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetZTranslationAxisOn_157(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZTranslationAxisOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkTensorRepresentation_SetTranslationAxisOff_158(JNIEnv* env, jobject obj)
{

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationAxisOff();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkTensorRepresentation_IsTranslationConstrained_159(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkTensorRepresentation* op = static_cast<vtkTensorRepresentation*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTranslationConstrained();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkTensorRepresentation_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkTensorRepresentation::New());
}
