// java wrapper for vtkMergeGraphs object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkMergeGraphs.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkGraphAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkMergeGraphs_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkMergeGraphs",dType)) { return me; }
  if ((res= vtkGraphAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMergeGraphs_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMergeGraphs_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMergeGraphs_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkMergeGraphs_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkMergeGraphs_ExtendGraph_14(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkMutableGraphHelper * temp0;
  vtkGraph * temp1;
  int   temp20;
  temp0 = static_cast<vtkMutableGraphHelper*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkGraph*>(vtkJavaGetPointerFromObject(env, id1));

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendGraph(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMergeGraphs_SetUseEdgeWindow_15(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseEdgeWindow(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkMergeGraphs_GetUseEdgeWindow_16(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseEdgeWindow();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMergeGraphs_UseEdgeWindowOn_17(JNIEnv* env, jobject obj)
{

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeWindowOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMergeGraphs_UseEdgeWindowOff_18(JNIEnv* env, jobject obj)
{

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseEdgeWindowOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMergeGraphs_SetEdgeWindowArrayName_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeWindowArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkMergeGraphs_GetEdgeWindowArrayName_110(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWindowArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkMergeGraphs_SetEdgeWindow_111(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEdgeWindow(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkMergeGraphs_GetEdgeWindow_112(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkMergeGraphs* op = static_cast<vtkMergeGraphs*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdgeWindow();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkMergeGraphs_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkMergeGraphs::New());
}
