// java wrapper for vtkPDataSetWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPDataSetWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkDataSetWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPDataSetWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPDataSetWriter",dType)) { return me; }
  if ((res= vtkDataSetWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDataSetWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDataSetWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_Write_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Write();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetNumberOfPieces_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfPieces(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_GetNumberOfPieces_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPieces();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetGhostLevel_17(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGhostLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_GetGhostLevel_18(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetStartPiece_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStartPiece(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_GetStartPiece_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStartPiece();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetEndPiece_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEndPiece(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_GetEndPiece_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEndPiece();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetFilePattern_113(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFilePattern(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPDataSetWriter_GetFilePattern_114(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFilePattern();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetUseRelativeFileNames_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseRelativeFileNames(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPDataSetWriter_GetUseRelativeFileNames_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseRelativeFileNames();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_UseRelativeFileNamesOn_117(JNIEnv* env, jobject obj)
{

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseRelativeFileNamesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_UseRelativeFileNamesOff_118(JNIEnv* env, jobject obj)
{

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseRelativeFileNamesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPDataSetWriter_SetController_119(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPDataSetWriter_GetController_120(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkPDataSetWriter* op = static_cast<vtkPDataSetWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPDataSetWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPDataSetWriter::New());
}
