// java wrapper for vtkPLYWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPLYWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPLYWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPLYWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPLYWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPLYWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetDataByteOrder_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataByteOrder(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetDataByteOrderMinValue_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataByteOrderMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetDataByteOrderMaxValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataByteOrderMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetDataByteOrder_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataByteOrder();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetDataByteOrderToBigEndian_18(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataByteOrderToBigEndian();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetDataByteOrderToLittleEndian_19(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataByteOrderToLittleEndian();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetWriteToOutputString_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteToOutputString(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPLYWriter_GetWriteToOutputString_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteToOutputString();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_WriteToOutputStringOn_112(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_WriteToOutputStringOff_113(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteToOutputStringOff();

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPLYWriter_GetOutputString_114(JNIEnv* env, jobject obj)
{
  const std::string * temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = &(op)->GetOutputString();
  return vtkJavaStringToUTF8(env, *temp20);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetWriteObjectInformation_115(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteObjectInformation(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPLYWriter_GetWriteObjectInformation_116(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteObjectInformation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_WriteObjectInformationOn_117(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteObjectInformationOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_WriteObjectInformationOff_118(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->WriteObjectInformationOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColorMode_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetColorMode_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColorMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColorModeToDefault_121(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToDefault();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColorModeToUniformCellColor_122(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToUniformCellColor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColorModeToUniformPointColor_123(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToUniformPointColor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColorModeToUniformColor_124(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToUniformColor();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColorModeToOff_125(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColorModeToOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetEnableAlpha_126(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableAlpha(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPLYWriter_GetEnableAlpha_127(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_EnableAlphaOn_128(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAlphaOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_EnableAlphaOff_129(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->EnableAlphaOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetArrayName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPLYWriter_GetArrayName_131(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetComponent_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetComponent(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetComponentMinValue_133(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetComponentMaxValue_134(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponentMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetComponent_135(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetLookupTable_136(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPLYWriter_GetLookupTable_137(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetColor_138(JNIEnv* env, jobject obj,jbyte id0,jbyte id1,jbyte id2)
{
   unsigned char   temp0;
   unsigned char   temp1;
   unsigned char   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetColor(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPLYWriter_GetColor_139(JNIEnv* env, jobject obj)
{
   unsigned char * temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetColor();
  return vtkJavaMakeJArrayOfByte(env, reinterpret_cast<jbyte*>(temp20), 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetAlpha_140(JNIEnv* env, jobject obj,jbyte id0)
{
   unsigned char   temp0;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAlpha(temp0);

}

extern "C" JNIEXPORT jbyte  JNICALL Java_vtk_vtkPLYWriter_GetAlpha_141(JNIEnv* env, jobject obj)
{
   unsigned char   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAlpha();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPLYWriter_GetInput_142(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPLYWriter_GetInput_143(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPolyData * temp20;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetFileName_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkPLYWriter_GetFileName_145(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetFileType_146(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetFileTypeMinValue_147(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetFileTypeMaxValue_148(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetFileType_149(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetFileTypeToASCII_150(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToASCII();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetFileTypeToBinary_151(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToBinary();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetTextureCoordinatesName_152(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureCoordinatesName(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetTextureCoordinatesNameMinValue_153(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureCoordinatesNameMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetTextureCoordinatesNameMaxValue_154(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureCoordinatesNameMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPLYWriter_GetTextureCoordinatesName_155(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTextureCoordinatesName();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetTextureCoordinatesNameToUV_156(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureCoordinatesNameToUV();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_SetTextureCoordinatesNameToTextureUV_157(JNIEnv* env, jobject obj)
{

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTextureCoordinatesNameToTextureUV();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPLYWriter_AddComment_158(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkPLYWriter* op = static_cast<vtkPLYWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddComment(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPLYWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPLYWriter::New());
}
