// java wrapper for vtkOpenVDBWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOpenVDBWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOpenVDBWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOpenVDBWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOpenVDBWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBWriter_SetFileName_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkOpenVDBWriter_GetFileName_15(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBWriter_SetWriteAllTimeSteps_16(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWriteAllTimeSteps(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenVDBWriter_GetWriteAllTimeSteps_17(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWriteAllTimeSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBWriter_SetLookupTable_18(JNIEnv* env, jobject obj,jobject id0)
{
  vtkScalarsToColors * temp0;
  temp0 = static_cast<vtkScalarsToColors*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLookupTable(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBWriter_GetLookupTable_19(JNIEnv* env, jobject obj)
{
  vtkScalarsToColors * temp20;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLookupTable();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBWriter_SetEnableColoring_110(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableColoring(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenVDBWriter_GetEnableColoring_111(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableColoring();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBWriter_SetEnableAlpha_112(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetEnableAlpha(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkOpenVDBWriter_GetEnableAlpha_113(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEnableAlpha();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOpenVDBWriter_SetController_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkMultiProcessController * temp0;
  temp0 = static_cast<vtkMultiProcessController*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetController(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOpenVDBWriter_GetController_115(JNIEnv* env, jobject obj)
{
  vtkMultiProcessController * temp20;

  vtkOpenVDBWriter* op = static_cast<vtkOpenVDBWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetController();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOpenVDBWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOpenVDBWriter::New());
}
