// java wrapper for vtkSLACReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSLACReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkMultiBlockDataSetAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSLACReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSLACReader",dType)) { return me; }
  if ((res= vtkMultiBlockDataSetAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSLACReader_GetMeshFileName_14(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMeshFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetMeshFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetMeshFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_AddModeFileName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddModeFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_RemoveAllModeFileNames_17(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllModeFileNames();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_GetNumberOfModeFileNames_18(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfModeFileNames();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSLACReader_GetModeFileName_19(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModeFileName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_GetReadInternalVolume_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadInternalVolume();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetReadInternalVolume_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadInternalVolume(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ReadInternalVolumeOn_112(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadInternalVolumeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ReadInternalVolumeOff_113(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadInternalVolumeOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_GetReadExternalSurface_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadExternalSurface();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetReadExternalSurface_115(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadExternalSurface(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ReadExternalSurfaceOn_116(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadExternalSurfaceOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ReadExternalSurfaceOff_117(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadExternalSurfaceOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_GetReadMidpoints_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetReadMidpoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetReadMidpoints_119(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetReadMidpoints(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ReadMidpointsOn_120(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadMidpointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ReadMidpointsOff_121(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReadMidpointsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_GetNumberOfVariableArrays_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVariableArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSLACReader_GetVariableArrayName_123(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVariableArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_GetVariableArrayStatus_124(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVariableArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetVariableArrayStatus_125(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVariableArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ResetFrequencyScales_126(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetFrequencyScales();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetFrequencyScale_127(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFrequencyScale(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_ResetPhaseShifts_128(JNIEnv* env, jobject obj)
{

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResetPhaseShifts();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSLACReader_SetPhaseShift_129(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
  int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPhaseShift(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_GetFrequencyScales_130(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFrequencyScales();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_GetPhaseShifts_131(JNIEnv* env, jobject obj)
{
  vtkDoubleArray * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPhaseShifts();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSLACReader_CanReadFile_132(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_IS_1INTERNAL_1VOLUME_133(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IS_INTERNAL_VOLUME();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_IS_1EXTERNAL_1SURFACE_134(JNIEnv* env, jobject obj)
{
  vtkInformationIntegerKey * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IS_EXTERNAL_SURFACE();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_POINTS_135(JNIEnv* env, jobject obj)
{
  vtkInformationObjectBaseKey * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->POINTS();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSLACReader_POINT_1DATA_136(JNIEnv* env, jobject obj)
{
  vtkInformationObjectBaseKey * temp20;

  vtkSLACReader* op = static_cast<vtkSLACReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->POINT_DATA();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSLACReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSLACReader::New());
}
