// java wrapper for vtkImageExport object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImageExport.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImageAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImageExport_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImageExport",dType)) { return me; }
  if ((res= vtkImageAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageExport_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageExport_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageExport_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageExport_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageExport_GetDataMemorySize_14(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataMemorySize();
  return temp20;

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageExport_GetDataDimensions_15(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDimensions();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageExport_GetDataNumberOfScalarComponents_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataNumberOfScalarComponents();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageExport_GetDataScalarType_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarType();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkImageExport_GetDataScalarTypeAsString_18(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataScalarTypeAsString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jintArray  JNICALL Java_vtk_vtkImageExport_GetDataExtent_19(JNIEnv* env, jobject obj)
{
  int * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataExtent();
  return vtkJavaMakeJArrayOfInt(env, reinterpret_cast<jint*>(temp20), 6);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageExport_GetDataSpacing_110(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSpacing();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageExport_GetDataOrigin_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImageExport_GetDataDirection_112(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataDirection();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 9);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImageExport_GetInput_113(JNIEnv* env, jobject obj)
{
  vtkImageData * temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageExport_ImageLowerLeftOn_114(JNIEnv* env, jobject obj)
{

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  op->ImageLowerLeftOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageExport_ImageLowerLeftOff_115(JNIEnv* env, jobject obj)
{

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  op->ImageLowerLeftOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImageExport_GetImageLowerLeft_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetImageLowerLeft();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageExport_SetImageLowerLeft_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetImageLowerLeft(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImageExport_Export_118(JNIEnv* env, jobject obj)
{

  vtkImageExport* op = static_cast<vtkImageExport*>(vtkJavaGetPointerFromObject(env, obj));
  op->Export();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImageExport_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImageExport::New());
}
