// java wrapper for vtkSTLWriter object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSTLWriter.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkWriter_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSTLWriter_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSTLWriter",dType)) { return me; }
  if ((res= vtkWriter_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLWriter_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLWriter_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLWriter_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLWriter_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLWriter_GetInput_14(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLWriter_GetInput_15(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkPolyData * temp20;
  temp0 = id0;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInput(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLWriter_SetFileName_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSTLWriter_GetFileName_17(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLWriter_SetHeader_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHeader(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSTLWriter_GetHeader_19(JNIEnv* env, jobject obj)
{
  char * temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHeader();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLWriter_SetBinaryHeader_110(JNIEnv* env, jobject obj,jobject id0)
{
  vtkUnsignedCharArray * temp0;
  temp0 = static_cast<vtkUnsignedCharArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetBinaryHeader(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSTLWriter_GetBinaryHeader_111(JNIEnv* env, jobject obj)
{
  vtkUnsignedCharArray * temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetBinaryHeader();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLWriter_SetFileType_112(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLWriter_GetFileTypeMinValue_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLWriter_GetFileTypeMaxValue_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSTLWriter_GetFileType_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFileType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLWriter_SetFileTypeToASCII_116(JNIEnv* env, jobject obj)
{

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToASCII();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSTLWriter_SetFileTypeToBinary_117(JNIEnv* env, jobject obj)
{

  vtkSTLWriter* op = static_cast<vtkSTLWriter*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileTypeToBinary();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSTLWriter_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSTLWriter::New());
}
