// java wrapper for vtkFidesReader object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkFidesReader.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkFidesReader_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkFidesReader",dType)) { return me; }
  if ((res= vtkAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFidesReader_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFidesReader_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_CanReadFile_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CanReadFile(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetFileName_15(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFileName(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_ParseDataModel_16(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  std::string temp0;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParseDataModel(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_ParseDataModel_17(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ParseDataModel();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetDataSourcePath_18(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  std::string temp0;
  std::string temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSourcePath(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetDataSourceEngine_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  std::string temp0;
  std::string temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSourceEngine(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetDataSourceIO_110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0, jbyteArray id1, jint len1)
{
  std::string temp0;
  std::string temp1;
  temp0 = vtkJavaUTF8ToString(env, id0, len0);
  temp1 = vtkJavaUTF8ToString(env, id1, len1);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSourceIO(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_PrepareNextStep_111(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->PrepareNextStep();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetNextStepStatus_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextStepStatus();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkFidesReader_GetTimeOfCurrentStep_113(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTimeOfCurrentStep();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_ConvertToVTKOn_114(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertToVTKOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_ConvertToVTKOff_115(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->ConvertToVTKOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetConvertToVTK_116(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetConvertToVTK(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFidesReader_GetConvertToVTK_117(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetConvertToVTK();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_StreamStepsOn_118(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->StreamStepsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_StreamStepsOff_119(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->StreamStepsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetStreamSteps_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStreamSteps(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFidesReader_GetStreamSteps_121(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStreamSteps();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_CreateSharedPointsOn_122(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateSharedPointsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_CreateSharedPointsOff_123(JNIEnv* env, jobject obj)
{

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->CreateSharedPointsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetCreateSharedPoints_124(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCreateSharedPoints(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkFidesReader_GetCreateSharedPoints_125(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCreateSharedPoints();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFidesReader_GetPointDataArraySelection_126(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFidesReader_GetCellDataArraySelection_127(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFidesReader_GetFieldDataArraySelection_128(JNIEnv* env, jobject obj)
{
  vtkDataArraySelection * temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldDataArraySelection();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetNumberOfPointArrays_129(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPointArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetNumberOfCellArrays_130(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellArrays();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetNumberOfFieldArrays_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFieldArrays();
  return temp20;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkFidesReader_GetPointArrayName_132(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkFidesReader_GetCellArrayName_133(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkFidesReader_GetFieldArrayName_134(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetPointArrayStatus_135(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetCellArrayStatus_136(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkFidesReader_GetFieldArrayStatus_137(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldArrayStatus(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetPointArrayStatus_138(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPointArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetCellArrayStatus_139(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCellArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkFidesReader_SetFieldArrayStatus_140(JNIEnv* env, jobject obj, jbyteArray id0, jint len0,jint id1)
{
  char * temp0;
  int   temp1;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);
  temp1 = id1;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldArrayStatus(temp0,temp1);
  delete[] temp0;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkFidesReader_GetMTime_141(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkFidesReader* op = static_cast<vtkFidesReader*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkFidesReader_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkFidesReader::New());
}
