// java wrapper for vtkSelectionSource object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkSelectionSource.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkSelectionAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkSelectionSource_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkSelectionSource",dType)) { return me; }
  if ((res= vtkSelectionAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetNumberOfNodes_14(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfNodes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfNodes_15(JNIEnv* env, jobject obj)
{
   unsigned int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfNodes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveNode_16(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNode(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveNode_17(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveNode(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllNodes_18(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllNodes();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetExpression_19(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetExpression(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetExpression_110(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetExpression();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetFieldTypeOption_111(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldTypeOption(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetFieldTypeOptionMinValue_112(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeOptionMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetFieldTypeOptionMaxValue_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeOptionMaxValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetFieldTypeOptionToFieldType_114(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldTypeOptionToFieldType();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetFieldTypeOptionToElementType_115(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldTypeOptionToElementType();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetFieldTypeOption_116(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeOption();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetFieldType_117(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFieldType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetFieldTypeMinValue_118(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetFieldTypeMaxValue_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetFieldType_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFieldType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetElementType_121(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetElementType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetElementTypeMinValue_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetElementTypeMaxValue_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetElementType_124(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetElementType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetProcessID_125(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetProcessID(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetProcessIDMinValue_126(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessIDMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetProcessIDMaxValue_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessIDMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetProcessID_128(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetProcessID();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetNodeName_129(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeName(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetNodeName_130(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNodeName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetNodeName_131(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetNodeName_132(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNodeName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddID_133(JNIEnv* env, jobject obj,jint id0,jlong id1,jlong id2)
{
   unsigned int   temp0;
  long long   temp1;
  long long   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddID(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddID_134(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddID(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddStringID_135(JNIEnv* env, jobject obj,jint id0,jlong id1, jbyteArray id2, jint len2)
{
   unsigned int   temp0;
  long long   temp1;
  char * temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = vtkJavaUTF8ToChars(env, id2, len2);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddStringID(temp0,temp1,temp2);
  delete[] temp2;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddStringID_136(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddStringID(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddLocation_137(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2,jdouble id3)
{
   unsigned int   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLocation(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddLocation_138(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddLocation(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddThreshold_139(JNIEnv* env, jobject obj,jint id0,jdouble id1,jdouble id2)
{
   unsigned int   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddThreshold(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddThreshold_140(JNIEnv* env, jobject obj,jdouble id0,jdouble id1)
{
  double   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddThreshold(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddBlock_141(JNIEnv* env, jobject obj,jint id0,jlong id1)
{
   unsigned int   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBlock(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddBlock_142(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBlock(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddBlockSelector_143(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBlockSelector(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddBlockSelector_144(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddBlockSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllBlockSelectors_145(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllBlockSelectors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllBlockSelectors_146(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllBlockSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllIDs_147(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllIDs(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllIDs_148(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllIDs();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllStringIDs_149(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllStringIDs(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllStringIDs_150(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllStringIDs();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllThresholds_151(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllThresholds(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllThresholds_152(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllThresholds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllLocations_153(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllLocations(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllLocations_154(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllLocations();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllBlocks_155(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllBlocks(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllBlocks_156(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllBlocks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetContentType_157(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContentType(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetContentType_158(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContentType(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetContentTypeMinValue_159(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentTypeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetContentTypeMaxValue_160(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentTypeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetContentType_161(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetContentType_162(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContentType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetContainingCells_163(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContainingCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetContainingCells_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetContainingCells(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetContainingCells_165(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContainingCells(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetContainingCells_166(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetContainingCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetNumberOfLayers_167(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLayers(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetNumberOfLayers_168(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfLayers(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfLayersMinValue_169(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayersMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfLayersMaxValue_170(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayersMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfLayers_171(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayers(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetNumberOfLayers_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLayers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetRemoveSeed_173(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
   unsigned int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveSeed(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetRemoveSeed_174(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveSeed(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSelectionSource_GetRemoveSeed_175(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveSeed(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSelectionSource_GetRemoveSeed_176(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveSeed();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetRemoveIntermediateLayers_177(JNIEnv* env, jobject obj,jint id0,jboolean id1)
{
   unsigned int   temp0;
  bool   temp1;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveIntermediateLayers(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetRemoveIntermediateLayers_178(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRemoveIntermediateLayers(temp0);

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSelectionSource_GetRemoveIntermediateLayers_179(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  bool   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveIntermediateLayers(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkSelectionSource_GetRemoveIntermediateLayers_180(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRemoveIntermediateLayers();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetInverse_181(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInverse(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetInverse_182(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetInverse(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetInverse_183(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverse(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetInverse_184(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetInverse();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetArrayName_185(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetArrayName_186(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetArrayName_187(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetArrayName_188(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetArrayComponent_189(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayComponent(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetArrayComponent_190(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetArrayComponent(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetArrayComponent_191(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayComponent(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetArrayComponent_192(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetArrayComponent();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetCompositeIndex_193(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompositeIndex(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetCompositeIndex_194(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCompositeIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetCompositeIndex_195(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetCompositeIndex_196(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCompositeIndex();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetHierarchicalLevel_197(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHierarchicalLevel(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetHierarchicalLevel_198(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHierarchicalLevel(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetHierarchicalLevel_199(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchicalLevel(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetHierarchicalLevel_1100(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchicalLevel();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetHierarchicalIndex_1101(JNIEnv* env, jobject obj,jint id0,jint id1)
{
   unsigned int   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHierarchicalIndex(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetHierarchicalIndex_1102(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetHierarchicalIndex(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetHierarchicalIndex_1103(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  int   temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchicalIndex(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkSelectionSource_GetHierarchicalIndex_1104(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetHierarchicalIndex();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetAssemblyName_1105(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssemblyName(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetAssemblyName_1106(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAssemblyName(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetAssemblyName_1107(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyName(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetAssemblyName_1108(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAssemblyName();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddSelector_1109(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddSelector(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_AddSelector_1110(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddSelector(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllSelectors_1111(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllSelectors(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_RemoveAllSelectors_1112(JNIEnv* env, jobject obj)
{

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveAllSelectors();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetQueryString_1113(JNIEnv* env, jobject obj,jint id0, jbyteArray id1, jint len1)
{
   unsigned int   temp0;
  char * temp1;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQueryString(temp0,temp1);
  delete[] temp1;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkSelectionSource_SetQueryString_1114(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetQueryString(temp0);
  delete[] temp0;

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetQueryString_1115(JNIEnv* env, jobject obj,jint id0)
{
   unsigned int   temp0;
  const char * temp20;
  temp0 = id0;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQueryString(temp0);
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jbyteArray  JNICALL Java_vtk_vtkSelectionSource_GetQueryString_1116(JNIEnv* env, jobject obj)
{
  const char * temp20;

  vtkSelectionSource* op = static_cast<vtkSelectionSource*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetQueryString();
  return (temp20 == nullptr) ? env->NewByteArray(0) : vtkJavaCharsToUTF8(env, temp20, strlen(temp20));

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkSelectionSource_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkSelectionSource::New());
}
