// java wrapper for vtkOBBTree object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOBBTree.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkAbstractCellLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOBBTree_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOBBTree",dType)) { return me; }
  if ((res= vtkAbstractCellLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOBBTree_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOBBTree_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOBBTree_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOBBTree_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOBBTree_IntersectWithLine_14(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2,jobject id3)
{
  double temp0[3];
  double temp1[3];
  vtkPoints * temp2;
  vtkIdList * temp3;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithLine(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOBBTree_ComputeOBB_15(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5)
{
  vtkPoints * temp0;
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double temp5[3];
  temp0 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 3, &temp5[0]);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeOBB(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->SetDoubleArrayRegion(id5, 0, 3, &temp5[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOBBTree_ComputeOBB_16(JNIEnv* env, jobject obj,jobject id0,jdoubleArray id1,jdoubleArray id2,jdoubleArray id3,jdoubleArray id4,jdoubleArray id5)
{
  vtkDataSet * temp0;
  double temp1[3];
  double temp2[3];
  double temp3[3];
  double temp4[3];
  double temp5[3];
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->GetDoubleArrayRegion(id5, 0, 3, &temp5[0]);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeOBB(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  env->SetDoubleArrayRegion(id5, 0, 3, &temp5[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOBBTree_InsideOrOutside_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsideOrOutside(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOBBTree_FreeSearchStructure_18(JNIEnv* env, jobject obj)
{

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->FreeSearchStructure();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOBBTree_BuildLocator_19(JNIEnv* env, jobject obj)
{

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOBBTree_ForceBuildLocator_110(JNIEnv* env, jobject obj)
{

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->ForceBuildLocator();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOBBTree_GenerateRepresentation_111(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkPolyData * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  op->GenerateRepresentation(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOBBTree_IntersectWithLine_112(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdouble id2,jobject id3,jobject id4)
{
  double temp0[3];
  double temp1[3];
  double   temp2;
  vtkPoints * temp3;
  vtkIdList * temp4;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  temp3 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithLine(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOBBTree_IntersectWithLine_113(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdouble id2,jobject id3,jobject id4,jobject id5)
{
  double temp0[3];
  double temp1[3];
  double   temp2;
  vtkPoints * temp3;
  vtkIdList * temp4;
  vtkGenericCell * temp5;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  temp3 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id5));

  vtkOBBTree* op = static_cast<vtkOBBTree*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithLine(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOBBTree_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOBBTree::New());
}
