// java wrapper for vtkCursor2D object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkCursor2D.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPolyDataAlgorithm_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkCursor2D_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkCursor2D",dType)) { return me; }
  if ((res= vtkPolyDataAlgorithm_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCursor2D_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkCursor2D_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetModelBounds_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0,temp1,temp2,temp3,temp4,temp5);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetModelBounds_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetModelBounds(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCursor2D_GetModelBounds_16(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetModelBounds();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetFocalPoint_17(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetFocalPoint_18(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFocalPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkCursor2D_GetFocalPoint_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFocalPoint();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetOutline_110(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutline(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_GetOutline_111(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutline();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_OutlineOn_112(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_OutlineOff_113(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->OutlineOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetAxes_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetAxes(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_GetAxes_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetAxes();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_AxesOn_116(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_AxesOff_117(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AxesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetRadius_118(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRadius(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCursor2D_GetRadiusMinValue_119(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMinValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCursor2D_GetRadiusMaxValue_120(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadiusMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkCursor2D_GetRadius_121(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRadius();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetPoint_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPoint(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_GetPoint_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPoint();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_PointOn_124(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_PointOff_125(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->PointOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetTranslationMode_126(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetTranslationMode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_GetTranslationMode_127(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTranslationMode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_TranslationModeOn_128(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslationModeOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_TranslationModeOff_129(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->TranslationModeOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_SetWrap_130(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetWrap(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkCursor2D_GetWrap_131(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetWrap();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_WrapOn_132(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->WrapOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_WrapOff_133(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->WrapOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_AllOn_134(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkCursor2D_AllOff_135(JNIEnv* env, jobject obj)
{

  vtkCursor2D* op = static_cast<vtkCursor2D*>(vtkJavaGetPointerFromObject(env, obj));
  op->AllOff();

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkCursor2D_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkCursor2D::New());
}
