// java wrapper for vtkUniformHyperTreeGrid object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkUniformHyperTreeGrid.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkHyperTreeGrid_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkUniformHyperTreeGrid_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkUniformHyperTreeGrid",dType)) { return me; }
  if ((res= vtkHyperTreeGrid_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniformHyperTreeGrid_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniformHyperTreeGrid_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetDataObjectType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_CopyStructure_15(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_Initialize_16(JNIEnv* env, jobject obj)
{

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetOrigin_17(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetOrigin_18(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOrigin(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetOrigin_19(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOrigin();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetGridScale_110(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScale(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetGridScale_111(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGridScale();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetGridScale_112(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetGridScale(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetGridBounds_113(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetGridBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetXCoordinates_114(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetXCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetXCoordinates_115(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetXCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetYCoordinates_116(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetYCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetYCoordinates_117(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetYCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetZCoordinates_118(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataArray * temp0;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetZCoordinates(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetZCoordinates_119(JNIEnv* env, jobject obj)
{
  vtkDataArray * temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetZCoordinates();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_CopyCoordinates_120(JNIEnv* env, jobject obj,jobject id0)
{
  vtkHyperTreeGrid * temp0;
  temp0 = static_cast<vtkHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyCoordinates(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_SetFixedCoordinates_121(JNIEnv* env, jobject obj,jint id0,jdouble id1)
{
   unsigned int   temp0;
  double   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetFixedCoordinates(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_ShallowCopy_122(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkUniformHyperTreeGrid_DeepCopy_123(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetActualMemorySizeBytes_124(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySizeBytes();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkUniformHyperTreeGrid_GetTree_125(JNIEnv* env, jobject obj,jlong id0,jboolean id1)
{
  long long   temp0;
  bool   temp1;
  vtkHyperTree * temp20;
  temp0 = id0;
  temp1 = (id1 != 0) ? true : false;

  vtkUniformHyperTreeGrid* op = static_cast<vtkUniformHyperTreeGrid*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTree(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkUniformHyperTreeGrid_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkUniformHyperTreeGrid::New());
}
