// java wrapper for vtkQuadraticPolygon object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkQuadraticPolygon.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkNonLinearCell_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkQuadraticPolygon_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkQuadraticPolygon",dType)) { return me; }
  if ((res= vtkNonLinearCell_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuadraticPolygon_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuadraticPolygon_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_GetCellType_14(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_GetCellDimension_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_GetNumberOfEdges_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfEdges();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_GetNumberOfFaces_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfFaces();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuadraticPolygon_GetEdge_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetEdge(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkQuadraticPolygon_GetFace_19(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetFace(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_IsPrimaryCell_110(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPrimaryCell();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_CellBoundary_111(JNIEnv* env, jobject obj,jint id0,jdoubleArray id1,jobject id2)
{
  int   temp0;
  double temp1[3];
  vtkIdList * temp2;
  int   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->CellBoundary(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadraticPolygon_Contour_112(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jobject id7,jobject id8,jlong id9,jobject id10)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkCellArray * temp4;
  vtkCellArray * temp5;
  vtkPointData * temp6;
  vtkPointData * temp7;
  vtkCellData * temp8;
  long long   temp9;
  vtkCellData * temp10;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id7));
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;
  temp10 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id10));

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  op->Contour(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9,temp10);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadraticPolygon_Clip_113(JNIEnv* env, jobject obj,jdouble id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jobject id6,jlong id7,jobject id8,jint id9)
{
  double   temp0;
  vtkDataArray * temp1;
  vtkIncrementalPointLocator * temp2;
  vtkCellArray * temp3;
  vtkPointData * temp4;
  vtkPointData * temp5;
  vtkCellData * temp6;
  long long   temp7;
  vtkCellData * temp8;
  int   temp9;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id6));
  temp7 = id7;
  temp8 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id8));
  temp9 = id9;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  op->Clip(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7,temp8,temp9);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadraticPolygon_ComputeCentroid_114(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdoubleArray id2)
{
  vtkIdTypeArray * temp0;
  vtkPoints * temp1;
  double temp2[3];
  temp0 = static_cast<vtkIdTypeArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id1));
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCentroid(temp0,temp1,temp2);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_Triangulate_115(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2)
{
  int   temp0;
  vtkIdList * temp1;
  vtkPoints * temp2;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->Triangulate(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_TriangulateLocalIds_116(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->TriangulateLocalIds(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_NonDegenerateTriangulate_117(JNIEnv* env, jobject obj,jobject id0)
{
  vtkIdList * temp0;
  int   temp20;
  temp0 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id0));

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NonDegenerateTriangulate(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkQuadraticPolygon_IntersectConvex2DCells_118(JNIEnv* env, jobject obj,jobject id0,jobject id1,jdouble id2,jdoubleArray id3,jdoubleArray id4)
{
  vtkCell * temp0;
  vtkCell * temp1;
  double   temp2;
  double temp3[3];
  double temp4[3];
  int   temp20;
  temp0 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkCell*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectConvex2DCells(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkQuadraticPolygon_GetUseMVCInterpolation_119(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseMVCInterpolation();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkQuadraticPolygon_SetUseMVCInterpolation_120(JNIEnv* env, jobject obj,jboolean id0)
{
  bool   temp0;
  temp0 = (id0 != 0) ? true : false;

  vtkQuadraticPolygon* op = static_cast<vtkQuadraticPolygon*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseMVCInterpolation(temp0);

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkQuadraticPolygon_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkQuadraticPolygon::New());
}
