// java wrapper for vtkPolyData object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkPolyData.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkPointSet_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkPolyData_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkPolyData",dType)) { return me; }
  if ((res= vtkPointSet_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_ExtendedNew_10(JNIEnv* env, jobject obj)
{
  vtkPolyData * temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->ExtendedNew();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_IsTypeOf_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_IsA_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfGenerationsFromBaseType_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfGenerationsFromBase_14(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetDataObjectType_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataObjectType();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_CopyStructure_16(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyStructure(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfCells_17(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCells();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetCell_18(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  vtkCell * temp20;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetCell_19(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkGenericCell * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCell(temp0,temp1);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetCellType_110(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  int   temp20;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellType(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetCellSize_111(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellSize(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetCellBounds_112(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1)
{
  long long   temp0;
  double temp1[6];
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id1, 0, 6, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetCellNeighbors_113(JNIEnv* env, jobject obj,jlong id0,jobject id1,jobject id2)
{
  long long   temp0;
  vtkIdList * temp1;
  vtkIdList * temp2;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellNeighbors(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_CopyCells_114(JNIEnv* env, jobject obj,jobject id0,jobject id1,jobject id2)
{
  vtkPolyData * temp0;
  vtkIdList * temp1;
  vtkIncrementalPointLocator * temp2;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id2));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->CopyCells(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetCellPoints_115(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellPoints(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetPointCells_116(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetPointCells(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ComputeCellsBounds_117(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCellsBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetCellsBounds_118(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[6];
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellsBounds(temp0);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_Squeeze_119(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Squeeze();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetMaxCellSize_120(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxCellSize();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetMaxSpatialDimension_121(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMaxSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetMinSpatialDimension_122(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMinSpatialDimension();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetCellIdRelativeToCellArray_123(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCellIdRelativeToCellArray(temp0);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_SetVerts_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetVerts(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetVerts_125(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetVerts();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_SetLines_126(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLines(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetLines_127(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLines();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_SetPolys_128(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPolys(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetPolys_129(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPolys();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_SetStrips_130(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetStrips(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetStrips_131(JNIEnv* env, jobject obj)
{
  vtkCellArray * temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetStrips();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfVerts_132(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfVerts();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfLines_133(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfLines();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfPolys_134(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPolys();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetNumberOfStrips_135(JNIEnv* env, jobject obj)
{
  long long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfStrips();
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_AllocateEstimate_136(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateEstimate(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_AllocateEstimate_137(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jlong id3,jlong id4,jlong id5,jlong id6,jlong id7)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  long long   temp3;
  long long   temp4;
  long long   temp5;
  long long   temp6;
  long long   temp7;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateEstimate(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_AllocateExact_138(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateExact(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_AllocateExact_139(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jlong id3,jlong id4,jlong id5,jlong id6,jlong id7)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  long long   temp3;
  long long   temp4;
  long long   temp5;
  long long   temp6;
  long long   temp7;
  bool   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;
  temp7 = id7;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateExact(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_AllocateCopy_140(JNIEnv* env, jobject obj,jobject id0)
{
  vtkPolyData * temp0;
  bool   temp20;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateCopy(temp0);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_AllocateProportional_141(JNIEnv* env, jobject obj,jobject id0,jdouble id1)
{
  vtkPolyData * temp0;
  double   temp1;
  bool   temp20;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AllocateProportional(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_Allocate_142(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Allocate(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_Allocate_143(JNIEnv* env, jobject obj,jobject id0,jlong id1,jint id2)
{
  vtkPolyData * temp0;
  long long   temp1;
  int   temp2;
  temp0 = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;
  temp2 = id2;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Allocate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_InsertNextCell_144(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextCell(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_Reset_145(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Reset();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_BuildCells_146(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildCells();

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkPolyData_NeedToBuildCells_147(JNIEnv* env, jobject obj)
{
  bool   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->NeedToBuildCells();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_BuildLinks_148(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->BuildLinks(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_SetLinks_149(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLinks * temp0;
  temp0 = static_cast<vtkAbstractCellLinks*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetLinks(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetLinks_150(JNIEnv* env, jobject obj)
{
  vtkAbstractCellLinks * temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetLinks();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_DeleteCells_151(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteCells();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_DeleteLinks_152(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteLinks();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_GetCellEdgeNeighbors_153(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkIdList * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->GetCellEdgeNeighbors(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_IsTriangle_154(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  int   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTriangle(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_IsEdge_155(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsEdge(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_IsPointUsedByCell_156(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsPointUsedByCell(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ReplaceCell_157(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkIdList * temp1;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ReplaceCellPoint_158(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceCellPoint(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ReplaceCellPoint_159(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jobject id3)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  vtkIdList * temp3;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReplaceCellPoint(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ReverseCell_160(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ReverseCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_DeletePoint_161(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeletePoint(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_DeleteCell_162(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeleteCell(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_RemoveDeletedCells_163(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveDeletedCells();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_InsertNextLinkedPoint_164(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  long long   temp20;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextLinkedPoint(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_InsertNextLinkedPoint_165(JNIEnv* env, jobject obj,jdoubleArray id0,jint id1)
{
  double temp0[3];
  int   temp1;
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertNextLinkedPoint(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_RemoveCellReference_166(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveCellReference(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_AddCellReference_167(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  temp0 = id0;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddCellReference(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_RemoveReferenceToCell_168(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveReferenceToCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_AddReferenceToCell_169(JNIEnv* env, jobject obj,jlong id0,jlong id1)
{
  long long   temp0;
  long long   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->AddReferenceToCell(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ResizeCellList_170(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ResizeCellList(temp0,temp1);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_Initialize_171(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->Initialize();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetPiece_172(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPiece();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetNumberOfPieces_173(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPieces();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetGhostLevel_174(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetGhostLevel();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetActualMemorySize_175(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetActualMemorySize();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_ShallowCopy_176(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_DeepCopy_177(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataObject * temp0;
  temp0 = static_cast<vtkDataObject*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->DeepCopy(temp0);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkPolyData_RemoveGhostCells_178(JNIEnv* env, jobject obj)
{

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  op->RemoveGhostCells();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetData_179(JNIEnv* env, jobject obj,jobject id0)
{
  vtkInformation * temp0;
  vtkPolyData * temp20;
  temp0 = static_cast<vtkInformation*>(vtkJavaGetPointerFromObject(env, id0));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetData_180(JNIEnv* env, jobject obj,jobject id0,jint id1)
{
  vtkInformationVector * temp0;
  int   temp1;
  vtkPolyData * temp20;
  temp0 = static_cast<vtkInformationVector*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetData(temp0,temp1);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetScalarFieldCriticalIndex_181(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkDataArray * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarFieldCriticalIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetScalarFieldCriticalIndex_182(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  int   temp20;
  temp0 = id0;
  temp1 = id1;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarFieldCriticalIndex(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkPolyData_GetScalarFieldCriticalIndex_183(JNIEnv* env, jobject obj,jlong id0, jbyteArray id1, jint len1)
{
  long long   temp0;
  char * temp1;
  int   temp20;
  temp0 = id0;
  temp1 = vtkJavaUTF8ToChars(env, id1, len1);

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetScalarFieldCriticalIndex(temp0,temp1);
  delete[] temp1;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetMeshMTime_184(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMeshMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetMTime_185(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkPolyData_GetCell_186(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  vtkCell * temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkPolyData* op = static_cast<vtkPolyData*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCell(temp0,temp1,temp2);
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkPolyData_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkPolyData::New());
}
