// java wrapper for vtkOrderedTriangulator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkOrderedTriangulator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkObject_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkOrderedTriangulator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkOrderedTriangulator",dType)) { return me; }
  if ((res= vtkObject_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_InitTriangulation_14(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2,jdouble id3,jdouble id4,jdouble id5,jint id6)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp3;
  double   temp4;
  double   temp5;
  int   temp6;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  temp3 = id3;
  temp4 = id4;
  temp5 = id5;
  temp6 = id6;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTriangulation(temp0,temp1,temp2,temp3,temp4,temp5,temp6);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_InitTriangulation_15(JNIEnv* env, jobject obj,jdoubleArray id0,jint id1)
{
  double temp0[6];
  int   temp1;
  env->GetDoubleArrayRegion(id0, 0, 6, &temp0[0]);
  temp1 = id1;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTriangulation(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 6, &temp0[0]);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_InsertPoint_16(JNIEnv* env, jobject obj,jlong id0,jdoubleArray id1,jdoubleArray id2,jint id3)
{
  long long   temp0;
  double temp1[3];
  double temp2[3];
  int   temp3;
  long long   temp20;
  temp0 = id0;
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  temp3 = id3;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertPoint(temp0,temp1,temp2,temp3);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_InsertPoint_17(JNIEnv* env, jobject obj,jlong id0,jlong id1,jdoubleArray id2,jdoubleArray id3,jint id4)
{
  long long   temp0;
  long long   temp1;
  double temp2[3];
  double temp3[3];
  int   temp4;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  env->GetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  temp4 = id4;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertPoint(temp0,temp1,temp2,temp3,temp4);
  env->SetDoubleArrayRegion(id2, 0, 3, &temp2[0]);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_InsertPoint_18(JNIEnv* env, jobject obj,jlong id0,jlong id1,jlong id2,jdoubleArray id3,jdoubleArray id4,jint id5)
{
  long long   temp0;
  long long   temp1;
  long long   temp2;
  double temp3[3];
  double temp4[3];
  int   temp5;
  long long   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;
  env->GetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->GetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  temp5 = id5;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsertPoint(temp0,temp1,temp2,temp3,temp4,temp5);
  env->SetDoubleArrayRegion(id3, 0, 3, &temp3[0]);
  env->SetDoubleArrayRegion(id4, 0, 3, &temp4[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_Triangulate_19(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->Triangulate();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_TemplateTriangulate_110(JNIEnv* env, jobject obj,jint id0,jint id1,jint id2)
{
  int   temp0;
  int   temp1;
  int   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->TemplateTriangulate(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_UpdatePointType_111(JNIEnv* env, jobject obj,jlong id0,jint id1)
{
  long long   temp0;
  int   temp1;
  temp0 = id0;
  temp1 = id1;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->UpdatePointType(temp0,temp1);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_GetPointId_112(JNIEnv* env, jobject obj,jlong id0)
{
  long long   temp0;
  long long   temp20;
  temp0 = id0;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPointId(temp0);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_GetNumberOfPoints_113(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfPoints();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_SetUseTemplates_114(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTemplates(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_GetUseTemplates_115(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTemplates();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_UseTemplatesOn_116(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTemplatesOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_UseTemplatesOff_117(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTemplatesOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_SetPreSorted_118(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetPreSorted(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_GetPreSorted_119(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetPreSorted();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_PreSortedOn_120(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreSortedOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_PreSortedOff_121(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->PreSortedOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_SetUseTwoSortIds_122(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetUseTwoSortIds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_GetUseTwoSortIds_123(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetUseTwoSortIds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_UseTwoSortIdsOn_124(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTwoSortIdsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_UseTwoSortIdsOff_125(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->UseTwoSortIdsOff();

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_GetTetras_126(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkUnstructuredGrid * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetTetras(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTetras_127(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkUnstructuredGrid * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkUnstructuredGrid*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTetras(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTetras_128(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkCellArray * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTetras(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTetras_129(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2,jobject id3,jobject id4,jobject id5,jlong id6,jobject id7)
{
  int   temp0;
  vtkIncrementalPointLocator * temp1;
  vtkCellArray * temp2;
  vtkPointData * temp3;
  vtkPointData * temp4;
  vtkCellData * temp5;
  long long   temp6;
  vtkCellData * temp7;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIncrementalPointLocator*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkPointData*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id5));
  temp6 = id6;
  temp7 = static_cast<vtkCellData*>(vtkJavaGetPointerFromObject(env, id7));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTetras(temp0,temp1,temp2,temp3,temp4,temp5,temp6,temp7);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTetras_130(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2)
{
  int   temp0;
  vtkIdList * temp1;
  vtkPoints * temp2;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTetras(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTetras_131(JNIEnv* env, jobject obj,jint id0,jobject id1)
{
  int   temp0;
  vtkIdList * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTetras(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTriangles_132(JNIEnv* env, jobject obj,jobject id0)
{
  vtkCellArray * temp0;
  long long   temp20;
  temp0 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id0));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTriangles(temp0);
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkOrderedTriangulator_AddTriangles_133(JNIEnv* env, jobject obj,jlong id0,jobject id1)
{
  long long   temp0;
  vtkCellArray * temp1;
  long long   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkCellArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->AddTriangles(temp0,temp1);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkOrderedTriangulator_InitTetraTraversal_134(JNIEnv* env, jobject obj)
{

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  op->InitTetraTraversal();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkOrderedTriangulator_GetNextTetra_135(JNIEnv* env, jobject obj,jint id0,jobject id1,jobject id2,jobject id3)
{
  int   temp0;
  vtkTetra * temp1;
  vtkDataArray * temp2;
  vtkDoubleArray * temp3;
  int   temp20;
  temp0 = id0;
  temp1 = static_cast<vtkTetra*>(vtkJavaGetPointerFromObject(env, id1));
  temp2 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkDoubleArray*>(vtkJavaGetPointerFromObject(env, id3));

  vtkOrderedTriangulator* op = static_cast<vtkOrderedTriangulator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNextTetra(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkOrderedTriangulator_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkOrderedTriangulator::New());
}
