// java wrapper for vtkImplicitDataSet object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkImplicitDataSet.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkImplicitFunction_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkImplicitDataSet_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkImplicitDataSet",dType)) { return me; }
  if ((res= vtkImplicitFunction_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitDataSet_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkImplicitDataSet_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitDataSet_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitDataSet_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitDataSet_GetMTime_14(JNIEnv* env, jobject obj)
{
   unsigned long   temp20;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetMTime();
  return temp20;

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitDataSet_EvaluateFunction_15(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  double   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitDataSet_EvaluateGradient_16(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1)
{
  double temp0[3];
  double temp1[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateGradient(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->SetDoubleArrayRegion(id1, 0, 3, &temp1[0]);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitDataSet_SetDataSet_17(JNIEnv* env, jobject obj,jobject id0)
{
  vtkDataSet * temp0;
  temp0 = static_cast<vtkDataSet*>(vtkJavaGetPointerFromObject(env, id0));

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetDataSet(temp0);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkImplicitDataSet_GetDataSet_18(JNIEnv* env, jobject obj)
{
  vtkDataSet * temp20;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetDataSet();
  return reinterpret_cast<jlong>(temp20);
}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitDataSet_SetOutValue_19(JNIEnv* env, jobject obj,jdouble id0)
{
  double   temp0;
  temp0 = id0;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutValue(temp0);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitDataSet_GetOutValue_110(JNIEnv* env, jobject obj)
{
  double   temp20;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutValue();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitDataSet_SetOutGradient_111(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutGradient(temp0,temp1,temp2);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitDataSet_SetOutGradient_112(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetOutGradient(temp0);

}

extern "C" JNIEXPORT jdoubleArray  JNICALL Java_vtk_vtkImplicitDataSet_GetOutGradient_113(JNIEnv* env, jobject obj)
{
  double * temp20;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetOutGradient();
  return vtkJavaMakeJArrayOfDouble(env, temp20, 3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkImplicitDataSet_EvaluateFunction_114(JNIEnv* env, jobject obj,jobject id0,jobject id1)
{
  vtkDataArray * temp0;
  vtkDataArray * temp1;
  temp0 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id0));
  temp1 = static_cast<vtkDataArray*>(vtkJavaGetPointerFromObject(env, id1));

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  op->EvaluateFunction(temp0,temp1);

}

extern "C" JNIEXPORT jdouble  JNICALL Java_vtk_vtkImplicitDataSet_EvaluateFunction_115(JNIEnv* env, jobject obj,jdouble id0,jdouble id1,jdouble id2)
{
  double   temp0;
  double   temp1;
  double   temp2;
  double   temp20;
  temp0 = id0;
  temp1 = id1;
  temp2 = id2;

  vtkImplicitDataSet* op = static_cast<vtkImplicitDataSet*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->EvaluateFunction(temp0,temp1,temp2);
  return temp20;

}

extern "C" JNIEXPORT jlong JNICALL Java_vtk_vtkImplicitDataSet_VTKInit(JNIEnv*, jobject)
{
  return reinterpret_cast<jlong>(vtkImplicitDataSet::New());
}
