// java wrapper for vtkAbstractCellLocator object
//
#define VTK_WRAPPING_CXX
#define VTK_STREAMS_FWD_ONLY
#include "vtkABI.h"
#include "vtkSystemIncludes.h"
#include "vtkAbstractCellLocator.h"
#include "vtkJavaUtil.h"

#include "vtkStdString.h"

#include <sstream>
extern "C" JNIEXPORT void* vtkLocator_Typecast(void* op,char* dType);

extern "C" JNIEXPORT void* vtkAbstractCellLocator_Typecast(void* me,char* dType)
{
  void* res;
  if (!strcmp("vtkAbstractCellLocator",dType)) { return me; }
  if ((res= vtkLocator_Typecast(me,dType)) != nullptr) { return res; }
  return nullptr;
}


extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_IsTypeOf_10(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsTypeOf(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_IsA_11(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  int   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IsA(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractCellLocator_GetNumberOfGenerationsFromBaseType_12(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBaseType(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractCellLocator_GetNumberOfGenerationsFromBase_13(JNIEnv* env, jobject obj, jbyteArray id0, jint len0)
{
  char * temp0;
  long long   temp20;
  temp0 = vtkJavaUTF8ToChars(env, id0, len0);

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfGenerationsFromBase(temp0);
  delete[] temp0;
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_SetNumberOfCellsPerNode_14(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetNumberOfCellsPerNode(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_GetNumberOfCellsPerNodeMinValue_15(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerNodeMinValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_GetNumberOfCellsPerNodeMaxValue_16(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerNodeMaxValue();
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_GetNumberOfCellsPerNode_17(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetNumberOfCellsPerNode();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_SetCacheCellBounds_18(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetCacheCellBounds(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_GetCacheCellBounds_19(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetCacheCellBounds();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_CacheCellBoundsOn_110(JNIEnv* env, jobject obj)
{

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheCellBoundsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_CacheCellBoundsOff_111(JNIEnv* env, jobject obj)
{

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->CacheCellBoundsOff();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_ComputeCellBounds_112(JNIEnv* env, jobject obj)
{

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ComputeCellBounds();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_SetRetainCellLists_113(JNIEnv* env, jobject obj,jint id0)
{
  int   temp0;
  temp0 = id0;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->SetRetainCellLists(temp0);

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_GetRetainCellLists_114(JNIEnv* env, jobject obj)
{
  int   temp20;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->GetRetainCellLists();
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_RetainCellListsOn_115(JNIEnv* env, jobject obj)
{

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RetainCellListsOn();

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_RetainCellListsOff_116(JNIEnv* env, jobject obj)
{

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->RetainCellListsOff();

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_IntersectWithLine_117(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jobject id2,jobject id3)
{
  double temp0[3];
  double temp1[3];
  vtkPoints * temp2;
  vtkIdList * temp3;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id2));
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithLine(temp0,temp1,temp2,temp3);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_IntersectWithLine_118(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdouble id2,jobject id3,jobject id4)
{
  double temp0[3];
  double temp1[3];
  double   temp2;
  vtkPoints * temp3;
  vtkIdList * temp4;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  temp3 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithLine(temp0,temp1,temp2,temp3,temp4);
  return temp20;

}

extern "C" JNIEXPORT jint  JNICALL Java_vtk_vtkAbstractCellLocator_IntersectWithLine_119(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdouble id2,jobject id3,jobject id4,jobject id5)
{
  double temp0[3];
  double temp1[3];
  double   temp2;
  vtkPoints * temp3;
  vtkIdList * temp4;
  vtkGenericCell * temp5;
  int   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  temp3 = static_cast<vtkPoints*>(vtkJavaGetPointerFromObject(env, id3));
  temp4 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id4));
  temp5 = static_cast<vtkGenericCell*>(vtkJavaGetPointerFromObject(env, id5));

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->IntersectWithLine(temp0,temp1,temp2,temp3,temp4,temp5);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_FindCellsAlongLine_120(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdouble id2,jobject id3)
{
  double temp0[3];
  double temp1[3];
  double   temp2;
  vtkIdList * temp3;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindCellsAlongLine(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_FindCellsAlongPlane_121(JNIEnv* env, jobject obj,jdoubleArray id0,jdoubleArray id1,jdouble id2,jobject id3)
{
  double temp0[3];
  double temp1[3];
  double   temp2;
  vtkIdList * temp3;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  env->GetDoubleArrayRegion(id1, 0, 3, &temp1[0]);
  temp2 = id2;
  temp3 = static_cast<vtkIdList*>(vtkJavaGetPointerFromObject(env, id3));

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->FindCellsAlongPlane(temp0,temp1,temp2,temp3);

}

extern "C" JNIEXPORT jlong  JNICALL Java_vtk_vtkAbstractCellLocator_FindCell_122(JNIEnv* env, jobject obj,jdoubleArray id0)
{
  double temp0[3];
  long long   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->FindCell(temp0);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT jboolean  JNICALL Java_vtk_vtkAbstractCellLocator_InsideCellBounds_123(JNIEnv* env, jobject obj,jdoubleArray id0,jlong id1)
{
  double temp0[3];
  long long   temp1;
  bool   temp20;
  env->GetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  temp1 = id1;

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  temp20 = op->InsideCellBounds(temp0,temp1);
  env->SetDoubleArrayRegion(id0, 0, 3, &temp0[0]);
  return temp20;

}

extern "C" JNIEXPORT void  JNICALL Java_vtk_vtkAbstractCellLocator_ShallowCopy_124(JNIEnv* env, jobject obj,jobject id0)
{
  vtkAbstractCellLocator * temp0;
  temp0 = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, id0));

  vtkAbstractCellLocator* op = static_cast<vtkAbstractCellLocator*>(vtkJavaGetPointerFromObject(env, obj));
  op->ShallowCopy(temp0);

}
